/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.protobuf.Timestamp;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.util.TimeUtils;

public class TimestampRange {
    static final BanyandbModel.TimeRange MAX_RANGE = BanyandbModel.TimeRange.newBuilder().setBegin(TimeUtils.fromEpochNanos(Long.MIN_VALUE)).setEnd(TimeUtils.fromEpochNanos(Long.MAX_VALUE)).build();
    private final long begin;
    private final long end;

    BanyandbModel.TimeRange build() {
        BanyandbModel.TimeRange.Builder builder = BanyandbModel.TimeRange.newBuilder();
        builder.setBegin(Timestamp.newBuilder().setSeconds(this.begin / 1000L).setNanos((int)(this.begin % 1000L * 1000000L)));
        builder.setEnd(Timestamp.newBuilder().setSeconds(this.end / 1000L).setNanos((int)(this.end % 1000L * 1000000L)));
        return builder.build();
    }

    public TimestampRange(long begin, long end) {
        this.begin = begin;
        this.end = end;
    }

    protected long getBegin() {
        return this.begin;
    }

    protected long getEnd() {
        return this.end;
    }
}

