/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Contains$;
import org.apache.spark.sql.catalyst.expressions.EndsWith$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe$;
import org.apache.spark.sql.catalyst.expressions.EqualTo$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan$;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual$;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.IsNotNull$;
import org.apache.spark.sql.catalyst.expressions.IsNull$;
import org.apache.spark.sql.catalyst.expressions.LessThan$;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not$;
import org.apache.spark.sql.catalyst.expressions.Or$;
import org.apache.spark.sql.catalyst.expressions.StartsWith$;
import org.apache.spark.sql.sources.AlwaysFalse;
import org.apache.spark.sql.sources.AlwaysTrue;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class StructFilters$ {
    public static StructFilters$ MODULE$;

    static {
        new StructFilters$();
    }

    private boolean checkFilterRefs(Filter filter, Set<String> fieldNames) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.references())).forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)fieldNames.contains((Object)elem)));
    }

    public Filter[] pushedFilters(Filter[] filters, StructType schema) {
        Set fieldNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).toSet();
        return (Filter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StructFilters$.MODULE$.checkFilterRefs(x$3, (Set<String>)fieldNames)));
    }

    private <A, B> Option<Tuple2<A, B>> zip(Option<A> a, Option<B> b) {
        return ((TraversableLike)Option$.MODULE$.option2Iterable(a).zip((GenIterable)Option$.MODULE$.option2Iterable(b), Iterable$.MODULE$.canBuildFrom())).headOption();
    }

    private Option<Literal> toLiteral(Object value) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.apply(value)).toOption();
    }

    public Option<Expression> filterToExpression(Filter filter, Function1<String, Option<BoundReference>> toRef) {
        return this.translate$1(filter, toRef);
    }

    private final Option zipAttributeAndValue$1(String name, Object value, Function1 toRef$1) {
        return this.zip((Option)toRef$1.apply((Object)name), this.toLiteral(value));
    }

    private final Option translate$1(Filter filter, Function1 toRef$1) {
        Option option;
        Filter filter2 = filter;
        if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            option = this.zip(this.translate$1(left, toRef$1), this.translate$1(right, toRef$1)).map(And$.MODULE$.tupled());
        } else if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            option = this.zip(this.translate$1(left, toRef$1), this.translate$1(right, toRef$1)).map(Or$.MODULE$.tupled());
        } else if (filter2 instanceof Not) {
            Not not = (Not)filter2;
            Filter child = not.child();
            option = this.translate$1(child, toRef$1).map((Function1)Not$.MODULE$);
        } else if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attribute = equalTo.attribute();
            Object value2 = equalTo.value();
            option = this.zipAttributeAndValue$1(attribute, value2, toRef$1).map(EqualTo$.MODULE$.tupled());
        } else if (filter2 instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter2;
            String attribute = equalNullSafe.attribute();
            Object value3 = equalNullSafe.value();
            option = this.zipAttributeAndValue$1(attribute, value3, toRef$1).map(EqualNullSafe$.MODULE$.tupled());
        } else if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attribute = isNull.attribute();
            option = ((Option)toRef$1.apply((Object)attribute)).map((Function1)IsNull$.MODULE$);
        } else if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attribute = isNotNull.attribute();
            option = ((Option)toRef$1.apply((Object)attribute)).map((Function1)IsNotNull$.MODULE$);
        } else if (filter2 instanceof org.apache.spark.sql.sources.In) {
            org.apache.spark.sql.sources.In in = (org.apache.spark.sql.sources.In)filter2;
            String attribute = in.attribute();
            Object[] values = in.values();
            Seq literals = (Seq)Predef$.MODULE$.genericArrayOps((Object)values).toSeq().flatMap((Function1 & Serializable & scala.Serializable)value -> Option$.MODULE$.option2Iterable(MODULE$.toLiteral(value)), Seq$.MODULE$.canBuildFrom());
            option = literals.length() == values.length ? ((Option)toRef$1.apply((Object)attribute)).map((Function1 & Serializable & scala.Serializable)x$4 -> new In((Expression)x$4, (Seq<Expression>)literals)) : None$.MODULE$;
        } else if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attribute = greaterThan.attribute();
            Object value4 = greaterThan.value();
            option = this.zipAttributeAndValue$1(attribute, value4, toRef$1).map(GreaterThan$.MODULE$.tupled());
        } else if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attribute = greaterThanOrEqual.attribute();
            Object value5 = greaterThanOrEqual.value();
            option = this.zipAttributeAndValue$1(attribute, value5, toRef$1).map(GreaterThanOrEqual$.MODULE$.tupled());
        } else if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attribute = lessThan.attribute();
            Object value6 = lessThan.value();
            option = this.zipAttributeAndValue$1(attribute, value6, toRef$1).map(LessThan$.MODULE$.tupled());
        } else if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attribute = lessThanOrEqual.attribute();
            Object value7 = lessThanOrEqual.value();
            option = this.zipAttributeAndValue$1(attribute, value7, toRef$1).map(LessThanOrEqual$.MODULE$.tupled());
        } else if (filter2 instanceof StringContains) {
            StringContains stringContains = (StringContains)filter2;
            String attribute = stringContains.attribute();
            String value8 = stringContains.value();
            option = this.zipAttributeAndValue$1(attribute, value8, toRef$1).map(Contains$.MODULE$.tupled());
        } else if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attribute = stringStartsWith.attribute();
            String value9 = stringStartsWith.value();
            option = this.zipAttributeAndValue$1(attribute, value9, toRef$1).map(StartsWith$.MODULE$.tupled());
        } else if (filter2 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter2;
            String attribute = stringEndsWith.attribute();
            String value10 = stringEndsWith.value();
            option = this.zipAttributeAndValue$1(attribute, value10, toRef$1).map(EndsWith$.MODULE$.tupled());
        } else if (filter2 instanceof AlwaysTrue) {
            option = new Some((Object)new Literal(BoxesRunTime.boxToBoolean((boolean)true), BooleanType$.MODULE$));
        } else if (filter2 instanceof AlwaysFalse) {
            option = new Some((Object)new Literal(BoxesRunTime.boxToBoolean((boolean)false), BooleanType$.MODULE$));
        } else {
            throw new MatchError((Object)filter2);
        }
        return option;
    }

    private StructFilters$() {
        MODULE$ = this;
    }
}

