/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArraysOverlap$;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(a1, a2) - Returns true if a1 contains at least a non-null element present also in a2. If the arrays have no common element and they are both non-empty and either of them contains a null element null is returned, false otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(3, 4, 5));\n       true\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\tec\u0001B\u0012%\u0001FB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011X\u0011!q\u0006\u0001#b\u0001\n\u0013y\u0006\u0002\u0003:\u0001\u0011\u000b\u0007I\u0011B:\t\u000by\u0004A\u0011I@\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u0011q\u0003\u0001\u0005B\u0005e\u0001bBA\u0012\u0001\u0011%\u0011Q\u0005\u0005\b\u0003_\u0001A\u0011BA\u0019\u0011\u001d\t9\u0004\u0001C!\u0003sAq!!\u0016\u0001\t\u0013\t9\u0006C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\"9\u0011Q\u0013\u0001\u0005B\u0005]\u0005\"CAM\u0001\u0005\u0005I\u0011AAN\u0011%\t\t\u000bAI\u0001\n\u0003\t\u0019\u000bC\u0005\u0002:\u0002\t\n\u0011\"\u0001\u0002$\"I\u00111\u0018\u0001\u0002\u0002\u0013\u0005\u0013Q\u0018\u0005\n\u0003\u001b\u0004\u0011\u0011!C\u0001\u0003\u001fD\u0011\"a6\u0001\u0003\u0003%\t!!7\t\u0013\u0005}\u0007!!A\u0005B\u0005\u0005\b\"CAx\u0001\u0005\u0005I\u0011AAy\u0011%\t)\u0010AA\u0001\n\u0003\n9pB\u0005\u0003\u001c\u0011\n\t\u0011#\u0001\u0003\u001e\u0019A1\u0005JA\u0001\u0012\u0003\u0011y\u0002\u0003\u0004R;\u0011\u0005!Q\u0006\u0005\n\u0005_i\u0012\u0011!C#\u0005cA\u0011Ba\r\u001e\u0003\u0003%\tI!\u000e\t\u0013\tmR$!A\u0005\u0002\nu\u0002\"\u0003B(;\u0005\u0005I\u0011\u0002B)\u00055\t%O]1zg>3XM\u001d7ba*\u0011QEJ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002(Q\u0005A1-\u0019;bYf\u001cHO\u0003\u0002*U\u0005\u00191/\u001d7\u000b\u0005-b\u0013!B:qCJ\\'BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001eYJ\u0004I\u0012\t\u0003gQj\u0011\u0001J\u0005\u0003k\u0011\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005M:\u0014B\u0001\u001d%\u0005\u0015\u0012\u0015N\\1ss\u0006\u0013(/Y=FqB\u0014Xm]:j_:<\u0016\u000e\u001e5J[Bd\u0017nY5u\u0007\u0006\u001cH\u000f\u0005\u0002;{9\u00111gO\u0005\u0003y\u0011\nq\u0001]1dW\u0006<W-\u0003\u0002?\u007f\tqa*\u001e7m\u0013:$x\u000e\\3sC:$(B\u0001\u001f%!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u001d\u0001&o\u001c3vGR\u0004\"!Q$\n\u0005!\u0013%\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00027fMR,\u0012a\u0013\t\u0003g1K!!\u0014\u0013\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007M#V\u000b\u0005\u00024\u0001!)\u0011*\u0002a\u0001\u0017\")q*\u0002a\u0001\u0017\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\t\u0001\f\u0005\u0002Z96\t!L\u0003\u0002\\M\u0005A\u0011M\\1msNL7/\u0003\u0002^5\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0005pe\u0012,'/\u001b8h+\u0005\u0001\u0007cA1iW:\u0011!m\u001a\b\u0003G\u001al\u0011\u0001\u001a\u0006\u0003KB\na\u0001\u0010:p_Rt\u0014\"A\"\n\u0005q\u0012\u0015BA5k\u0005!y%\u000fZ3sS:<'B\u0001\u001fC!\t\tE.\u0003\u0002n\u0005\n\u0019\u0011I\\=)\u0005\u001dy\u0007CA!q\u0013\t\t(IA\u0005ue\u0006t7/[3oi\u0006aAm\\#wC2,\u0018\r^5p]V\tA\u000fE\u0003Bk^<8.\u0003\u0002w\u0005\nIa)\u001e8di&|gN\r\t\u0003qnl\u0011!\u001f\u0006\u0003u\u001a\nA!\u001e;jY&\u0011A0\u001f\u0002\n\u0003J\u0014\u0018-\u001f#bi\u0006D#\u0001C8\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\u0001\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002)\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tY!!\u0002\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0003\u0003#\u00012!QA\n\u0013\r\t)B\u0011\u0002\b\u0005>|G.Z1o\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0015Y\u00171DA\u0010\u0011\u0019\tib\u0003a\u0001W\u0006\u0011\u0011-\r\u0005\u0007\u0003CY\u0001\u0019A6\u0002\u0005\u0005\u0014\u0014\u0001\u00034bgR,e/\u00197\u0015\u000b-\f9#a\u000b\t\r\u0005%B\u00021\u0001x\u0003\u0011\t'O]\u0019\t\r\u00055B\u00021\u0001x\u0003\u0011\t'O\u001d\u001a\u0002\u001d\t\u0014X\u000f^3G_J\u001cW-\u0012<bYR)1.a\r\u00026!1\u0011\u0011F\u0007A\u0002]Da!!\f\u000e\u0001\u00049\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\tY$a\u0012\u0002RA!\u0011QHA\"\u001b\t\tyDC\u0002\u0002B\u0011\nqaY8eK\u001e,g.\u0003\u0003\u0002F\u0005}\"\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005%c\u00021\u0001\u0002L\u0005\u00191\r\u001e=\u0011\t\u0005u\u0012QJ\u0005\u0005\u0003\u001f\nyD\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005Mc\u00021\u0001\u0002<\u0005\u0011QM^\u0001\fM\u0006\u001cHoQ8eK\u001e,g\u000e\u0006\u0006\u0002Z\u0005%\u00141NA7\u0003c\u0002B!a\u0017\u0002d9!\u0011QLA0!\t\u0019')C\u0002\u0002b\t\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA3\u0003O\u0012aa\u0015;sS:<'bAA1\u0005\"9\u0011\u0011J\bA\u0002\u0005-\u0003bBA*\u001f\u0001\u0007\u00111\b\u0005\b\u0003_z\u0001\u0019AA-\u0003\u001d\u0019X.\u00197mKJDq!a\u001d\u0010\u0001\u0004\tI&\u0001\u0004cS\u001e<WM]\u0001\u0012EJ,H/\u001a$pe\u000e,7i\u001c3fO\u0016tGCCA-\u0003s\nY(! \u0002\u0000!9\u0011\u0011\n\tA\u0002\u0005-\u0003bBA*!\u0001\u0007\u00111\b\u0005\b\u0003_\u0002\u0002\u0019AA-\u0011\u001d\t\u0019\b\u0005a\u0001\u00033\naC\\;mYN\u000bg-Z#mK6,g\u000e^\"pI\u0016<WM\u001c\u000b\u000b\u00033\n))!#\u0002\u000e\u0006E\u0005bBAD#\u0001\u0007\u0011\u0011L\u0001\tCJ\u0014\u0018-\u001f,be\"9\u00111R\tA\u0002\u0005e\u0013!B5oI\u0016D\bbBAH#\u0001\u0007\u0011\u0011L\u0001\u0005G>$W\rC\u0004\u0002\u0014F\u0001\r!!\u0017\u0002\u0015%\u001ch*\u001e7m\u0007>$W-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0017\u0002\t\r|\u0007/\u001f\u000b\u0006'\u0006u\u0015q\u0014\u0005\b\u0013N\u0001\n\u00111\u0001L\u0011\u001dy5\u0003%AA\u0002-\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002&*\u001a1*a*,\u0005\u0005%\u0006\u0003BAV\u0003kk!!!,\u000b\t\u0005=\u0016\u0011W\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a-C\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\u000biKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u007f\u0003B!!1\u0002L6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\f9-\u0001\u0003mC:<'BAAe\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00141Y\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003#\u00042!QAj\u0013\r\t)N\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004W\u0006m\u0007\"CAo1\u0005\u0005\t\u0019AAi\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u001d\t\u0006\u0003K\fYo[\u0007\u0003\u0003OT1!!;C\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003[\f9O\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\t\u0003gD\u0001\"!8\u001b\u0003\u0003\u0005\ra[\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005E\u0011\u0011 \u0005\t\u0003;\\\u0012\u0011!a\u0001W\"\u001a\u0002!!@\u0003\u0004\t\u0015!\u0011\u0002B\u0006\u0005\u001f\u0011\tB!\u0006\u0003\u0018A\u00191'a@\n\u0007\t\u0005AEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t\u001d\u0011!a6`\rVs5i\u0018\u0015bc1\u0002\u0013MM\u0015![\u0001\u0012V\r^;s]N\u0004CO];fA%4\u0007%Y\u0019!G>tG/Y5og\u0002\nG\u000f\t7fCN$\b%\u0019\u0011o_:lc.\u001e7mA\u0015dW-\\3oi\u0002\u0002(/Z:f]R\u0004\u0013\r\\:pA%t\u0007%\u0019\u001a/A%3\u0007\u0005\u001e5fA\u0005\u0014(/Y=tA!\fg/\u001a\u0011o_\u0002\u001aw.\\7p]\u0002*G.Z7f]R\u0004\u0013M\u001c3!i\",\u0017\u0010I1sK\u0002\u0012w\u000e\u001e5!]>tW&Z7qif\u0004\u0013M\u001c3!K&$\b.\u001a:!_\u001a\u0004C\u000f[3nA\r|g\u000e^1j]N\u0004\u0013\r\t8vY2\u0004S\r\\3nK:$\bE\\;mY\u0002J7\u000f\t:fiV\u0014h.\u001a3-A\u0019\fGn]3!_RDWM]<jg\u0016t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t5\u0011\u0001\u0016\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012D\u0006I\u001a*Y\u0001\n'O]1zQMb\u0003\u0005\u000e\u0017!k%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005'\t1\"\u0019:sCf|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!\u0011D\u0001\u0006e9\"d\u0006M\u0001\u000e\u0003J\u0014\u0018-_:Pm\u0016\u0014H.\u00199\u0011\u0005Mj2\u0003B\u000f\u0003\"\u0019\u0003rAa\t\u0003*-[5+\u0004\u0002\u0003&)\u0019!q\u0005\"\u0002\u000fI,h\u000e^5nK&!!1\u0006B\u0013\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005;\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u007f\u000bQ!\u00199qYf$Ra\u0015B\u001c\u0005sAQ!\u0013\u0011A\u0002-CQa\u0014\u0011A\u0002-\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003@\t-\u0003#B!\u0003B\t\u0015\u0013b\u0001B\"\u0005\n1q\n\u001d;j_:\u0004R!\u0011B$\u0017.K1A!\u0013C\u0005\u0019!V\u000f\u001d7fe!A!QJ\u0011\u0002\u0002\u0003\u00071+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!1\u000b\t\u0005\u0003\u0003\u0014)&\u0003\u0003\u0003X\u0005\r'AB(cU\u0016\u001cG\u000f")
public class ArraysOverlap
extends BinaryExpression
implements BinaryArrayExpressionWithImplicitCast,
package.NullIntolerant,
scala.Serializable {
    private transient Ordering<Object> ordering;
    private transient Function2<ArrayData, ArrayData, Object> doEvaluation;
    private final Expression left;
    private final Expression right;
    private transient DataType elementType;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArraysOverlap arraysOverlap) {
        return ArraysOverlap$.MODULE$.unapply(arraysOverlap);
    }

    public static Function1<Tuple2<Expression, Expression>, ArraysOverlap> tupled() {
        return ArraysOverlap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArraysOverlap>> curried() {
        return ArraysOverlap$.MODULE$.curried();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    private DataType elementType$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
        TypeCheckResult typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult) ? TypeUtils$.MODULE$.checkForOrderingExpr(this.elementType(), new StringBuilder(9).append("function ").append(this.prettyName()).toString()) : typeCheckResult;
        return typeCheckResult2;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.elementType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.doEvaluation = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable & scala.Serializable)(arr1, arr2) -> this.fastEval((ArrayData)arr1, (ArrayData)arr2) : (Function2 & Serializable & scala.Serializable)(arr1, arr2) -> this.bruteForceEval((ArrayData)arr1, (ArrayData)arr2);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.doEvaluation;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.doEvaluation$lzycompute() : this.doEvaluation;
    }

    @Override
    public DataType dataType() {
        return BooleanType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.left().nullable() || this.right().nullable() || ((ArrayType)this.left().dataType()).containsNull() || ((ArrayType)this.right().dataType()).containsNull();
    }

    @Override
    public Object nullSafeEval(Object a1, Object a2) {
        return this.doEvaluation().apply((Object)((ArrayData)a1), (Object)((ArrayData)a2));
    }

    private Object fastEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            Tuple2 tuple2;
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            Tuple2 tuple22 = tuple2 = arr1.numElements() > arr2.numElements() ? new Tuple2((Object)arr1, (Object)arr2) : new Tuple2((Object)arr2, (Object)arr1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayData bigger = (ArrayData)tuple2._1();
            ArrayData smaller = (ArrayData)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)bigger, (Object)smaller);
            Tuple2 tuple24 = tuple23;
            ArrayData bigger2 = (ArrayData)tuple24._1();
            ArrayData smaller2 = (ArrayData)tuple24._2();
            if (smaller2.numElements() > 0) {
                HashSet smallestSet = new HashSet();
                smaller2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$29, v) -> {
                    ArraysOverlap.$anonfun$fastEval$1(hasNull, smallestSet, BoxesRunTime.unboxToInt((Object)x$29), v);
                    return BoxedUnit.UNIT;
                });
                bigger2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$30, v1) -> {
                    ArraysOverlap.$anonfun$fastEval$2(hasNull, smallestSet, object2, BoxesRunTime.unboxToInt((Object)x$30), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    private Object bruteForceEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            if (arr1.numElements() > 0 && arr2.numElements() > 0) {
                arr1.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$31, v1) -> {
                    ArraysOverlap.$anonfun$bruteForceEval$1(this, hasNull, arr2, object2, BoxesRunTime.unboxToInt((Object)x$31), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(a1, a2) -> {
            String smaller = ctx.freshName("smallerArray");
            String bigger = ctx.freshName("biggerArray");
            String comparisonCode = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? this.fastCodegen(ctx, ev, smaller, bigger) : this.bruteForceCodegen(ctx, ev, smaller, bigger);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(261).append("\n         |ArrayData ").append(smaller).append(";\n         |ArrayData ").append(bigger).append(";\n         |if (").append((String)a1).append(".numElements() > ").append((String)a2).append(".numElements()) {\n         |  ").append(bigger).append(" = ").append((String)a1).append(";\n         |  ").append(smaller).append(" = ").append((String)a2).append(";\n         |} else {\n         |  ").append(smaller).append(" = ").append((String)a1).append(";\n         |  ").append(bigger).append(" = ").append((String)a2).append(";\n         |}\n         |if (").append(smaller).append(".numElements() > 0) {\n         |  ").append(comparisonCode).append("\n         |}\n       ").toString())).stripMargin();
        });
    }

    private String fastCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), i);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String javaElementClass = CodeGenerator$.MODULE$.boxedType(this.elementType());
        String javaSet = HashSet.class.getName();
        String set = ctx.freshName("set");
        String addToSetFromSmallerCode = this.nullSafeElementCodegen(smaller, i, new StringBuilder(7).append(set).append(".add(").append(getFromSmaller).append(");").toString(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        String setIsNullCode = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        String elementIsInSetCode = this.nullSafeElementCodegen(bigger, i, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("\n         |if (").append(set).append(".contains(").append(getFromBigger).append(")) {\n         |  ").append(setIsNullCode).append("\n         |  ").append(ev.value()).append(" = true;\n         |  break;\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(170).append("\n       |").append(javaSet).append("<").append(javaElementClass).append("> ").append(set).append(" = new ").append(javaSet).append("<").append(javaElementClass).append(">();\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(smaller).append(".numElements(); ").append(i).append(" ++) {\n       |  ").append(addToSetFromSmallerCode).append("\n       |}\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(bigger).append(".numElements(); ").append(i).append(" ++) {\n       |  ").append(elementIsInSetCode).append("\n       |}\n     ").toString())).stripMargin();
    }

    private String bruteForceCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), j);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String setIsNullCode = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        String compareValues = this.nullSafeElementCodegen(smaller, j, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(72).append("\n         |if (").append(ctx.genEqual(this.elementType(), getFromSmaller, getFromBigger)).append(") {\n         |  ").append(setIsNullCode).append("\n         |  ").append(ev.value()).append(" = true;\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        String isInSmaller = this.nullSafeElementCodegen(bigger, i, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n         |for (int ").append(j).append(" = 0; ").append(j).append(" < ").append(smaller).append(".numElements() && !").append(ev.value()).append("; ").append(j).append(" ++) {\n         |  ").append(compareValues).append("\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(81).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(bigger).append(".numElements() && !").append(ev.value()).append("; ").append(i).append(" ++) {\n       |  ").append(isInSmaller).append("\n       |}\n     ").toString())).stripMargin();
    }

    public String nullSafeElementCodegen(String arrayVar, String index, String code, String isNullCode) {
        return this.inputTypes().exists((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)ArraysOverlap.$anonfun$nullSafeElementCodegen$1(x$33))) ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n         |if (").append(arrayVar).append(".isNullAt(").append(index).append(")) {\n         |  ").append(isNullCode).append("\n         |} else {\n         |  ").append(code).append("\n         |}\n       ").toString())).stripMargin() : code;
    }

    @Override
    public String prettyName() {
        return "arrays_overlap";
    }

    public ArraysOverlap copy(Expression left, Expression right) {
        return new ArraysOverlap(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArraysOverlap";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraysOverlap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraysOverlap)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraysOverlap arraysOverlap = (ArraysOverlap)x$1;
        Expression expression = this.left();
        Expression expression2 = arraysOverlap.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arraysOverlap.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arraysOverlap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$fastEval$1(BooleanRef hasNull$2, HashSet smallestSet$1, int x$29, Object v) {
        if (v == null) {
            hasNull$2.elem = true;
        } else {
            smallestSet$1.add(v);
        }
    }

    public static final /* synthetic */ void $anonfun$fastEval$2(BooleanRef hasNull$2, HashSet smallestSet$1, Object nonLocalReturnKey2$1, int x$30, Object v1) {
        if (v1 == null) {
            hasNull$2.elem = true;
        } else if (smallestSet$1.contains(v1)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$2(ArraysOverlap $this, BooleanRef hasNull$3, Object v1$1, Object nonLocalReturnKey3$1, int x$32, Object v2) {
        if (v2 == null) {
            hasNull$3.elem = true;
        } else if ($this.ordering().equiv(v1$1, v2)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey3$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$1(ArraysOverlap $this, BooleanRef hasNull$3, ArrayData arr2$1, Object nonLocalReturnKey3$1, int x$31, Object v1) {
        if (v1 == null) {
            hasNull$3.elem = true;
        } else {
            arr2$1.foreach($this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$32, v2) -> {
                ArraysOverlap.$anonfun$bruteForceEval$2($this, hasNull$3, v1, nonLocalReturnKey3$1, BoxesRunTime.unboxToInt((Object)x$32), v2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$nullSafeElementCodegen$1(AbstractDataType x$33) {
        return ((ArrayType)x$33).containsNull();
    }

    public ArraysOverlap(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
    }
}

