/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualTo$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` equals `expr2`, or false otherwise.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       NULL\n      > SELECT NULL _FUNC_ NULL;\n       NULL\n  ", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u0005Q\b\u0003\u0005D\u0001\tE\t\u0015!\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u00151\u0006\u0001\"\u0015X\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u001da\u0007!!A\u0005\u00025Dq\u0001\u001d\u0001\u0012\u0002\u0013\u0005\u0011\u000fC\u0004}\u0001E\u0005I\u0011A9\t\u000fu\u0004\u0011\u0011!C!}\"I\u0011Q\u0002\u0001\u0002\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003/\u0001\u0011\u0011!C\u0001\u00033A\u0011\"a\b\u0001\u0003\u0003%\t%!\t\t\u0013\u0005=\u0002!!A\u0005\u0002\u0005E\u0002\"CA\u001e\u0001\u0005\u0005I\u0011IA\u001f\u000f%\t\tGGA\u0001\u0012\u0003\t\u0019G\u0002\u0005\u001a5\u0005\u0005\t\u0012AA3\u0011\u0019!5\u0003\"\u0001\u0002t!I\u0011QO\n\u0002\u0002\u0013\u0015\u0013q\u000f\u0005\n\u0003s\u001a\u0012\u0011!CA\u0003wB\u0011\"!!\u0014\u0003\u0003%\t)a!\t\u0013\u0005U5#!A\u0005\n\u0005]%aB#rk\u0006dGk\u001c\u0006\u00037q\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QDH\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0004I\u0001\u0004gFd'BA\u0011#\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u000b\u00174sA\u0011\u0011FK\u0007\u00025%\u00111F\u0007\u0002\u0011\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:\u0004\"!\f\u0019\u000f\u0005%r\u0013BA\u0018\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!!\r\u001a\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011qF\u0007\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\b!J|G-^2u!\t!$(\u0003\u0002<k\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005q\u0004CA\u0015@\u0013\t\u0001%D\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002G\u000f\"\u0003\"!\u000b\u0001\t\u000bq*\u0001\u0019\u0001 \t\u000b\t+\u0001\u0019\u0001 \u0002\rMLXNY8m+\u0005Y\u0005C\u0001'T\u001d\ti\u0015\u000b\u0005\u0002Ok5\tqJ\u0003\u0002QM\u00051AH]8pizJ!AU\u001b\u0002\rA\u0013X\rZ3g\u0013\t!VK\u0001\u0004TiJLgn\u001a\u0006\u0003%V\nAB\\;mYN\u000bg-Z#wC2$2\u0001W.]!\t!\u0014,\u0003\u0002[k\t\u0019\u0011I\\=\t\u000bq:\u0001\u0019\u0001-\t\u000b\t;\u0001\u0019\u0001-\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA0fUB\u0011\u0001mY\u0007\u0002C*\u0011!MG\u0001\bG>$WmZ3o\u0013\t!\u0017M\u0001\u0005FqB\u00148i\u001c3f\u0011\u00151\u0007\u00021\u0001h\u0003\r\u0019G\u000f\u001f\t\u0003A\"L!![1\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")1\u000e\u0003a\u0001?\u0006\u0011QM^\u0001\u0005G>\u0004\u0018\u0010F\u0002G]>Dq\u0001P\u0005\u0011\u0002\u0003\u0007a\bC\u0004C\u0013A\u0005\t\u0019\u0001 \u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t!O\u000b\u0002?g.\nA\u000f\u0005\u0002vu6\taO\u0003\u0002xq\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003sV\n!\"\u00198o_R\fG/[8o\u0013\tYhOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001\u00027b]\u001eT!!!\u0003\u0002\t)\fg/Y\u0005\u0004)\u0006\r\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\t!\r!\u00141C\u0005\u0004\u0003+)$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001-\u0002\u001c!I\u0011Q\u0004\b\u0002\u0002\u0003\u0007\u0011\u0011C\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0002#BA\u0013\u0003WAVBAA\u0014\u0015\r\tI#N\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0017\u0003O\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111GA\u001d!\r!\u0014QG\u0005\u0004\u0003o)$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003;\u0001\u0012\u0011!a\u00011\u00061Q-];bYN$B!a\r\u0002@!A\u0011QD\t\u0002\u0002\u0003\u0007\u0001\fK\n\u0001\u0003\u0007\nI%a\u0013\u0002P\u0005E\u0013QKA,\u00037\ni\u0006E\u0002*\u0003\u000bJ1!a\u0012\u001b\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u0014\u0002!\u0016D\bO]\u0019!?\u001a+fjQ0!Kb\u0004(O\r\u0011.AI+G/\u001e:og\u0002\"(/^3!S\u001a\u0004\u0003-\u001a=qeF\u0002\u0007%Z9vC2\u001c\b\u0005Y3yaJ\u0014\u0004\r\f\u0011pe\u00022\u0017\r\\:fA=$\b.\u001a:xSN,g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u00111K\u0001\u0003^)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a=qeFb\u0003%\u001a=qeJ\u0002S\u0006\t;iK\u0002\"xo\u001c\u0011fqB\u0014Xm]:j_:\u001c\b%\\;ti\u0002\u0012W\rI:b[\u0016\u0004C/\u001f9fA=\u0014\beY1oA\t,\u0007eY1ti\u0016$\u0007\u0005^8!C\u0002\u001aw.\\7p]\u0002\"\u0018\u0010]3-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u00198eA5,8\u000f\u001e\u0011cK\u0002\n\u0007\u0005^=qK\u0002\"\b.\u0019;!G\u0006t\u0007EY3!kN,G\rI5oA\u0015\fX/\u00197jif\u00043m\\7qCJL7o\u001c8/A5\u000b\u0007\u000f\t;za\u0016\u0004\u0013n\u001d\u0011o_R\u00043/\u001e9q_J$X\r\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002ci\u001c:!G>l\u0007\u000f\\3yAQL\b/Z:!gV\u001c\u0007\u000eI1se\u0006Lxf\u001d;sk\u000e$H\u0006\t;iK\u0002\"\u0017\r^1!if\u0004Xm\u001d\u0011pM\u00022\u0017.\u001a7eg\u0002jWo\u001d;!E\u0016\u0004sN\u001d3fe\u0006\u0014G.\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u00033\n\u0011q\u000f\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!e\u0001zf)\u0016(D?\u0002\u00124H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\r\u0011`\rVs5i\u0018\u0011(c\u001dZ$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003CO];fA}3UKT\"`A9+F\nT\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011O+2c\u0005e\u0018$V\u001d\u000e{\u0006ET+M\u0019nR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA0\u0003\u0015\td\u0006\r\u00181\u0003\u001d)\u0015/^1m)>\u0004\"!K\n\u0014\tM\t9'\u000f\t\b\u0003S\nyG\u0010 G\u001b\t\tYGC\u0002\u0002nU\nqA];oi&lW-\u0003\u0003\u0002r\u0005-$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u00111M\u0001\ti>\u001cFO]5oOR\tq0A\u0003baBd\u0017\u0010F\u0003G\u0003{\ny\bC\u0003=-\u0001\u0007a\bC\u0003C-\u0001\u0007a(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0015\u0015\u0011\u0013\t\u0006i\u0005\u001d\u00151R\u0005\u0004\u0003\u0013+$AB(qi&|g\u000eE\u00035\u0003\u001bsd(C\u0002\u0002\u0010V\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAJ/\u0005\u0005\t\u0019\u0001$\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAM!\u0011\t\t!a'\n\t\u0005u\u00151\u0001\u0002\u0007\u001f\nTWm\u0019;")
public class EqualTo
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualTo equalTo) {
        return EqualTo$.MODULE$.unapply(equalTo);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualTo> tupled() {
        return EqualTo$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualTo>> curried() {
        return EqualTo$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "=";
    }

    @Override
    public Object nullSafeEval(Object left, Object right) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(left, right));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & java.io.Serializable & Serializable)(c1, c2) -> ctx.genEqual(this.left().dataType(), (String)c1, (String)c2));
    }

    public EqualTo copy(Expression left, Expression right) {
        return new EqualTo(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualTo";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualTo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualTo)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualTo equalTo = (EqualTo)x$1;
        Expression expression = this.left();
        Expression expression2 = equalTo.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalTo.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalTo.canEqual(this)) return false;
        return true;
    }

    public EqualTo(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

