/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual$;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is greater than or equal to `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       true\n      > SELECT 2.0 _FUNC_ '2.1';\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       false\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001\u0002\r\u001a\u0001\u001aB\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005{!A\u0011\t\u0001BK\u0002\u0013\u0005A\b\u0003\u0005C\u0001\tE\t\u0015!\u0003>\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0015A\u0005\u0001\"\u0011J\u0011\u0015)\u0006\u0001\"\u0015W\u0011\u001dq\u0006!!A\u0005\u0002}CqA\u0019\u0001\u0012\u0002\u0013\u00051\rC\u0004o\u0001E\u0005I\u0011A2\t\u000f=\u0004\u0011\u0011!C!a\"9\u0001\u0010AA\u0001\n\u0003I\bbB?\u0001\u0003\u0003%\tA \u0005\n\u0003\u0007\u0001\u0011\u0011!C!\u0003\u000bA\u0011\"a\u0005\u0001\u0003\u0003%\t!!\u0006\t\u0013\u0005}\u0001!!A\u0005B\u0005\u0005r!CA#3\u0005\u0005\t\u0012AA$\r!A\u0012$!A\t\u0002\u0005%\u0003BB\"\u0013\t\u0003\t9\u0006C\u0005\u0002ZI\t\t\u0011\"\u0012\u0002\\!I\u0011Q\f\n\u0002\u0002\u0013\u0005\u0015q\f\u0005\n\u0003K\u0012\u0012\u0011!CA\u0003OB\u0011\"!\u001f\u0013\u0003\u0003%I!a\u001f\u0003%\u001d\u0013X-\u0019;feRC\u0017M\\(s\u000bF,\u0018\r\u001c\u0006\u00035m\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011A$H\u0001\tG\u0006$\u0018\r\\=ti*\u0011adH\u0001\u0004gFd'B\u0001\u0011\"\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\u0004\u0001M)\u0001aJ\u00163qA\u0011\u0001&K\u0007\u00023%\u0011!&\u0007\u0002\u0011\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:\u0004\"\u0001L\u0018\u000f\u0005!j\u0013B\u0001\u0018\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001M\u0019\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011a&\u0007\t\u0003gYj\u0011\u0001\u000e\u0006\u0002k\u0005)1oY1mC&\u0011q\u0007\u000e\u0002\b!J|G-^2u!\t\u0019\u0014(\u0003\u0002;i\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005i\u0004C\u0001\u0015?\u0013\ty\u0014D\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002F\r\u001e\u0003\"\u0001\u000b\u0001\t\u000bm*\u0001\u0019A\u001f\t\u000b\u0005+\u0001\u0019A\u001f\u0002\rMLXNY8m+\u0005Q\u0005CA&S\u001d\ta\u0005\u000b\u0005\u0002Ni5\taJ\u0003\u0002PK\u00051AH]8pizJ!!\u0015\u001b\u0002\rA\u0013X\rZ3g\u0013\t\u0019FK\u0001\u0004TiJLgn\u001a\u0006\u0003#R\nAB\\;mYN\u000bg-Z#wC2$2a\u0016.]!\t\u0019\u0004,\u0003\u0002Zi\t\u0019\u0011I\\=\t\u000bm;\u0001\u0019A,\u0002\r%t\u0007/\u001e;2\u0011\u0015iv\u00011\u0001X\u0003\u0019Ig\u000e];ue\u0005!1m\u001c9z)\r)\u0005-\u0019\u0005\bw!\u0001\n\u00111\u0001>\u0011\u001d\t\u0005\u0002%AA\u0002u\nabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001eU\tiTmK\u0001g!\t9G.D\u0001i\u0015\tI'.A\u0005v]\u000eDWmY6fI*\u00111\u000eN\u0001\u000bC:tw\u000e^1uS>t\u0017BA7i\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\t\u0011\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u0006!A.\u00198h\u0015\u00051\u0018\u0001\u00026bm\u0006L!aU:\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003i\u0004\"aM>\n\u0005q$$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HCA,\u0000\u0011!\t\t!DA\u0001\u0002\u0004Q\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\bA)\u0011\u0011BA\b/6\u0011\u00111\u0002\u0006\u0004\u0003\u001b!\u0014AC2pY2,7\r^5p]&!\u0011\u0011CA\u0006\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]\u0011Q\u0004\t\u0004g\u0005e\u0011bAA\u000ei\t9!i\\8mK\u0006t\u0007\u0002CA\u0001\u001f\u0005\u0005\t\u0019A,\u0002\r\u0015\fX/\u00197t)\u0011\t9\"a\t\t\u0011\u0005\u0005\u0001#!AA\u0002]C3\u0003AA\u0014\u0003[\ty#a\r\u00026\u0005e\u00121HA \u0003\u0003\u00022\u0001KA\u0015\u0013\r\tY#\u0007\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t$A)fqB\u0014\u0018\u0007I0G+:\u001bu\fI3yaJ\u0014\u0004%\f\u0011SKR,(O\\:!iJ,X\rI5gA\u0001,\u0007\u0010\u001d:2A\u0002J7\u000fI4sK\u0006$XM\u001d\u0011uQ\u0006t\u0007e\u001c:!KF,\u0018\r\u001c\u0011u_\u0002\u0002W\r\u001f9se\u0001t\u0013!C1sOVlWM\u001c;tC\t\t9$\u0001BJ\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002S\r\u001f9sc1\u0002S\r\u001f9se\u0001j\u0003\u0005\u001e5fAQ<x\u000eI3yaJ,7o]5p]N\u0004S.^:uA\t,\u0007e]1nK\u0002\"\u0018\u0010]3!_J\u00043-\u00198!E\u0016\u00043-Y:uK\u0012\u0004Co\u001c\u0011bA\r|W.\\8oAQL\b/\u001a\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013M\u001c3![V\u001cH\u000f\t2fA\u0005\u0004C/\u001f9fAQD\u0017\r\u001e\u0011dC:\u0004#-\u001a\u0011pe\u0012,'/\u001a3/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017![\u0006\u0004\b\u0005^=qK\u0002J7\u000f\t8pi\u0002z'\u000fZ3sC\ndW\r\f\u0011t_\u0002JGO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A%\u001c\bE\\8uAM,\b\u000f]8si\u0016$g\u0006\t$pe\u0002\u001aw.\u001c9mKb\u0004C/\u001f9fg\u0002\u001aXo\u00195!CJ\u0014\u0018-_\u0018tiJ,8\r\u001e\u0017!i\",\u0007\u0005Z1uC\u0002\"\u0018\u0010]3tA=4\u0007EZ5fY\u0012\u001c\b%\\;ti*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t2fA=\u0014H-\u001a:bE2,gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA\u001f\u0003\t\u001d&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t\u001a!?\u001a+fjQ0!cmR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0012d\u0006\r\u0011`\rVs5i\u0018\u0011(e9\nte\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011gC2\u001cXM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011u_~#\u0017\r^3)OI\u0002\u0004'O\u00171o5\u001a\u0004\u0007\t\u00195uE:$(\u000e\u001a(S\u0001zf)\u0016(D?\u0002\"xn\u00183bi\u0016DsE\r\u00191s5\u0002t'L\u001a1AA\"$(M\u001c;kI:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t;p?\u0012\fG/\u001a\u0015(eA\u0002\u0014(\f\u00198[M\u0002\u0004\u0005\r\u001b;c]RTGM\u0014*A}3UKT\"`AQ|w\fZ1uK\":#\u0007\r\u0019:[ABT\u0006M\u0019!aQR\u0014g\u000e\u001e6e\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t4bYN,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0019!?\u001a+fjQ0!\u001dVcEj\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\r\u0013!B\u0019/a9\u0002\u0014AE$sK\u0006$XM\u001d+iC:|%/R9vC2\u0004\"\u0001\u000b\n\u0014\tI\tY\u0005\u000f\t\b\u0003\u001b\n\u0019&P\u001fF\u001b\t\tyEC\u0002\u0002RQ\nqA];oi&lW-\u0003\u0003\u0002V\u0005=#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011qI\u0001\ti>\u001cFO]5oOR\t\u0011/A\u0003baBd\u0017\u0010F\u0003F\u0003C\n\u0019\u0007C\u0003<+\u0001\u0007Q\bC\u0003B+\u0001\u0007Q(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005%\u0014Q\u000f\t\u0006g\u0005-\u0014qN\u0005\u0004\u0003[\"$AB(qi&|g\u000eE\u00034\u0003cjT(C\u0002\u0002tQ\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CA<-\u0005\u0005\t\u0019A#\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAA?!\r\u0011\u0018qP\u0005\u0004\u0003\u0003\u001b(AB(cU\u0016\u001cG\u000f")
public class GreaterThanOrEqual
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(GreaterThanOrEqual greaterThanOrEqual) {
        return GreaterThanOrEqual$.MODULE$.unapply(greaterThanOrEqual);
    }

    public static Function1<Tuple2<Expression, Expression>, GreaterThanOrEqual> tupled() {
        return GreaterThanOrEqual$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GreaterThanOrEqual>> curried() {
        return GreaterThanOrEqual$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return ">=";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().gteq(input1, input2));
    }

    public GreaterThanOrEqual copy(Expression left, Expression right) {
        return new GreaterThanOrEqual(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "GreaterThanOrEqual";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GreaterThanOrEqual;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GreaterThanOrEqual)) return false;
        boolean bl = true;
        if (!bl) return false;
        GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)x$1;
        Expression expression = this.left();
        Expression expression2 = greaterThanOrEqual.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = greaterThanOrEqual.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!greaterThanOrEqual.canEqual(this)) return false;
        return true;
    }

    public GreaterThanOrEqual(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

