/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonObjectKeys$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(json_object) - Returns all the keys of the outmost JSON object as an array.", arguments="\n    Arguments:\n      * json_object - A JSON object. If a valid JSON object is given, all the keys of the outmost\n          object will be returned as an array. If it is any other valid JSON string, an invalid JSON\n          string or an empty string, the function returns null.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('{}');\n        []\n      > SELECT _FUNC_('{\"key\": \"value\"}');\n        [\"key\"]\n      > SELECT _FUNC_('{\"f1\":\"abc\",\"f2\":{\"f3\":\"a\", \"f4\":\"b\"}}');\n        [\"f1\",\"f2\"]\n  ", group="json_funcs", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\r\u001b\u0001\u001eB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\")A\t\u0001C\u0001\u000b\")\u0001\n\u0001C!\u0013\")A\f\u0001C!;\")a\f\u0001C!?\")1\r\u0001C!I\")Q\u000e\u0001C!]\")\u0001\u0010\u0001C\u0005s\"I\u0011q\u0004\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0005\u0005\n\u0003K\u0001\u0011\u0013!C\u0001\u0003OA\u0011\"!\u0010\u0001\u0003\u0003%\t%a\u0010\t\u0013\u0005=\u0003!!A\u0005\u0002\u0005E\u0003\"CA-\u0001\u0005\u0005I\u0011AA.\u0011%\t\t\u0007AA\u0001\n\u0003\n\u0019\u0007C\u0005\u0002r\u0001\t\t\u0011\"\u0001\u0002t!I\u0011q\u000f\u0001\u0002\u0002\u0013\u0005\u0013\u0011P\u0004\n\u0003GS\u0012\u0011!E\u0001\u0003K3\u0001\"\u0007\u000e\u0002\u0002#\u0005\u0011q\u0015\u0005\u0007\tN!\t!!.\t\u0013\u0005]6#!A\u0005F\u0005e\u0006\"CA^'\u0005\u0005I\u0011QA_\u0011%\t\tmEA\u0001\n\u0003\u000b\u0019\rC\u0005\u0002PN\t\t\u0011\"\u0003\u0002R\nq!j]8o\u001f\nTWm\u0019;LKf\u001c(BA\u000e\u001d\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005uq\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005}\u0001\u0013aA:rY*\u0011\u0011EI\u0001\u0006gB\f'o\u001b\u0006\u0003G\u0011\na!\u00199bG\",'\"A\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001ACFM\u001b<!\tI#&D\u0001\u001b\u0013\tY#DA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ti\u0003'D\u0001/\u0015\ty#$A\u0004d_\u0012,w-\u001a8\n\u0005Er#aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005%\u001a\u0014B\u0001\u001b\u001b\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\b!J|G-^2u!\t1D(\u0003\u0002>o\ta1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\t\u0001\t\u0005\u0002*\u0003&\u0011!I\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\r\u001e\u0003\"!\u000b\u0001\t\u000by\u001a\u0001\u0019\u0001!\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001K!\rY5K\u0016\b\u0003\u0019Fs!!\u0014)\u000e\u00039S!a\u0014\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0014B\u0001*8\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001V+\u0003\u0007M+\u0017O\u0003\u0002SoA\u0011qKW\u0007\u00021*\u0011\u0011LH\u0001\u0006if\u0004Xm]\u0005\u00037b\u0013\u0001\u0002R1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\ta+\u0001\u0005ok2d\u0017M\u00197f+\u0005\u0001\u0007C\u0001\u001cb\u0013\t\u0011wGA\u0004C_>dW-\u00198\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001f!\t1'N\u0004\u0002hQB\u0011QjN\u0005\u0003S^\na\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011nN\u0001\u0005KZ\fG\u000e\u0006\u0002peB\u0011a\u0007]\u0005\u0003c^\u00121!\u00118z\u0011\u001d\u0019\b\u0002%AA\u0002Q\fQ!\u001b8qkR\u0004\"!\u001e<\u000e\u0003qI!a\u001e\u000f\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\fO\u0016$(j]8o\u0017\u0016L8\u000fF\u0003{\u0003\u0003\ti\u0002\u0005\u0002|}6\tAP\u0003\u0002~9\u0005!Q\u000f^5m\u0013\tyHP\u0001\tHK:,'/[2BeJ\f\u0017\u0010R1uC\"9\u00111A\u0005A\u0002\u0005\u0015\u0011A\u00029beN,'\u000f\u0005\u0003\u0002\b\u0005eQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\t\r|'/\u001a\u0006\u0005\u0003\u001f\t\t\"A\u0004kC\u000e\\7o\u001c8\u000b\t\u0005M\u0011QC\u0001\nM\u0006\u001cH/\u001a:y[2T!!a\u0006\u0002\u0007\r|W.\u0003\u0003\u0002\u001c\u0005%!A\u0003&t_:\u0004\u0016M]:fe\")1/\u0003a\u0001i\u0006!1m\u001c9z)\r1\u00151\u0005\u0005\b})\u0001\n\u00111\u0001A\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u000b+\u0007\u0001\u000bYc\u000b\u0002\u0002.A!\u0011qFA\u001d\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012!C;oG\",7m[3e\u0015\r\t9dN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001e\u0003c\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\ni%\u0004\u0002\u0002F)!\u0011qIA%\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0013\u0001\u00026bm\u0006L1a[A#\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\u0019\u0006E\u00027\u0003+J1!a\u00168\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ry\u0017Q\f\u0005\n\u0003?r\u0011\u0011!a\u0001\u0003'\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA3!\u0015\t9'!\u001cp\u001b\t\tIGC\u0002\u0002l]\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty'!\u001b\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004A\u0006U\u0004\u0002CA0!\u0005\u0005\t\u0019A8\u0002\r\u0015\fX/\u00197t)\r\u0001\u00171\u0010\u0005\t\u0003?\n\u0012\u0011!a\u0001_\":\u0002!a \u0002\u0006\u0006\u001d\u00151RAG\u0003#\u000b\u0019*a&\u0002\u001a\u0006u\u0015q\u0014\t\u0004S\u0005\u0005\u0015bAAB5\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAE\u0003I{f)\u0016(D?\"R7o\u001c8`_\nTWm\u0019;*A5\u0002#+\u001a;ve:\u001c\b%\u00197mAQDW\rI6fsN\u0004sN\u001a\u0011uQ\u0016\u0004s.\u001e;n_N$\bES*P\u001d\u0002z'M[3di\u0002\n7\u000fI1oA\u0005\u0014(/Y=/\u0003%\t'oZ;nK:$8/\t\u0002\u0002\u0010\u0006\u0011\u0019D\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!UN|gnX8cU\u0016\u001cG\u000fI\u0017!\u0003\u0002R5k\u0014(!_\nTWm\u0019;/A%3\u0007%\u0019\u0011wC2LG\r\t&T\u001f:\u0003sN\u00196fGR\u0004\u0013n\u001d\u0011hSZ,g\u000e\f\u0011bY2\u0004C\u000f[3!W\u0016L8\u000fI8gAQDW\rI8vi6|7\u000f\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001z'M[3di\u0002:\u0018\u000e\u001c7!E\u0016\u0004#/\u001a;ve:,G\rI1tA\u0005t\u0007%\u0019:sCft\u0003%\u00134!SR\u0004\u0013n\u001d\u0011b]f\u0004s\u000e\u001e5fe\u00022\u0018\r\\5eA)\u001bvJ\u0014\u0011tiJLgn\u001a\u0017!C:\u0004\u0013N\u001c<bY&$\u0007ES*P\u001d*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I:ue&tw\rI8sA\u0005t\u0007%Z7qif\u00043\u000f\u001e:j]\u001ed\u0003\u0005\u001e5fA\u0019,hn\u0019;j_:\u0004#/\u001a;ve:\u001c\bE\\;mY:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QS\u0001\u0002\u0014*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse_?(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003eW/\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dZ(e[3zEi\u0002#E^1mk\u0016\u0014SpJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001Z&e[3zEuS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ>#MF\u0012#HI1cG\nb#E\u001a\u001a#um\u0014cm\r\u0012;E\u0005\u0014C\u0006\t\u0012gi\tR$E\u0019\u0012~{\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011\\E\u0019\f$\u0005\f\u0012ge\tj&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005m\u0015A\u00036t_:|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011\u0011U\u0001\u0006g9\nd\u0006M\u0001\u000f\u0015N|gn\u00142kK\u000e$8*Z=t!\tI3c\u0005\u0003\u0014\u0003S[\u0004CBAV\u0003c\u0003e)\u0004\u0002\u0002.*\u0019\u0011qV\u001c\u0002\u000fI,h\u000e^5nK&!\u00111WAW\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003K\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0003\nQ!\u00199qYf$2ARA`\u0011\u0015qd\u00031\u0001A\u0003\u001d)h.\u00199qYf$B!!2\u0002LB!a'a2A\u0013\r\tIm\u000e\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u00055w#!AA\u0002\u0019\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005M\u0007\u0003BA\"\u0003+LA!a6\u0002F\t1qJ\u00196fGR\u0004")
public class JsonObjectKeys
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(JsonObjectKeys jsonObjectKeys) {
        return JsonObjectKeys$.MODULE$.unapply(jsonObjectKeys);
    }

    public static <A> Function1<Expression, A> andThen(Function1<JsonObjectKeys, A> function1) {
        return JsonObjectKeys$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, JsonObjectKeys> compose(Function1<A, Expression> function1) {
        return JsonObjectKeys$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply(StringType$.MODULE$);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "json_object_keys";
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object object2 = new Object();
        try {
            UTF8String json = (UTF8String)this.child().eval(input);
            if (json == null) {
                return null;
            }
            try {
                object = Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), json), (Function1 & Serializable & scala.Serializable)parser -> {
                    block3: {
                        block2: {
                            if (parser.nextToken() == null) break block2;
                            JsonToken jsonToken = parser.currentToken();
                            JsonToken jsonToken2 = JsonToken.START_OBJECT;
                            if (!(jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2))) break block3;
                        }
                        throw new NonLocalReturnControl(object2, null);
                    }
                    return this.getJsonKeys((JsonParser)parser, input);
                });
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof IOException;
                if (!bl) {
                    throw throwable;
                }
                Object var2_7 = null;
                object = var2_7;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    private GenericArrayData getJsonKeys(JsonParser parser, InternalRow input) {
        ArrayBuffer arrayBufferOfKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (parser.nextValue() != null && parser.currentName() != null) {
            arrayBufferOfKeys.$plus$eq((Object)UTF8String.fromString((String)parser.getCurrentName()));
            parser.skipChildren();
        }
        return new GenericArrayData(arrayBufferOfKeys.toArray(ClassTag$.MODULE$.apply(UTF8String.class)));
    }

    public JsonObjectKeys copy(Expression child) {
        return new JsonObjectKeys(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "JsonObjectKeys";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonObjectKeys;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonObjectKeys)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonObjectKeys jsonObjectKeys = (JsonObjectKeys)x$1;
        Expression expression = this.child();
        Expression expression2 = jsonObjectKeys.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!jsonObjectKeys.canEqual(this)) return false;
        return true;
    }

    public JsonObjectKeys(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

