/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FrameLessOffsetWindowFunction;
import org.apache.spark.sql.catalyst.expressions.Lag$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.package$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExpressionDescription(usage="\n    _FUNC_(input[, offset[, default]]) - Returns the value of `input` at the `offset`th row\n      before the current row in the window. The default value of `offset` is 1 and the default\n      value of `default` is null. If the value of `input` at the `offset`th row is null,\n      null is returned. If there is no such offset row (e.g., when the offset is 1, the first\n      row of the window does not have any previous row), `default` is returned.\n  ", arguments="\n    Arguments:\n      * input - a string expression to evaluate `offset` rows before the current row.\n      * offset - an int expression which is rows to jump back in the partition.\n      * default - a string expression which is to use when the offset row does not exist.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\tNULL\n       A1\t1\t1\n       A1\t2\t1\n       A2\t3\tNULL\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0010!\u00016B\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005{!A\u0011\t\u0001BK\u0002\u0013\u0005A\b\u0003\u0005C\u0001\tE\t\u0015!\u0003>\u0011!\u0019\u0005A!f\u0001\n\u0003a\u0004\u0002\u0003#\u0001\u0005#\u0005\u000b\u0011B\u001f\t\u000b\u0015\u0003A\u0011\u0001$\t\u000b\u0015\u0003A\u0011A&\t\u000b\u0015\u0003A\u0011A(\t\u000b\u0015\u0003A\u0011A)\t\u000bI\u0003A\u0011I*\t\u000f9\u0003!\u0019!C!y!1\u0001\r\u0001Q\u0001\nuBq!\u0019\u0001\u0002\u0002\u0013\u0005!\rC\u0004g\u0001E\u0005I\u0011A4\t\u000fI\u0004\u0011\u0013!C\u0001O\"91\u000fAI\u0001\n\u00039\u0007b\u0002;\u0001\u0003\u0003%\t%\u001e\u0005\b}\u0002\t\t\u0011\"\u0001\u0000\u0011%\t9\u0001AA\u0001\n\u0003\tI\u0001C\u0005\u0002\u0016\u0001\t\t\u0011\"\u0011\u0002\u0018!I\u0011Q\u0005\u0001\u0002\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003c\u0001\u0011\u0011!C!\u0003g9\u0011\"!\u0018!\u0003\u0003E\t!a\u0018\u0007\u0011}\u0001\u0013\u0011!E\u0001\u0003CBa!R\r\u0005\u0002\u0005=\u0004\"CA93\u0005\u0005IQIA:\u0011%\t)(GA\u0001\n\u0003\u000b9\bC\u0005\u0002\u0000e\t\t\u0011\"!\u0002\u0002\"I\u00111S\r\u0002\u0002\u0013%\u0011Q\u0013\u0002\u0004\u0019\u0006<'BA\u0011#\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\r\"\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u00152\u0013aA:rY*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001q#\u0007\u000f\t\u0003_Aj\u0011\u0001I\u0005\u0003c\u0001\u0012QD\u0012:b[\u0016dUm]:PM\u001a\u001cX\r^,j]\u0012|wOR;oGRLwN\u001c\t\u0003gYj\u0011\u0001\u000e\u0006\u0002k\u0005)1oY1mC&\u0011q\u0007\u000e\u0002\b!J|G-^2u!\t\u0019\u0014(\u0003\u0002;i\ta1+\u001a:jC2L'0\u00192mK\u0006)\u0011N\u001c9viV\tQ\b\u0005\u00020}%\u0011q\b\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB5oaV$\b%A\u0006j]B,Ho\u00144gg\u0016$\u0018\u0001D5oaV$xJ\u001a4tKR\u0004\u0013a\u00023fM\u0006,H\u000e^\u0001\tI\u00164\u0017-\u001e7uA\u00051A(\u001b8jiz\"Ba\u0012%J\u0015B\u0011q\u0006\u0001\u0005\u0006w\u001d\u0001\r!\u0010\u0005\u0006\u0003\u001e\u0001\r!\u0010\u0005\u0006\u0007\u001e\u0001\r!\u0010\u000b\u0004\u000f2k\u0005\"B\u001e\t\u0001\u0004i\u0004\"\u0002(\t\u0001\u0004i\u0014AB8gMN,G\u000f\u0006\u0002H!\")1(\u0003a\u0001{Q\tq)\u0001\u0005dQ&dGM]3o+\u0005!\u0006cA+^{9\u0011ak\u0017\b\u0003/jk\u0011\u0001\u0017\u0006\u000332\na\u0001\u0010:p_Rt\u0014\"A\u001b\n\u0005q#\u0014a\u00029bG.\fw-Z\u0005\u0003=~\u00131aU3r\u0015\taF'A\u0004pM\u001a\u001cX\r\u001e\u0011\u0002\t\r|\u0007/\u001f\u000b\u0005\u000f\u000e$W\rC\u0004<\u001dA\u0005\t\u0019A\u001f\t\u000f\u0005s\u0001\u0013!a\u0001{!91I\u0004I\u0001\u0002\u0004i\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0002Q*\u0012Q([\u0016\u0002UB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u001c\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002rY\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001w!\t9H0D\u0001y\u0015\tI(0\u0001\u0003mC:<'\"A>\u0002\t)\fg/Y\u0005\u0003{b\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0001!\r\u0019\u00141A\u0005\u0004\u0003\u000b!$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0006\u0003#\u00012aMA\u0007\u0013\r\ty\u0001\u000e\u0002\u0004\u0003:L\b\"CA\n)\u0005\u0005\t\u0019AA\u0001\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0004\t\u0007\u00037\t\t#a\u0003\u000e\u0005\u0005u!bAA\u0010i\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0012Q\u0004\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002*\u0005=\u0002cA\u001a\u0002,%\u0019\u0011Q\u0006\u001b\u0003\u000f\t{w\u000e\\3b]\"I\u00111\u0003\f\u0002\u0002\u0003\u0007\u00111B\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005%\u0012Q\u0007\u0005\n\u0003'9\u0012\u0011!a\u0001\u0003\u0017As\u0003AA\u001d\u0003\u007f\t\t%!\u0012\u0002H\u0005-\u0013QJA)\u0003'\n9&!\u0017\u0011\u0007=\nY$C\u0002\u0002>\u0001\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002D\u0005\u0019YI\u0003\u0011!A\u0001zf)\u0016(D?\"Jg\u000e];u72\u0002sN\u001a4tKR\\F\u0006\t3fM\u0006,H\u000e^/^S\u0001j\u0003EU3ukJt7\u000f\t;iK\u00022\u0018\r\\;fA=4\u0007\u0005Y5oaV$\b\rI1uAQDW\r\t1pM\u001a\u001cX\r\u001e1uQ\u0002\u0012xn\u001e\u0006!A\u0001\u0002\u0003\u0005\t2fM>\u0014X\r\t;iK\u0002\u001aWO\u001d:f]R\u0004#o\\<!S:\u0004C\u000f[3!o&tGm\\</AQCW\r\t3fM\u0006,H\u000e\u001e\u0011wC2,X\rI8gA\u0001|gMZ:fi\u0002\u0004\u0013n\u001d\u00112A\u0005tG\r\t;iK\u0002\"WMZ1vYRT\u0001\u0005\t\u0011!A\u00012\u0018\r\\;fA=4\u0007\u0005\u00193fM\u0006,H\u000e\u001e1!SN\u0004c.\u001e7m]\u0001Je\r\t;iK\u00022\u0018\r\\;fA=4\u0007\u0005Y5oaV$\b\rI1uAQDW\r\t1pM\u001a\u001cX\r\u001e1uQ\u0002\u0012xn\u001e\u0011jg\u0002rW\u000f\u001c7-\u0015\u0001\u0002\u0003\u0005\t\u0011!]VdG\u000eI5tAI,G/\u001e:oK\u0012t\u0003%\u00134!i\",'/\u001a\u0011jg\u0002rw\u000eI:vG\"\u0004sN\u001a4tKR\u0004#o\\<!Q\u0015tsM\f\u0017!o\",g\u000e\t;iK\u0002zgMZ:fi\u0002J7\u000fI\u0019-AQDW\r\t4jeN$(\u0002\t\u0011!A\u0001\u0002#o\\<!_\u001a\u0004C\u000f[3!o&tGm\\<!I>,7\u000f\t8pi\u0002B\u0017M^3!C:L\b\u0005\u001d:fm&|Wo\u001d\u0011s_^LC\u0006\t1eK\u001a\fW\u000f\u001c;aA%\u001c\bE]3ukJtW\r\u001a\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005%\u0013A!\n\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001Jg\u000e];uA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]\u0002\"x\u000eI3wC2,\u0018\r^3!A>4gm]3uA\u0002\u0012xn^:!E\u00164wN]3!i\",\u0007eY;se\u0016tG\u000f\t:po:R\u0001\u0005\t\u0011!A\u0001R\u0003e\u001c4gg\u0016$\b%\f\u0011b]\u0002Jg\u000e\u001e\u0011fqB\u0014Xm]:j_:\u0004s\u000f[5dQ\u0002J7\u000f\t:poN\u0004Co\u001c\u0011kk6\u0004\bEY1dW\u0002Jg\u000e\t;iK\u0002\u0002\u0018M\u001d;ji&|gN\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!I\u00164\u0017-\u001e7uA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]\u0002:\b.[2iA%\u001c\b\u0005^8!kN,\u0007e\u001e5f]\u0002\"\b.\u001a\u0011pM\u001a\u001cX\r\u001e\u0011s_^\u0004Cm\\3tA9|G\u000fI3ySN$hF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA(\u0003\u0005\r&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI1-A\td\u0003e\u0018$V\u001d\u000e{\u0006FY\u0015!\u001fZ+%\u000b\t\u0015Q\u0003J#\u0016\nV%P\u001d\u0002\u0012\u0015\fI1!\u001fJ#UI\u0015\u0011C3\u0002\u0012\u0017\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003fJ!2O1\u0002#'\u000b\u0017!Q\u001d\n\u0015g\n\u0017!c%b\u0003\u0005K\u0014Be\u001db\u0003eM\u0015-A!:\u0013)M\u0014-AEJ\u0003\u0005^1cQ\u0005d\u0003EY\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u000b\u0014\"M\u0005O+2c%\u0002\t\u0011!A\u0001\u0002\u0003%Q\u0019\nc%\t$\u0002\t\u0011!A\u0001\u0002\u0003%Q\u0019\ne%\t$\u0002\t\u0011!A\u0001\u0002\u0003%\u0011\u001a\ng%qU\u000b\u0014'\u000bA\u0001\nQa]5oG\u0016\f#!!\u0016\u0002\u000bIr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005m\u0013\u0001D<j]\u0012|wo\u00184v]\u000e\u001c\u0018a\u0001'bOB\u0011q&G\n\u00053\u0005\r\u0004\b\u0005\u0005\u0002f\u0005-T(P\u001fH\u001b\t\t9GC\u0002\u0002jQ\nqA];oi&lW-\u0003\u0003\u0002n\u0005\u001d$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u0011qL\u0001\ti>\u001cFO]5oOR\ta/A\u0003baBd\u0017\u0010F\u0004H\u0003s\nY(! \t\u000bmb\u0002\u0019A\u001f\t\u000b\u0005c\u0002\u0019A\u001f\t\u000b\rc\u0002\u0019A\u001f\u0002\u000fUt\u0017\r\u001d9msR!\u00111QAH!\u0015\u0019\u0014QQAE\u0013\r\t9\t\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\rM\nY)P\u001f>\u0013\r\ti\t\u000e\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005EU$!AA\u0002\u001d\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005]\u0005cA<\u0002\u001a&\u0019\u00111\u0014=\u0003\r=\u0013'.Z2u\u0001")
public class Lag
extends FrameLessOffsetWindowFunction
implements Serializable {
    private final Expression input;
    private final Expression inputOffset;
    private final Expression default;
    private final Expression offset;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Lag lag) {
        return Lag$.MODULE$.unapply(lag);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Lag> tupled() {
        return Lag$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Lag>>> curried() {
        return Lag$.MODULE$.curried();
    }

    @Override
    public Expression input() {
        return this.input;
    }

    public Expression inputOffset() {
        return this.inputOffset;
    }

    @Override
    public Expression default() {
        return this.default;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.input(), this.inputOffset(), this.default()}));
    }

    @Override
    public Expression offset() {
        return this.offset;
    }

    public Lag copy(Expression input, Expression inputOffset, Expression expression) {
        return new Lag(input, inputOffset, expression);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.inputOffset();
    }

    public Expression copy$default$3() {
        return this.default();
    }

    @Override
    public String productPrefix() {
        return "Lag";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.input();
                break;
            }
            case 1: {
                expression = this.inputOffset();
                break;
            }
            case 2: {
                expression = this.default();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Lag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Lag)) return false;
        boolean bl = true;
        if (!bl) return false;
        Lag lag = (Lag)x$1;
        Expression expression = this.input();
        Expression expression2 = lag.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.inputOffset();
        Expression expression4 = lag.inputOffset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.default();
        Expression expression6 = lag.default();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!lag.canEqual(this)) return false;
        return true;
    }

    public Lag(Expression input, Expression inputOffset, Expression expression) {
        UnaryMinus unaryMinus;
        this.input = input;
        this.inputOffset = inputOffset;
        this.default = expression;
        UnaryMinus unaryMinus2 = new UnaryMinus(inputOffset, UnaryMinus$.MODULE$.apply$default$2());
        Expression expression2 = unaryMinus2 != null && (unaryMinus = unaryMinus2).foldable() ? Literal$.MODULE$.create(unaryMinus.eval(package$.MODULE$.EmptyRow()), unaryMinus.dataType()) : unaryMinus2;
        this.offset = expression2;
    }

    public Lag(Expression input, Expression offset) {
        this(input, offset, Literal$.MODULE$.apply(null));
    }

    public Lag(Expression input) {
        this(input, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }

    public Lag() {
        this(Literal$.MODULE$.apply(null));
    }
}

