/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringRPad$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, len[, pad]) - Returns `str`, right-padded with `pad` to a length of `len`.\n      If `str` is longer than `len`, the return value is shortened to `len` characters.\n      If `pad` is not specified, `str` will be padded to the right with space characters.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('hi', 5, '??');\n       hi???\n      > SELECT _FUNC_('hi', 1, '??');\n       h\n      > SELECT _FUNC_('hi', 5);\n       hi\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011!\u0001\u0006A!f\u0001\n\u0003I\u0005\u0002C)\u0001\u0005#\u0005\u000b\u0011\u0002&\t\u000bI\u0003A\u0011A*\t\u000bI\u0003A\u0011\u0001-\t\u000bm\u0003A\u0011\t/\t\u000b!\u0004A\u0011I5\t\u000bA\u0004A\u0011I9\t\u000bM\u0004A\u0011\t;\t\u000bm\u0004A\u0011\u000b?\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018!I\u0011\u0011\u0006\u0001\u0002\u0002\u0013\u0005\u00111\u0006\u0005\n\u0003g\u0001\u0011\u0013!C\u0001\u0003kA\u0011\"a\u0013\u0001#\u0003%\t!!\u000e\t\u0013\u00055\u0003!%A\u0005\u0002\u0005U\u0002\"CA(\u0001\u0005\u0005I\u0011IA)\u0011%\t\t\u0007AA\u0001\n\u0003\t\u0019\u0007C\u0005\u0002l\u0001\t\t\u0011\"\u0001\u0002n!I\u00111\u000f\u0001\u0002\u0002\u0013\u0005\u0013Q\u000f\u0005\n\u0003\u0007\u0003\u0011\u0011!C\u0001\u0003\u000bC\u0011\"a$\u0001\u0003\u0003%\t%!%\b\u0013\u0005=6%!A\t\u0002\u0005Ef\u0001\u0003\u0012$\u0003\u0003E\t!a-\t\rISB\u0011AAa\u0011%\t\u0019MGA\u0001\n\u000b\n)\rC\u0005\u0002Hj\t\t\u0011\"!\u0002J\"I\u0011\u0011\u001b\u000e\u0012\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003'T\u0012\u0011!CA\u0003+D\u0011\"a:\u001b#\u0003%\t!!\u000e\t\u0013\u0005%($!A\u0005\n\u0005-(AC*ue&twM\u0015)bI*\u0011A%J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002'O\u0005A1-\u0019;bYf\u001cHO\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001cUBt(\u0012\t\u0003eMj\u0011aI\u0005\u0003i\r\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0011d'\u0003\u00028G\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002:y9\u0011!GO\u0005\u0003w\r\nq\u0001]1dW\u0006<W-\u0003\u0002>}\tqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA\u001e$!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0011$\n\u0005\u001d\u000b%\u0001D*fe&\fG.\u001b>bE2,\u0017aA:ueV\t!\n\u0005\u00023\u0017&\u0011Aj\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001B:ue\u0002\n1\u0001\\3o\u0003\u0011aWM\u001c\u0011\u0002\u0007A\fG-\u0001\u0003qC\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003U+Z;\u0006C\u0001\u001a\u0001\u0011\u0015Au\u00011\u0001K\u0011\u0015qu\u00011\u0001K\u0011\u001d\u0001v\u0001%AA\u0002)#2\u0001V-[\u0011\u0015A\u0005\u00021\u0001K\u0011\u0015q\u0005\u00021\u0001K\u0003!\u0019\u0007.\u001b7ee\u0016tW#A/\u0011\u0007y+'J\u0004\u0002`I:\u0011\u0001mY\u0007\u0002C*\u0011!mL\u0001\u0007yI|w\u000e\u001e \n\u0003\tK!aO!\n\u0005\u0019<'aA*fc*\u00111(Q\u0001\tI\u0006$\u0018\rV=qKV\t!\u000e\u0005\u0002l]6\tAN\u0003\u0002nO\u0005)A/\u001f9fg&\u0011q\u000e\u001c\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003I\u00042AX3k\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011)\b0\u001f>\u0011\u0005\u00013\u0018BA<B\u0005\r\te.\u001f\u0005\u0006\u00112\u0001\r!\u001e\u0005\u0006\u001d2\u0001\r!\u001e\u0005\u0006!2\u0001\r!^\u0001\nI><UM\\\"pI\u0016$R!`A\u0004\u0003#\u00012A`A\u0002\u001b\u0005y(bAA\u0001G\u000591m\u001c3fO\u0016t\u0017bAA\u0003\u007f\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\n5\u0001\r!a\u0003\u0002\u0007\r$\b\u0010E\u0002\u007f\u0003\u001bI1!a\u0004\u0000\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!a\u0005\u000e\u0001\u0004i\u0018AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u00033\u0001B!a\u0007\u0002$9!\u0011QDA\u0010!\t\u0001\u0017)C\u0002\u0002\"\u0005\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0013\u0003O\u0011aa\u0015;sS:<'bAA\u0011\u0003\u0006!1m\u001c9z)\u001d!\u0016QFA\u0018\u0003cAq\u0001S\b\u0011\u0002\u0003\u0007!\nC\u0004O\u001fA\u0005\t\u0019\u0001&\t\u000fA{\u0001\u0013!a\u0001\u0015\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001cU\rQ\u0015\u0011H\u0016\u0003\u0003w\u0001B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0005v]\u000eDWmY6fI*\u0019\u0011QI!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002J\u0005}\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005M\u0003\u0003BA+\u0003?j!!a\u0016\u000b\t\u0005e\u00131L\u0001\u0005Y\u0006twM\u0003\u0002\u0002^\u0005!!.\u0019<b\u0013\u0011\t)#a\u0016\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0004c\u0001!\u0002h%\u0019\u0011\u0011N!\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007U\fy\u0007C\u0005\u0002rU\t\t\u00111\u0001\u0002f\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001e\u0011\u000b\u0005e\u0014qP;\u000e\u0005\u0005m$bAA?\u0003\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00151\u0010\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\b\u00065\u0005c\u0001!\u0002\n&\u0019\u00111R!\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011O\f\u0002\u0002\u0003\u0007Q/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000f\u000b\u0019\n\u0003\u0005\u0002ra\t\t\u00111\u0001vQ=\u0001\u0011qSAO\u0003?\u000b\u0019+!*\u0002*\u0006-\u0006c\u0001\u001a\u0002\u001a&\u0019\u00111T\u0012\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011U\u0001\u0003\")\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJd\u0003\u0005\\3o72\u0002\u0003/\u00193^S\u0001j\u0003EU3ukJt7\u000f\t1tiJ\u0004G\u0006\t:jO\"$X\u0006]1eI\u0016$\u0007e^5uQ\u0002\u0002\u0007/\u00193aAQ|\u0007%\u0019\u0011mK:<G\u000f\u001b\u0011pM\u0002\u0002G.\u001a8a])\u0001\u0003\u0005\t\u0011!A%3\u0007\u0005Y:ue\u0002\u0004\u0013n\u001d\u0011m_:<WM\u001d\u0011uQ\u0006t\u0007\u0005\u00197f]\u0002d\u0003\u0005\u001e5fAI,G/\u001e:oAY\fG.^3!SN\u00043\u000f[8si\u0016tW\r\u001a\u0011u_\u0002\u0002G.\u001a8aA\rD\u0017M]1di\u0016\u00148O\f\u0006!A\u0001\u0002\u0003\u0005I%gA\u0001\u0004\u0018\r\u001a1!SN\u0004cn\u001c;!gB,7-\u001b4jK\u0012d\u0003\u0005Y:ue\u0002\u0004s/\u001b7mA\t,\u0007\u0005]1eI\u0016$\u0007\u0005^8!i\",\u0007E]5hQR\u0004s/\u001b;iAM\u0004\u0018mY3!G\"\f'/Y2uKJ\u001chF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAT\u0003\u0005m\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014iS\u001eb\u0003%\u000e\u0017!O}zt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!Q&|th\u0010\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!Lw\u0005\f\u00112Y\u0001:shP\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001B'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014iS\u001eb\u0003%N\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A!L'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u00055\u0016!B\u0019/k9\u0002\u0014AC*ue&twM\u0015)bIB\u0011!GG\n\u00055\u0005UV\t\u0005\u0005\u00028\u0006u&J\u0013&U\u001b\t\tILC\u0002\u0002<\u0006\u000bqA];oi&lW-\u0003\u0003\u0002@\u0006e&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u0011\u0011W\u0001\ti>\u001cFO]5oOR\u0011\u00111K\u0001\u0006CB\u0004H.\u001f\u000b\b)\u0006-\u0017QZAh\u0011\u0015AU\u00041\u0001K\u0011\u0015qU\u00041\u0001K\u0011\u001d\u0001V\u0004%AA\u0002)\u000bq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9.a9\u0011\u000b\u0001\u000bI.!8\n\u0007\u0005m\u0017I\u0001\u0004PaRLwN\u001c\t\u0007\u0001\u0006}'J\u0013&\n\u0007\u0005\u0005\u0018I\u0001\u0004UkBdWm\r\u0005\t\u0003K|\u0012\u0011!a\u0001)\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u00055\b\u0003BA+\u0003_LA!!=\u0002X\t1qJ\u00196fGR\u0004")
public class StringRPad
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression str;
    private final Expression len;
    private final Expression pad;

    public static Expression $lessinit$greater$default$3() {
        return StringRPad$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringRPad stringRPad) {
        return StringRPad$.MODULE$.unapply(stringRPad);
    }

    public static Expression apply$default$3() {
        return StringRPad$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringRPad> tupled() {
        return StringRPad$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringRPad>>> curried() {
        return StringRPad$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression len() {
        return this.len;
    }

    public Expression pad() {
        return this.pad;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.len();
        Expression expression3 = this.pad();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object str, Object len, Object pad) {
        return ((UTF8String)str).rpad(BoxesRunTime.unboxToInt((Object)len), (UTF8String)pad);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(str, len, pad) -> new StringBuilder(9).append((String)str).append(".rpad(").append((String)len).append(", ").append((String)pad).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "rpad";
    }

    public StringRPad copy(Expression str, Expression len, Expression pad) {
        return new StringRPad(str, len, pad);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.len();
    }

    public Expression copy$default$3() {
        return this.pad();
    }

    @Override
    public String productPrefix() {
        return "StringRPad";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.len();
                break;
            }
            case 2: {
                expression = this.pad();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringRPad;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringRPad)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringRPad stringRPad = (StringRPad)x$1;
        Expression expression = this.str();
        Expression expression2 = stringRPad.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.len();
        Expression expression4 = stringRPad.len();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.pad();
        Expression expression6 = stringRPad.pad();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringRPad.canEqual(this)) return false;
        return true;
    }

    public StringRPad(Expression str, Expression len, Expression pad) {
        this.str = str;
        this.len = len;
        this.pad = pad;
        ExpectsInputTypes.$init$(this);
    }

    public StringRPad(Expression str, Expression len) {
        this(str, len, Literal$.MODULE$.apply(" "));
    }
}

