/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.MaxMinBy;
import org.apache.spark.sql.catalyst.expressions.aggregate.MinBy$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(x, y) - Returns the value of `x` associated with the minimum value of `y`.", examples="\n    Examples:\n      > SELECT _FUNC_(x, y) FROM VALUES (('a', 10)), (('b', 50)), (('c', 20)) AS tab(x, y);\n       a\n  ", group="agg_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\r\u001b\u0001&B\u0001b\u000e\u0001\u0003\u0016\u0004%\t\u0001\u000f\u0005\t{\u0001\u0011\t\u0012)A\u0005s!Aa\b\u0001BK\u0002\u0013\u0005\u0001\b\u0003\u0005@\u0001\tE\t\u0015!\u0003:\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u0015)\u0005\u0001\"\u0011G\u0011\u0015\u0011\u0006\u0001\"\u0015T\u0011\u0015A\u0006\u0001\"\u0015Z\u0011\u001da\u0006!!A\u0005\u0002uCq\u0001\u0019\u0001\u0012\u0002\u0013\u0005\u0011\rC\u0004m\u0001E\u0005I\u0011A1\t\u000f5\u0004\u0011\u0011!C!]\"9a\u000fAA\u0001\n\u00039\bbB>\u0001\u0003\u0003%\t\u0001 \u0005\n\u0003\u000b\u0001\u0011\u0011!C!\u0003\u000fA\u0011\"!\u0006\u0001\u0003\u0003%\t!a\u0006\t\u0013\u0005\u0005\u0002!!A\u0005B\u0005\rr!CA$5\u0005\u0005\t\u0012AA%\r!I\"$!A\t\u0002\u0005-\u0003B\u0002!\u0014\t\u0003\tI\u0006C\u0005\u0002\\M\t\t\u0011\"\u0012\u0002^!I\u0011qL\n\u0002\u0002\u0013\u0005\u0015\u0011\r\u0005\n\u0003O\u001a\u0012\u0011!CA\u0003SB\u0011\"a\u001f\u0014\u0003\u0003%I!! \u0003\u000b5KgNQ=\u000b\u0005ma\u0012!C1hOJ,w-\u0019;f\u0015\tib$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0010!\u0003!\u0019\u0017\r^1msN$(BA\u0011#\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003G\u0011\nQa\u001d9be.T!!\n\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0013aA8sO\u000e\u00011\u0003\u0002\u0001+]Q\u0002\"a\u000b\u0017\u000e\u0003iI!!\f\u000e\u0003\u00115\u000b\u00070T5o\u0005f\u0004\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00020k%\u0011a\u0007\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\nm\u0006dW/Z#yaJ,\u0012!\u000f\t\u0003umj\u0011\u0001H\u0005\u0003yq\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003)1\u0018\r\\;f\u000bb\u0004(\u000fI\u0001\r_J$WM]5oO\u0016C\bO]\u0001\u000e_J$WM]5oO\u0016C\bO\u001d\u0011\u0002\rqJg.\u001b;?)\r\u00115\t\u0012\t\u0003W\u0001AQaN\u0003A\u0002eBQAP\u0003A\u0002e\n!\u0002\u001d:fiRLh*Y7f+\u00059\u0005C\u0001%P\u001d\tIU\n\u0005\u0002Ka5\t1J\u0003\u0002MQ\u00051AH]8pizJ!A\u0014\u0019\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0016K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001dB\n\u0011\u0002\u001d:fI&\u001c\u0017\r^3\u0015\u0007e\"f\u000bC\u0003V\u000f\u0001\u0007\u0011(A\u0004pY\u0012,\u0005\u0010\u001d:\t\u000b];\u0001\u0019A\u001d\u0002\u000f9,w/\u0012=qe\u0006yqN\u001d3fe&tw-\u00169eCR,'\u000fF\u0002:5nCQ!\u0016\u0005A\u0002eBQa\u0016\u0005A\u0002e\nAaY8qsR\u0019!IX0\t\u000f]J\u0001\u0013!a\u0001s!9a(\u0003I\u0001\u0002\u0004I\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0002E*\u0012\u0011hY\u0016\u0002IB\u0011QM[\u0007\u0002M*\u0011q\r[\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001b\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002lM\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\u0012a\u001c\t\u0003aVl\u0011!\u001d\u0006\u0003eN\fA\u0001\\1oO*\tA/\u0001\u0003kCZ\f\u0017B\u0001)r\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005A\bCA\u0018z\u0013\tQ\bGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002~\u0003\u0003\u0001\"a\f@\n\u0005}\u0004$aA!os\"A\u00111\u0001\b\u0002\u0002\u0003\u0007\u00010A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0013\u0001R!a\u0003\u0002\u0012ul!!!\u0004\u000b\u0007\u0005=\u0001'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0005\u0002\u000e\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI\"a\b\u0011\u0007=\nY\"C\u0002\u0002\u001eA\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u0004A\t\t\u00111\u0001~\u0003\u0019)\u0017/^1mgR!\u0011\u0011DA\u0013\u0011!\t\u0019!EA\u0001\u0002\u0004i\bf\u0005\u0001\u0002*\u0005=\u0012\u0011GA\u001b\u0003o\tY$!\u0010\u0002B\u0005\r\u0003c\u0001\u001e\u0002,%\u0019\u0011Q\u0006\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111G\u0001R?\u001a+fjQ0)q2\u0002\u00130\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011wC2,X\rI8gA\u0001D\b\rI1tg>\u001c\u0017.\u0019;fI\u0002:\u0018\u000e\u001e5!i\",\u0007%\\5oS6,X\u000e\t<bYV,\u0007e\u001c4!Af\u0004g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tI$\u0001<\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Qad\u0003%_\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u0015)O\u0005<C\u0006I\u00191S%b\u0003\u0005\u000b\u0015(E\u001eb\u0003%\u000e\u0019*S1\u0002\u0003\u0006K\u0014dO1\u0002#\u0007M\u0015*A\u0005\u001b\u0006\u0005^1cQad\u0003%_\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005T\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u007f\t\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005\u0015\u0013!B\u001a/a9\u0002\u0014!B'j]\nK\bCA\u0016\u0014'\u0011\u0019\u0012Q\n\u001b\u0011\u000f\u0005=\u0013QK\u001d:\u00056\u0011\u0011\u0011\u000b\u0006\u0004\u0003'\u0002\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003/\n\tFA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!!\u0013\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\\\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0005\u0006\r\u0014Q\r\u0005\u0006oY\u0001\r!\u000f\u0005\u0006}Y\u0001\r!O\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY'a\u001e\u0011\u000b=\ni'!\u001d\n\u0007\u0005=\u0004G\u0001\u0004PaRLwN\u001c\t\u0006_\u0005M\u0014(O\u0005\u0004\u0003k\u0002$A\u0002+va2,'\u0007\u0003\u0005\u0002z]\t\t\u00111\u0001C\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0000A\u0019\u0001/!!\n\u0007\u0005\r\u0015O\u0001\u0004PE*,7\r\u001e")
public class MinBy
extends MaxMinBy {
    private final Expression valueExpr;
    private final Expression orderingExpr;

    public static Option<Tuple2<Expression, Expression>> unapply(MinBy minBy) {
        return MinBy$.MODULE$.unapply(minBy);
    }

    public static Function1<Tuple2<Expression, Expression>, MinBy> tupled() {
        return MinBy$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MinBy>> curried() {
        return MinBy$.MODULE$.curried();
    }

    @Override
    public Expression valueExpr() {
        return this.valueExpr;
    }

    @Override
    public Expression orderingExpr() {
        return this.orderingExpr;
    }

    @Override
    public String prettyName() {
        return "min_by";
    }

    @Override
    public Expression predicate(Expression oldExpr, Expression newExpr) {
        return (Expression)((Object)package$expressions$.MODULE$.DslExpression(oldExpr).$less(newExpr));
    }

    @Override
    public Expression orderingUpdater(Expression oldExpr, Expression newExpr) {
        return package$expressions$.MODULE$.least((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{oldExpr, newExpr}));
    }

    public MinBy copy(Expression valueExpr, Expression orderingExpr) {
        return new MinBy(valueExpr, orderingExpr);
    }

    public Expression copy$default$1() {
        return this.valueExpr();
    }

    public Expression copy$default$2() {
        return this.orderingExpr();
    }

    @Override
    public String productPrefix() {
        return "MinBy";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.valueExpr();
                break;
            }
            case 1: {
                expression = this.orderingExpr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MinBy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MinBy)) return false;
        boolean bl = true;
        if (!bl) return false;
        MinBy minBy = (MinBy)x$1;
        Expression expression = this.valueExpr();
        Expression expression2 = minBy.valueExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.orderingExpr();
        Expression expression4 = minBy.orderingExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!minBy.canEqual(this)) return false;
        return true;
    }

    public MinBy(Expression valueExpr, Expression orderingExpr) {
        this.valueExpr = valueExpr;
        this.orderingExpr = orderingExpr;
    }
}

