/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.expressions;

import java.util.Arrays;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.LogicalExpressions;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import scala.collection.JavaConverters;
import scala.collection.Seq;

@Evolving
public class Expressions {
    private Expressions() {
    }

    public static Transform apply(String name, Expression ... args) {
        return LogicalExpressions.apply(name, (Seq<Expression>)JavaConverters.asScalaBuffer(Arrays.asList(args)).toSeq());
    }

    public static NamedReference column(String name) {
        return LogicalExpressions.parseReference(name);
    }

    public static <T> Literal<T> literal(T value) {
        return LogicalExpressions.literal(value);
    }

    public static Transform bucket(int numBuckets, String ... columns) {
        NamedReference[] references2 = (NamedReference[])Arrays.stream(columns).map(Expressions::column).toArray(NamedReference[]::new);
        return LogicalExpressions.bucket(numBuckets, references2);
    }

    public static Transform identity(String column) {
        return LogicalExpressions.identity(Expressions.column(column));
    }

    public static Transform years(String column) {
        return LogicalExpressions.years(Expressions.column(column));
    }

    public static Transform months(String column) {
        return LogicalExpressions.months(Expressions.column(column));
    }

    public static Transform days(String column) {
        return LogicalExpressions.days(Expressions.column(column));
    }

    public static Transform hours(String column) {
        return LogicalExpressions.hours(Expressions.column(column));
    }
}

