/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ParseToDate$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(date_str[, fmt]) - Parses the `date_str` expression with the `fmt` expression to\n      a date. Returns null with invalid input. By default, it follows casting rules to a date if\n      the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * date_str - A string to be parsed to date.\n      * fmt - Date format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 04:17:52');\n       2009-07-30\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001B\u0010!\u00016B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005J\u0001\tE\t\u0015!\u0003G\u0011!Q\u0005A!f\u0001\n\u0003y\u0004\u0002C&\u0001\u0005#\u0005\u000b\u0011\u0002!\t\u000b1\u0003A\u0011A'\t\u000b1\u0003A\u0011\u0001*\t\u000b1\u0003A\u0011A+\t\u000b]\u0003A\u0011\t-\t\u000b\u0015\u0004A\u0011\t4\t\u000b5\u0004A\u0011\t8\t\u000b]\u0004A\u0011\u000b=\t\u000fm\u0004\u0011\u0011!C\u0001y\"I\u0011\u0011\u0001\u0001\u0012\u0002\u0013\u0005\u00111\u0001\u0005\n\u00033\u0001\u0011\u0013!C\u0001\u00037A\u0011\"a\b\u0001#\u0003%\t!a\u0001\t\u0013\u0005\u0005\u0002!!A\u0005B\u0005\r\u0002\"CA\u001a\u0001\u0005\u0005I\u0011AA\u001b\u0011%\ti\u0004AA\u0001\n\u0003\ty\u0004C\u0005\u0002F\u0001\t\t\u0011\"\u0011\u0002H!I\u00111\u000b\u0001\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003?\u0002\u0011\u0011!C!\u0003C:\u0011\"a#!\u0003\u0003E\t!!$\u0007\u0011}\u0001\u0013\u0011!E\u0001\u0003\u001fCa\u0001T\r\u0005\u0002\u0005u\u0005\"CAP3\u0005\u0005IQIAQ\u0011%\t\u0019+GA\u0001\n\u0003\u000b)\u000bC\u0005\u0002.f\t\t\u0011\"!\u00020\"I\u0011QX\r\u0002\u0002\u0013%\u0011q\u0018\u0002\f!\u0006\u00148/\u001a+p\t\u0006$XM\u0003\u0002\"E\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0019C%\u0001\u0005dCR\fG._:u\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\u0015\u0001aFM\u001b<!\ty\u0003'D\u0001!\u0013\t\t\u0004EA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ty3'\u0003\u00025A\t\u0011\"+\u001e8uS6,'+\u001a9mC\u000e,\u0017M\u00197f!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u000e\u001f\n\u0005u:$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00027fMR,\u0012\u0001\u0011\t\u0003_\u0005K!A\u0011\u0011\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%\u0001\u0004g_Jl\u0017\r^\u000b\u0002\rB\u0019ag\u0012!\n\u0005!;$AB(qi&|g.A\u0004g_Jl\u0017\r\u001e\u0011\u0002\u000b\rD\u0017\u000e\u001c3\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q!aj\u0014)R!\ty\u0003\u0001C\u0003?\u000f\u0001\u0007\u0001\tC\u0003E\u000f\u0001\u0007a\tC\u0003K\u000f\u0001\u0007\u0001\tF\u0002O'RCQA\u0010\u0005A\u0002\u0001CQ\u0001\u0012\u0005A\u0002\u0001#\"A\u0014,\t\u000byJ\u0001\u0019\u0001!\u0002\u001b\u0015D\bO]:SKBd\u0017mY3e+\u0005I\u0006c\u0001.c\u0001:\u00111\f\u0019\b\u00039~k\u0011!\u0018\u0006\u0003=2\na\u0001\u0010:p_Rt\u0014\"\u0001\u001d\n\u0005\u0005<\u0014a\u00029bG.\fw-Z\u0005\u0003G\u0012\u00141aU3r\u0015\t\tw'A\u0007gY\u0006$\u0018I]4v[\u0016tGo]\u000b\u0002OB\u0019!\f\u001b6\n\u0005%$'\u0001C%uKJ\fGo\u001c:\u0011\u0005YZ\u0017B\u000178\u0005\r\te._\u0001\u000baJ,G\u000f^=OC6,W#A8\u0011\u0005A$hBA9s!\tav'\u0003\u0002to\u00051\u0001K]3eK\u001aL!!\u001e<\u0003\rM#(/\u001b8h\u0015\t\u0019x'\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0003\u001dfDQA_\u0007A\u0002\u0001\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003O{z|\bb\u0002 \u000f!\u0003\u0005\r\u0001\u0011\u0005\b\t:\u0001\n\u00111\u0001G\u0011\u001dQe\u0002%AA\u0002\u0001\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0006)\u001a\u0001)a\u0002,\u0005\u0005%\u0001\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u00058\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003/\tiAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u001e)\u001aa)a\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\n\u0011\t\u0005\u001d\u0012\u0011G\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005!A.\u00198h\u0015\t\ty#\u0001\u0003kCZ\f\u0017bA;\u0002*\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0007\t\u0004m\u0005e\u0012bAA\u001eo\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!.!\u0011\t\u0013\u0005\rC#!AA\u0002\u0005]\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002JA)\u00111JA)U6\u0011\u0011Q\n\u0006\u0004\u0003\u001f:\u0014AC2pY2,7\r^5p]&\u0019\u0011.!\u0014\u0002\u0011\r\fg.R9vC2$B!a\u0016\u0002^A\u0019a'!\u0017\n\u0007\u0005msGA\u0004C_>dW-\u00198\t\u0011\u0005\rc#!AA\u0002)\fa!Z9vC2\u001cH\u0003BA,\u0003GB\u0001\"a\u0011\u0018\u0003\u0003\u0005\rA\u001b\u0015\u0018\u0001\u0005\u001d\u0014QNA8\u0003g\n)(!\u001f\u0002|\u0005}\u0014\u0011QAC\u0003\u000f\u00032aLA5\u0013\r\tY\u0007\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t(AA]\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b3bi\u0016|6\u000f\u001e:\\Y\u00012W\u000e^/*A5\u0002\u0003+\u0019:tKN\u0004C\u000f[3!A\u0012\fG/Z0tiJ\u0004\u0007%\u001a=qe\u0016\u001c8/[8oA]LG\u000f\u001b\u0011uQ\u0016\u0004\u0003MZ7uA\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011u_*\u0001\u0003\u0005\t\u0011!A\u0005\u0004C-\u0019;f]\u0001\u0012V\r^;s]N\u0004c.\u001e7mA]LG\u000f\u001b\u0011j]Z\fG.\u001b3!S:\u0004X\u000f\u001e\u0018!\u0005f\u0004C-\u001a4bk2$H\u0006I5uA\u0019|G\u000e\\8xg\u0002\u001a\u0017m\u001d;j]\u001e\u0004#/\u001e7fg\u0002\"x\u000eI1!I\u0006$X\rI5g\u0015\u0001\u0002\u0003\u0005\t\u0011!i\",\u0007\u0005\u00194ni\u0002\u0004\u0013n\u001d\u0011p[&$H/\u001a3/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\t9(\u0001B\u0010\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002C-\u0019;f?N$(\u000fI\u0017!\u0003\u0002\u001aHO]5oO\u0002\"x\u000e\t2fAA\f'o]3eAQ|\u0007\u0005Z1uK:R\u0001\u0005\t\u0011!A\u0001R\u0003EZ7uA5\u0002C)\u0019;fA\u0019|'/\\1uAA\fG\u000f^3s]\u0002\"x\u000e\t4pY2|wO\f\u0011TK\u0016\u0004C(\u0019\u0011ie\u00164WH\t5uiB\u001c(hL\u0018ta\u0006\u00148NL1qC\u000eDWML8sO>\"wnY:0Y\u0006$Xm\u001d;0gFdWF]3g[\u0011\fG/\u001a;j[\u0016l\u0003/\u0019;uKJtg\u0006\u001b;nY\nrD)\u0019;fi&lW\r\t)biR,'O\\:=_\u0005t\u0004EZ8sAY\fG.\u001b3\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!I\u0006$X\rI1oI\u0002\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:og:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QP\u0001\u0002.)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00191s5\u0002t'L\u001a1AA\"$(M\u001c;kI:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aAJT\u0006M\u001c.gAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1cYj\u0013GM\u00174c\u001db\u0003eJ=zsflS*T\u0017eI\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cYj\u0013GM\u00174c)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002\u0004\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAE\u0003\u0015\td&\u000e\u00181\u0003-\u0001\u0016M]:f)>$\u0015\r^3\u0011\u0005=J2\u0003B\r\u0002\u0012n\u0002\u0002\"a%\u0002\u001a\u00023\u0005IT\u0007\u0003\u0003+S1!a&8\u0003\u001d\u0011XO\u001c;j[\u0016LA!a'\u0002\u0016\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u00055\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0012!B1qa2LHc\u0002(\u0002(\u0006%\u00161\u0016\u0005\u0006}q\u0001\r\u0001\u0011\u0005\u0006\tr\u0001\rA\u0012\u0005\u0006\u0015r\u0001\r\u0001Q\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t,!/\u0011\tY:\u00151\u0017\t\u0007m\u0005U\u0006I\u0012!\n\u0007\u0005]vG\u0001\u0004UkBdWm\r\u0005\t\u0003wk\u0012\u0011!a\u0001\u001d\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0003\u0004B!a\n\u0002D&!\u0011QYA\u0015\u0005\u0019y%M[3di\u0002")
public class ParseToDate
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToDate parseToDate) {
        return ParseToDate$.MODULE$.unapply(parseToDate);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToDate> tupled() {
        return ParseToDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToDate>>> curried() {
        return ParseToDate$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return RuntimeReplaceable.mkString$(this, childrenString);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public String prettyName() {
        return "to_date";
    }

    @Override
    public ParseToDate withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    public ParseToDate copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToDate(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToDate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToDate parseToDate = (ParseToDate)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToDate.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToDate.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToDate.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToDate.canEqual(this)) return false;
        return true;
    }

    public ParseToDate(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public ParseToDate(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new Cast(new GetTimestamp(left, format, TimestampType$.MODULE$, GetTimestamp$.MODULE$.apply$default$4(), GetTimestamp$.MODULE$.apply$default$5()), DateType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()));
    }

    public ParseToDate(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, DateType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()));
    }
}

