/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.delegate.ScriptInvocation;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;

public class ScriptTaskActivityBehavior
extends TaskActivityBehavior {
    protected ExecutableScript script;
    protected String resultVariable;

    public ScriptTaskActivityBehavior(ExecutableScript script, String resultVariable) {
        this.script = script;
        this.resultVariable = resultVariable;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        boolean noErrors = true;
        try {
            ScriptInvocation invocation = new ScriptInvocation(this.script, execution);
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
            Object result = invocation.getInvocationResult();
            if (result != null && this.resultVariable != null) {
                execution.setVariable(this.resultVariable, result);
            }
        }
        catch (ProcessEngineException e) {
            noErrors = false;
            BpmnError error = this.checkIfCauseOfExceptionIsBpmnError(e);
            if (error != null) {
                this.propagateBpmnError(error, execution);
            }
            this.propagateExceptionAsError(e, execution);
        }
        if (noErrors) {
            this.leave(execution);
        }
    }

    protected BpmnError checkIfCauseOfExceptionIsBpmnError(Throwable e) {
        if (e instanceof BpmnError) {
            return (BpmnError)e;
        }
        if (e.getCause() == null) {
            return null;
        }
        return this.checkIfCauseOfExceptionIsBpmnError(e.getCause());
    }

    public ExecutableScript getScript() {
        return this.script;
    }
}

