/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Map;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public class StartProcessInstanceByMessageAndProcessDefinitionIdCmd
implements Command<ProcessInstance> {
    protected final String messageName;
    protected final String businessKey;
    protected final Map<String, Object> processVariables;
    protected final String processDefinitionId;

    public StartProcessInstanceByMessageAndProcessDefinitionIdCmd(String messageName, String processDefinitionId, String businessKey, Map<String, Object> processVariables) {
        this.messageName = messageName;
        this.businessKey = businessKey;
        this.processVariables = processVariables;
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("Cannot start process instance by message and process definition id", "messageName", (Object)this.messageName);
        EnsureUtil.ensureNotNull("Cannot start process instance by message and process definition id", "processDefinitionId", (Object)this.processDefinitionId);
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);
        EnsureUtil.ensureNotNull("No process definition found for id '" + this.processDefinitionId + "'", "processDefinition", (Object)processDefinition);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkCreateProcessInstance(processDefinition);
        String activityId = this.findStartActivityIdByMessage(processDefinition);
        EnsureUtil.ensureNotNull("Cannot start process instance by message: no message start event with name '" + this.messageName + "' found for process definition with id '" + this.processDefinitionId + "'", "activityId", (Object)activityId);
        ActivityImpl startActivity = processDefinition.findActivity(activityId);
        ExecutionEntity processInstance = processDefinition.createProcessInstance(this.businessKey, startActivity);
        processInstance.start(this.processVariables);
        return processInstance;
    }

    protected String findStartActivityIdByMessage(ProcessDefinitionEntity processDefinition) {
        for (EventSubscriptionDeclaration declaration : EventSubscriptionDeclaration.getDeclarationsForScope(processDefinition)) {
            if (!this.isMessageStartEventWithName(declaration, this.messageName)) continue;
            return declaration.getActivityId();
        }
        return null;
    }

    protected boolean isMessageStartEventWithName(EventSubscriptionDeclaration declaration, String messageName) {
        return "message".equals(declaration.getEventType()) && declaration.isStartEvent() && messageName.equals(declaration.getEventName());
    }
}

