/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.AcquireJobsRunnable;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;

public class SequentialJobAcquisitionRunnable
extends AcquireJobsRunnable {
    private static Logger log = Logger.getLogger(AcquireJobsRunnable.class.getName());

    public SequentialJobAcquisitionRunnable(JobExecutor jobExecutor) {
        super(jobExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        log.info(this.jobExecutor.getName() + " starting to acquire jobs");
        int processEngineLoopCounter = 0;
        ArrayList<String> idleEngines = new ArrayList<String>();
        boolean jobExecutionFailed = false;
        while (!this.isInterrupted) {
            Object acquiredJobs;
            block27: {
                ProcessEngineImpl currentProcessEngine = null;
                int maxJobsPerAcquisition = this.jobExecutor.getMaxJobsPerAcquisition();
                try {
                    List<ProcessEngineImpl> registeredProcessEngines;
                    List<ProcessEngineImpl> list = registeredProcessEngines = this.jobExecutor.getProcessEngines();
                    synchronized (list) {
                        if (registeredProcessEngines.size() > 0) {
                            if (registeredProcessEngines.size() <= processEngineLoopCounter) {
                                processEngineLoopCounter = 0;
                                this.isJobAdded = false;
                                idleEngines.clear();
                            }
                            currentProcessEngine = registeredProcessEngines.get(processEngineLoopCounter);
                            ++processEngineLoopCounter;
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "exception while determining next process engine: " + e.getMessage(), e);
                }
                jobExecutionFailed = false;
                if (currentProcessEngine != null) {
                    try {
                        CommandExecutor commandExecutor = currentProcessEngine.getProcessEngineConfiguration().getCommandExecutorTxRequired();
                        acquiredJobs = commandExecutor.execute(this.jobExecutor.getAcquireJobsCmd());
                        for (List<String> jobIds : ((AcquiredJobs)acquiredJobs).getJobIdBatches()) {
                            this.jobExecutor.executeJobs(jobIds, currentProcessEngine);
                        }
                        int jobsAcquired = ((AcquiredJobs)acquiredJobs).getJobIdBatches().size() + ((AcquiredJobs)acquiredJobs).getNumberOfJobsFailedToLock();
                        if (jobsAcquired < maxJobsPerAcquisition) {
                            idleEngines.add(currentProcessEngine.getName());
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "exception during job acquisition: " + e.getMessage(), e);
                        jobExecutionFailed = true;
                        if (this.millisToWait == 0L) {
                            this.millisToWait = this.jobExecutor.getWaitTimeInMillis();
                        }
                        this.millisToWait = (long)((float)this.millisToWait * this.waitIncreaseFactor);
                        if (this.millisToWait <= this.maxWait) break block27;
                        this.millisToWait = this.maxWait;
                    }
                }
            }
            int numOfEngines = this.jobExecutor.getProcessEngines().size();
            if (idleEngines.size() == numOfEngines) {
                this.millisToWait = this.jobExecutor.getWaitTimeInMillis();
            } else if (!jobExecutionFailed) {
                this.millisToWait = 0L;
            }
            if (this.millisToWait <= 0L || this.isJobAdded) continue;
            try {
                log.fine("job acquisition thread sleeping for " + this.millisToWait + " millis");
                acquiredJobs = this.MONITOR;
                synchronized (acquiredJobs) {
                    if (!this.isInterrupted) {
                        this.isWaiting.set(true);
                        this.MONITOR.wait(this.millisToWait);
                    }
                }
                log.fine("job acquisition thread woke up");
                this.isJobAdded = false;
            }
            catch (InterruptedException e) {
                log.fine("job acquisition wait interrupted");
            }
            finally {
                this.isWaiting.set(false);
            }
        }
        log.info(this.jobExecutor.getName() + " stopped job acquisition");
    }

    public boolean isJobAdded() {
        return this.isJobAdded;
    }
}

