/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.camunda.bpm.engine.ArtifactFactory;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class ClassDelegateUtil {
    public static Object instantiateDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        return ClassDelegateUtil.instantiateDelegate(clazz.getName(), fieldDeclarations);
    }

    public static Object instantiateDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        ArtifactFactory artifactFactory = Context.getProcessEngineConfiguration().getArtifactFactory();
        try {
            Class<?> clazz = ReflectUtil.loadClass(className);
            Object object = artifactFactory.getArtifact(clazz);
            ClassDelegateUtil.applyFieldDeclaration(fieldDeclarations, object);
            return object;
        }
        catch (Exception e) {
            throw new ProcessEngineException("couldn't instantiate class " + className, e);
        }
    }

    public static void applyFieldDeclaration(List<FieldDeclaration> fieldDeclarations, Object target) {
        if (fieldDeclarations != null) {
            for (FieldDeclaration declaration : fieldDeclarations) {
                ClassDelegateUtil.applyFieldDeclaration(declaration, target);
            }
        }
    }

    public static void applyFieldDeclaration(FieldDeclaration declaration, Object target) {
        Method setterMethod = ReflectUtil.getSetter(declaration.getName(), target.getClass(), declaration.getValue().getClass());
        if (setterMethod != null) {
            try {
                setterMethod.invoke(target, declaration.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new ProcessEngineException("Error while invoking '" + declaration.getName() + "' on class " + target.getClass().getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new ProcessEngineException("Illegal acces when calling '" + declaration.getName() + "' on class " + target.getClass().getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new ProcessEngineException("Exception while invoking '" + declaration.getName() + "' on class " + target.getClass().getName(), e);
            }
        } else {
            Field field = ReflectUtil.getField(declaration.getName(), target);
            EnsureUtil.ensureNotNull("Field definition uses unexisting field '" + declaration.getName() + "' on class " + target.getClass().getName(), "field", (Object)field);
            if (!ClassDelegateUtil.fieldTypeCompatible(declaration, field)) {
                throw new ProcessEngineException("Incompatible type set on field declaration '" + declaration.getName() + "' for class " + target.getClass().getName() + ". Declared value has type " + declaration.getValue().getClass().getName() + ", while expecting " + field.getType().getName());
            }
            ReflectUtil.setField(field, target, declaration.getValue());
        }
    }

    public static boolean fieldTypeCompatible(FieldDeclaration declaration, Field field) {
        if (declaration.getValue() != null) {
            return field.getType().isAssignableFrom(declaration.getValue().getClass());
        }
        return true;
    }
}

