/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.util.encoders.Hex;
import org.chainmaker.pb.accesscontrol.MemberOuterClass;
import org.chainmaker.pb.accesscontrol.PolicyOuterClass;
import org.chainmaker.pb.archivecenter.Archivecenter;
import org.chainmaker.pb.common.ChainmakerBlock;
import org.chainmaker.pb.common.ChainmakerTransaction;
import org.chainmaker.pb.common.ContractOuterClass;
import org.chainmaker.pb.common.Request;
import org.chainmaker.pb.common.ResultOuterClass;
import org.chainmaker.pb.config.ChainConfigOuterClass;
import org.chainmaker.pb.config.ChainmakerServer;
import org.chainmaker.pb.config.LocalConfig;
import org.chainmaker.pb.discovery.Discovery;
import org.chainmaker.pb.store.Store;
import org.chainmaker.pb.sync.Sync;
import org.chainmaker.pb.syscontract.AccountManager;
import org.chainmaker.pb.syscontract.Archive;
import org.chainmaker.pb.syscontract.CertManage;
import org.chainmaker.pb.syscontract.ChainConfig;
import org.chainmaker.pb.syscontract.ChainQuery;
import org.chainmaker.pb.syscontract.ContractManage;
import org.chainmaker.pb.syscontract.MultiSign;
import org.chainmaker.pb.syscontract.PubkeyManage;
import org.chainmaker.pb.syscontract.Subscribe;
import org.chainmaker.pb.syscontract.SystemContractOuterClass;
import org.chainmaker.pb.txpool.TransactionPool;
import org.chainmaker.sdk.ChainClientException;
import org.chainmaker.sdk.ChainManager;
import org.chainmaker.sdk.GrpcClientFactory;
import org.chainmaker.sdk.Node;
import org.chainmaker.sdk.RpcServiceClient;
import org.chainmaker.sdk.User;
import org.chainmaker.sdk.archivecenter.ArchiveCenterGrpcClient;
import org.chainmaker.sdk.archivecenter.ArchiveCenterHttpClient;
import org.chainmaker.sdk.archivecenter.ArchiveCenterMySqlClient;
import org.chainmaker.sdk.archivecenter.ArchiveService;
import org.chainmaker.sdk.archivecenter.Blocks;
import org.chainmaker.sdk.archivecenter.Notice;
import org.chainmaker.sdk.archivecenter.ProcessMessage;
import org.chainmaker.sdk.config.ArchiveCenterConfig;
import org.chainmaker.sdk.config.ArchiveConfig;
import org.chainmaker.sdk.config.AuthType;
import org.chainmaker.sdk.config.NodeConfig;
import org.chainmaker.sdk.crypto.ChainMakerCryptoSuiteException;
import org.chainmaker.sdk.execption.ExceptionType;
import org.chainmaker.sdk.sync.TxResultDispatcher;
import org.chainmaker.sdk.utils.CryptoUtils;
import org.chainmaker.sdk.utils.FileUtils;
import org.chainmaker.sdk.utils.Utils;
import org.chainmaker.sdk.utils.UtilsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainClient {
    private String chainId;
    private GenericObjectPool<RpcServiceClient> connectionPool;
    private ArchiveConfig archiveConfig;
    private User clientUser;
    private int retryLimit;
    private int retryInterval;
    private TxResultDispatcher dispatcher;
    private ArchiveCenterConfig archiveCenterConfig;
    private ArchiveService archiveService;
    private boolean archiveCenterQueryFirst;
    private boolean enableSendRequestSync;
    private boolean enableLowProfile;
    private String hash;
    private String proxyUrl;
    private boolean isEnabledCertHash;
    private boolean isEnabledAlias;
    private static final String TX_ID = "txId";
    private static final String ROOT = "root";
    private static final String ORG_ID = "org_id";
    private static final String MEMBER_INFO = "member_info";
    private static final String ADDR_TYPE = "addr_type";
    private static final String NODE_ID = "node_id";
    private static final String ROLE = "role";
    private static final String NODE_IDS = "node_ids";
    private static final String BLOCK_HEIGHT = "blockHeight";
    private static final String BLOCK_HASH = "blockHash";
    private static final String WITH_RW_SET = "withRWSet";
    private static final String GET_ARCHIVED_BLOCK_HEIGHT = "GET_ARCHIVED_BLOCK_HEIGHT";
    private static final long DEFAULT_RPC_TIMEOUT = 10000L;
    private static final long DEFAULT_SYNC_RESULT_TIMEOUT = 10000L;
    private static final String DRIVER_NAME = "com.mysql.cj.jdbc.Driver";
    private static final String MYSQL_DBNAME_PREFIX = "cm_archived_chain";
    private static final String MYSQL_TABLENAME_PREFIX = "t_block_info";
    private static final long ROWS_PREBLOCKINFO_TABLE = 100000L;
    private static final long DEFAULT_SEQ = 0L;
    private static final int SUCCESS = 0;
    private static final String KEYCERTHASHS = "cert_hashes";
    private static final String KEYCERTS = "certs";
    private static final String KEYCERTCRL = "cert_crl";
    private static final String KEY_PUBKEY = "pubkey";
    private static final String KEY_PUBKEY_ROLE = "role";
    private static final String KEY_PUBKEY_ORG_ID = "org_id";
    private static final String KEY_ALIAS = "alias";
    private static final String KEY_ALIASES = "aliases";
    private static final String KEY_CERT = "cert";
    private static final Logger logger = LoggerFactory.getLogger(ChainClient.class);
    private static final String KEY_GASPUBLIC = "public_key";
    private static final String KEY_GASADDRESSKEY = "address_key";
    private static final String Key_GASBATCHRECHARGE = "batch_recharge";
    private static final String Key_GASBALANCEPUBLICKEY = "balance_public_key";
    private static final String Key_GASCHARGEPUBLICKEY = "charge_public_key";
    private static final String Key_GASCHARGEGASAMOUNT = "charge_gas_amount";
    private static final String Key_GASFROZENPUBLICKEY = "frozen_public_key";
    private static final String Key_GASENABLEOPTIMIZECHARGEGAS = "enable_optimize_charge_gas";
    private static final String Key_GASSETINVOKEBASEGAS = "set_invoke_base_gas";
    private static final String Key_GASSETINVOKEGASPRICE = "set_invoke_gas_price";
    private static final String Key_GASSETINSTALLBASEGAS = "set_install_base_gas";
    private static final String Key_GASSETINSTALLGASPRICE = "set_install_gas_price";

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public GenericObjectPool<RpcServiceClient> getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPool(GenericObjectPool<RpcServiceClient> connectionPool) {
        this.connectionPool = connectionPool;
    }

    public ArchiveConfig getArchiveConfig() {
        return this.archiveConfig;
    }

    public void setArchiveConfig(ArchiveConfig archiveConfig) {
        this.archiveConfig = archiveConfig;
    }

    public User getClientUser() {
        return this.clientUser;
    }

    public void setClientUser(User clientUser) {
        this.clientUser = clientUser;
    }

    public TxResultDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(TxResultDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public ArchiveCenterConfig getArchiveCenterConfig() {
        return this.archiveCenterConfig;
    }

    public void setArchiveCenterConfig(ArchiveCenterConfig archiveCenterConfig) {
        this.archiveCenterConfig = archiveCenterConfig;
    }

    public void setArchiveService(ArchiveService archiveService) {
        this.archiveService = archiveService;
    }

    public boolean isArchiveCenterQueryFirst() {
        return this.archiveCenterQueryFirst;
    }

    public void setArchiveCenterQueryFirst(boolean archiveCenterQueryFirst) {
        this.archiveCenterQueryFirst = archiveCenterQueryFirst;
    }

    public boolean isEnableSendRequestSync() {
        return this.enableSendRequestSync;
    }

    public void setEnableSendRequestSync(boolean enableSendRequestSync) {
        this.enableSendRequestSync = enableSendRequestSync;
    }

    public boolean isEnableLowProfile() {
        return this.enableLowProfile;
    }

    public void setEnableLowProfile(boolean enableLowProfile) {
        this.enableLowProfile = enableLowProfile;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public synchronized boolean enableAlias() throws ChainMakerCryptoSuiteException, ChainClientException {
        if (this.isEnabledAlias) {
            return true;
        }
        if (!this.clientUser.getAuthType().equals(AuthType.PermissionedWithCert.getMsg())) {
            throw new ChainClientException("cert alias is not supported");
        }
        if (this.checkCertAliasOnChain()) {
            this.isEnabledAlias = true;
            return true;
        }
        this.addAlias(10000L);
        for (int i = 0; i < 10; ++i) {
            if (!this.getCheckAlias()) continue;
            this.isEnabledAlias = true;
            return true;
        }
        return false;
    }

    public synchronized boolean enableCertHash() throws ChainMakerCryptoSuiteException, ChainClientException {
        if (this.isEnabledAlias) {
            return true;
        }
        if (!this.clientUser.getAuthType().equals(AuthType.PermissionedWithCert.getMsg())) {
            throw new ChainClientException("cert hash is not supported");
        }
        if (this.isEnabledCertHash) {
            return true;
        }
        if (this.clientUser.getCertHash() == null || this.clientUser.getCertHash().length == 0) {
            ChainConfigOuterClass.ChainConfig chainConfig = this.getChainConfig(10000L);
            if (chainConfig == null) {
                throw new ChainClientException("get chain config from node failed, please try again later");
            }
            this.clientUser.setCertHash(this.getCertificateId(chainConfig.getCrypto().getHash()));
            if (this.clientUser.getCertHash() == null || this.clientUser.getCertHash().length == 0) {
                throw new ChainClientException("get certificate id failed");
            }
        }
        if (this.checkCertHashOnChain()) {
            this.isEnabledCertHash = true;
            return true;
        }
        ResultOuterClass.TxResponse responseInfo = this.addCert(10000L);
        if (responseInfo == null || responseInfo.getCode() != ResultOuterClass.TxStatusCode.SUCCESS || responseInfo.getContractResult().getCode() != 0) {
            throw new ChainClientException("add cert failed");
        }
        for (int i = 0; i < 10; ++i) {
            if (!this.checkCertHashOnChain()) continue;
            this.isEnabledCertHash = true;
            return true;
        }
        return false;
    }

    public synchronized void disableCertHash() {
        this.isEnabledCertHash = false;
    }

    public byte[] getCertHash() throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainConfigOuterClass.ChainConfig chainConfig = this.getChainConfig(10000L);
        return this.getCertificateId(chainConfig.getCrypto().getHash());
    }

    private byte[] getCertificateId(String hashType) throws ChainMakerCryptoSuiteException {
        byte[] encodedCert;
        if (this.clientUser.getCertBytes() == null || this.clientUser.getCertBytes().length == 0) {
            return new byte[0];
        }
        try {
            encodedCert = this.clientUser.getCertificate().getEncoded();
        }
        catch (CertificateEncodingException e) {
            logger.error("encoded cert err : ", (Throwable)e);
            throw new ChainMakerCryptoSuiteException("encoded cert err : " + e.getMessage());
        }
        if (encodedCert == null || encodedCert.length == 0) {
            return new byte[0];
        }
        Digest digest = this.getHashDigest(hashType);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.update(encodedCert, 0, encodedCert.length);
        digest.doFinal(hash, 0);
        return hash;
    }

    private Digest getHashDigest(String hashAlgorithm) {
        if ("SHA3".equals(hashAlgorithm)) {
            return new SHA3Digest();
        }
        if ("SM3".equals(hashAlgorithm)) {
            return new SM3Digest();
        }
        return new SHA256Digest();
    }

    private boolean checkCertAliasOnChain() {
        try {
            String alias = this.clientUser.getAlias();
            if (alias == null || alias.length() == 0) {
                return false;
            }
            ResultOuterClass.AliasInfos aliasInfos = this.queryAlias(new String[]{alias}, 10000L);
            if (aliasInfos == null) {
                logger.warn("get alias infos failed");
                return false;
            }
            if (aliasInfos.getAliasInfosList().size() == 0) {
                return false;
            }
            return alias.equals(aliasInfos.getAliasInfos(0).getAlias());
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            return false;
        }
    }

    private boolean checkCertHashOnChain() throws ChainClientException, ChainMakerCryptoSuiteException {
        byte[] certHash = this.clientUser.getCertHash();
        if (certHash == null || certHash.length == 0) {
            return false;
        }
        ResultOuterClass.CertInfos certInfos = this.queryCert(new String[]{Hex.toHexString((byte[])certHash)}, 10000L);
        if (certInfos == null) {
            throw new ChainClientException("get cert infos failed");
        }
        if (certInfos.getCertInfosList().size() != 1 || certInfos.getCertInfos(0).getCert().isEmpty()) {
            return false;
        }
        return certInfos.getCertInfos(0).getHash().equals(Hex.toHexString((byte[])certHash));
    }

    private boolean getCheckAlias() throws ChainClientException, ChainMakerCryptoSuiteException {
        ResultOuterClass.AliasInfos aliasInfos = this.queryAlias(new String[]{this.clientUser.getAlias()}, 10000L);
        if (aliasInfos == null) {
            throw new ChainClientException("get alias infos failed");
        }
        return aliasInfos.getAliasInfos(0).getAlias().equals(this.clientUser.getAlias());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArchiveService getArchiveService() throws ChainClientException {
        if (this.archiveService != null) {
            return this.archiveService;
        }
        if (this.archiveConfig == null) {
            throw new ChainClientException("archive config is not set");
        }
        if (Objects.equals(this.archiveConfig.getType(), "mysql")) {
            this.archiveService = new ArchiveCenterMySqlClient(this.chainId, this.archiveConfig, this);
            return this.archiveService;
        } else {
            if (this.archiveCenterConfig == null) throw new ChainClientException("archive config is not set");
            if (this.archiveCenterConfig.getRpcAddress() != null && this.archiveCenterConfig.getRpcAddress().length() > 0) {
                this.archiveService = new ArchiveCenterGrpcClient(this.archiveCenterConfig);
                return this.archiveService;
            } else {
                if (this.archiveCenterConfig.getArchiveCenterHttpUrl() == null || this.archiveCenterConfig.getArchiveCenterHttpUrl().length() <= 0) throw new ChainClientException("archive config is not set");
                this.archiveService = new ArchiveCenterHttpClient(this.archiveCenterConfig);
            }
        }
        return this.archiveService;
    }

    public Request.Payload createContractCreatePayload(String contractName, String version, byte[] byteCode, ContractOuterClass.RuntimeType runtime, Map<String, byte[]> params) throws ChainMakerCryptoSuiteException {
        return this.createContractManageWithByteCodePayload(contractName, ContractManage.ContractManageFunction.INIT_CONTRACT.toString(), version, byteCode, runtime, params);
    }

    public Request.Payload createContractUpgradePayload(String contractName, String version, byte[] byteCode, ContractOuterClass.RuntimeType runtime, Map<String, byte[]> params) throws ChainMakerCryptoSuiteException {
        return this.createContractManageWithByteCodePayload(contractName, ContractManage.ContractManageFunction.UPGRADE_CONTRACT.toString(), version, byteCode, runtime, params);
    }

    public Request.Payload createContractFreezePayload(String contractName) throws ChainMakerCryptoSuiteException {
        return this.createContractManagePayload(contractName, ContractManage.ContractManageFunction.FREEZE_CONTRACT.toString());
    }

    public Request.Payload createContractUnFreezePayload(String contractName) throws ChainMakerCryptoSuiteException {
        return this.createContractManagePayload(contractName, ContractManage.ContractManageFunction.UNFREEZE_CONTRACT.toString());
    }

    public Request.Payload createContractRevokePayload(String contractName) throws ChainMakerCryptoSuiteException {
        return this.createContractManagePayload(contractName, ContractManage.ContractManageFunction.REVOKE_CONTRACT.toString());
    }

    public ResultOuterClass.TxResponse sendContractManageRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse sendContractManageRequestWithPayer(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, Request.EndorsementEntry payer, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendContractRequestWithPayer(payload, endorsementEntries, payer, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse invokeContract(String contractName, String method, String txId, Map<String, byte[]> params, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Request.Payload payload = this.createPayload(txId, Request.TxType.INVOKE_CONTRACT, contractName, method, params, 0L);
        return this.sendContractRequest(payload, null, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse queryContract(String contractName, String method, String txId, Map<String, byte[]> params, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Request.Payload payload = this.createPayload(txId, Request.TxType.QUERY_CONTRACT, contractName, method, params, 0L);
        return this.sendContractRequest(payload, null, rpcCallTimeout, -1L);
    }

    public Request.Payload invokeContractPayload(String contractName, String method, String txId, Map<String, byte[]> params) throws ChainMakerCryptoSuiteException {
        return this.createPayload(txId, Request.TxType.INVOKE_CONTRACT, contractName, method, params, 0L);
    }

    public ResultOuterClass.TxResponse queryContract(String contractName, String method, String txId, Map<String, byte[]> params, long rpcCallTimeout, User user) throws ChainMakerCryptoSuiteException, ChainClientException {
        Request.Payload payload = this.createPayload(txId, Request.TxType.QUERY_CONTRACT, contractName, method, params, 0L);
        return this.sendContractRequest(payload, null, rpcCallTimeout, -1L, user);
    }

    public ResultOuterClass.TxResponse invokeContract(String contractName, String method, String txId, Map<String, byte[]> params, long rpcCallTimeout, long syncResultTimeout, User user) throws ChainMakerCryptoSuiteException, ChainClientException {
        Request.Payload payload = this.createPayload(txId, Request.TxType.INVOKE_CONTRACT, contractName, method, params, 0L);
        return this.sendContractRequest(payload, null, rpcCallTimeout, syncResultTimeout, user);
    }

    public ChainmakerTransaction.TransactionInfo getTxByTxId(String txId, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainmakerTransaction.TransactionInfo transactionInfo;
        if (this.archiveCenterQueryFirst) {
            try {
                transactionInfo = this.getArchiveService().getTxByTxId(txId, rpcCallTimeout);
                if (transactionInfo != null) {
                    return transactionInfo;
                }
            }
            catch (ChainClientException e) {
                logger.error("archive center get data, fail{}", (Object)e.getMessage());
            }
        }
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(TX_ID, txId.getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_TX_BY_TX_ID.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        try {
            transactionInfo = ChainmakerTransaction.TransactionInfo.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("transactionInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("transactionInfo parseFrom result : " + e.getMessage());
        }
        return transactionInfo;
    }

    public ChainmakerTransaction.TransactionInfoWithRWSet getTxWithRWSetByTxId(String txId, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainmakerTransaction.TransactionInfoWithRWSet transactionInfoWithRWSet;
        if (this.archiveCenterQueryFirst) {
            try {
                transactionInfoWithRWSet = this.getArchiveService().getTxWithRWSetByTxId(txId, rpcCallTimeout);
                if (transactionInfoWithRWSet != null) {
                    return transactionInfoWithRWSet;
                }
            }
            catch (ChainClientException e) {
                logger.error("archive center get data, fail{}", (Object)e.getMessage());
            }
        }
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(TX_ID, txId.getBytes());
        params.put(WITH_RW_SET, String.valueOf(true).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_TX_BY_TX_ID.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            transactionInfoWithRWSet = ChainmakerTransaction.TransactionInfoWithRWSet.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("transactionInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("transactionInfo parseFrom result : " + e.getMessage());
        }
        return transactionInfoWithRWSet;
    }

    public ChainmakerBlock.BlockInfo getBlockByHeight(long blockHeight, boolean withRWSet, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainmakerBlock.BlockInfo blockInfo;
        if (this.archiveCenterQueryFirst) {
            try {
                blockInfo = this.getArchiveService().getBlockByHeight(blockHeight, withRWSet, rpcCallTimeout);
                if (blockInfo != null) {
                    return blockInfo;
                }
            }
            catch (ChainClientException e) {
                logger.error("archive center get data, fail{}", (Object)e.getMessage());
            }
        }
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(BLOCK_HEIGHT, String.valueOf(blockHeight).getBytes());
        params.put(WITH_RW_SET, String.valueOf(withRWSet).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_BLOCK_BY_HEIGHT.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            blockInfo = ChainmakerBlock.BlockInfo.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockInfo parseFrom result : " + e.getMessage());
        }
        return blockInfo;
    }

    public ChainmakerBlock.BlockInfo getBlockByHash(String blockHash, boolean withRWSet, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainmakerBlock.BlockInfo blockInfo;
        if (this.archiveCenterQueryFirst) {
            try {
                blockInfo = this.getArchiveService().getBlockByHash(blockHash, withRWSet, rpcCallTimeout);
                if (blockInfo != null) {
                    return blockInfo;
                }
            }
            catch (ChainClientException e) {
                logger.error("archive center get data, fail{}", (Object)e.getMessage());
            }
        }
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(BLOCK_HASH, blockHash.getBytes());
        params.put(WITH_RW_SET, String.valueOf(withRWSet).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_BLOCK_BY_HASH.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            blockInfo = ChainmakerBlock.BlockInfo.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockInfo parseFrom result : " + e.getMessage());
        }
        return blockInfo;
    }

    public ChainmakerBlock.BlockInfo getBlockByTxId(String txId, boolean withRWSet, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainmakerBlock.BlockInfo blockInfo;
        if (this.archiveCenterQueryFirst) {
            try {
                blockInfo = this.getArchiveService().getBlockByTxId(txId, withRWSet, rpcCallTimeout);
                if (blockInfo != null) {
                    return blockInfo;
                }
            }
            catch (ChainClientException e) {
                logger.error("archive center get data, fail{}", (Object)e.getMessage());
            }
        }
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(TX_ID, txId.getBytes());
        params.put(WITH_RW_SET, String.valueOf(withRWSet).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_BLOCK_BY_TX_ID.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            blockInfo = ChainmakerBlock.BlockInfo.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockInfo parseFrom result : " + e.getMessage());
        }
        return blockInfo;
    }

    public ChainmakerBlock.BlockInfo getLastConfigBlock(boolean withRWSet, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainmakerBlock.BlockInfo blockInfo;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(WITH_RW_SET, Boolean.toString(withRWSet).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_LAST_CONFIG_BLOCK.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            blockInfo = ChainmakerBlock.BlockInfo.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockInfo parseFrom result : " + e.getMessage());
        }
        return blockInfo;
    }

    public Discovery.ChainList getNodeChainList(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Discovery.ChainList chainList;
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_NODE_CHAIN_LIST.toString(), null, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            chainList = Discovery.ChainList.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("chainList parseFrom result : ", (Throwable)e);
            throw new ChainClientException("chainList parseFrom result : " + e.getMessage());
        }
        return chainList;
    }

    public Discovery.ChainInfo getChainInfo(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Discovery.ChainInfo chainInfo;
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_CHAIN_INFO.toString(), null, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            chainInfo = Discovery.ChainInfo.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("chainInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("chainInfo parseFrom result : " + e.getMessage());
        }
        return chainInfo;
    }

    public long getBlockHeightByTxId(String txId, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.getBlockHeight(txId, null, rpcCallTimeout);
    }

    public long getBlockHeightByBlockHash(String blockHash, long timeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.getBlockHeight("", blockHash, timeout);
    }

    public Store.BlockWithRWSet getFullBlockByHeight(long blockHeight, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        Store.BlockWithRWSet blockWithRWSet;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(BLOCK_HEIGHT, String.valueOf(blockHeight).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_FULL_BLOCK_BY_HEIGHT.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            blockWithRWSet = Store.BlockWithRWSet.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockWithRWSet parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockWithRWSet parseFrom result : " + e.getMessage());
        }
        return blockWithRWSet;
    }

    public ChainmakerBlock.BlockInfo getLastBlock(boolean withRWSet, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        ChainmakerBlock.BlockInfo blockInfo;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(WITH_RW_SET, Boolean.toString(withRWSet).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_LAST_BLOCK.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            blockInfo = ChainmakerBlock.BlockInfo.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockInfo parseFrom result : " + e.getMessage());
        }
        return blockInfo;
    }

    public long getCurrentBlockHeight(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainmakerBlock.BlockInfo blockInfo = this.getLastBlock(false, rpcCallTimeout);
        return blockInfo.getBlock().getHeader().getBlockHeight();
    }

    public ChainmakerBlock.BlockHeader getBlockHeaderByHeight(long blockHeight, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        ChainmakerBlock.BlockHeader blockHeader;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(BLOCK_HEIGHT, Long.toString(blockHeight).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_BLOCK_HEADER_BY_HEIGHT.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            blockHeader = ChainmakerBlock.BlockHeader.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockHeader parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockHeader parseFrom result : " + e.getMessage());
        }
        return blockHeader;
    }

    public ResultOuterClass.TxResponse invokeSystemContract(String contractName, String method, String txId, Map<String, byte[]> params, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Request.Payload payload = this.createPayload(txId, Request.TxType.INVOKE_CONTRACT, contractName, method, params, 0L);
        return this.sendContractRequest(payload, null, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse querySystemContract(String contractName, String method, String txId, Map<String, byte[]> params, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Request.Payload payload = this.createPayload(txId, Request.TxType.QUERY_CONTRACT, contractName, method, params, 0L);
        return this.sendContractRequest(payload, null, rpcCallTimeout, -1L);
    }

    public byte[] getMerklePathByTxId(String txId, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(TX_ID, txId.getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_MERKLE_PATH_BY_TX_ID.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        return txResponse.getContractResult().getResult().toByteArray();
    }

    public Request.Payload createNativeContractAccessGrantPayload(String[] grantContractList) throws ChainMakerCryptoSuiteException {
        return this.createNativeContractAccessPayload(ContractManage.ContractManageFunction.GRANT_CONTRACT_ACCESS.toString(), grantContractList);
    }

    public Request.Payload createNativeContractAccessRevokePayload(String[] revokeContractList) throws ChainMakerCryptoSuiteException {
        return this.createNativeContractAccessPayload(ContractManage.ContractManageFunction.REVOKE_CONTRACT_ACCESS.toString(), revokeContractList);
    }

    public Request.Payload createGetDisabledNativeContractListPayload() throws ChainMakerCryptoSuiteException {
        return this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CONTRACT_MANAGE.toString(), ContractManage.ContractQueryFunction.GET_DISABLED_CONTRACT_LIST.toString(), null, 0L);
    }

    private ContractOuterClass.Contract parseContractFromJSONString(String contractData) throws ChainClientException {
        ContractOuterClass.Contract.Builder contractBuilder = ContractOuterClass.Contract.newBuilder();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(contractData.getBytes());
            new JsonFormat().merge((InputStream)is, (Message.Builder)contractBuilder);
        }
        catch (IOException e) {
            logger.error("contract parseFrom result : ", (Throwable)e);
            throw new ChainClientException("contract parseFrom result : " + e.getMessage());
        }
        return contractBuilder.build();
    }

    public ContractOuterClass.Contract getContractInfo(String contractName, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(ContractManage.GetContractInfo.Parameter.CONTRACT_NAME.toString(), contractName.getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CONTRACT_MANAGE.toString(), ContractManage.ContractQueryFunction.GET_CONTRACT_INFO.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        String jsonResult = txResponse.getContractResult().getResult().toStringUtf8();
        return this.parseContractFromJSONString(jsonResult);
    }

    public ContractOuterClass.Contract[] getContractList(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CONTRACT_MANAGE.toString(), ContractManage.ContractQueryFunction.GET_CONTRACT_LIST.toString(), null, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        ContractOuterClass.Contract[] contracts = null;
        String jsonResult = txResponse.getContractResult().getResult().toStringUtf8();
        if (jsonResult != null) {
            JSONArray jsonArray = JSONArray.parseArray((String)jsonResult);
            contracts = new ContractOuterClass.Contract[jsonArray.size()];
            for (int i = 0; i < jsonArray.size(); ++i) {
                String contractData = jsonArray.getJSONObject(i).toJSONString();
                contracts[i] = this.parseContractFromJSONString(contractData);
            }
        }
        return contracts;
    }

    public ContractOuterClass.Contract[] getDisabledNativeContractList(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CONTRACT_MANAGE.toString(), ContractManage.ContractQueryFunction.GET_DISABLED_CONTRACT_LIST.toString(), null, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        ContractOuterClass.Contract[] contracts = null;
        String jsonResult = txResponse.getContractResult().getResult().toStringUtf8();
        if (!jsonResult.equals("null")) {
            JSONArray jsonArray = JSONArray.parseArray((String)jsonResult);
            contracts = new ContractOuterClass.Contract[jsonArray.size()];
            for (int i = 0; i < jsonArray.size(); ++i) {
                String contractData = jsonArray.getJSONObject(i).toJSONString();
                contracts[i] = this.parseContractFromJSONString(contractData);
            }
        }
        return contracts;
    }

    public ChainConfigOuterClass.ChainConfig getChainConfig(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainConfigOuterClass.ChainConfig chainConfig;
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.GET_CHAIN_CONFIG.toString(), null, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            chainConfig = ChainConfigOuterClass.ChainConfig.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("chainConfig parseFrom result : ", (Throwable)e);
            throw new ChainClientException("chainConfig parseFrom result : " + e.getMessage());
        }
        return chainConfig;
    }

    public ChainConfigOuterClass.ChainConfig getChainConfigByBlockHeight(long blockHeight, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainConfigOuterClass.ChainConfig chainConfig;
        if (this.archiveCenterQueryFirst) {
            try {
                chainConfig = this.getArchiveService().getChainConfigByBlockHeight(blockHeight, rpcCallTimeout);
                if (chainConfig != null) {
                    return chainConfig;
                }
            }
            catch (ChainClientException e) {
                logger.error("archive center get data, fail{}", (Object)e.getMessage());
            }
        }
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("block_height", String.valueOf(blockHeight).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.GET_CHAIN_CONFIG_AT.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            chainConfig = ChainConfigOuterClass.ChainConfig.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("ChainConfig parseFrom result : ", (Throwable)e);
            throw new ChainClientException("ChainConfig parseFrom result : " + e.getMessage());
        }
        return chainConfig;
    }

    public long getChainConfigSequence(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainConfigOuterClass.ChainConfig chainConfig = this.getChainConfig(rpcCallTimeout);
        return chainConfig.getSequence();
    }

    public Request.Payload createPayloadOfChainConfigCoreUpdate(int txSchedulerTimeout, int txSchedulerValidateTimeout, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        if (txSchedulerTimeout > 60 || txSchedulerValidateTimeout > 60) {
            throw new ChainClientException("invalid txSchedulerTimeout or txSchedulerValidateTimeout");
        }
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (txSchedulerTimeout > 0) {
            params.put("tx_scheduler_timeout", String.valueOf(txSchedulerTimeout).getBytes());
        }
        if (txSchedulerValidateTimeout > 0) {
            params.put("tx_scheduler_validate_timeout", String.valueOf(txSchedulerValidateTimeout).getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.CORE_UPDATE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigBlockUpdate(boolean txTimestampVerify, int txTimeout, int blockTxCapacity, int blockSize, int blockInterval, int txParameterSize, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        if (txTimeout > 0 && txTimeout < 600) {
            throw new ChainClientException("invalid parameters: txTimeout should >= 600");
        }
        if (blockInterval > 0 && blockInterval < 10) {
            throw new ChainClientException("invalid parameters: blockInterval should >= 10");
        }
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("tx_timestamp_verify", String.valueOf(txTimestampVerify).getBytes());
        if (txTimeout > 0) {
            params.put("tx_timeout", String.valueOf(txTimeout).getBytes());
        }
        if (blockTxCapacity > 0) {
            params.put("block_tx_capacity", String.valueOf(blockTxCapacity).getBytes());
        }
        if (blockSize > 0) {
            params.put("block_size", String.valueOf(blockSize).getBytes());
        }
        if (blockInterval > 0) {
            params.put("block_interval", String.valueOf(blockInterval).getBytes());
        }
        if (txParameterSize > 0) {
            params.put("tx_parameter_size", String.valueOf(txParameterSize).getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.BLOCK_UPDATE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigTrustRootAdd(String trustRootOrgId, String[] trustRootCrt, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", trustRootOrgId.getBytes());
        if (trustRootCrt.length > 0) {
            params.put(ROOT, Utils.joinList(trustRootCrt).getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.TRUST_ROOT_ADD.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigTrustRootUpdate(String trustRootOrgId, String[] trustRootCrt, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", trustRootOrgId.getBytes());
        if (trustRootCrt.length > 0) {
            params.put(ROOT, Utils.joinList(trustRootCrt).getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.TRUST_ROOT_UPDATE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigTrustRootDelete(String orgIdOrPKPubkeyPEM, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (Objects.equals(this.clientUser.getAuthType(), AuthType.Public.getMsg())) {
            params.put("org_id", "public".getBytes());
            params.put(ROOT, orgIdOrPKPubkeyPEM.getBytes());
        } else {
            params.put("org_id", orgIdOrPKPubkeyPEM.getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.TRUST_ROOT_DELETE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigPermissionAdd(String permissionResourceName, PolicyOuterClass.Policy principal, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(permissionResourceName, principal.toByteArray());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.PERMISSION_ADD.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigPermissionUpdate(String permissionResourceName, PolicyOuterClass.Policy principal, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(permissionResourceName, principal.toByteArray());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.PERMISSION_UPDATE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigPermissionDelete(String permissionResourceName, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(permissionResourceName, "".getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.PERMISSION_DELETE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusNodeAddrAdd(String nodeOrgId, String[] nodeAddresses, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", nodeOrgId.getBytes());
        if (nodeAddresses.length > 0) {
            params.put(NODE_IDS, Utils.joinList(nodeAddresses).getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.NODE_ID_ADD.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusNodeAddrUpdate(String nodeOrgId, String nodeOldAddress, String nodeNewAddress, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", nodeOrgId.getBytes());
        params.put(NODE_ID, nodeOldAddress.getBytes());
        params.put("new_node_id", nodeNewAddress.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.NODE_ID_UPDATE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusNodeAddrDelete(String nodeOrgId, String nodeAddress, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", nodeOrgId.getBytes());
        params.put(NODE_ID, nodeAddress.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.NODE_ID_DELETE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusNodeOrgAdd(String nodeOrgId, String[] nodeAddresses, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", nodeOrgId.getBytes());
        if (nodeAddresses.length > 0) {
            params.put(NODE_IDS, Utils.joinList(nodeAddresses).getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.NODE_ORG_ADD.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusNodeOrgUpdate(String nodeOrgId, String[] nodeAddresses, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", nodeOrgId.getBytes());
        if (nodeAddresses.length > 0) {
            params.put(NODE_IDS, Utils.joinList(nodeAddresses).getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.NODE_ORG_UPDATE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusNodeOrgDelete(String nodeOrgId, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", nodeOrgId.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.NODE_ORG_DELETE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusExtAdd(Map<String, byte[]> params, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.CONSENSUS_EXT_ADD.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusExtUpdate(Map<String, byte[]> params, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.CONSENSUS_EXT_UPDATE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusExtDelete(String[] keys, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (keys.length > 0) {
            for (String key : keys) {
                params.put(key, "".getBytes());
            }
        }
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.CONSENSUS_EXT_DELETE.toString(), params, sequence + 1L);
    }

    public Request.Payload createChainConfigTrustMemberAddPayload(String trustMemberOrgId, String trustMemberNodeId, String trustMemberRole, String trustMemberInfo, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", trustMemberOrgId.getBytes());
        params.put(MEMBER_INFO, trustMemberInfo.getBytes());
        params.put(NODE_ID, trustMemberNodeId.getBytes());
        params.put("role", trustMemberRole.getBytes());
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.TRUST_MEMBER_ADD.toString(), params, sequence + 1L);
    }

    public Request.Payload createChainConfigTrustMemberDeletePayload(String trustMemberInfo, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(MEMBER_INFO, trustMemberInfo.getBytes());
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.TRUST_MEMBER_DELETE.toString(), params, sequence + 1L);
    }

    public ResultOuterClass.TxResponse updateChainConfig(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public Request.Payload createChainConfigAlterAddrTypePayload(String addressType, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(ADDR_TYPE, addressType.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.ALTER_ADDR_TYPE.toString(), params, sequence + 1L);
    }

    public Request.Payload createChainConfigOptimizeChargeGasPayload(Boolean enable, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        logger.debug("[SDK] begin CreateChainConfigOptimizeChargeGasPayload");
        long seq = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Key_GASENABLEOPTIMIZECHARGEGAS, String.valueOf(enable).getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.CORE_UPDATE.toString(), params, seq + 1L);
    }

    public List<ChainConfigOuterClass.ResourcePolicy> getChainConfigPermissionList(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException, InvalidProtocolBufferException {
        logger.debug("[SDK] begin to get chain config permission list");
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.PERMISSION_LIST.toString(), null, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        ChainConfigOuterClass.ChainConfig chainConfig = ChainConfigOuterClass.ChainConfig.parseFrom(txResponse.getContractResult().getResult().toByteArray());
        return chainConfig.getResourcePoliciesList();
    }

    public ResultOuterClass.TxResponse addCert(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        byte[] certHash = this.getCertHash();
        Request.Payload payload = this.createCertManagePayload(CertManage.CertManageFunction.CERT_ADD.toString(), null);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, false);
        ResultOuterClass.TxResponse.Builder txResponseBuilder = txResponse.toBuilder();
        txResponseBuilder.setContractResult(ResultOuterClass.ContractResult.newBuilder().setResult(ByteString.copyFrom((byte[])certHash)));
        return txResponseBuilder.build();
    }

    public ResultOuterClass.TxResponse deleteCert(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.CertInfos queryCert(String[] certHashes, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ResultOuterClass.CertInfos certInfos;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (certHashes.length > 0) {
            params.put(KEYCERTHASHS, Utils.joinList(certHashes).getBytes());
        }
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CERT_MANAGE.toString(), CertManage.CertManageFunction.CERTS_QUERY.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        try {
            certInfos = ResultOuterClass.CertInfos.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("certInfos parseFrom result : ", (Throwable)e);
            throw new ChainClientException("certInfos parseFrom result : " + e.getMessage());
        }
        return certInfos;
    }

    public ResultOuterClass.TxResponse freezeCerts(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse unfreezeCerts(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse revokeCerts(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public Request.Payload createCertManagePayload(String method, Map<String, byte[]> params) throws ChainMakerCryptoSuiteException {
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CERT_MANAGE.toString(), method, params, 0L);
    }

    public Request.Payload createCertDeletePayload(String[] certHashes) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (certHashes.length > 0) {
            params.put(KEYCERTHASHS, Utils.joinList(certHashes).getBytes());
        }
        return this.createCertManagePayload(CertManage.CertManageFunction.CERTS_DELETE.toString(), params);
    }

    public Request.Payload createCertFreezePayload(String[] certs) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (certs.length > 0) {
            params.put(KEYCERTS, Utils.joinList(certs).getBytes());
        }
        return this.createCertManagePayload(CertManage.CertManageFunction.CERTS_FREEZE.toString(), params);
    }

    public Request.Payload createPayloadOfUnfreezeCerts(String[] certs) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (certs.length > 0) {
            params.put(KEYCERTS, Utils.joinList(certs).getBytes());
        }
        return this.createCertManagePayload(CertManage.CertManageFunction.CERTS_UNFREEZE.toString(), params);
    }

    public ResultOuterClass.TxResponse sendCertManageRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public Request.Payload createPayloadOfRevokeCerts(String certCrl) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEYCERTCRL, certCrl.getBytes());
        return this.createCertManagePayload(CertManage.CertManageFunction.CERTS_REVOKE.toString(), params);
    }

    public void subscribeBlock(long startBlock, long endBlock, boolean withRwSet, boolean onlyHeader, StreamObserver<ResultOuterClass.SubscribeResult> blockStreamObserver) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Subscribe.SubscribeBlock.Parameter.START_BLOCK.toString(), Utils.longToByteLittleEndian(startBlock));
        params.put(Subscribe.SubscribeBlock.Parameter.END_BLOCK.toString(), Utils.longToByteLittleEndian(endBlock));
        params.put(Subscribe.SubscribeBlock.Parameter.WITH_RWSET.toString(), String.valueOf(withRwSet).getBytes());
        params.put(Subscribe.SubscribeBlock.Parameter.ONLY_HEADER.toString(), String.valueOf(onlyHeader).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.SUBSCRIBE, SystemContractOuterClass.SystemContract.SUBSCRIBE_MANAGE.toString(), Subscribe.SubscribeFunction.SUBSCRIBE_BLOCK.toString(), params, 0L);
        this.subscribe(payload, blockStreamObserver);
    }

    public void subscribeTx(long startBlock, long endBlock, String contractName, String[] txIds, StreamObserver<ResultOuterClass.SubscribeResult> txStreamObserver) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Subscribe.SubscribeTx.Parameter.START_BLOCK.toString(), Utils.longToByteLittleEndian(startBlock));
        params.put(Subscribe.SubscribeTx.Parameter.END_BLOCK.toString(), Utils.longToByteLittleEndian(endBlock));
        params.put(Subscribe.SubscribeTx.Parameter.CONTRACT_NAME.toString(), contractName.getBytes());
        if (txIds.length > 0) {
            params.put(Subscribe.SubscribeTx.Parameter.TX_IDS.toString(), Utils.joinList(txIds).getBytes());
        }
        Request.Payload payload = this.createPayload("", Request.TxType.SUBSCRIBE, SystemContractOuterClass.SystemContract.SUBSCRIBE_MANAGE.toString(), Subscribe.SubscribeFunction.SUBSCRIBE_TX.toString(), params, 0L);
        this.subscribe(payload, txStreamObserver);
    }

    public void subscribeTxByPreAlias(long startBlock, long endBlock, String preAlias, StreamObserver<ResultOuterClass.SubscribeResult> txStreamObserver) throws ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Subscribe.SubscribeTx.Parameter.START_BLOCK.toString(), Utils.longToByteLittleEndian(startBlock));
        params.put(Subscribe.SubscribeTx.Parameter.END_BLOCK.toString(), Utils.longToByteLittleEndian(endBlock));
        params.put("PRE_ALIAS", preAlias.getBytes());
        if (preAlias.isEmpty()) {
            throw new ChainClientException("parameter error, preAlias cannot be empty");
        }
        Request.Payload payload = this.createPayload("", Request.TxType.SUBSCRIBE, SystemContractOuterClass.SystemContract.SUBSCRIBE_MANAGE.toString(), Subscribe.SubscribeFunction.SUBSCRIBE_TX.toString(), params, 0L);
        this.subscribe(payload, txStreamObserver);
    }

    public void subscribeTxByPreTxId(long startBlock, long endBlock, String preTxId, StreamObserver<ResultOuterClass.SubscribeResult> txStreamObserver) throws ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Subscribe.SubscribeTx.Parameter.START_BLOCK.toString(), Utils.longToByteLittleEndian(startBlock));
        params.put(Subscribe.SubscribeTx.Parameter.END_BLOCK.toString(), Utils.longToByteLittleEndian(endBlock));
        params.put("PRE_TX_ID", preTxId.getBytes());
        if (preTxId.isEmpty()) {
            throw new ChainClientException("parameter error, preTxId cannot be empty");
        }
        Request.Payload payload = this.createPayload("", Request.TxType.SUBSCRIBE, SystemContractOuterClass.SystemContract.SUBSCRIBE_MANAGE.toString(), Subscribe.SubscribeFunction.SUBSCRIBE_TX.toString(), params, 0L);
        this.subscribe(payload, txStreamObserver);
    }

    public void subscribeTxByPreOrgId(long startBlock, long endBlock, String preOrgId, StreamObserver<ResultOuterClass.SubscribeResult> txStreamObserver) throws ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Subscribe.SubscribeTx.Parameter.START_BLOCK.toString(), Utils.longToByteLittleEndian(startBlock));
        params.put(Subscribe.SubscribeTx.Parameter.END_BLOCK.toString(), Utils.longToByteLittleEndian(endBlock));
        params.put("PRE_ORG_ID", preOrgId.getBytes());
        if (preOrgId.isEmpty()) {
            throw new ChainClientException("parameter error, preOrgId cannot be empty");
        }
        Request.Payload payload = this.createPayload("", Request.TxType.SUBSCRIBE, SystemContractOuterClass.SystemContract.SUBSCRIBE_MANAGE.toString(), Subscribe.SubscribeFunction.SUBSCRIBE_TX.toString(), params, 0L);
        this.subscribe(payload, txStreamObserver);
    }

    public void subscribeContractEvent(long startBlock, long endBlock, String topic, String contractName, StreamObserver<ResultOuterClass.SubscribeResult> contractEventStreamObserver) throws ChainClientException, ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Subscribe.SubscribeContractEvent.Parameter.START_BLOCK.toString(), Utils.longToByteLittleEndian(startBlock));
        params.put(Subscribe.SubscribeContractEvent.Parameter.END_BLOCK.toString(), Utils.longToByteLittleEndian(endBlock));
        params.put(Subscribe.SubscribeContractEvent.Parameter.TOPIC.toString(), topic.getBytes());
        params.put(Subscribe.SubscribeContractEvent.Parameter.CONTRACT_NAME.toString(), contractName.getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.SUBSCRIBE, SystemContractOuterClass.SystemContract.SUBSCRIBE_MANAGE.toString(), Subscribe.SubscribeFunction.SUBSCRIBE_CONTRACT_EVENT.toString(), params, 0L);
        this.subscribe(payload, contractEventStreamObserver);
    }

    public ResultOuterClass.TxResponse sendArchiveBlockRequest(Request.Payload payload, long timeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendRequest(payload, null, timeout);
    }

    public ResultOuterClass.TxResponse sendRestoreBlockRequest(Request.Payload payload, long timeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendRequest(payload, null, timeout);
    }

    public Request.Payload createArchiveBlockPayload(long targetBlockHeight) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Archive.ArchiveBlock.Parameter.BLOCK_HEIGHT.toString(), Utils.longToByteLittleEndian(targetBlockHeight));
        return this.createPayload("", Request.TxType.ARCHIVE, SystemContractOuterClass.SystemContract.ARCHIVE_MANAGE.toString(), Archive.ArchiveFunction.ARCHIVE_BLOCK.toString(), params, 0L);
    }

    public Request.Payload createRestoreBlockPayload(byte[] fullBlock) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Archive.RestoreBlock.Parameter.FULL_BLOCK.toString(), fullBlock);
        return this.createPayload("", Request.TxType.ARCHIVE, SystemContractOuterClass.SystemContract.ARCHIVE_MANAGE.toString(), Archive.ArchiveFunction.RESTORE_BLOCK.toString(), params, 0L);
    }

    public Store.BlockWithRWSet getArchivedFullBlockByHeight(long blockHeight) throws ChainClientException {
        return this.getFromArchiveStore(blockHeight);
    }

    public ChainmakerBlock.BlockInfo getArchivedBlockByHeight(long blockHeight, boolean withRWSet) throws ChainClientException {
        Store.BlockWithRWSet fullBlock = this.getFromArchiveStore(blockHeight);
        ChainmakerBlock.BlockInfo blockInfo = ChainmakerBlock.BlockInfo.newBuilder().setBlock(fullBlock.getBlock()).build();
        ChainmakerBlock.BlockInfo.Builder blockInfoBuilder = blockInfo.toBuilder();
        if (withRWSet) {
            blockInfoBuilder.addAllRwsetList(blockInfo.getRwsetListList());
        }
        return blockInfoBuilder.build();
    }

    public long getArchivedBlockHeight(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), GET_ARCHIVED_BLOCK_HEIGHT, params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        return Integer.parseInt(txResponse.getContractResult().getResult().toStringUtf8());
    }

    public Request.Payload createPubkeyAddPayload(String pubkey, String orgId, String role) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_PUBKEY, pubkey.getBytes());
        params.put("org_id", orgId.getBytes());
        params.put("role", role.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.PUBKEY_MANAGE.toString(), PubkeyManage.PubkeyManageFunction.PUBKEY_ADD.toString(), params, 0L);
    }

    public Request.Payload createPubkeyDelPayload(String pubkey, String orgId) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_PUBKEY, pubkey.getBytes());
        params.put("org_id", orgId.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.PUBKEY_MANAGE.toString(), PubkeyManage.PubkeyManageFunction.PUBKEY_DELETE.toString(), params, 0L);
    }

    public Request.Payload createPubkeyQueryPayload(String pubkey) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_PUBKEY, pubkey.getBytes());
        return this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.PUBKEY_MANAGE.toString(), PubkeyManage.PubkeyManageFunction.PUBKEY_QUERY.toString(), params, 0L);
    }

    public ResultOuterClass.TxResponse sendPubkeyManageRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse multiSignContractReq(Request.Payload payload, long rpcCallTimeout, boolean withSyncResult) throws ChainClientException, ChainMakerCryptoSuiteException {
        long syncResultTimeout = -1L;
        if (withSyncResult) {
            syncResultTimeout = (long)this.retryLimit * (long)this.retryInterval;
        }
        return this.sendContractRequest(payload, null, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse multiSignContractReqWithPayer(Request.Payload payload, Request.EndorsementEntry[] endorsers, Request.EndorsementEntry payer, long rpcCallTimeout, boolean withSyncResult) throws ChainClientException, ChainMakerCryptoSuiteException {
        long syncResultTimeout = -1L;
        if (withSyncResult) {
            syncResultTimeout = (long)this.retryLimit * (long)this.retryInterval;
        }
        return this.sendContractRequestWithPayer(payload, endorsers, payer, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse multiSignContractVote(Request.Payload payload, Request.EndorsementEntry endorsementEntry, boolean isAgree, long rpcCallTimeout, boolean withSyncResult) throws ChainMakerCryptoSuiteException, ChainClientException {
        MultiSign.MultiSignVoteInfo.Builder multiSignVoteInfoBuilder = MultiSign.MultiSignVoteInfo.newBuilder();
        multiSignVoteInfoBuilder.setEndorsement(endorsementEntry);
        if (isAgree) {
            multiSignVoteInfoBuilder.setVote(MultiSign.VoteStatus.AGREE);
        } else {
            multiSignVoteInfoBuilder.setVote(MultiSign.VoteStatus.REJECT);
        }
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(MultiSign.MultiVote.Parameter.VOTE_INFO.toString(), multiSignVoteInfoBuilder.build().toByteArray());
        params.put(MultiSign.MultiVote.Parameter.TX_ID.toString(), payload.getTxId().getBytes());
        Request.Payload multiSignVotePayload = this.createMultiSignVotePayload(params, null);
        long syncResultTimeout = -1L;
        if (withSyncResult) {
            syncResultTimeout = (long)this.retryLimit * (long)this.retryInterval;
        }
        return this.sendContractRequest(multiSignVotePayload, null, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse multiSignContractVoteWithGasLimit(Request.Payload payload, Request.EndorsementEntry endorsementEntry, boolean isAgree, long gasLimit, long rpcCallTimeout, boolean withSyncResult) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.multiSignContractVoteWithGasLimitAndPayer(payload, endorsementEntry, null, isAgree, gasLimit, rpcCallTimeout, withSyncResult);
    }

    public ResultOuterClass.TxResponse multiSignContractVoteWithGasLimitAndPayer(Request.Payload payload, Request.EndorsementEntry endorsementEntry, Request.EndorsementEntry payer, boolean isAgree, long gasLimit, long rpcCallTimeout, boolean withSyncResult) throws ChainMakerCryptoSuiteException, ChainClientException {
        MultiSign.MultiSignVoteInfo.Builder multiSignVoteInfoBuilder = MultiSign.MultiSignVoteInfo.newBuilder();
        multiSignVoteInfoBuilder.setEndorsement(endorsementEntry);
        if (isAgree) {
            multiSignVoteInfoBuilder.setVote(MultiSign.VoteStatus.AGREE);
        } else {
            multiSignVoteInfoBuilder.setVote(MultiSign.VoteStatus.REJECT);
        }
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(MultiSign.MultiVote.Parameter.VOTE_INFO.toString(), multiSignVoteInfoBuilder.build().toByteArray());
        params.put(MultiSign.MultiVote.Parameter.TX_ID.toString(), payload.getTxId().getBytes());
        Request.Limit.Builder builder = Request.Limit.newBuilder();
        if (gasLimit > 0L) {
            builder.setGasLimit(gasLimit);
        }
        Request.Limit limit = builder.build();
        Request.Payload multiSignVotePayload = this.createMultiSignVotePayload(params, limit);
        long syncResultTimeout = -1L;
        if (withSyncResult) {
            syncResultTimeout = (long)this.retryLimit * (long)this.retryInterval;
        }
        return this.sendContractRequestWithPayer(multiSignVotePayload, null, payer, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse multiSignContractTrig(Request.Payload payload, Request.Limit limit, long rpcCallTimeout, boolean withSyncResult) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.multiSignContractTrig(payload.getTxId(), limit, rpcCallTimeout, withSyncResult);
    }

    public ResultOuterClass.TxResponse multiSignContractTrigWithPayer(Request.Payload payload, Request.EndorsementEntry payer, Request.Limit limit, long rpcCallTimeout, boolean withSyncResult) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.multiSignContractTrigWithPayer(payload.getTxId(), payer, limit, rpcCallTimeout, withSyncResult);
    }

    public ResultOuterClass.TxResponse multiSignContractTrig(String txId, Request.Limit limit, long rpcCallTimeout, boolean withSyncResult) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.multiSignContractTrigWithPayer(txId, null, limit, rpcCallTimeout, withSyncResult);
    }

    public ResultOuterClass.TxResponse multiSignContractTrigWithPayer(String txId, Request.EndorsementEntry payer, Request.Limit limit, long rpcCallTimeout, boolean withSyncResult) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(MultiSign.MultiVote.Parameter.TX_ID.toString(), txId.getBytes());
        Request.Payload multiSignVotePayload = this.createMultiSignTrigPayload(params, limit);
        long syncResultTimeout = -1L;
        if (withSyncResult) {
            syncResultTimeout = (long)this.retryLimit * (long)this.retryInterval;
        }
        return this.sendContractRequestWithPayer(multiSignVotePayload, null, payer, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse multiSignContractQuery(String txId, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(MultiSign.MultiVote.Parameter.TX_ID.toString(), txId.getBytes());
        Request.Payload payload = this.createMultiSignQueryPayload(params);
        return this.proposalRequest(payload, null, rpcCallTimeout);
    }

    public ResultOuterClass.TxResponse multiSignContractQueryWithParams(String txId, Map<String, byte[]> params, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        if (params == null) {
            params = new HashMap<String, byte[]>();
        }
        params.put(MultiSign.MultiVote.Parameter.TX_ID.toString(), txId.getBytes());
        Request.Payload payload = this.createMultiSignQueryPayload(params);
        return this.proposalRequest(payload, null, rpcCallTimeout);
    }

    public Request.Payload createMultiSignReqPayload(Map<String, byte[]> params) throws ChainMakerCryptoSuiteException {
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.MULTI_SIGN.toString(), MultiSign.MultiSignFunction.REQ.toString(), params, 0L);
    }

    public Request.Payload createMultiSignReqPayloadWithGasLimit(Map<String, byte[]> params, long gasLimit) throws ChainMakerCryptoSuiteException {
        Request.Limit.Builder builder = Request.Limit.newBuilder();
        if (gasLimit > 0L) {
            builder.setGasLimit(gasLimit);
        }
        Request.Limit limit = builder.build();
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.MULTI_SIGN.toString(), MultiSign.MultiSignFunction.REQ.toString(), params, 0L, limit);
    }

    public Request.Payload createMultiSignVotePayload(Map<String, byte[]> params, Request.Limit limit) throws ChainMakerCryptoSuiteException {
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.MULTI_SIGN.toString(), MultiSign.MultiSignFunction.VOTE.toString(), params, 0L, limit);
    }

    public Request.Payload createMultiSignTrigPayload(Map<String, byte[]> params, Request.Limit limit) throws ChainMakerCryptoSuiteException {
        Request.Payload payload = this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.MULTI_SIGN.toString(), MultiSign.MultiSignFunction.TRIG.toString(), params, 0L);
        if (limit != null) {
            return payload.toBuilder().setLimit(limit).build();
        }
        return payload.toBuilder().build();
    }

    public Request.Payload createMultiSignQueryPayload(Map<String, byte[]> params) throws ChainMakerCryptoSuiteException {
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.MULTI_SIGN.toString(), MultiSign.MultiSignFunction.QUERY.toString(), params, 0L);
    }

    public void stop() {
        this.connectionPool.close();
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
        if (this.connectionPool.getNumActive() > 0) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.connectionPool.close();
            if (this.connectionPool.getNumActive() > 0) {
                GrpcClientFactory factory = (GrpcClientFactory)this.getConnectionPool().getFactory();
                factory.stopAll();
            }
        }
    }

    public String getChainMakerServerVersion(long timeout) throws ChainClientException {
        ChainmakerServer.ChainMakerVersionResponse response;
        RpcServiceClient rpcServiceClient = null;
        try {
            rpcServiceClient = (RpcServiceClient)this.connectionPool.borrowObject();
        }
        catch (Exception e) {
            logger.error("all connections no Idle or Ready");
            throw new ChainClientException("all connections no Idle or Ready, please reSet connection count", ExceptionType.NOTNORMALCONNECT);
        }
        ChainmakerServer.ChainMakerVersionRequest.Builder chainMakerVersionRequest = ChainmakerServer.ChainMakerVersionRequest.newBuilder();
        try {
            response = (ChainmakerServer.ChainMakerVersionResponse)rpcServiceClient.getRpcNodeFutureStub().getChainMakerVersion(chainMakerVersionRequest.build()).get(timeout, TimeUnit.MILLISECONDS);
            this.connectionPool.returnObject((Object)rpcServiceClient);
        }
        catch (Exception e) {
            logger.error("connect to peer error : ", (Throwable)e);
            try {
                this.connectionPool.invalidateObject((Object)rpcServiceClient);
            }
            catch (Exception ex) {
                logger.error("invalidate object fail :", (Throwable)ex);
                throw new ChainClientException("invalidate object fail : " + ex.getMessage());
            }
            throw new ChainClientException("connect to peer error : " + e.getMessage());
        }
        if (response.getCode() != 0) {
            logger.error("get chain version failed : " + response.getMessage());
            throw new ChainClientException("get chain version failed : " + response.getMessage());
        }
        return response.getVersion();
    }

    public LocalConfig.CheckNewBlockChainConfigResponse checkNewBlockChainConfig(NodeConfig nodeConfig, long timeout) throws ChainClientException {
        LocalConfig.CheckNewBlockChainConfigResponse response;
        RpcServiceClient rpcServiceClient = null;
        LocalConfig.CheckNewBlockChainConfigRequest.Builder checkNewBlockChainConfigRequest = LocalConfig.CheckNewBlockChainConfigRequest.newBuilder();
        try {
            Node node = this.getNodeByNodeConfig(nodeConfig);
            rpcServiceClient = RpcServiceClient.newServiceClient(node, this.getClientUser(), 16, this.proxyUrl);
            logger.info("open connect:{}", (Object)rpcServiceClient.getManagedChannel());
            response = (LocalConfig.CheckNewBlockChainConfigResponse)rpcServiceClient.getRpcNodeFutureStub().checkNewBlockChainConfig(checkNewBlockChainConfigRequest.build()).get(timeout, TimeUnit.MILLISECONDS);
            if (response.getCode() != 0) {
                logger.error("check new block chain config failed : " + response.getMessage());
                throw new ChainClientException("check new block chain config failed : " + response.getMessage());
            }
            logger.info("shutdown:{}", (Object)(rpcServiceClient != null ? rpcServiceClient.getManagedChannel() : null));
        }
        catch (Exception e) {
            try {
                logger.error("connect to peer error : ", (Throwable)e);
                throw new ChainClientException("connect to peer error : " + e.getMessage());
            }
            catch (Throwable throwable) {
                logger.info("shutdown:{}", (Object)(rpcServiceClient != null ? rpcServiceClient.getManagedChannel() : null));
                if (rpcServiceClient != null) {
                    rpcServiceClient.getManagedChannel().shutdown();
                }
                throw throwable;
            }
        }
        if (rpcServiceClient != null) {
            rpcServiceClient.getManagedChannel().shutdown();
        }
        return response;
    }

    public Request.Payload createSetGasAdminPayload(String address) throws ChainMakerCryptoSuiteException, UtilsException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_GASADDRESSKEY, address.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.SET_ADMIN.toString(), params, 0L);
    }

    public String getGasAdmin(long rpcCallTimeout) throws ChainClientException {
        ResultOuterClass.TxResponse resp;
        try {
            Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.GET_ADMIN.toString(), null, 0L);
            resp = this.proposalRequest(payload, null, rpcCallTimeout);
            this.checkProposalRequestResp(resp, true);
        }
        catch (Exception e) {
            logger.error("[SDK] begin to QUERY system contract, method:", (Throwable)e);
            throw new ChainClientException("Gas Admin error:" + e.getMessage());
        }
        return resp.getContractResult().getResult().toStringUtf8();
    }

    public Request.Payload createRechargeGasPayload(AccountManager.RechargeGas[] rechargeGasList) throws ChainMakerCryptoSuiteException {
        AccountManager.RechargeGasReq.Builder rechargeGasReqBuilder = AccountManager.RechargeGasReq.newBuilder();
        rechargeGasReqBuilder.addAllBatchRechargeGas(Arrays.asList((Object[])rechargeGasList.clone()));
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Key_GASBATCHRECHARGE, rechargeGasReqBuilder.build().toByteArray());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.RECHARGE_GAS.toString(), params, 0L);
    }

    public long getGasBalance(String address, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException, UtilsException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_GASADDRESSKEY, address.getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.GET_BALANCE.toString(), params, 0L);
        ResultOuterClass.TxResponse resp = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(resp, true);
        return Long.parseLong(resp.getContractResult().getResult().toStringUtf8());
    }

    public Request.Payload createRefundGasPayload(String address, long amount) throws ChainMakerCryptoSuiteException {
        if (amount <= 0L) {
            logger.error("amount must > 0");
        }
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_GASADDRESSKEY, address.getBytes());
        params.put(Key_GASCHARGEGASAMOUNT, String.valueOf(amount).getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.REFUND_GAS.toString(), params, 0L);
    }

    public Request.Payload createFrozenGasAccountPayload(String address) throws ChainMakerCryptoSuiteException, UtilsException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_GASADDRESSKEY, address.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.FROZEN_ACCOUNT.toString(), params, 0L);
    }

    public Request.Payload createUnfrozenGasAccountPayload(String address) throws ChainMakerCryptoSuiteException, UtilsException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_GASADDRESSKEY, address.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.UNFROZEN_ACCOUNT.toString(), params, 0L);
    }

    public boolean getGasAccountStatus(String address, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException, UtilsException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_GASADDRESSKEY, address.getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.ACCOUNT_STATUS.toString(), params, 0L);
        ResultOuterClass.TxResponse resp = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(resp, true);
        return resp.getContractResult().getResult().toStringUtf8().equals("0");
    }

    public ResultOuterClass.TxResponse sendGasManageRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public Request.Payload attachGasLimit(Request.Payload payload, Request.Limit limit) {
        Request.Payload.Builder payloadBuilder = payload.toBuilder();
        payloadBuilder.setLimit(limit);
        payload = payloadBuilder.build();
        return payload;
    }

    public Request.Payload createChainConfigEnableOrDisableGasPayload(long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.ENABLE_OR_DISABLE_GAS.toString(), null, sequence + 1L);
    }

    public Request.Payload createSetInvokeBaseGasPayload(long amount, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        logger.debug("[SDK] begin CreateSetInvokeBaseGasPayload");
        if (amount <= 0L) {
            logger.error("amount must > 0");
            return null;
        }
        long seq = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Key_GASSETINVOKEBASEGAS, String.valueOf(amount).getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.SET_INVOKE_BASE_GAS.toString(), params, seq + 1L);
    }

    public Request.Payload createSetInvokeGasPricePayload(String gasPrice, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        logger.debug("[SDK] begin createSetInvokeGasPricePayload");
        long seq = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Key_GASSETINVOKEGASPRICE, gasPrice.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.SET_INVOKE_GAS_PRICE.toString(), params, seq + 1L);
    }

    public Request.Payload createSetInstallBaseGasPayload(long amount, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        logger.debug("[SDK] begin createSetInstallBaseGasPayload");
        if (amount <= 0L) {
            logger.error("amount must > 0");
            return null;
        }
        long seq = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Key_GASSETINSTALLBASEGAS, String.valueOf(amount).getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.SET_INSTALL_BASE_GAS.toString(), params, seq + 1L);
    }

    public Request.Payload createSetInstallGasPricePayload(String gasPrice, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        logger.debug("[SDK] begin createSetInstallGasPricePayload");
        long seq = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Key_GASSETINSTALLGASPRICE, gasPrice.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.SET_INSTALL_GAS_PRICE.toString(), params, seq + 1L);
    }

    public long estimateGas(Request.Payload payload, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        logger.debug("[SDK] begin EstimateGas");
        payload = payload.toBuilder().setTxType(Request.TxType.QUERY_CONTRACT).build();
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        return txResponse.getContractResult().getGasUsed();
    }

    public ResultOuterClass.TxResponse addAlias(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_ALIAS, this.clientUser.getAlias().getBytes());
        Request.Payload payload = this.createCertManagePayload(CertManage.CertManageFunction.CERT_ALIAS_ADD.toString(), params);
        ResultOuterClass.TxResponse txResponse = this.sendContractRequest(payload, null, rpcCallTimeout, 10000L);
        this.checkProposalRequestResp(txResponse, true);
        ResultOuterClass.TxResponse.Builder txResponseBuilder = txResponse.toBuilder();
        txResponseBuilder.setContractResult(ResultOuterClass.ContractResult.newBuilder().setResult(ByteString.copyFrom((byte[])this.clientUser.getAlias().getBytes())));
        return txResponseBuilder.build();
    }

    public Request.Payload createAliasUpdatePayload(String alias, String certPem) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_ALIAS, alias.getBytes());
        params.put(KEY_CERT, certPem.getBytes());
        return this.createCertManagePayload(CertManage.CertManageFunction.CERT_ALIAS_UPDATE.toString(), params);
    }

    public ResultOuterClass.TxResponse updateAlias(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, -1L);
    }

    public ResultOuterClass.AliasInfos queryAlias(String[] aliasList, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ResultOuterClass.AliasInfos aliasInfos;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_ALIASES, Utils.joinList(aliasList).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CERT_MANAGE.toString(), CertManage.CertManageFunction.CERTS_ALIAS_QUERY.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            aliasInfos = ResultOuterClass.AliasInfos.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("aliasInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("aliasInfo parseFrom result : " + e.getMessage());
        }
        return aliasInfos;
    }

    public Request.Payload createAliasDeletePayload(String[] aliasList) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_ALIASES, Utils.joinList(aliasList).getBytes());
        return this.createCertManagePayload(CertManage.CertManageFunction.CERTS_ALIAS_DELETE.toString(), params);
    }

    public ResultOuterClass.TxResponse deleteAlias(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public TransactionPool.TxPoolStatus getPoolStatus(long rpcCallTimeout) throws ChainClientException {
        RpcServiceClient rpcServiceClient;
        logger.debug("[SDK] begin GetPoolStatus");
        try {
            rpcServiceClient = (RpcServiceClient)this.connectionPool.borrowObject();
        }
        catch (Exception e) {
            logger.error("all connections no Idle or Ready");
            throw new ChainClientException("all connections no Idle or Ready, please reSet connection count", ExceptionType.NOTNORMALCONNECT);
        }
        TransactionPool.GetPoolStatusRequest req = TransactionPool.GetPoolStatusRequest.newBuilder().setChainId(this.chainId).build();
        TransactionPool.TxPoolStatus txPoolStatus = null;
        try {
            txPoolStatus = (TransactionPool.TxPoolStatus)rpcServiceClient.getRpcNodeFutureStub().getPoolStatus(req).get(rpcCallTimeout, TimeUnit.MILLISECONDS);
            this.connectionPool.returnObject((Object)rpcServiceClient);
        }
        catch (Exception e) {
            logger.error("getPoolStatus error: {}", (Object)e.getMessage());
            try {
                this.connectionPool.invalidateObject((Object)rpcServiceClient);
            }
            catch (Exception ex) {
                logger.error("invalidate object fail :", (Throwable)ex);
                throw new ChainClientException("invalidate object fail : " + ex.getMessage());
            }
            throw new ChainClientException("getPoolStatus error : " + e.getMessage());
        }
        return txPoolStatus;
    }

    public List<String> getTxIdsByTypeAndStage(TransactionPool.TxType txType, TransactionPool.TxStage txStage, long rpcCallTimeout) throws ChainClientException {
        TransactionPool.GetTxIdsByTypeAndStageResponse resp;
        RpcServiceClient rpcServiceClient;
        logger.debug("[SDK] begin GetTxIdsByTypeAndStage");
        try {
            rpcServiceClient = (RpcServiceClient)this.connectionPool.borrowObject();
        }
        catch (Exception e) {
            logger.error("all connections no Idle or Ready");
            throw new ChainClientException("all connections no Idle or Ready, please reSet connection count", ExceptionType.NOTNORMALCONNECT);
        }
        TransactionPool.GetTxIdsByTypeAndStageRequest req = TransactionPool.GetTxIdsByTypeAndStageRequest.newBuilder().setChainId(this.chainId).setTxType(txType).setTxStage(txStage).build();
        try {
            resp = (TransactionPool.GetTxIdsByTypeAndStageResponse)rpcServiceClient.getRpcNodeFutureStub().getTxIdsByTypeAndStage(req).get(rpcCallTimeout, TimeUnit.MILLISECONDS);
            this.connectionPool.returnObject((Object)rpcServiceClient);
        }
        catch (Exception e) {
            logger.error("getTxIdsByTypeAndStage error: {}", (Object)e.getMessage());
            try {
                this.connectionPool.invalidateObject((Object)rpcServiceClient);
            }
            catch (Exception ex) {
                logger.error("invalidate object fail :", (Throwable)ex);
                throw new ChainClientException("invalidate object fail : " + ex.getMessage());
            }
            throw new ChainClientException("getTxIdsByTypeAndStage error : " + e.getMessage());
        }
        if (resp == null || resp.getTxIdsList() == null) {
            return null;
        }
        return resp.getTxIdsList().stream().collect(Collectors.toList());
    }

    public List<ChainmakerTransaction.Transaction> getTxsInPoolByTxIds(String[] txIds, long rpcCallTimeout) throws ChainClientException, ExecutionException, InterruptedException, TimeoutException {
        TransactionPool.GetTxsInPoolByTxIdsResponse resp;
        RpcServiceClient rpcServiceClient;
        logger.debug("[SDK] begin GetTxsInPoolByTxIds");
        try {
            rpcServiceClient = (RpcServiceClient)this.connectionPool.borrowObject();
        }
        catch (Exception e) {
            logger.error("all connections no Idle or Ready");
            throw new ChainClientException("all connections no Idle or Ready, please reSet connection count", ExceptionType.NOTNORMALCONNECT);
        }
        TransactionPool.GetTxsInPoolByTxIdsRequest req = TransactionPool.GetTxsInPoolByTxIdsRequest.newBuilder().setChainId(this.chainId).addAllTxIds(Arrays.asList(txIds)).build();
        try {
            resp = (TransactionPool.GetTxsInPoolByTxIdsResponse)rpcServiceClient.getRpcNodeFutureStub().getTxsInPoolByTxIds(req).get(rpcCallTimeout, TimeUnit.MILLISECONDS);
            this.connectionPool.returnObject((Object)rpcServiceClient);
        }
        catch (Exception e) {
            logger.error("getTxsInPoolByTxIds error: {}", (Object)e.getMessage());
            try {
                this.connectionPool.invalidateObject((Object)rpcServiceClient);
            }
            catch (Exception ex) {
                logger.error("invalidate object fail :", (Throwable)ex);
                throw new ChainClientException("invalidate object fail : " + ex.getMessage());
            }
            throw new ChainClientException("getTxsInPoolByTxIds error : " + e.getMessage());
        }
        if (resp == null || resp.getTxsList() == null) {
            return null;
        }
        return resp.getTxsList();
    }

    public Request.Payload createSetContractMethodPayerPayload(String payerAddress, String contractName, String methodName, String requestId, String payerOrgId, byte[] payerKeyPem, byte[] payerCertPem) throws ChainMakerCryptoSuiteException {
        PrivateKey privateKey = CryptoUtils.getPrivateKeyFromBytes(payerKeyPem);
        if (requestId == null || requestId.isEmpty()) {
            requestId = UUID.randomUUID().toString();
        }
        AccountManager.SetContractMethodPayerParams params = AccountManager.SetContractMethodPayerParams.newBuilder().setContractName(contractName).setMethod(methodName).setPayerAddress(payerAddress).setRequestId(requestId).build();
        byte[] message = params.toByteArray();
        byte[] signature = this.clientUser.getCryptoSuite().sign(privateKey, message);
        MemberOuterClass.Member.Builder signer = MemberOuterClass.Member.newBuilder().setMemberInfo(ByteString.copyFrom((byte[])payerCertPem)).setOrgId(payerOrgId);
        if (this.clientUser.getAuthType() == AuthType.PermissionedWithCert.getMsg()) {
            signer.setMemberType(MemberOuterClass.MemberType.CERT);
        } else if (this.clientUser.getAuthType() == AuthType.PermissionedWithKey.getMsg()) {
            signer.setMemberType(MemberOuterClass.MemberType.PUBLIC_KEY);
        } else if (this.clientUser.getAuthType() == AuthType.Public.getMsg()) {
            signer.setMemberType(MemberOuterClass.MemberType.PUBLIC_KEY);
        }
        Request.EndorsementEntry.Builder endorsementEntry = Request.EndorsementEntry.newBuilder().setSignature(ByteString.copyFrom((byte[])signature)).setSigner(signer);
        HashMap<String, byte[]> parameters = new HashMap<String, byte[]>();
        parameters.put("PARAMS", message);
        parameters.put("ENDORSEMENT", endorsementEntry.build().toByteArray());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.SET_CONTRACT_METHOD_PAYER.toString(), parameters, 0L);
    }

    public Request.Payload createUnsetContractMethodPayerPayload(String contractName, String methodName) {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (methodName != "") {
            params.put(AccountManager.UnsetContractMethodPayer.Parameter.CONTRACT_NAME.toString(), contractName.getBytes());
            params.put(AccountManager.UnsetContractMethodPayer.Parameter.METHOD.toString(), methodName.getBytes());
        } else {
            params.put(AccountManager.UnsetContractMethodPayer.Parameter.CONTRACT_NAME.toString(), contractName.getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.UNSET_CONTRACT_METHOD_PAYER.toString(), params, 0L);
    }

    public Request.Payload createQueryContractMethodPayerPayload(String contractName, String methodName) {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (methodName != "") {
            params.put(AccountManager.GetContractMethodPayer.Parameter.CONTRACT_NAME.toString(), contractName.getBytes());
            params.put(AccountManager.GetContractMethodPayer.Parameter.METHOD.toString(), methodName.getBytes());
        } else {
            params.put(AccountManager.UnsetContractMethodPayer.Parameter.CONTRACT_NAME.toString(), contractName.getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.GET_CONTRACT_METHOD_PAYER.toString(), params, 0L);
    }

    public Request.Payload createQueryTxPayerPayload(String txId) {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(AccountManager.GetTxPayer.Parameter.TX_ID.toString(), txId.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.GET_TX_PAYER.toString(), params, 0L);
    }

    public Request.TxRequest createTxRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries) throws ChainMakerCryptoSuiteException {
        return this.createTxRequestWithPayer(payload, endorsementEntries, null);
    }

    private Request.TxRequest createTxRequestWithPayer(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, Request.EndorsementEntry payer) throws ChainMakerCryptoSuiteException {
        Request.EndorsementEntry.Builder endorsementEntryBuilder;
        MemberOuterClass.Member sender = null;
        if (this.clientUser.getAuthType().equals(AuthType.PermissionedWithCert.getMsg())) {
            sender = this.isEnabledCertHash && this.clientUser.getCertHash() != null && this.clientUser.getCertHash().length > 0 ? MemberOuterClass.Member.newBuilder().setOrgId(this.clientUser.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])this.clientUser.getCertHash())).setMemberType(MemberOuterClass.MemberType.CERT_HASH).build() : (this.isEnabledAlias && this.clientUser.getAlias() != null && this.clientUser.getAlias().length() > 0 ? MemberOuterClass.Member.newBuilder().setOrgId(this.clientUser.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])this.clientUser.getAlias().getBytes())).setMemberType(MemberOuterClass.MemberType.ALIAS).build() : MemberOuterClass.Member.newBuilder().setOrgId(this.clientUser.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])this.clientUser.getCertBytes())).setMemberType(MemberOuterClass.MemberType.CERT).build());
            byte[] signsture = !this.clientUser.isPkcs11Enable() ? this.clientUser.getCryptoSuite().sign(this.clientUser.getPrivateKey(), payload.toByteArray()) : this.clientUser.getCryptoSuite().signWithCustom(payload.toByteArray(), this.clientUser.getKeys());
            endorsementEntryBuilder = Request.EndorsementEntry.newBuilder().setSigner(sender).setSignature(ByteString.copyFrom((byte[])signsture));
        } else {
            sender = MemberOuterClass.Member.newBuilder().setOrgId(this.clientUser.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])this.clientUser.getPukBytes())).setMemberType(MemberOuterClass.MemberType.PUBLIC_KEY).build();
            byte[] signature = null;
            signature = !this.clientUser.isPkcs11Enable() ? this.clientUser.getCryptoSuite().rsaSign(this.clientUser.getPrivateKey(), payload.toByteArray(), this.getHash()) : this.clientUser.getCryptoSuite().signWithCustom(payload.toByteArray(), this.clientUser.getKeys());
            endorsementEntryBuilder = Request.EndorsementEntry.newBuilder().setSigner(sender).setSignature(ByteString.copyFrom((byte[])signature));
        }
        Request.TxRequest.Builder txRequestBuilder = Request.TxRequest.newBuilder().setPayload(payload).setSender(endorsementEntryBuilder);
        if (payer != null) {
            txRequestBuilder.setPayer(payer);
        }
        if (endorsementEntries != null) {
            txRequestBuilder.addAllEndorsers(Arrays.asList((Object[])endorsementEntries.clone()));
        }
        return txRequestBuilder.build();
    }

    private Request.TxRequest createTxRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, User user) throws ChainMakerCryptoSuiteException {
        Request.EndorsementEntry.Builder endorsementEntryBuilder;
        MemberOuterClass.Member sender = null;
        if (this.clientUser.getAuthType().equals(AuthType.PermissionedWithCert.getMsg())) {
            sender = this.isEnabledCertHash && this.clientUser.getCertHash() != null && this.clientUser.getCertHash().length > 0 ? MemberOuterClass.Member.newBuilder().setOrgId(user.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])this.clientUser.getCertHash())).setMemberType(MemberOuterClass.MemberType.CERT_HASH).build() : (this.isEnabledAlias && this.clientUser.getAlias() != null && this.clientUser.getAlias().length() > 0 ? MemberOuterClass.Member.newBuilder().setOrgId(user.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])this.clientUser.getAlias().getBytes())).setMemberType(MemberOuterClass.MemberType.ALIAS).build() : MemberOuterClass.Member.newBuilder().setOrgId(user.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])user.getCertBytes())).setMemberType(MemberOuterClass.MemberType.CERT).build());
            byte[] signsture = !this.clientUser.isPkcs11Enable() ? user.getCryptoSuite().sign(user.getPrivateKey(), payload.toByteArray()) : user.getCryptoSuite().signWithCustom(payload.toByteArray(), user.getKeys());
            endorsementEntryBuilder = Request.EndorsementEntry.newBuilder().setSigner(sender).setSignature(ByteString.copyFrom((byte[])signsture));
        } else {
            sender = MemberOuterClass.Member.newBuilder().setOrgId(this.clientUser.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])user.getPukBytes())).setMemberType(MemberOuterClass.MemberType.PUBLIC_KEY).build();
            byte[] signature = null;
            signature = !this.clientUser.isPkcs11Enable() ? user.getCryptoSuite().rsaSign(user.getPrivateKey(), payload.toByteArray(), this.getHash()) : user.getCryptoSuite().signWithCustom(payload.toByteArray(), this.clientUser.getKeys());
            endorsementEntryBuilder = Request.EndorsementEntry.newBuilder().setSigner(sender).setSignature(ByteString.copyFrom((byte[])signature));
        }
        Request.TxRequest.Builder txRequestBuilder = Request.TxRequest.newBuilder().setPayload(payload).setSender(endorsementEntryBuilder);
        if (endorsementEntries != null) {
            txRequestBuilder.addAllEndorsers(Arrays.asList((Object[])endorsementEntries.clone()));
        }
        return txRequestBuilder.build();
    }

    private ResultOuterClass.TxResponse sendTxRequest(Request.TxRequest signedRequest, long timeout) throws ChainClientException {
        return this.sendTxRequestWithSync(signedRequest, timeout, false);
    }

    private ResultOuterClass.TxResponse sendTxRequestWithSync(Request.TxRequest signedRequest, long timeout, Boolean enableSendRequestSync) throws ChainClientException {
        ResultOuterClass.TxResponse txResponse;
        RpcServiceClient rpcServiceClient = null;
        try {
            rpcServiceClient = (RpcServiceClient)this.connectionPool.borrowObject();
            if (rpcServiceClient == null) {
                logger.error("all connections no Idle or Ready");
                throw new ChainClientException("all connections no Idle or Ready, please reSet connection count", ExceptionType.NOTNORMALCONNECT);
            }
            if (this.enableLowProfile) {
                this.connectionPool.returnObject((Object)rpcServiceClient);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            txResponse = enableSendRequestSync != false ? (ResultOuterClass.TxResponse)rpcServiceClient.getRpcNodeFutureStub().sendRequestSync(signedRequest).get(timeout, TimeUnit.MILLISECONDS) : (ResultOuterClass.TxResponse)rpcServiceClient.getRpcNodeFutureStub().sendRequest(signedRequest).get(timeout, TimeUnit.MILLISECONDS);
            if (!this.enableLowProfile) {
                this.connectionPool.returnObject((Object)rpcServiceClient);
            }
        }
        catch (TimeoutException e) {
            logger.error("connect timeout error  : ", (Throwable)e);
            this.invalidateObject(rpcServiceClient);
            throw new ChainClientException("connect timeout error : " + e.getMessage(), ExceptionType.TIMEOUT);
        }
        catch (InterruptedException e) {
            logger.error("connect interrupted, error : ", (Throwable)e);
            this.invalidateObject(rpcServiceClient);
            throw new ChainClientException("connect interrupted, error : " + e.getMessage(), ExceptionType.INTERRUPTED);
        }
        catch (ExecutionException e) {
            logger.error("connect execution error: ", (Throwable)e);
            this.invalidateObject(rpcServiceClient);
            throw new ChainClientException("connect execution error : " + e.getMessage(), ExceptionType.EXECUTION);
        }
        return txResponse;
    }

    public void invalidateObject(RpcServiceClient rpcServiceClient) throws ChainClientException {
        try {
            this.connectionPool.invalidateObject((Object)rpcServiceClient);
        }
        catch (Exception ex) {
            logger.error("invalidate object fail :", (Throwable)ex);
            throw new ChainClientException("invalidate object fail : " + ex.getMessage(), ExceptionType.INVALIDATECLIENT);
        }
    }

    public ChainmakerBlock.BlockInfo getArchivedBlockByTxId(String txId, boolean withRWSet, long timeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long blockHeight = this.getBlockHeightByTxId(txId, timeout);
        return this.getArchivedBlockByHeight(blockHeight, withRWSet);
    }

    public ChainmakerBlock.BlockInfo getArchivedBlockByHash(String blockHash, boolean withRWSet, long timeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long blockHeight = this.getBlockHeightByBlockHash(blockHash, timeout);
        return this.getArchivedBlockByHeight(blockHeight, withRWSet);
    }

    public ChainmakerTransaction.TransactionInfo getArchivedTxByTxId(String txId, long timeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long blockHeight = this.getBlockHeightByTxId(txId, timeout);
        ChainmakerBlock.BlockInfo blockInfo = this.getArchivedBlockByHeight(blockHeight, false);
        for (int i = 0; i < blockInfo.getBlock().getTxsList().size(); ++i) {
            ChainmakerTransaction.Transaction tx = blockInfo.getBlock().getTxs(i);
            if (!tx.getPayload().getTxId().equals(txId)) continue;
            return ChainmakerTransaction.TransactionInfo.newBuilder().setTransaction(tx).setBlockHeight(blockInfo.getBlock().getHeader().getBlockHeight()).setBlockHash(blockInfo.getBlock().getHeader().getBlockHash()).setTxIndex(i).build();
        }
        return null;
    }

    public void archiveBlocks(long archiveHeight, Notice notice, long rpcCallTimeout) throws ChainClientException {
        try {
            Archivecenter.ArchiveStatusResp archiveStatusResp;
            long endHeight;
            Store.ArchiveStatus archiveStatus = this.getArchiveStatus(rpcCallTimeout);
            if (archiveStatus.getProcess() != Store.ArchiveProcess.Normal) {
                throw new ChainClientException("peer archive is in process");
            }
            long beginHeight = 0L;
            if (archiveStatus.getArchivePivot() > beginHeight) {
                beginHeight = archiveStatus.getArchivePivot();
            }
            if ((endHeight = archiveHeight) > archiveStatus.getMaxAllowArchiveHeight()) {
                endHeight = archiveStatus.getMaxAllowArchiveHeight();
            }
            if ((archiveStatusResp = this.getArchiveService().getArchivedStatus(rpcCallTimeout)).getMessage().contains("chain genesis not exists")) {
                ChainmakerBlock.BlockInfo block = this.getBlockByHeight(0L, true, rpcCallTimeout);
                this.getArchiveService().register(block, rpcCallTimeout);
            }
            if (archiveStatusResp.getInArchive()) {
                throw new ChainClientException("archive service is in process");
            }
            if (beginHeight > archiveStatusResp.getArchivedHeight()) {
                throw new ChainClientException("peer archive begin height: " + beginHeight + ", archive service height: " + archiveStatusResp.getArchivedHeight() + ", not match");
            }
            beginHeight = archiveStatusResp.getArchivedHeight();
            Blocks blockIterator = new Blocks(beginHeight, endHeight, endHeight - beginHeight, notice, this);
            this.getArchiveService().archiveBlocks(blockIterator, notice);
        }
        catch (Exception e) {
            logger.error("archive store fail:{}", (Object)e.getMessage());
            throw new ChainClientException("archive store fail:" + e.getMessage());
        }
    }

    public void restoreBlocks(long restoreHeight, Notice notice, long rpcCallTimeout) throws ChainClientException {
        try {
            Store.ArchiveStatus archiveStatus = this.getArchiveStatus(rpcCallTimeout);
            if (archiveStatus.getProcess() != Store.ArchiveProcess.Normal) {
                throw new ChainClientException("chain is restoreing or archiveing, retry later !GetArchiveStatus got archiveProcess" + (Object)((Object)archiveStatus.getProcess()));
            }
            if (restoreHeight > archiveStatus.getArchivePivot()) {
                throw new ChainClientException("no block needs restore");
            }
            long beginHeight = archiveStatus.getArchivePivot();
            long endHeight = restoreHeight;
            for (long i = beginHeight; i >= endHeight; --i) {
                notice.heightNotice(new ProcessMessage(i, endHeight - beginHeight + 1L));
                if (this.isHeightInRestoreRange(beginHeight, archiveStatus.getFileRangesList())) continue;
                ChainmakerBlock.BlockInfo blockInfo = this.getArchiveService().getBlockByHeight(i, true, rpcCallTimeout);
                ArrayList<ChainmakerBlock.BlockInfo> blockInfos = new ArrayList<ChainmakerBlock.BlockInfo>();
                blockInfos.add(blockInfo);
                this.sendRestoreBlockReq(blockInfos, rpcCallTimeout);
                if (i != 0L) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new ChainClientException(e.getMessage());
        }
    }

    private boolean isHeightInRestoreRange(long height, List<Store.FileRange> fileRanges) {
        for (Store.FileRange fileRange : fileRanges) {
            if (height < fileRange.getStart() || height > fileRange.getEnd()) continue;
            return true;
        }
        return false;
    }

    private void sendRestoreBlockReq(List<ChainmakerBlock.BlockInfo> blockInfos, long rpcCallTimeout) throws ChainClientException {
        byte[][] fullBlocks = new byte[blockInfos.size()][];
        for (int i = 0; i < blockInfos.size(); ++i) {
            fullBlocks[i] = blockInfos.get(i).toByteArray();
        }
        try {
            Request.Payload payload = this.createRestoreBlocksPayload(fullBlocks);
            ResultOuterClass.TxResponse response = this.sendContractRequest(payload, null, rpcCallTimeout, 0L);
            if (response.getCode() == ResultOuterClass.TxStatusCode.SUCCESS) {
                return;
            }
        }
        catch (Exception e) {
            throw new ChainClientException("SendRestoreBlockRequest get error :" + e.getMessage());
        }
        throw new ChainClientException("SendRestoreBlockRequest fail");
    }

    private long getBlockHeight(String txId, String blockHash, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        String method = "";
        if (txId != null && !txId.equals("")) {
            method = ChainQuery.ChainQueryFunction.GET_BLOCK_HEIGHT_BY_TX_ID.toString();
            params.put(TX_ID, txId.getBytes());
        } else if (blockHash != null && !blockHash.equals("")) {
            method = ChainQuery.ChainQueryFunction.GET_BLOCK_HEIGHT_BY_HASH.toString();
            params.put(BLOCK_HASH, blockHash.getBytes());
        }
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), method, params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        return Integer.parseInt(txResponse.getContractResult().getResult().toStringUtf8());
    }

    private Request.Payload createContractManagePayload(String contractName, String method) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(ContractManage.GetContractInfo.Parameter.CONTRACT_NAME.toString(), contractName.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CONTRACT_MANAGE.toString(), method, params, 0L);
    }

    private Request.Payload createContractManageWithByteCodePayload(String contractName, String method, String version, byte[] byteCode, ContractOuterClass.RuntimeType runtime, Map<String, byte[]> params) throws ChainMakerCryptoSuiteException {
        Request.Payload payload = this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CONTRACT_MANAGE.toString(), method, params, 0L);
        Request.Payload.Builder payloadBuilder = payload.toBuilder();
        payloadBuilder.addParameters(Request.KeyValuePair.newBuilder().setKey(ContractManage.InitContract.Parameter.CONTRACT_NAME.toString()).setValue(ByteString.copyFromUtf8((String)contractName)));
        payloadBuilder.addParameters(Request.KeyValuePair.newBuilder().setKey(ContractManage.InitContract.Parameter.CONTRACT_VERSION.toString()).setValue(ByteString.copyFromUtf8((String)version)));
        payloadBuilder.addParameters(Request.KeyValuePair.newBuilder().setKey(ContractManage.InitContract.Parameter.CONTRACT_RUNTIME_TYPE.toString()).setValue(ByteString.copyFromUtf8((String)runtime.toString())));
        if (runtime == ContractOuterClass.RuntimeType.EVM) {
            byteCode = Hex.decode((String)new String(byteCode));
        }
        payloadBuilder.addParameters(Request.KeyValuePair.newBuilder().setKey(ContractManage.InitContract.Parameter.CONTRACT_BYTECODE.toString()).setValue(ByteString.copyFrom((byte[])byteCode)));
        return payloadBuilder.build();
    }

    private Request.Payload createNativeContractAccessPayload(String method, String[] accessContractList) throws ChainMakerCryptoSuiteException {
        String jsonString = JSON.toJSONString((Object)accessContractList);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(ContractManage.ContractAccess.Parameter.NATIVE_CONTRACT_NAME.toString(), jsonString.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CONTRACT_MANAGE.toString(), method, params, 0L);
    }

    private Request.Payload createRestoreBlocksPayload(byte[][] fullBlocks) throws ChainMakerCryptoSuiteException {
        ArrayList<Request.KeyValuePair> keyValuePairs = new ArrayList<Request.KeyValuePair>();
        for (byte[] fullBlock : fullBlocks) {
            Request.KeyValuePair keyValuePair = Request.KeyValuePair.newBuilder().setKey(Archive.RestoreBlock.Parameter.FULL_BLOCK.toString()).setValue(ByteString.copyFrom((byte[])fullBlock)).build();
            keyValuePairs.add(keyValuePair);
        }
        String txId = Utils.generateTxId();
        Request.TxType txType = Request.TxType.ARCHIVE;
        Request.Payload.Builder payloadBuilder = Request.Payload.newBuilder().setChainId(this.chainId).setTxType(txType).setTxId(txId).addAllParameters(keyValuePairs).setTimestamp(Utils.getCurrentTimeSeconds()).setContractName(SystemContractOuterClass.SystemContract.ARCHIVE_MANAGE.toString()).setMethod(Archive.ArchiveFunction.RESTORE_BLOCK.toString()).setSequence(0L);
        return payloadBuilder.build();
    }

    public Request.Payload createPayload(String txId, Request.TxType txType, String contractName, String method, Map<String, byte[]> params, long seq) {
        if (txId == null || txId.equals("")) {
            txId = Utils.generateTxId();
        }
        Request.Payload.Builder payloadBuilder = Request.Payload.newBuilder().setChainId(this.chainId).setTxType(txType).setTxId(txId).setTimestamp(Utils.getCurrentTimeSeconds()).setContractName(contractName).setMethod(method).setSequence(seq);
        if (params != null && !params.isEmpty()) {
            params.forEach((key, value) -> payloadBuilder.addParameters(Request.KeyValuePair.newBuilder().setKey((String)key).setValue(ByteString.copyFrom((byte[])value)).build()));
        }
        return payloadBuilder.build();
    }

    private Request.Payload createPayload(String txId, Request.TxType txType, String contractName, String method, Map<String, byte[]> params, long seq, Request.Limit limit) throws ChainMakerCryptoSuiteException {
        if (txId == null || txId.equals("")) {
            txId = Utils.generateTxId();
        }
        Request.Payload.Builder payloadBuilder = Request.Payload.newBuilder().setChainId(this.chainId).setTxType(txType).setTxId(txId).setTimestamp(Utils.getCurrentTimeSeconds()).setContractName(contractName).setMethod(method).setSequence(seq).setLimit(limit);
        if (params != null && !params.isEmpty()) {
            params.forEach((key, value) -> payloadBuilder.addParameters(Request.KeyValuePair.newBuilder().setKey((String)key).setValue(ByteString.copyFrom((byte[])value)).build()));
        }
        return payloadBuilder.build();
    }

    private ResultOuterClass.TxResponse proposalRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        return this.sendRequest(payload, endorsementEntries, rpcCallTimeout);
    }

    private ResultOuterClass.TxResponse proposalRequestWithTimeoutAndPayer(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, Request.EndorsementEntry payer, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        return this.sendTxRequest(this.createTxRequestWithPayer(payload, endorsementEntries, payer), rpcCallTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultOuterClass.TxResponse sendContractRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        ResultOuterClass.TxResponse.Builder responseInfoBuilder = ResultOuterClass.TxResponse.newBuilder();
        try {
            if (!this.enableSendRequestSync && syncResultTimeout > 0L && this.clientUser.getEnableTxResultDispatcher().booleanValue()) {
                this.dispatcher.register(payload.getTxId());
            }
            ResultOuterClass.TxResponse responseInfo = this.sendRequestWithSync(payload, endorsementEntries, rpcCallTimeout, this.enableSendRequestSync);
            responseInfoBuilder = responseInfo.toBuilder();
            if (responseInfo.getCode() == ResultOuterClass.TxStatusCode.SUCCESS && syncResultTimeout > 0L && !this.enableSendRequestSync) {
                ChainmakerTransaction.Transaction transaction;
                if (this.clientUser.getEnableTxResultDispatcher().booleanValue()) {
                    transaction = this.getResultSync(responseInfo.getTxId(), syncResultTimeout);
                    if (transaction == null) {
                        throw new ChainClientException(String.format("get tx by txId %s failed", responseInfo.getTxId()));
                    }
                } else {
                    ChainmakerTransaction.TransactionInfo transactionInfo = this.loopQueryResultByTxId(responseInfo.getTxId(), syncResultTimeout);
                    if (transactionInfo == null || transactionInfo.getTransaction() == null || transactionInfo.getTransaction().getResult() == null) {
                        throw new ChainClientException(String.format("get tx by txId %s failed", responseInfo.getTxId()));
                    }
                    transaction = transactionInfo.getTransaction();
                }
                responseInfoBuilder.setContractResult(transaction.getResult().getContractResult().toBuilder()).build();
            }
        }
        finally {
            if (!this.enableSendRequestSync && syncResultTimeout > 0L && this.clientUser.getEnableTxResultDispatcher().booleanValue()) {
                this.dispatcher.unregister(payload.getTxId());
            }
        }
        return responseInfoBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultOuterClass.TxResponse sendContractRequestWithPayer(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, Request.EndorsementEntry payer, long rpcCallTimeout, long syncResultTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        ResultOuterClass.TxResponse.Builder responseInfoBuilder = ResultOuterClass.TxResponse.newBuilder();
        try {
            if (!this.enableSendRequestSync && syncResultTimeout > 0L && this.clientUser.getEnableTxResultDispatcher().booleanValue()) {
                this.dispatcher.register(payload.getTxId());
            }
            ResultOuterClass.TxResponse responseInfo = this.sendRequestSyncWithPayerAndSync(payload, endorsementEntries, payer, rpcCallTimeout, this.enableSendRequestSync);
            responseInfoBuilder = responseInfo.toBuilder();
            if (responseInfo.getCode() == ResultOuterClass.TxStatusCode.SUCCESS && syncResultTimeout > 0L && !this.enableSendRequestSync) {
                ChainmakerTransaction.Transaction transaction;
                if (this.clientUser.getEnableTxResultDispatcher().booleanValue()) {
                    transaction = this.getResultSync(responseInfo.getTxId(), syncResultTimeout);
                    if (transaction == null) {
                        throw new ChainClientException(String.format("get tx by txId %s failed", responseInfo.getTxId()));
                    }
                } else {
                    ChainmakerTransaction.TransactionInfo transactionInfo = this.loopQueryResultByTxId(responseInfo.getTxId(), syncResultTimeout);
                    if (transactionInfo == null || transactionInfo.getTransaction() == null || transactionInfo.getTransaction().getResult() == null) {
                        throw new ChainClientException(String.format("get tx by txId %s failed", responseInfo.getTxId()));
                    }
                    transaction = transactionInfo.getTransaction();
                }
                responseInfoBuilder.setContractResult(transaction.getResult().getContractResult().toBuilder()).build();
            }
        }
        finally {
            if (!this.enableSendRequestSync && syncResultTimeout > 0L && this.clientUser.getEnableTxResultDispatcher().booleanValue()) {
                this.dispatcher.unregister(payload.getTxId());
            }
        }
        return responseInfoBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultOuterClass.TxResponse sendContractRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout, User user) throws ChainClientException, ChainMakerCryptoSuiteException {
        ResultOuterClass.TxResponse.Builder responseInfoBuilder = ResultOuterClass.TxResponse.newBuilder();
        try {
            if (!this.enableSendRequestSync && syncResultTimeout > 0L && this.clientUser.getEnableTxResultDispatcher().booleanValue()) {
                this.dispatcher.register(payload.getTxId());
            }
            ResultOuterClass.TxResponse responseInfo = this.sendRequestWithSync(payload, endorsementEntries, rpcCallTimeout, user, this.enableSendRequestSync);
            responseInfoBuilder = responseInfo.toBuilder();
            if (responseInfo.getCode() == ResultOuterClass.TxStatusCode.SUCCESS && syncResultTimeout > 0L && !this.enableSendRequestSync) {
                ChainmakerTransaction.Transaction transaction;
                if (this.clientUser.getEnableTxResultDispatcher().booleanValue()) {
                    transaction = this.getResultSync(responseInfo.getTxId(), syncResultTimeout);
                    if (transaction == null) {
                        throw new ChainClientException(String.format("get tx by txId %s failed", responseInfo.getTxId()));
                    }
                } else {
                    ChainmakerTransaction.TransactionInfo transactionInfo = this.loopQueryResultByTxId(responseInfo.getTxId(), syncResultTimeout);
                    if (transactionInfo == null || transactionInfo.getTransaction() == null || transactionInfo.getTransaction().getResult() == null) {
                        throw new ChainClientException(String.format("get tx by txId %s failed", responseInfo.getTxId()));
                    }
                    transaction = transactionInfo.getTransaction();
                }
                responseInfoBuilder.setContractResult(transaction.getResult().getContractResult().toBuilder()).build();
            }
        }
        finally {
            if (!this.enableSendRequestSync && syncResultTimeout > 0L && this.clientUser.getEnableTxResultDispatcher().booleanValue()) {
                this.dispatcher.unregister(payload.getTxId());
            }
        }
        return responseInfoBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultOuterClass.TxResponse sendRequest(Request.TxRequest request, long rpcCallTimeout, long syncResultTimeout, User user) throws ChainClientException, ChainMakerCryptoSuiteException {
        ResultOuterClass.TxResponse.Builder responseInfoBuilder = ResultOuterClass.TxResponse.newBuilder();
        try {
            if (!this.enableSendRequestSync && syncResultTimeout > 0L && this.clientUser.getEnableTxResultDispatcher().booleanValue()) {
                this.dispatcher.register(request.getPayload().getTxId());
            }
            ResultOuterClass.TxResponse responseInfo = this.sendTxRequestWithSync(request, rpcCallTimeout, this.enableSendRequestSync);
            responseInfoBuilder = responseInfo.toBuilder();
            if (responseInfo.getCode() == ResultOuterClass.TxStatusCode.SUCCESS && syncResultTimeout > 0L && !this.enableSendRequestSync) {
                ChainmakerTransaction.Transaction transaction;
                if (this.clientUser.getEnableTxResultDispatcher().booleanValue()) {
                    transaction = this.getResultSync(responseInfo.getTxId(), syncResultTimeout);
                    if (transaction == null) {
                        throw new ChainClientException(String.format("get tx by txId %s failed", responseInfo.getTxId()));
                    }
                } else {
                    ChainmakerTransaction.TransactionInfo transactionInfo = this.loopQueryResultByTxId(responseInfo.getTxId(), syncResultTimeout);
                    if (transactionInfo == null || transactionInfo.getTransaction() == null || transactionInfo.getTransaction().getResult() == null) {
                        throw new ChainClientException(String.format("get tx by txId %s failed", responseInfo.getTxId()));
                    }
                    transaction = transactionInfo.getTransaction();
                }
                responseInfoBuilder.setContractResult(transaction.getResult().getContractResult().toBuilder()).build();
            }
        }
        finally {
            if (!this.enableSendRequestSync && syncResultTimeout > 0L && this.clientUser.getEnableTxResultDispatcher().booleanValue()) {
                this.dispatcher.unregister(request.getPayload().getTxId());
            }
        }
        return responseInfoBuilder.build();
    }

    public ResultOuterClass.TxResponse sendRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendRequestWithSync(payload, endorsementEntries, rpcCallTimeout, false);
    }

    public ResultOuterClass.TxResponse sendRequestWithSync(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, Boolean enableSendRequestSync) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendTxRequestWithSync(this.createTxRequest(payload, endorsementEntries), rpcCallTimeout, enableSendRequestSync);
    }

    public ResultOuterClass.TxResponse sendRequestWithPayer(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, Request.EndorsementEntry payer, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendRequestSyncWithPayerAndSync(payload, endorsementEntries, payer, rpcCallTimeout, false);
    }

    public ResultOuterClass.TxResponse sendRequestSyncWithPayerAndSync(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, Request.EndorsementEntry payer, long rpcCallTimeout, Boolean enableSendRequestSync) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendTxRequestWithSync(this.createTxRequestWithPayer(payload, endorsementEntries, payer), rpcCallTimeout, enableSendRequestSync);
    }

    public ResultOuterClass.TxResponse sendRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, User user) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendRequestWithSync(payload, endorsementEntries, rpcCallTimeout, user, false);
    }

    public ResultOuterClass.TxResponse sendRequestWithSync(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, User user, Boolean enableSendRequestSync) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendTxRequestWithSync(this.createTxRequest(payload, endorsementEntries, user), rpcCallTimeout, enableSendRequestSync);
    }

    private ChainmakerTransaction.Transaction getResultSync(String txId, long timeout) throws ChainClientException {
        ChainmakerTransaction.Transaction transaction = this.dispatcher.getResult(txId, timeout);
        return transaction;
    }

    private ChainmakerTransaction.TransactionInfo loopQueryResultByTxId(String txId, long timeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long tryCount;
        int interval = this.getRetryInterval();
        long l = tryCount = timeout % (long)interval == 0L ? timeout / (long)interval : timeout / (long)interval + 1L;
        if (tryCount == 0L) {
            ++tryCount;
        }
        for (long i = 0L; i < tryCount; ++i) {
            ChainmakerTransaction.TransactionInfo transactionInfo = this.getTxByTxId(txId, timeout);
            if (transactionInfo == null || !transactionInfo.hasTransaction()) {
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException e) {
                    logger.error("Thread sleep error : ", (Throwable)e);
                }
                continue;
            }
            return transactionInfo;
        }
        return null;
    }

    public void subscribe(Request.Payload payload, StreamObserver<ResultOuterClass.SubscribeResult> txStreamObserver) throws ChainClientException {
        RpcServiceClient rpcServiceClient = null;
        try {
            rpcServiceClient = (RpcServiceClient)this.connectionPool.borrowObject();
            if (rpcServiceClient == null) {
                logger.error("all connections no Idle or Ready");
                throw new ChainClientException("all connections no Idle or Ready, please reSet connection count", ExceptionType.NOTNORMALCONNECT);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            rpcServiceClient.getRpcNodeStub().subscribe(this.createTxRequest(payload, null), txStreamObserver);
            this.connectionPool.returnObject((Object)rpcServiceClient);
        }
        catch (Exception e) {
            logger.error("subscribeTx to peer error : ", (Throwable)e);
            try {
                this.connectionPool.invalidateObject((Object)rpcServiceClient);
            }
            catch (Exception ex) {
                logger.error("invalidate object fail :", (Throwable)ex);
                throw new ChainClientException("invalidate object fail : " + ex.getMessage());
            }
            throw new ChainClientException("subscribeTx to peer error : " + e.getMessage());
        }
    }

    public Store.BlockWithRWSet getFromArchiveStore(long blockHeight) throws ChainClientException {
        if (this.archiveConfig.getType().equals("mysql")) {
            return this.getArchivedBlockFromMySQL(blockHeight);
        }
        return null;
    }

    public Store.BlockWithRWSet getArchivedBlockFromMySQL(long blockHeight) throws ChainClientException {
        Store.BlockWithRWSet blockWithRWSet;
        String archiveDest = this.archiveConfig.getDest();
        String[] destList = archiveDest.split(":");
        String user = destList[0];
        String pwd = destList[1];
        String host = destList[2];
        String port = destList[3];
        try {
            Class.forName(DRIVER_NAME);
        }
        catch (ClassNotFoundException e) {
            logger.error("com.mysql.cj.jdbc.Driver class not found : ", (Throwable)e);
            throw new ChainClientException("class not found : " + e.getMessage());
        }
        String url = String.format("jdbc:mysql://%s:%s/%s_%s?serverTimezone=GMT", host, port, MYSQL_DBNAME_PREFIX, this.chainId);
        byte[] blockWithRWSetBytes = null;
        String hmac = "";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = DriverManager.getConnection(url, user, pwd);
            statement = connection.createStatement();
            String sql = String.format("SELECT Fblock_with_rwset, Fhmac from %s_%d WHERE Fblock_height = %d", MYSQL_TABLENAME_PREFIX, blockHeight / 100000L + 1L, blockHeight);
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                ResultSetMetaData metaData = resultSet.getMetaData();
                for (int i = 1; i < metaData.getColumnCount() + 1; ++i) {
                    if (metaData.getColumnName(i).equals("Fblock_with_rwset")) {
                        blockWithRWSetBytes = (byte[])resultSet.getObject(i);
                    }
                    if (!metaData.getColumnName(i).equals("Fhmac")) continue;
                    hmac = (String)resultSet.getObject(i);
                }
            }
        }
        catch (SQLException e) {
            logger.error("sql err : ", (Throwable)e);
            throw new ChainClientException("sql err : " + e.getMessage());
        }
        try {
            connection.close();
            statement.close();
        }
        catch (SQLException e) {
            logger.error("sql err : ", (Throwable)e);
            throw new ChainClientException("sql err : " + e.getMessage());
        }
        try {
            blockWithRWSet = Store.BlockWithRWSet.parseFrom(blockWithRWSetBytes);
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockWithRWSet parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockWithRWSet parseFrom result : " + e.getMessage());
        }
        return blockWithRWSet;
    }

    public Store.ArchiveStatus getArchiveStatus(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Store.ArchiveStatus archiveStatus;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_ARCHIVE_STATUS.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        try {
            archiveStatus = Store.ArchiveStatus.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("archiveStatus parseFrom result : ", (Throwable)e);
            throw new ChainClientException("archiveStatus parseFrom result : " + e.getMessage());
        }
        return archiveStatus;
    }

    public void checkProposalRequestResp(ResultOuterClass.TxResponse resp, boolean needContractResult) throws ChainClientException {
        if (resp.getCode() != ResultOuterClass.TxStatusCode.SUCCESS) {
            throw new ChainClientException(resp.getMessage());
        }
        if (needContractResult && resp.getContractResult() == null) {
            throw new ChainClientException("contract result is nulll");
        }
        if (resp.getContractResult() != null && resp.getContractResult().getCode() != 0) {
            throw new ChainClientException(resp.getContractResult().getMessage());
        }
    }

    public void addNode(NodeConfig nodeConfig) throws ChainClientException {
        try {
            Node node = this.getNodeByNodeConfig(nodeConfig);
            GrpcClientFactory grpcClientFactory = (GrpcClientFactory)this.getConnectionPool().getFactory();
            grpcClientFactory.addNode(node);
        }
        catch (Exception e) {
            logger.error("add node err:{}", (Object)e.getMessage());
            throw new ChainClientException("add node err : " + e.getMessage());
        }
    }

    public void delNode(NodeConfig nodeConfig) throws ChainClientException {
        try {
            Node node = this.getNodeByNodeConfig(nodeConfig);
            GrpcClientFactory grpcClientFactory = (GrpcClientFactory)this.getConnectionPool().getFactory();
            grpcClientFactory.delNode(node);
        }
        catch (Exception e) {
            logger.error("del node err:{}", (Object)e.getMessage());
            throw new ChainClientException("del node err : " + e.getMessage());
        }
    }

    private Node getNodeByNodeConfig(NodeConfig nodeConfig) throws UtilsException {
        ArrayList<byte[]> tlsCaCertList = new ArrayList<byte[]>();
        if (nodeConfig.getTrustRootBytes() == null && nodeConfig.getTrustRootPaths() != null) {
            for (String rootPath : nodeConfig.getTrustRootPaths()) {
                List<String> filePathList = FileUtils.getFilesByPath(rootPath);
                for (String filePath : filePathList) {
                    tlsCaCertList.add(FileUtils.getFileOrResourceFileBytes(filePath));
                }
            }
            byte[][] tlsCaCerts = new byte[tlsCaCertList.size()][];
            tlsCaCertList.toArray((T[])tlsCaCerts);
            nodeConfig.setTrustRootBytes(tlsCaCerts);
        }
        String url = nodeConfig.isEnableTls() ? "grpcs://" + nodeConfig.getNodeAddr() : "grpc://" + nodeConfig.getNodeAddr();
        Node node = new Node();
        node.setTlsCertBytes(nodeConfig.getTrustRootBytes());
        node.setHostname(nodeConfig.getTlsHostName());
        node.setGrpcUrl(url);
        node.setSslProvider(ChainManager.OPENSSL_PROVIDER);
        node.setNegotiationType(ChainManager.TLS_NEGOTIATION);
        return node;
    }

    public Sync.SyncState getSyncState(boolean withOthersState, long rpcCallTimeout) throws ChainClientException {
        RpcServiceClient rpcServiceClient = null;
        try {
            rpcServiceClient = (RpcServiceClient)this.connectionPool.borrowObject();
            if (rpcServiceClient == null) {
                logger.error("all connections no Idle or Ready");
                throw new ChainClientException("all connections no Idle or Ready, please reSet connection count", ExceptionType.NOTNORMALCONNECT);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Sync.SyncState state = null;
        try {
            Sync.GetSyncStateRequest req = Sync.GetSyncStateRequest.newBuilder().setChainId(this.chainId).setWithPeers(withOthersState).build();
            state = (Sync.SyncState)rpcServiceClient.getRpcNodeFutureStub().getSyncState(req).get(rpcCallTimeout, TimeUnit.MILLISECONDS);
            this.connectionPool.returnObject((Object)rpcServiceClient);
        }
        catch (Exception e) {
            logger.error("getSyncState error: {}", (Object)e.getMessage());
            try {
                this.connectionPool.invalidateObject((Object)rpcServiceClient);
            }
            catch (Exception ex) {
                logger.error("invalidate object fail :", (Throwable)ex);
                throw new ChainClientException("invalidate object fail : " + ex.getMessage());
            }
            throw new ChainClientException("getSyncState error : " + e.getMessage());
        }
        return state;
    }
}

