/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.chainmaker.sdk.ChainClient;
import org.chainmaker.sdk.ChainClientException;
import org.chainmaker.sdk.GrpcClientFactory;
import org.chainmaker.sdk.Node;
import org.chainmaker.sdk.RpcServiceClient;
import org.chainmaker.sdk.RpcServiceClientException;
import org.chainmaker.sdk.User;
import org.chainmaker.sdk.config.ArchiveCenterConfig;
import org.chainmaker.sdk.config.ArchiveConfig;
import org.chainmaker.sdk.config.AuthType;
import org.chainmaker.sdk.config.ChainClientConfig;
import org.chainmaker.sdk.config.ConnPoolConfig;
import org.chainmaker.sdk.config.CryptoConfig;
import org.chainmaker.sdk.config.NodeConfig;
import org.chainmaker.sdk.config.Pkcs11Config;
import org.chainmaker.sdk.config.SdkConfig;
import org.chainmaker.sdk.crypto.ChainMakerCryptoSuiteException;
import org.chainmaker.sdk.sync.TxResultDispatcher;
import org.chainmaker.sdk.utils.FileUtils;
import org.chainmaker.sdk.utils.UtilsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainManager {
    private static final Logger logger = LoggerFactory.getLogger(ChainManager.class);
    static String OPENSSL_PROVIDER = "openSSL";
    static String TLS_NEGOTIATION = "TLS";
    private Map<String, ChainClient> chains = new HashMap<String, ChainClient>();
    private static ChainManager chainManager = new ChainManager();

    private ChainManager() {
    }

    public static ChainManager getInstance() {
        return chainManager;
    }

    public ChainClient getChainClient(String chainId) {
        return this.chains.get(chainId);
    }

    public synchronized ChainClient createChainClient(SdkConfig sdkConfig) throws ChainClientException, RpcServiceClientException, UtilsException, ChainMakerCryptoSuiteException {
        User clientUser;
        boolean pkcs11Enabled;
        this.checkConfig(sdkConfig.getChainClient());
        String chainId = sdkConfig.getChainClient().getChainId();
        ChainClientConfig chainClientConfig = sdkConfig.getChainClient();
        this.dealChainClientConfig(chainClientConfig);
        if (chainClientConfig.getAuthType().equals(AuthType.PermissionedWithKey.getMsg()) || chainClientConfig.getAuthType().equals(AuthType.Public.getMsg())) {
            if (chainClientConfig.getPkcs11() == null) {
                chainClientConfig.setPkcs11(new Pkcs11Config(false));
            }
            pkcs11Enabled = chainClientConfig.getPkcs11().isEnabled();
            clientUser = new User(sdkConfig.getChainClient().getOrgId(), chainClientConfig.getUserSignKeyBytes(), chainClientConfig.getUserSignCrtBytes(), chainClientConfig.getUserKeyBytes(), chainClientConfig.getUserCrtBytes(), chainClientConfig.getUserEncKeyBytes(), chainClientConfig.getUserEncCrtBytes(), chainClientConfig.getCrypto(), pkcs11Enabled);
        } else {
            if (chainClientConfig.getPkcs11() == null) {
                chainClientConfig.setPkcs11(new Pkcs11Config(false));
            }
            pkcs11Enabled = chainClientConfig.getPkcs11().isEnabled();
            clientUser = new User(sdkConfig.getChainClient().getOrgId(), chainClientConfig.getUserSignKeyBytes(), chainClientConfig.getUserSignCrtBytes(), chainClientConfig.getUserKeyBytes(), chainClientConfig.getUserCrtBytes(), chainClientConfig.getUserEncKeyBytes(), chainClientConfig.getUserEncCrtBytes(), pkcs11Enabled);
            if (sdkConfig.getChainClient().getAlias() != null && sdkConfig.getChainClient().getAlias().length() > 0) {
                clientUser.setAlias(sdkConfig.getChainClient().getAlias());
            }
        }
        clientUser.setAuthType(chainClientConfig.getAuthType());
        clientUser.setEnableTxResultDispatcher(chainClientConfig.getEnableTxResultDispatcher());
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (NodeConfig nodeConfig : sdkConfig.getChainClient().getNodes()) {
            ArrayList<byte[]> tlsCaCertList = new ArrayList<byte[]>();
            if (nodeConfig.getTrustRootBytes() == null && nodeConfig.getTrustRootPaths() != null) {
                for (String rootPath : nodeConfig.getTrustRootPaths()) {
                    List<String> filePathList = FileUtils.getFilesByPath(rootPath);
                    for (String filePath : filePathList) {
                        tlsCaCertList.add(FileUtils.getFileOrResourceFileBytes(filePath));
                    }
                }
                byte[][] tlsCaCerts = new byte[tlsCaCertList.size()][];
                tlsCaCertList.toArray((T[])tlsCaCerts);
                nodeConfig.setTrustRootBytes(tlsCaCerts);
            }
            String url = nodeConfig.isEnableTls() ? "grpcs://" + nodeConfig.getNodeAddr() : "grpc://" + nodeConfig.getNodeAddr();
            Node node = new Node();
            node.setTlsCertBytes(nodeConfig.getTrustRootBytes());
            if (nodeConfig.getChain_tls_host_name() != null && !nodeConfig.getChain_tls_host_name().isEmpty()) {
                node.setChainHostname(nodeConfig.getChainTtlsHostName());
            }
            node.setHostname(nodeConfig.getTlsHostName());
            node.setGrpcUrl(url);
            node.setSslProvider(OPENSSL_PROVIDER);
            node.setNegotiationType(TLS_NEGOTIATION);
            nodeList.add(node);
        }
        Node[] nodes = new Node[nodeList.size()];
        nodeList.toArray(nodes);
        if (chainClientConfig.getConnPool() == null) {
            chainClientConfig.setConnPool(new ConnPoolConfig());
        }
        if (chainClientConfig.getArchiveCenterQueryFirst() == null) {
            chainClientConfig.setArchiveCenterQueryFirst(false);
        }
        if (chainClientConfig.getEnableSendRequestSync() == null) {
            chainClientConfig.setEnableSendRequestSync(false);
        }
        return this.createChainClient(chainId, clientUser, nodes, chainClientConfig.getRpcClient().getMaxReceiveMessageSize(), chainClientConfig.getRetryInterval(), chainClientConfig.getRetryLimit(), chainClientConfig.getArchive(), chainClientConfig.getConnPool(), chainClientConfig.getArchiveCenterConfig(), chainClientConfig.getArchiveCenterQueryFirst(), chainClientConfig.getEnableSendRequestSync(), chainClientConfig.getCrypto(), chainClientConfig.getRpcClient().getProxyAddr());
    }

    private ChainClient createChainClient(String chainId, User clientUser, Node[] nodes, int messageSize, int retryInterval, int retryLimit, ArchiveConfig archiveConfig, ConnPoolConfig connPoolConfig, ArchiveCenterConfig archiveCenterConfig, Boolean archiveCenterQueryFirst, Boolean enableSendRequestSync, CryptoConfig cryptoConfig, String proxyUrl) throws RpcServiceClientException, UtilsException, ChainClientException {
        ChainClient chainClient = this.chains.get(chainId);
        if (chainClient != null) {
            return chainClient;
        }
        GrpcClientFactory grpcClientFactory = new GrpcClientFactory(nodes, clientUser, messageSize);
        grpcClientFactory.setProxyUrl(proxyUrl);
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(connPoolConfig.getMaxTotal().intValue());
        poolConfig.setMinIdle(connPoolConfig.getMinIdle().intValue());
        poolConfig.setMaxIdle(connPoolConfig.getMaxIdle().intValue());
        poolConfig.setTestWhileIdle(true);
        poolConfig.setBlockWhenExhausted(connPoolConfig.isBlockWhenExhausted());
        poolConfig.setMaxWait(Duration.ofMillis(connPoolConfig.getMaxWaitMillis().intValue()));
        if (connPoolConfig.getMinEvictableIdleTime() != null) {
            poolConfig.setMinEvictableIdleTime(Duration.ofMillis(connPoolConfig.getMinEvictableIdleTime().intValue()));
        }
        if (connPoolConfig.getSoftMinEvictableIdleTime() != null) {
            poolConfig.setSoftMinEvictableIdleTime(Duration.ofMillis(connPoolConfig.getSoftMinEvictableIdleTime().intValue()));
        }
        if (connPoolConfig.getTimeBetweenEvictionRuns() != null) {
            poolConfig.setTimeBetweenEvictionRuns(Duration.ofMillis(connPoolConfig.getTimeBetweenEvictionRuns().intValue()));
        }
        poolConfig.setLifo(false);
        GenericObjectPool connPool = new GenericObjectPool((PooledObjectFactory)grpcClientFactory, poolConfig);
        for (int i = 0; i < poolConfig.getMinIdle(); ++i) {
            try {
                connPool.addObject();
                continue;
            }
            catch (Exception e) {
                logger.warn("create connpool object fail:%v", (Throwable)e);
            }
        }
        grpcClientFactory.setPool((GenericObjectPool<RpcServiceClient>)connPool);
        chainClient = new ChainClient();
        chainClient.setChainId(chainId);
        chainClient.setRetryInterval(retryInterval);
        chainClient.setRetryLimit(retryLimit);
        chainClient.setClientUser(clientUser);
        chainClient.setConnectionPool((GenericObjectPool<RpcServiceClient>)connPool);
        chainClient.setArchiveConfig(archiveConfig);
        chainClient.setArchiveCenterQueryFirst(archiveCenterQueryFirst);
        chainClient.setEnableSendRequestSync(enableSendRequestSync);
        chainClient.setEnableLowProfile(connPoolConfig.getEnableLowProfile());
        chainClient.setProxyUrl(proxyUrl);
        if (cryptoConfig != null && !Objects.equals(cryptoConfig.getHash(), "")) {
            chainClient.setHash(cryptoConfig.getHash());
        }
        if (retryInterval == 0) {
            chainClient.setRetryInterval(200);
        }
        if (retryLimit == 0) {
            chainClient.setRetryInterval(50);
        }
        if (clientUser.getEnableTxResultDispatcher() == null) {
            clientUser.setEnableTxResultDispatcher(false);
        }
        if (clientUser.getEnableTxResultDispatcher().booleanValue()) {
            chainClient.setDispatcher(new TxResultDispatcher(chainClient));
            chainClient.getDispatcher().start();
        }
        chainClient.setArchiveCenterConfig(archiveCenterConfig);
        this.chains.put(chainId, chainClient);
        if (chainClient.getClientUser().getAlias() != null && chainClient.getClientUser().getAlias().length() > 0) {
            try {
                chainClient.enableAlias();
            }
            catch (ChainClientException | ChainMakerCryptoSuiteException e) {
                throw new ChainClientException("enable Alias failed: " + e.getMessage());
            }
        }
        return chainClient;
    }

    private void dealChainClientConfig(ChainClientConfig chainClientConfig) throws UtilsException, ChainMakerCryptoSuiteException {
        String authType = chainClientConfig.getAuthType();
        if (authType.equals(AuthType.PermissionedWithKey.getMsg()) || authType.equals(AuthType.Public.getMsg())) {
            byte[] userEncCrtBytes;
            byte[] userEncKeyBytes;
            byte[] userCrtBytes;
            byte[] userKeyBytes;
            byte[] userSignCrtBytes;
            byte[] pemKey = chainClientConfig.getUserSignKeyBytes();
            if (pemKey == null && chainClientConfig.getUserSignKeyFilePath() != null) {
                chainClientConfig.setUserSignKeyBytes(FileUtils.getFileOrResourceFileBytes(chainClientConfig.getUserSignKeyFilePath()));
            }
            if ((userSignCrtBytes = chainClientConfig.getUserSignCrtBytes()) == null && chainClientConfig.getUserSignCrtFilePath() != null) {
                chainClientConfig.setUserSignCrtBytes(FileUtils.getFileOrResourceFileBytes(chainClientConfig.getUserSignCrtFilePath()));
            }
            if ((userKeyBytes = chainClientConfig.getUserKeyBytes()) == null && chainClientConfig.getUserKeyFilePath() != null) {
                chainClientConfig.setUserKeyBytes(FileUtils.getFileOrResourceFileBytes(chainClientConfig.getUserKeyFilePath()));
            }
            if ((userCrtBytes = chainClientConfig.getUserCrtBytes()) == null && chainClientConfig.getUserCrtFilePath() != null) {
                chainClientConfig.setUserCrtBytes(FileUtils.getFileOrResourceFileBytes(chainClientConfig.getUserCrtFilePath()));
            }
            if ((userEncKeyBytes = chainClientConfig.getUserEncKeyBytes()) == null && chainClientConfig.getUserEncKeyFilePath() != null) {
                chainClientConfig.setUserEncKeyBytes(FileUtils.getFileOrResourceFileBytes(chainClientConfig.getUserEncKeyFilePath()));
            }
            if ((userEncCrtBytes = chainClientConfig.getUserEncCrtBytes()) == null && chainClientConfig.getUserEncCrtFilePath() != null) {
                chainClientConfig.setUserEncCrtBytes(FileUtils.getFileOrResourceFileBytes(chainClientConfig.getUserEncCrtFilePath()));
            }
        } else {
            byte[] userSignCrtBytes;
            byte[] userSignKeyBytes;
            byte[] userEncCrtBytes;
            byte[] userEncKeyBytes;
            byte[] userCrtBytes;
            chainClientConfig.setAuthType(AuthType.PermissionedWithCert.getMsg());
            byte[] userKeyBytes = chainClientConfig.getUserKeyBytes();
            if (userKeyBytes == null && chainClientConfig.getUserKeyFilePath() != null) {
                chainClientConfig.setUserKeyBytes(FileUtils.getFileOrResourceFileBytes(chainClientConfig.getUserKeyFilePath()));
            }
            if ((userCrtBytes = chainClientConfig.getUserCrtBytes()) == null && chainClientConfig.getUserCrtFilePath() != null) {
                chainClientConfig.setUserCrtBytes(FileUtils.getFileOrResourceFileBytes(chainClientConfig.getUserCrtFilePath()));
            }
            if ((userEncKeyBytes = chainClientConfig.getUserEncKeyBytes()) == null && chainClientConfig.getUserEncKeyFilePath() != null) {
                chainClientConfig.setUserEncKeyBytes(FileUtils.getFileOrResourceFileBytes(chainClientConfig.getUserEncKeyFilePath()));
            }
            if ((userEncCrtBytes = chainClientConfig.getUserEncCrtBytes()) == null && chainClientConfig.getUserEncCrtFilePath() != null) {
                chainClientConfig.setUserEncCrtBytes(FileUtils.getFileOrResourceFileBytes(chainClientConfig.getUserEncCrtFilePath()));
            }
            if ((userSignKeyBytes = chainClientConfig.getUserSignKeyBytes()) == null && chainClientConfig.getUserSignKeyFilePath() != null) {
                chainClientConfig.setUserSignKeyBytes(FileUtils.getFileOrResourceFileBytes(chainClientConfig.getUserSignKeyFilePath()));
            }
            if ((userSignCrtBytes = chainClientConfig.getUserSignCrtBytes()) == null && chainClientConfig.getUserSignCrtFilePath() != null) {
                chainClientConfig.setUserSignCrtBytes(FileUtils.getFileOrResourceFileBytes(chainClientConfig.getUserSignCrtFilePath()));
            }
        }
    }

    private void checkConfig(ChainClientConfig chainClientConfig) throws ChainClientException {
        if (chainClientConfig == null) {
            logger.error("chainClientConfig is null, please check config");
            throw new ChainClientException("chainClientConfig is null");
        }
        this.checkNodeListConfig(chainClientConfig);
        this.checkUserConfig(chainClientConfig);
        this.checkChainConfig(chainClientConfig);
    }

    private void checkNodeListConfig(ChainClientConfig chainClientConfig) throws ChainClientException {
        NodeConfig[] nodeConfigs;
        for (NodeConfig nodeConfig : nodeConfigs = chainClientConfig.getNodes()) {
            if (nodeConfig.isEnableTls() && nodeConfig.getTrustRootBytes() == null && nodeConfig.getTrustRootPaths() == null) {
                throw new ChainClientException("if node useTLS is open, should set caPaths or caCerts");
            }
            if (!"".equals(nodeConfig.getTlsHostName())) continue;
            throw new ChainClientException("if node useTLS is open, should set tls hostname");
        }
    }

    private void checkUserConfig(ChainClientConfig chainClientConfig) throws ChainClientException {
        if ("".equals(chainClientConfig.getUserKeyFilePath()) && chainClientConfig.getUserKeyBytes() == null) {
            throw new ChainClientException("user key cannot be empty");
        }
        if ("".equals(chainClientConfig.getUserCrtFilePath()) && chainClientConfig.getUserCrtBytes() == null) {
            throw new ChainClientException("user cert cannot be empty");
        }
    }

    private void checkChainConfig(ChainClientConfig chainClientConfig) throws ChainClientException {
        if ("".equals(chainClientConfig.getChainId())) {
            throw new ChainClientException("chainId cannot be empty");
        }
    }
}

