/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk;

import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.DestroyMode;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.chainmaker.pb.api.RpcNodeGrpc;
import org.chainmaker.pb.config.ChainmakerServer;
import org.chainmaker.sdk.Node;
import org.chainmaker.sdk.RpcServiceClient;
import org.chainmaker.sdk.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcClientFactory
extends BasePooledObjectFactory<RpcServiceClient> {
    private static final Logger logger = LoggerFactory.getLogger(GrpcClientFactory.class);
    private final User clientUser;
    private final int messageSize;
    private String proxyUrl;
    private List<Node> readNodes;
    private Map<String, AtomicInteger> nodeConnCountMap;
    private Map<RpcServiceClient, String> connNodeMap;
    final long rpcCallTimeout = 10000L;
    GenericObjectPool<RpcServiceClient> connPool;

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public void setPool(GenericObjectPool<RpcServiceClient> connPool) {
        this.connPool = connPool;
    }

    public GrpcClientFactory(Node[] nodes, User clientUser, int messageSize) {
        this.clientUser = clientUser;
        this.readNodes = Arrays.stream(nodes).collect(Collectors.toList());
        this.messageSize = messageSize;
        this.nodeConnCountMap = new ConcurrentHashMap<String, AtomicInteger>(nodes.length);
        this.connNodeMap = new ConcurrentHashMap<RpcServiceClient, String>();
    }

    public void addNode(Node node) {
        logger.info("add node:{}", (Object)node.getUri());
        this.readNodes.add(node);
        this.logReadNode();
    }

    public void delNode(Node node) {
        logger.info("del node:{}", (Object)node.getUri());
        boolean removed = this.readNodes.remove(node);
        Set<Map.Entry<RpcServiceClient, String>> keepConn = this.connNodeMap.entrySet();
        if (keepConn.size() > 0 && removed) {
            ArrayList<RpcServiceClient> delClients = new ArrayList<RpcServiceClient>();
            for (Map.Entry<RpcServiceClient, String> entry : keepConn) {
                if (!entry.getValue().equals(node.getUri())) continue;
                logger.debug("found node grpc url:{}", (Object)node.getUri());
                RpcServiceClient delClient = entry.getKey();
                delClients.add(delClient);
            }
            for (RpcServiceClient delClient : delClients) {
                try {
                    this.connPool.invalidateObject((Object)delClient, DestroyMode.NORMAL);
                    logger.debug("grpc client destroyed:{}", (Object)delClient);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.logReadNode();
    }

    public RpcServiceClient create() throws Exception {
        RpcServiceClient rpcServiceClient;
        HashSet<String> errorNodes = new HashSet<String>();
        try {
            rpcServiceClient = this.createRpcClient(errorNodes);
        }
        finally {
            errorNodes.clear();
        }
        logger.info("create a new  grpc client:{}....", (Object)rpcServiceClient);
        return rpcServiceClient;
    }

    private RpcServiceClient createRpcClient(Set<String> errorNodes) {
        RpcServiceClient rpcServiceClient = null;
        Node node = null;
        while (rpcServiceClient == null) {
            node = this.getLeastConnNode(errorNodes);
            if (node == null) {
                logger.error("create chainClient error:no node can use");
                logger.info("errorNodes:" + errorNodes);
                this.logReadNode();
                throw new RuntimeException("create chainClient error:no node can use");
            }
            try {
                rpcServiceClient = RpcServiceClient.newServiceClient(node, this.clientUser, this.messageSize, this.proxyUrl);
                boolean b = this.buseCheck(rpcServiceClient);
                if (b) continue;
                logger.warn("===============\u521b\u5efa\u8fde\u63a5\u5931\u8d25,\u628a\u8282\u70b9\u52a0\u5165\u5f02\u5e38\u8282\u70b9{}", (Object)node.getUri());
                errorNodes.add(node.getUri());
                if (errorNodes.size() >= this.readNodes.size()) {
                    logger.warn("create chainClient error:no node can use");
                    throw new RuntimeException("create chainClient error:no node can use");
                }
                rpcServiceClient.getManagedChannel().shutdown();
                rpcServiceClient = null;
            }
            catch (Exception e) {
                if (rpcServiceClient != null) {
                    rpcServiceClient.getManagedChannel().shutdown();
                }
                logger.warn("===============\u521b\u5efa\u8fde\u63a5\u5931\u8d25{},\u628a\u8282\u70b9\u52a0\u5165\u5f02\u5e38\u8282\u70b9{}", (Object)e.getMessage(), (Object)node.getUri());
                logger.warn("===============\u521b\u5efa\u8fde\u63a5\u5931\u8d25===============", (Throwable)e);
                errorNodes.add(node.getUri());
                if (errorNodes.size() < this.readNodes.size()) continue;
                logger.error("create chainClient error:no node can use", (Throwable)e);
                throw new RuntimeException("create chainClient error:no node can use");
            }
        }
        this.connNodeMap.put(rpcServiceClient, node.getUri());
        AtomicInteger count = this.nodeConnCountMap.putIfAbsent(node.getUri(), new AtomicInteger(0));
        if (count == null) {
            count = this.nodeConnCountMap.get(node.getUri());
        }
        count.incrementAndGet();
        logger.info("create a new  grpc client:{} {} current conn {}....", new Object[]{rpcServiceClient, node.getUri(), count.get()});
        return rpcServiceClient;
    }

    private Node getLeastConnNode(Set<String> errorNodes) {
        Node leastNode = null;
        int least = Integer.MAX_VALUE;
        for (Node n : this.readNodes) {
            AtomicInteger nodeCount;
            if (errorNodes.contains(n.getUri()) || (nodeCount = this.nodeConnCountMap.getOrDefault(n.getUri(), new AtomicInteger(0))).get() >= least) continue;
            least = nodeCount.get();
            leastNode = n;
        }
        if (leastNode != null) {
            logger.debug("getLeastConnNode grpc url:{}...", (Object)leastNode.getUri());
        } else {
            logger.debug("getLeastConnNode grpc is null");
        }
        return leastNode;
    }

    public PooledObject<RpcServiceClient> wrap(RpcServiceClient client) {
        return new DefaultPooledObject((Object)client);
    }

    public void destroyObject(PooledObject<RpcServiceClient> p) throws Exception {
        long start = System.currentTimeMillis();
        RpcServiceClient rpcServiceClient = (RpcServiceClient)p.getObject();
        rpcServiceClient.getManagedChannel().shutdown();
        try {
            if (!rpcServiceClient.getManagedChannel().awaitTermination(3L, TimeUnit.SECONDS)) {
                rpcServiceClient.getManagedChannel().shutdownNow();
            }
        }
        catch (Exception e) {
            logger.info("destroyObject exception :{}", (Object)e.getMessage());
        }
        String uri = this.connNodeMap.get(rpcServiceClient);
        this.nodeConnCountMap.get(uri).decrementAndGet();
        this.connNodeMap.remove(rpcServiceClient);
        super.destroyObject(p);
        logger.info("destroyObject: {} cost: {}ms", (Object)rpcServiceClient, (Object)(System.currentTimeMillis() - start));
    }

    public void close(RpcServiceClient rpcServiceClient) {
        long start = System.currentTimeMillis();
        rpcServiceClient.getManagedChannel().shutdownNow();
        String uri = this.connNodeMap.get(rpcServiceClient);
        this.nodeConnCountMap.get(uri).decrementAndGet();
        this.connNodeMap.remove(rpcServiceClient);
        logger.info("close: {} cost: {}ms", (Object)rpcServiceClient, (Object)(System.currentTimeMillis() - start));
    }

    public boolean validateObject(PooledObject<RpcServiceClient> p) {
        RpcServiceClient rpcServiceClient = (RpcServiceClient)p.getObject();
        ManagedChannel managedChannel = rpcServiceClient.getManagedChannel();
        ConnectivityState connectivityState = managedChannel.getState(true);
        logger.info(" {} check validateObject......{}", (Object)managedChannel, (Object)connectivityState.name());
        if (connectivityState.equals((Object)ConnectivityState.READY) || connectivityState.equals((Object)ConnectivityState.IDLE)) {
            return this.buseCheck(rpcServiceClient);
        }
        if (connectivityState.equals((Object)ConnectivityState.SHUTDOWN)) {
            return false;
        }
        if (connectivityState.equals((Object)ConnectivityState.CONNECTING) || connectivityState.equals((Object)ConnectivityState.TRANSIENT_FAILURE)) {
            return this.checkReady(managedChannel);
        }
        return true;
    }

    private boolean buseCheck(RpcServiceClient rpcServiceClient) {
        ChainmakerServer.ChainMakerVersionRequest chainMakerVersionRequest = ChainmakerServer.ChainMakerVersionRequest.newBuilder().build();
        RpcNodeGrpc.RpcNodeFutureStub rpcNodeFutureStub = rpcServiceClient.getRpcNodeFutureStub();
        try {
            rpcNodeFutureStub.getChainMakerVersion(chainMakerVersionRequest).get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warn("check invoke getVersion error one ", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean checkReady(ManagedChannel managedChannel) {
        for (int count = 100; count > 0 && !managedChannel.getState(true).equals((Object)ConnectivityState.READY); --count) {
            try {
                TimeUnit.MILLISECONDS.sleep(20L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (managedChannel.getState(true).equals((Object)ConnectivityState.READY)) {
            return true;
        }
        logger.info("managedChannel not ready......");
        return false;
    }

    public void stopAll() {
        Set<RpcServiceClient> clients = this.connNodeMap.keySet();
        for (RpcServiceClient rpcServiceClient : clients) {
            try {
                this.connPool.invalidateObject((Object)rpcServiceClient);
            }
            catch (Exception e) {
                logger.error("invalidate object err:{}", (Object)e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    private void logReadNode() {
        logger.info("now nodes:{}", this.readNodes.stream().map(Node::getUri).collect(Collectors.toList()));
    }
}

