/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk;

import com.google.protobuf.ByteString;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.Objects;
import org.chainmaker.pb.accesscontrol.MemberOuterClass;
import org.chainmaker.pb.common.Request;
import org.chainmaker.sdk.config.AuthType;
import org.chainmaker.sdk.config.CryptoConfig;
import org.chainmaker.sdk.crypto.ChainMakerCryptoSuiteException;
import org.chainmaker.sdk.crypto.ChainmakerX509CryptoSuite;
import org.chainmaker.sdk.crypto.CryptoSuite;
import org.chainmaker.sdk.utils.CryptoUtils;
import org.chainmaker.sdk.utils.UtilsException;

public class User {
    private String orgId;
    private PrivateKey privateKey;
    private Certificate certificate;
    private PrivateKey tlsPrivateKey;
    private Certificate tlsCertificate;
    private PrivateKey encTlsPrivateKey;
    private Certificate encTlsCertificate;
    private byte[] certBytes;
    private byte[] certHash;
    private String alias;
    private byte[] pukBytes;
    private byte[] priBytes;
    private PublicKey publicKey;
    private String authType = AuthType.PermissionedWithCert.getMsg();
    private CryptoSuite cryptoSuite;
    private Boolean enableTxResultDispatcher;
    private Map keys;
    private boolean pkcs11Enable;

    @Deprecated
    public User(String orgId, byte[] userKeyBytes, byte[] userCertBytes, byte[] tlsUserKeyBytes, byte[] tlsUserCertBytes) throws ChainMakerCryptoSuiteException {
        this(orgId, userKeyBytes, userCertBytes, tlsUserKeyBytes, tlsUserCertBytes, false);
    }

    @Deprecated
    public User(String orgId, byte[] userKeyBytes, byte[] userCertBytes, byte[] tlsUserKeyBytes, byte[] tlsUserCertBytes, boolean pkcs11Enable) throws ChainMakerCryptoSuiteException {
        ChainmakerX509CryptoSuite generatedCryptoSuite = ChainmakerX509CryptoSuite.newInstance(pkcs11Enable);
        PrivateKey generatedTlsPrivateKey = CryptoUtils.getPrivateKeyFromBytes(tlsUserKeyBytes);
        if (userCertBytes != null && userCertBytes.length > 0) {
            Certificate generatedCertificate;
            this.certificate = generatedCertificate = generatedCryptoSuite.getCertificateFromBytes(userCertBytes);
        }
        Certificate generatedTlsCertificate = generatedCryptoSuite.getCertificateFromBytes(tlsUserCertBytes);
        if (!pkcs11Enable) {
            this.privateKey = CryptoUtils.getPrivateKeyFromBytes(userKeyBytes);
        } else {
            this.pkcs11Enable = true;
            this.keys = generatedCryptoSuite.parseUserKey(userKeyBytes);
            this.keys.putIfAbsent("algorithm", generatedCryptoSuite.getAlgorithm());
        }
        this.orgId = orgId;
        this.certBytes = userCertBytes;
        this.tlsCertificate = generatedTlsCertificate;
        this.tlsPrivateKey = generatedTlsPrivateKey;
        this.cryptoSuite = generatedCryptoSuite;
    }

    public User(String orgId, byte[] userKeyBytes, byte[] userCertBytes, byte[] tlsUserKeyBytes, byte[] tlsUserCertBytes, byte[] encTlsUserKeyBytes, byte[] encTlsUserCertBytes, boolean pkcs11Enable) throws ChainMakerCryptoSuiteException {
        this(orgId, userKeyBytes, userCertBytes, tlsUserKeyBytes, tlsUserCertBytes, pkcs11Enable);
        if (encTlsUserKeyBytes != null) {
            this.encTlsPrivateKey = CryptoUtils.getPrivateKeyFromBytes(encTlsUserKeyBytes);
        }
        if (encTlsUserCertBytes != null) {
            this.encTlsCertificate = this.cryptoSuite.getCertificateFromBytes(encTlsUserCertBytes);
        }
    }

    @Deprecated
    public User(String orgId) throws ChainMakerCryptoSuiteException {
        this.cryptoSuite = ChainmakerX509CryptoSuite.newInstance();
        this.orgId = orgId;
    }

    public User(String orgId, byte[] userKeyBytes, byte[] userCertBytes, byte[] tlsUserKeyBytes, byte[] tlsUserCertBytes, byte[] encTlsUserKeyBytes, byte[] encTlsUserCertBytes, CryptoConfig cryptoConfig, boolean pkcs11Enable) throws ChainMakerCryptoSuiteException, UtilsException {
        this(orgId, userKeyBytes, userCertBytes, cryptoConfig, pkcs11Enable);
        if (encTlsUserKeyBytes != null) {
            this.encTlsPrivateKey = CryptoUtils.getPrivateKeyFromBytes(encTlsUserKeyBytes);
        }
        if (encTlsUserCertBytes != null) {
            this.encTlsCertificate = this.cryptoSuite.getCertificateFromBytes(encTlsUserCertBytes);
        }
        if (tlsUserKeyBytes != null) {
            this.tlsPrivateKey = CryptoUtils.getPrivateKeyFromBytes(tlsUserKeyBytes);
        }
        if (tlsUserCertBytes != null) {
            this.tlsCertificate = this.cryptoSuite.getCertificateFromBytes(tlsUserCertBytes);
        }
    }

    @Deprecated
    public User(String orgId, byte[] userKeyBytes, byte[] userCertBytes, CryptoConfig cryptoConfig, boolean pkcs11Enable) throws ChainMakerCryptoSuiteException, UtilsException {
        this.cryptoSuite = ChainmakerX509CryptoSuite.newInstance(pkcs11Enable);
        this.pkcs11Enable = pkcs11Enable;
        if (pkcs11Enable) {
            String algo = "EC";
            if (cryptoConfig != null && !Objects.equals(cryptoConfig.getAlgo(), "")) {
                algo = cryptoConfig.getAlgo();
            }
            this.keys = this.cryptoSuite.parseUserKey(userKeyBytes);
            PublicKey publicKey = CryptoUtils.publicKeyFromPem(new String(userCertBytes), algo);
            this.setPukBytes(CryptoUtils.getPemStrFromPublicKey(publicKey).getBytes());
            this.setPublicKey(publicKey);
        } else {
            PublicKey publicKey;
            PrivateKey privateKey = CryptoUtils.getPrivateKeyFromBytes(userKeyBytes);
            try {
                publicKey = CryptoUtils.getPublicKeyFromPrivateKey(privateKey);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
                throw new ChainMakerCryptoSuiteException("Get publicKey from privateKey Error: " + e.getMessage());
            }
            this.setPukBytes(CryptoUtils.getPemStrFromPublicKey(publicKey).getBytes());
            this.setPublicKey(publicKey);
            this.setPrivateKey(privateKey);
        }
        this.orgId = orgId;
    }

    public User(String orgId, byte[] userKeyBytes, byte[] userCertBytes, byte[] publicKey, String authType) throws ChainMakerCryptoSuiteException {
        ChainmakerX509CryptoSuite generatedCryptoSuite = ChainmakerX509CryptoSuite.newInstance();
        this.orgId = orgId;
        if (userCertBytes.length > 0) {
            this.certificate = generatedCryptoSuite.getCertificateFromBytes(userCertBytes);
        }
        if (publicKey.length > 0) {
            this.pukBytes = publicKey;
        }
        this.privateKey = CryptoUtils.getPrivateKeyFromBytes(userKeyBytes);
        this.authType = authType;
        this.cryptoSuite = generatedCryptoSuite;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public PrivateKey getTlsPrivateKey() {
        return this.tlsPrivateKey;
    }

    public void setTlsPrivateKey(PrivateKey tlsPrivateKey) {
        this.tlsPrivateKey = tlsPrivateKey;
    }

    public Certificate getTlsCertificate() {
        return this.tlsCertificate;
    }

    public void setTlsCertificate(Certificate tlsCertificate) {
        this.tlsCertificate = tlsCertificate;
    }

    public PrivateKey getEncTlsPrivateKey() {
        return this.encTlsPrivateKey;
    }

    public void setEncTlsPrivateKey(PrivateKey encTlsPrivateKey) {
        this.encTlsPrivateKey = encTlsPrivateKey;
    }

    public Certificate getEncTlsCertificate() {
        return this.encTlsCertificate;
    }

    public void setEncTlsCertificate(Certificate encTlsCertificate) {
        this.encTlsCertificate = encTlsCertificate;
    }

    public byte[] getCertBytes() {
        return this.certBytes;
    }

    public void setCertBytes(byte[] certBytes) {
        this.certBytes = certBytes;
    }

    public byte[] getCertHash() {
        return this.certHash;
    }

    public void setCertHash(byte[] certHash) {
        this.certHash = certHash;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public byte[] getPukBytes() {
        return this.pukBytes;
    }

    public void setPukBytes(byte[] pukBytes) {
        this.pukBytes = pukBytes;
    }

    public Map getKeys() {
        return this.keys;
    }

    public void setKeys(Map keys) {
        this.keys = keys;
    }

    public boolean isPkcs11Enable() {
        return this.pkcs11Enable;
    }

    public void setPkcs11Enable(boolean pkcs11Enable) {
        this.pkcs11Enable = pkcs11Enable;
    }

    public byte[] getPriBytes() {
        return this.priBytes;
    }

    public void setPriBytes(byte[] priBytes) {
        this.priBytes = priBytes;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public Boolean getEnableTxResultDispatcher() {
        return this.enableTxResultDispatcher;
    }

    public void setEnableTxResultDispatcher(Boolean enableTxResultDispatcher) {
        this.enableTxResultDispatcher = enableTxResultDispatcher;
    }

    public CryptoSuite getCryptoSuite() {
        return this.cryptoSuite;
    }

    public void setCryptoSuite(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public byte[] signPayload(byte[] payload, boolean isEnabledCertHash) throws ChainMakerCryptoSuiteException {
        Request.EndorsementEntry endorsementEntry = Request.EndorsementEntry.newBuilder().setSignature(ByteString.copyFrom((byte[])this.cryptoSuite.sign(this.privateKey, payload))).setSigner(this.getSerializedMember(isEnabledCertHash)).build();
        return endorsementEntry.toByteArray();
    }

    public Request.EndorsementEntry signPayloadOfMultiSign(byte[] payload, boolean isEnabledCertHash) throws ChainMakerCryptoSuiteException {
        return Request.EndorsementEntry.newBuilder().setSignature(ByteString.copyFrom((byte[])this.cryptoSuite.sign(this.privateKey, payload))).setSigner(this.getSerializedMember(isEnabledCertHash)).build();
    }

    public MemberOuterClass.Member getSerializedMember(boolean isEnabledCertHash) {
        if (isEnabledCertHash && this.certHash != null && this.certHash.length > 0) {
            return MemberOuterClass.Member.newBuilder().setOrgId(this.orgId).setMemberInfo(ByteString.copyFrom((byte[])this.certHash)).setMemberType(MemberOuterClass.MemberType.CERT_HASH).build();
        }
        return MemberOuterClass.Member.newBuilder().setOrgId(this.orgId).setMemberInfo(ByteString.copyFrom((byte[])this.certBytes)).setMemberType(MemberOuterClass.MemberType.CERT).build();
    }
}

