/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk.archivecenter;

import com.google.gson.Gson;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.util.Objects;
import org.chainmaker.pb.archivecenter.Archivecenter;
import org.chainmaker.pb.common.ChainmakerBlock;
import org.chainmaker.pb.common.ChainmakerTransaction;
import org.chainmaker.pb.config.ChainConfigOuterClass;
import org.chainmaker.sdk.ChainClientException;
import org.chainmaker.sdk.archivecenter.ArchiveCenterApi;
import org.chainmaker.sdk.archivecenter.ArchiveCenterQuery;
import org.chainmaker.sdk.archivecenter.ArchiveCenterResp;
import org.chainmaker.sdk.archivecenter.ArchiveService;
import org.chainmaker.sdk.archivecenter.BlockIterator;
import org.chainmaker.sdk.archivecenter.Notice;
import org.chainmaker.sdk.config.ArchiveCenterConfig;
import org.chainmaker.sdk.utils.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveCenterHttpClient
implements ArchiveService {
    private ArchiveCenterConfig archiveCenterConfig;
    private int httpCallTimeout = 10000;
    private static final Logger logger = LoggerFactory.getLogger(ArchiveCenterHttpClient.class);

    public ArchiveCenterHttpClient(ArchiveCenterConfig archiveCenterConfig) {
        this.archiveCenterConfig = archiveCenterConfig;
        if (archiveCenterConfig.getRequestSecondLimit() > 0) {
            this.httpCallTimeout = archiveCenterConfig.getRequestSecondLimit() * 1000;
        }
    }

    public ArchiveCenterConfig getArchiveCenterConfig() {
        return this.archiveCenterConfig;
    }

    public void setArchiveCenterConfig(ArchiveCenterConfig archiveCenterConfig) {
        this.archiveCenterConfig = archiveCenterConfig;
    }

    @Override
    public ChainmakerTransaction.TransactionInfo getTxByTxId(String txId, long rpcCallTimeout) throws ChainClientException {
        ChainmakerTransaction.TransactionInfo.Builder builder = ChainmakerTransaction.TransactionInfo.newBuilder();
        if ((builder = (Message.Builder)this.httpQueryArchiveCenter(builder, ArchiveCenterApi.GetCommonTransactionByTxId.getValue(), new ArchiveCenterQuery(txId, ArchiveCenterQuery.QueryType.TXID))) != null) {
            return (ChainmakerTransaction.TransactionInfo)builder.build();
        }
        return null;
    }

    @Override
    public ChainmakerTransaction.TransactionInfoWithRWSet getTxWithRWSetByTxId(String txId, long rpcCallTimeout) throws ChainClientException {
        ChainmakerTransaction.TransactionInfoWithRWSet.Builder builder = ChainmakerTransaction.TransactionInfoWithRWSet.newBuilder();
        if ((builder = (Message.Builder)this.httpQueryArchiveCenter(builder, ArchiveCenterApi.GetCommonTransactionWithRWSetByTxId.getValue(), new ArchiveCenterQuery(txId, ArchiveCenterQuery.QueryType.TXID))) != null) {
            return (ChainmakerTransaction.TransactionInfoWithRWSet)builder.build();
        }
        return null;
    }

    @Override
    public ChainmakerBlock.BlockInfo getBlockByHeight(long blockHeight, boolean withRWSet, long rpcCallTimeout) throws ChainClientException {
        ChainmakerBlock.BlockInfo.Builder builder = ChainmakerBlock.BlockInfo.newBuilder();
        if ((builder = (Message.Builder)this.httpQueryArchiveCenter(builder, ArchiveCenterApi.GetBlockWithTxRWSetByHeight.getValue(), new ArchiveCenterQuery(blockHeight))) != null) {
            ChainmakerBlock.BlockInfo blockInfo = (ChainmakerBlock.BlockInfo)builder.build();
            if (withRWSet) {
                return ChainmakerBlock.BlockInfo.newBuilder().addAllRwsetList(blockInfo.getRwsetListList()).build();
            }
            return blockInfo;
        }
        return null;
    }

    @Override
    public ChainmakerBlock.BlockInfo getBlockByHash(String blockHash, boolean withRWSet, long rpcCallTimeout) throws ChainClientException {
        ChainmakerBlock.BlockInfo.Builder builder = ChainmakerBlock.BlockInfo.newBuilder();
        if ((builder = (Message.Builder)this.httpQueryArchiveCenter(builder, ArchiveCenterApi.GetBlockWithTxRWSetByHash.getValue(), new ArchiveCenterQuery(blockHash, ArchiveCenterQuery.QueryType.BLOCKHASH))) != null) {
            ChainmakerBlock.BlockInfo blockInfo = (ChainmakerBlock.BlockInfo)builder.build();
            if (withRWSet) {
                return ChainmakerBlock.BlockInfo.newBuilder().addAllRwsetList(blockInfo.getRwsetListList()).build();
            }
            return blockInfo;
        }
        return null;
    }

    @Override
    public ChainmakerBlock.BlockInfo getBlockByTxId(String txId, boolean withRWSet, long rpcCallTimeout) throws ChainClientException {
        ChainmakerBlock.BlockInfo.Builder builder = ChainmakerBlock.BlockInfo.newBuilder();
        if ((builder = (Message.Builder)this.httpQueryArchiveCenter(builder, ArchiveCenterApi.GetBlockWithTxRWSetByTxId.getValue(), new ArchiveCenterQuery(txId, ArchiveCenterQuery.QueryType.TXID))) != null) {
            ChainmakerBlock.BlockInfo blockInfo = (ChainmakerBlock.BlockInfo)builder.build();
            if (withRWSet) {
                return ChainmakerBlock.BlockInfo.newBuilder().addAllRwsetList(blockInfo.getRwsetListList()).build();
            }
            return blockInfo;
        }
        return null;
    }

    @Override
    public ChainConfigOuterClass.ChainConfig getChainConfigByBlockHeight(long blockHeight, long rpcCallTimeout) throws ChainClientException {
        ChainConfigOuterClass.ChainConfig.Builder builder = ChainConfigOuterClass.ChainConfig.newBuilder();
        if ((builder = (Message.Builder)this.httpQueryArchiveCenter(builder, ArchiveCenterApi.GetConfigByHeight.getValue(), new ArchiveCenterQuery(blockHeight))) != null) {
            return (ChainConfigOuterClass.ChainConfig)builder.build();
        }
        return null;
    }

    @Override
    public void register(ChainmakerBlock.BlockInfo genesis, long rpcCallTimeout) throws ChainClientException {
    }

    @Override
    public void archiveBlock(ChainmakerBlock.BlockInfo block) {
    }

    @Override
    public void archiveBlocks(BlockIterator blockIterator, Notice notice) {
    }

    @Override
    public Archivecenter.ArchiveStatusResp getArchivedStatus(long rpcCallTimeout) {
        return null;
    }

    public <T> T httpQueryArchiveCenter(T t, String apiUri, ArchiveCenterQuery queryParam) {
        if (this.archiveCenterConfig == null || Objects.equals(this.archiveCenterConfig.getArchiveCenterHttpUrl(), "")) {
            return null;
        }
        String requestUri = this.archiveCenterConfig.getArchiveCenterHttpUrl() + "/" + apiUri;
        queryParam.setChainGenesisHash(this.archiveCenterConfig.getChainGenesisHash());
        try {
            Gson gson = new Gson();
            String result = HttpUtils.post(requestUri, gson.toJson((Object)queryParam), this.httpCallTimeout, this.httpCallTimeout);
            ArchiveCenterResp resp = new ArchiveCenterResp();
            resp = (ArchiveCenterResp)gson.fromJson(result, resp.getClass());
            if (resp.getCode() != null && resp.getCode() > 0) {
                logger.error("code: {}", (Object)resp.getCode());
                return null;
            }
            if (resp.getData() == null) {
                logger.error("errmsg: {}", (Object)resp.getErrorMsg());
                return null;
            }
            if (t instanceof Message.Builder) {
                JsonFormat.parser().merge(gson.toJson(resp.getData()), (Message.Builder)t);
                return t;
            }
            return resp.getData();
        }
        catch (Exception e) {
            logger.error("err: {}", (Object)e.getMessage());
            return null;
        }
    }
}

