/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk.archivecenter;

import org.chainmaker.pb.common.ChainmakerBlock;
import org.chainmaker.sdk.ChainClient;
import org.chainmaker.sdk.ChainClientException;
import org.chainmaker.sdk.archivecenter.BlockIterator;
import org.chainmaker.sdk.archivecenter.Notice;
import org.chainmaker.sdk.crypto.ChainMakerCryptoSuiteException;

public class Blocks
implements BlockIterator {
    private long height;
    private long endHeight;
    private long total;
    private Notice notice;
    private ChainClient chainClient;

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public long getEndHeight() {
        return this.endHeight;
    }

    public void setEndHeight(long endHeight) {
        this.endHeight = endHeight;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public Notice getNotice() {
        return this.notice;
    }

    public void setNotice(Notice notice) {
        this.notice = notice;
    }

    public ChainClient getChainClient() {
        return this.chainClient;
    }

    public void setChainClient(ChainClient chainClient) {
        this.chainClient = chainClient;
    }

    public Blocks(long height, long endHeight, long total, Notice notice, ChainClient chainClient) {
        this.height = height;
        this.endHeight = endHeight;
        this.total = total;
        this.notice = notice;
        this.chainClient = chainClient;
    }

    @Override
    public Boolean next() {
        return this.height++ < this.endHeight;
    }

    @Override
    public ChainmakerBlock.BlockInfo value() throws ChainClientException {
        try {
            return this.chainClient.getBlockByHeight(this.height, true, 10000L);
        }
        catch (ChainMakerCryptoSuiteException e) {
            throw new ChainClientException(e.getMessage());
        }
    }

    @Override
    public void release() {
    }

    @Override
    public long total() {
        return this.total;
    }

    @Override
    public long current() {
        return this.height;
    }
}

