/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk.crypto.hibe;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.chainmaker.sdk.SdkException;
import org.chainmaker.sdk.crypto.ChainMakerCryptoSuiteException;
import org.chainmaker.sdk.crypto.hibe.HibeBase;
import org.chainmaker.sdk.crypto.hibe.gotype.GoBytes;
import org.chainmaker.sdk.crypto.hibe.gotype.GoString;
import org.chainmaker.sdk.serialize.EasyCodecHelper;

public class Hibe {
    static final String SIZE = "size";

    public byte[] encryptHibeMsg(byte[] plainText, String[] receiverIds, List<byte[]> params, int keyType) throws SdkException {
        GoBytes.ByValue encryptHibeMsg = null;
        try {
            EasyCodecHelper helper1 = new EasyCodecHelper();
            helper1.addInt(SIZE, receiverIds.length);
            for (int i = 0; i < receiverIds.length; ++i) {
                helper1.addString(String.valueOf(i), receiverIds[i]);
            }
            byte[] idsBytes = helper1.EasyMarshal();
            EasyCodecHelper helper2 = new EasyCodecHelper();
            helper2.addInt(SIZE, 1);
            for (int i = 0; i < params.size(); ++i) {
                helper2.addBytes(String.valueOf(i), params.get(i));
            }
            byte[] paramsBytes = helper2.EasyMarshal();
            encryptHibeMsg = HibeBase.getHibeInterface().EncryptHibeMsg(plainText, plainText.length, idsBytes, idsBytes.length, paramsBytes, paramsBytes.length, keyType);
            if (encryptHibeMsg.r1 != -1L) {
                byte[] byArray = encryptHibeMsg.r0.getByteArray(0L, (int)encryptHibeMsg.r1);
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException | SdkException e) {
            throw new SdkException("EncryptHibeMsg err : " + e.getMessage());
        }
        finally {
            String os = System.getProperty("os.name");
            if (!os.toLowerCase().startsWith("win") && encryptHibeMsg != null && encryptHibeMsg.r0 != null) {
                Native.free((long)Pointer.nativeValue((Pointer)encryptHibeMsg.r0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decryptHibeMsg(String localId, byte[] param, byte[] privKey, byte[] hibeMsg, int keyType) throws SdkException {
        byte[] localIdBytes = localId.getBytes();
        GoBytes.ByValue decryptMsg = null;
        try {
            try {
                decryptMsg = HibeBase.getHibeInterface().DecryptHibeMsg(localIdBytes, localIdBytes.length, param, param.length, privKey, privKey.length, hibeMsg, hibeMsg.length, keyType);
            }
            catch (SdkException e) {
                throw new SdkException("DecryptHibeMsg err : " + e.getMessage());
            }
            if (decryptMsg.r1 != -1L) {
                byte[] byArray = decryptMsg.r0.getByteArray(0L, (int)decryptMsg.r1);
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            String os;
            if (decryptMsg != null && decryptMsg.getPointer() != null && !(os = System.getProperty("os.name")).toLowerCase().startsWith("win") && decryptMsg.r0 != null) {
                Native.free((long)Pointer.nativeValue((Pointer)decryptMsg.r0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readKey(String file) throws UnsupportedEncodingException, ChainMakerCryptoSuiteException {
        GoBytes.ByValue curve = null;
        try {
            curve = HibeBase.getHibeInterface().ReadKey(new GoString.ByValue(file));
            if (curve.r1 != -1L) {
                byte[] byArray = curve.r0.getByteArray(0L, (int)curve.r1);
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            String os = System.getProperty("os.name");
            if (!os.toLowerCase().startsWith("win") && curve != null && curve.getPointer() != null) {
                Native.free((long)Pointer.nativeValue((Pointer)curve.r0));
            }
        }
    }

    public static void printHex(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() != 1) continue;
            hex = '0' + hex;
            System.out.print(hex);
        }
        System.out.println();
    }
}

