/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk.serialize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chainmaker.sdk.serialize.EasyCodecItem;
import org.chainmaker.sdk.serialize.EasyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyCodecHelper {
    private List<EasyCodecItem> items = new ArrayList<EasyCodecItem>();
    private Map<String, EasyCodecItem> map = new HashMap<String, EasyCodecItem>();
    private static final Logger logger = LoggerFactory.getLogger(EasyCodecHelper.class);

    public List<EasyCodecItem> getItems() {
        return this.items;
    }

    private void initMap() {
        if (this.map.size() == 0) {
            for (int i = 0; i < this.items.size(); ++i) {
            }
        }
    }

    public int getInt(String key) {
        return (Integer)this.map.get(key).getValue();
    }

    public String getString(String key) {
        return String.valueOf(this.map.get(key).getValue());
    }

    public byte[] getBytes(String key) {
        return (byte[])this.map.get(key).getValue();
    }

    public EasyCodecHelper addInt(String key, int val) {
        this.addItem(EasyType.EasyKeyTypeUser, key, EasyType.EasyValueTypeInt, val);
        return this;
    }

    public EasyCodecHelper addString(String key, String val) {
        this.addItem(EasyType.EasyKeyTypeUser, key, EasyType.EasyValueTypeString, val);
        return this;
    }

    public EasyCodecHelper addBytes(String key, byte[] val) {
        this.addItem(EasyType.EasyKeyTypeUser, key, EasyType.EasyValueTypeBytes, val);
        return this;
    }

    private void addItem(EasyType keyType, String key, EasyType valType, Object val) {
        EasyCodecItem item = new EasyCodecItem();
        item.setKeyType(keyType);
        item.setKey(key);
        item.setValueType(valType);
        item.setValue(val);
        this.items.add(item);
        this.map.put(item.getKey(), item);
    }

    public byte[] EasyMarshal() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] tmpBytes = null;
        out.write(EasyCodecHelper.intToByte(this.items.size()));
        block5: for (int i = 0; i < this.items.size(); ++i) {
            EasyCodecItem item = this.items.get(i);
            if (item.getKeyType() != EasyType.EasyKeyTypeSystem && item.getKeyType() != EasyType.EasyKeyTypeUser) continue;
            out.write(EasyCodecHelper.intToByte(item.getKeyType().type()));
            tmpBytes = item.getKey().getBytes(StandardCharsets.UTF_8);
            out.write(EasyCodecHelper.intToByte(tmpBytes.length));
            out.write(tmpBytes);
            out.write(EasyCodecHelper.intToByte(item.getValueType().type()));
            switch (item.getValueType()) {
                case EasyValueTypeInt: {
                    int valInt = (Integer)item.getValue();
                    byte[] intBytes = EasyCodecHelper.intToByte(valInt);
                    out.write(EasyCodecHelper.intToByte(intBytes.length));
                    out.write(intBytes);
                    continue block5;
                }
                case EasyValueTypeString: {
                    String valStr = String.valueOf(item.getValue());
                    byte[] strBytes = valStr.getBytes(StandardCharsets.UTF_8);
                    out.write(EasyCodecHelper.intToByte(strBytes.length));
                    out.write(strBytes);
                    continue block5;
                }
                case EasyValueTypeBytes: {
                    byte[] bytes = (byte[])item.getValue();
                    out.write(EasyCodecHelper.intToByte(bytes.length));
                    out.write(bytes);
                    continue block5;
                }
                default: {
                    throw new RuntimeException("EasyCodec value type " + (Object)((Object)item.getValueType()) + " no match");
                }
            }
        }
        out.flush();
        return out.toByteArray();
    }

    public static EasyCodecHelper easyUnmarshal(byte[] bytes) throws IOException {
        EasyCodecHelper helper = new EasyCodecHelper();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        int length = EasyCodecHelper.readInt(is);
        if (length > 100000) {
            throw new RuntimeException("length " + length);
        }
        if (length == 0) {
            return helper;
        }
        for (int i = 0; i < length; ++i) {
            EasyCodecItem item = new EasyCodecItem();
            int keyType = EasyCodecHelper.readInt(is);
            int keyLen = EasyCodecHelper.readInt(is);
            byte[] keyBytes = new byte[keyLen];
            int count = is.read(keyBytes);
            if (count <= 0) {
                logger.warn("===================is.read fail================");
            }
            String key = new String(keyBytes, StandardCharsets.UTF_8);
            item.setKeyType(keyType == EasyType.EasyKeyTypeSystem.type() ? EasyType.EasyKeyTypeSystem : EasyType.EasyKeyTypeUser);
            item.setKey(key);
            int valType = EasyCodecHelper.readInt(is);
            int valLen = EasyCodecHelper.readInt(is);
            if (valType == EasyType.EasyValueTypeInt.type()) {
                int valInt = EasyCodecHelper.readInt(is);
                item.setValue(valInt);
            } else if (valType == EasyType.EasyValueTypeString.type()) {
                byte[] valBytes = new byte[valLen];
                count = is.read(valBytes);
                if (count <= 0) {
                    logger.warn("===================is.read fail================");
                }
                String valStr = new String(valBytes, StandardCharsets.UTF_8);
                item.setValue(valStr);
            } else if (valType == EasyType.EasyValueTypeBytes.type()) {
                byte[] valBytes = new byte[valLen];
                count = is.read(valBytes);
                if (count <= 0) {
                    logger.warn("===================is.read fail================");
                }
                item.setValue(valBytes);
            } else {
                throw new RuntimeException("EasyCodec value type " + valType + " no match");
            }
            helper.items.add(item);
            helper.map.put(item.getKey(), item);
        }
        return helper;
    }

    public String toJsonStr() {
        int len = this.items.size();
        String str = "{";
        for (int i = 0; i < len; ++i) {
            EasyCodecItem item = this.items.get(i);
            str = str + "\"" + item.getKey() + "\":\"" + item.getValue() + "\",";
        }
        if (str.length() > 1) {
            str = str.substring(0, str.length() - 1);
        }
        str = str + "}";
        return str;
    }

    private static int readInt(ByteArrayInputStream is) throws IOException {
        byte[] bytes = new byte[4];
        int count = is.read(bytes);
        if (count <= 0) {
            logger.warn("===================is.read fail================");
        }
        return EasyCodecHelper.bytesToInt(bytes);
    }

    public static int bytesToInt(byte[] bytes) {
        int a = bytes[0] & 0xFF;
        int b = (bytes[1] & 0xFF) << 8;
        int c = (bytes[3] & 0xFF) << 24;
        int d = (bytes[2] & 0xFF) << 16;
        return a | b | c | d;
    }

    public static byte[] intToByte(int n) {
        byte[] b = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return b;
    }
}

