/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk.serialize;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.chainmaker.sdk.serialize.EasyCodecHelper;
import org.chainmaker.sdk.serialize.EasyCodecItem;

public class EasyCodecTest {
    public static void main(String[] args) throws Exception {
        System.out.println("===================data===================");
        EasyCodecHelper helper = new EasyCodecHelper();
        helper.addInt("key1", 123);
        helper.addString("keyStr", "chainmaker\u957f\u5b89\u94fe");
        helper.addBytes("bytes", "1".getBytes(StandardCharsets.UTF_8));
        int val1 = helper.getInt("key1");
        String val2 = helper.getString("keyStr");
        byte[] val3 = helper.getBytes("bytes");
        System.out.println("key1=" + val1);
        System.out.println("keyStr=" + val2);
        System.out.println("bytes=" + new String(val3, StandardCharsets.UTF_8));
        for (int i = 0; i < val3.length; ++i) {
            System.out.print(val3[i] + " ");
        }
        System.out.println();
        System.out.println("obj to json: " + helper.toJsonStr());
        System.out.println("===================marshal================");
        byte[] bytes = helper.EasyMarshal();
        System.out.println("marshal: " + bytes);
        for (int i = 0; i < bytes.length; ++i) {
            System.out.print(bytes[i] + " ");
        }
        System.out.println();
        System.out.println("===================unmarshal==============");
        EasyCodecHelper helper2 = EasyCodecHelper.easyUnmarshal(bytes);
        System.out.println("obj to json: " + helper2.toJsonStr());
        byte[] val34 = helper2.getBytes("bytes");
        System.out.println("key1=" + helper2.getInt("key1"));
        System.out.println("keyStr=" + helper2.getString("keyStr"));
        System.out.println("bytes=" + new String(val34, StandardCharsets.UTF_8));
        for (int i = 0; i < val34.length; ++i) {
            System.out.print(val34[i] + " ");
        }
        EasyCodecItem ii = new EasyCodecItem();
        ii.setValue("1".getBytes(StandardCharsets.UTF_8));
    }

    public static void readFromFile() throws IOException {
        System.out.println("===================readFileFromGo================");
        File file = new File("C:\\Users\\51578\\Desktop\\\u4e34\u65f6\\go-java-byte\\tmpGo");
        byte[] bytes = FileUtils.readFileToByteArray((File)file);
        EasyCodecHelper h = EasyCodecHelper.easyUnmarshal(bytes);
        byte[] val3 = h.getBytes("bytes");
        System.out.println("bytes=" + new String(val3, StandardCharsets.UTF_8));
        for (int i = 0; i < val3.length; ++i) {
            System.out.print(val3[i] + " ");
        }
        System.out.println("readFileFromGo unmarshal to json" + h.toJsonStr());
        System.out.println("===================readFileFromGo================");
    }

    public static void writeToFile(byte[] bytes) throws IOException {
        System.out.println("===================writeToFile================");
        File file = new File("C:\\Users\\51578\\Desktop\\\u4e34\u65f6\\go-java-byte\\tmpJava");
        if (!file.createNewFile()) {
            System.out.println("===================createNewFile fail===================");
        }
        FileUtils.writeByteArrayToFile((File)file, (byte[])bytes);
        System.out.println("===================writeToFile================");
    }
}

