/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk.sync;

import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.chainmaker.pb.common.ChainmakerBlock;
import org.chainmaker.pb.common.ChainmakerTransaction;
import org.chainmaker.pb.common.ResultOuterClass;
import org.chainmaker.sdk.ChainClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxResultDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(TxResultDispatcher.class);
    private long nextBlockNum = -1L;
    private Status status;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final ChainClient chainClient;
    private final ConcurrentHashMap<String, Result> result = new ConcurrentHashMap();
    private long rpcCallTimeout = 5000L;

    public TxResultDispatcher(ChainClient chainClient) {
        this.status = Status.START;
        this.chainClient = chainClient;
    }

    public void stop() {
        this.status = Status.STOP;
        this.executorService.shutdown();
    }

    public void register(String txId) {
        this.result.put(txId, new Result());
    }

    public void unregister(String txId) {
        this.result.remove(txId);
    }

    public ChainmakerTransaction.Transaction getResult(String txId, long timeout) {
        long deadLine = System.currentTimeMillis() + timeout;
        ChainmakerTransaction.Transaction tx = null;
        while ((tx = this.result.get(txId).getTx()) == null && System.currentTimeMillis() < deadLine) {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (tx == null) {
            logger.error("get txid {}  timeout...{}", (Object)txId, (Object)timeout);
        }
        return tx;
    }

    public void start() {
        try {
            ChainmakerBlock.BlockInfo block = this.chainClient.getLastBlock(false, this.rpcCallTimeout);
            long blockHeight = block.getBlock().getHeader().getBlockHeight();
            if (blockHeight > 0L) {
                this.nextBlockNum = blockHeight;
            }
            logger.info("subscribe get last height {} ", (Object)this.nextBlockNum);
        }
        catch (Exception e) {
            logger.warn("subscribe get last height {} ", (Object)e.getMessage());
        }
        this.executorService.execute(new AutoSubscribe());
    }

    static enum Status {
        START(0),
        STOP(1);

        private final Integer type;

        private Status(int type) {
            this.type = type;
        }

        public int type() {
            return this.type;
        }
    }

    class AutoSubscribe
    implements Runnable {
        final StreamObserver<ResultOuterClass.SubscribeResult> responseObserver = new StreamObserver<ResultOuterClass.SubscribeResult>(){

            public void onNext(ResultOuterClass.SubscribeResult value) {
                ChainmakerBlock.BlockInfo blockInfo;
                try {
                    blockInfo = ChainmakerBlock.BlockInfo.parseFrom(value.getData());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
                List<ChainmakerTransaction.Transaction> txs = blockInfo.getBlock().getTxsList();
                int size = txs.size();
                for (int i = 0; i < size; ++i) {
                    ChainmakerTransaction.Transaction tx = txs.get(i);
                    String txId = tx.getPayload().getTxId();
                    if (!TxResultDispatcher.this.result.containsKey(txId)) continue;
                    ((Result)TxResultDispatcher.this.result.get(txId)).setTx(tx);
                }
                TxResultDispatcher.this.nextBlockNum = blockInfo.getBlock().getHeader().getBlockHeight() + 1L;
            }

            public void onError(Throwable t) {
                try {
                    Thread.sleep(100L);
                    if (TxResultDispatcher.this.nextBlockNum > 0L) {
                        TxResultDispatcher.this.nextBlockNum--;
                    }
                    TxResultDispatcher.this.chainClient.subscribeBlock(TxResultDispatcher.this.nextBlockNum, -1L, true, false, AutoSubscribe.this.responseObserver);
                }
                catch (Exception e) {
                    logger.error("=======subscribeBlock err:{}", (Object)e.getMessage());
                }
            }

            public void onCompleted() {
                logger.info("==========onCompleted========");
            }
        };

        AutoSubscribe() {
        }

        @Override
        public void run() {
            try {
                TxResultDispatcher.this.chainClient.subscribeBlock(TxResultDispatcher.this.nextBlockNum, -1L, true, false, this.responseObserver);
            }
            catch (Exception e) {
                logger.error("=======subscribeBlock err:{}", (Object)e.getMessage());
            }
        }
    }

    class Result {
        ChainmakerTransaction.Transaction tx;

        Result() {
        }

        public ChainmakerTransaction.Transaction getTx() {
            return this.tx;
        }

        public void setTx(ChainmakerTransaction.Transaction tx) {
            this.tx = tx;
        }
    }
}

