/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.chainmaker.pb.config.ChainConfigOuterClass;
import org.chainmaker.sdk.crypto.ChainMakerCryptoSuiteException;
import org.chainmaker.sdk.utils.UtilsException;
import org.web3j.crypto.Hash;

public class CryptoUtils {
    private static final int ZX_ADDR_SUFFIX_LENGTH = 20;
    private static final String ZX_ADDR_PREFIX = "ZX";
    private static final String RSA_PRE = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A";
    private static final String HEX_ADDR_PREFIX = "0x";
    private static final String SECP256R1 = "secp256r1";
    private static final String SECP = "secp";

    private CryptoUtils() {
        throw new IllegalStateException("Crypto Utils class");
    }

    public static PrivateKey getPrivateKeyFromBytes(byte[] pemKey) throws ChainMakerCryptoSuiteException {
        PrivateKey pk = null;
        try {
            PemReader pr = new PemReader((Reader)new StringReader(new String(pemKey)));
            PemObject po = pr.readPemObject();
            PEMParser pem = new PEMParser((Reader)new StringReader(new String(pemKey)));
            if (po.getType().equals("PRIVATE KEY")) {
                pk = new JcaPEMKeyConverter().getPrivateKey((PrivateKeyInfo)pem.readObject());
            } else {
                if (po.getType().equals("EC PRIVATE KEY")) {
                    ASN1Sequence sequence = ASN1Sequence.getInstance((Object)po.getContent());
                    org.bouncycastle.asn1.sec.ECPrivateKey ecPrivateKey = org.bouncycastle.asn1.sec.ECPrivateKey.getInstance((Object)sequence);
                    ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)SECP256R1);
                    ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(ecPrivateKey.getKey(), (ECParameterSpec)spec);
                    KeyFactory factory = KeyFactory.getInstance("ECDSA", "BC");
                    return factory.generatePrivate((KeySpec)ecPrivateKeySpec);
                }
                PEMKeyPair kp = (PEMKeyPair)pem.readObject();
                pk = new JcaPEMKeyConverter().getPrivateKey(kp.getPrivateKeyInfo());
            }
        }
        catch (Exception e) {
            throw new ChainMakerCryptoSuiteException(e.toString());
        }
        return pk;
    }

    public static PublicKey getPublicKeyFromPrivateKey(PrivateKey privateKey) throws ChainMakerCryptoSuiteException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        PublicKey publicKey;
        String algo = privateKey.getAlgorithm();
        if ("RSA".equals(algo)) {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            RSAPrivateKeySpec rsaPrivateKeySpec = kf.getKeySpec(privateKey, RSAPrivateKeySpec.class);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(rsaPrivateKeySpec.getModulus(), BigInteger.valueOf(65537L));
            publicKey = kf.generatePublic(keySpec);
        } else if ("ECDSA".equals(algo) || "EC".equals(algo)) {
            KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
            ECPrivateKey ecPrivateKey = (ECPrivateKey)privateKey;
            ECParameterSpec ecSpec = ecPrivateKey.getParameters();
            ECPoint Q = ecSpec.getG().multiply(ecPrivateKey.getD());
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(Q, ecSpec);
            publicKey = keyFactory.generatePublic((KeySpec)pubSpec);
        } else {
            throw new ChainMakerCryptoSuiteException("Not support private key for algorithm: " + algo);
        }
        return publicKey;
    }

    @Deprecated
    public static String makeAddrFromPubKeyPem(PublicKey publicKey) throws IOException {
        byte[] encoded = publicKey.getEncoded();
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(ASN1Sequence.getInstance((Object)encoded));
        byte[] subjectPublicKeyEncoded = subjectPublicKeyInfo.parsePublicKey().getEncoded();
        SHA256Digest digest = new SHA256Digest();
        byte[] retValue = new byte[digest.getDigestSize()];
        digest.update(subjectPublicKeyEncoded, 0, subjectPublicKeyEncoded.length);
        digest.doFinal(retValue, 0);
        String ski = Hex.toHexString((byte[])retValue);
        byte[] data = Hex.decode((String)ski);
        Keccak.Digest256 kecc = new Keccak.Digest256();
        kecc.update(data, 0, data.length);
        byte[] address = kecc.digest();
        String addr = Hex.toHexString((byte[])address);
        return HEX_ADDR_PREFIX + addr.substring(24);
    }

    @Deprecated
    public static String makeAddrFromCert(java.security.cert.Certificate certificate) throws UtilsException {
        ByteArrayInputStream bIn = null;
        try {
            bIn = new ByteArrayInputStream(certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new UtilsException("certificate to ByteArrayInputStream err : " + e.getMessage());
        }
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        ASN1Sequence seq = null;
        try {
            seq = (ASN1Sequence)aIn.readObject();
        }
        catch (IOException e) {
            throw new UtilsException("certificate to ASN1Sequence err : " + e.getMessage());
        }
        Certificate obj = Certificate.getInstance((Object)seq);
        TBSCertificate tbsCertificate = obj.getTBSCertificate();
        Extensions ext = tbsCertificate.getExtensions();
        SubjectKeyIdentifier si = SubjectKeyIdentifier.fromExtensions((Extensions)ext);
        String ski = Hex.toHexString((byte[])si.getKeyIdentifier());
        byte[] data = Hex.decode((String)ski);
        Keccak.Digest256 kecc = new Keccak.Digest256();
        kecc.update(data, 0, data.length);
        byte[] address = kecc.digest();
        String addr = Hex.toHexString((byte[])address);
        return HEX_ADDR_PREFIX + addr.substring(24);
    }

    public static String getPemStrFromPublicKey(PublicKey publicKey) throws UtilsException {
        StringWriter writer = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)writer);
        try {
            pemWriter.writeObject((PemObjectGenerator)new PemObject("PUBLIC KEY", publicKey.getEncoded()));
            pemWriter.flush();
            pemWriter.close();
        }
        catch (IOException e) {
            throw new UtilsException("publicKey parse to pem err :" + e.getMessage());
        }
        return writer.toString();
    }

    public static String getZXAddressFromPKPEM(String pk) throws UtilsException {
        pk = pk.replace(RSA_PRE, "");
        PemReader pr = new PemReader((Reader)new StringReader(new String(pk)));
        PemObject po = null;
        byte[] plainText = null;
        try {
            po = pr.readPemObject();
            RSAPublicKey rsaPublicKey = RSAPublicKey.getInstance((Object)po.getContent());
            plainText = rsaPublicKey.toASN1Primitive().getEncoded();
        }
        catch (IOException e) {
            throw new UtilsException("publicKey parse to addr err :" + e.getMessage());
        }
        SM3Digest digest = new SM3Digest();
        byte[] retValue = new byte[digest.getDigestSize()];
        digest.update(plainText, 0, plainText.length);
        digest.doFinal(retValue, 0);
        byte[] addrBytes = new byte[20];
        System.arraycopy(retValue, 0, addrBytes, 0, 20);
        return ZX_ADDR_PREFIX + Hex.toHexString((byte[])addrBytes);
    }

    public static String getEVMAddressFromCertBytes(byte[] certBytes) {
        java.security.cert.Certificate certificate = CryptoUtils.parseCertificate(certBytes);
        try {
            return CryptoUtils.certToAddrStr(certificate, ChainConfigOuterClass.AddrType.ETHEREUM);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getEVMAddressFromPrivateKeyBytes(byte[] privateKey, String hashType) {
        PublicKey publicKey = null;
        try {
            publicKey = CryptoUtils.getPublicKeyFromPrivateKey(CryptoUtils.getPrivateKeyFromBytes(privateKey));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException | ChainMakerCryptoSuiteException e) {
            throw new RuntimeException(e);
        }
        return CryptoUtils.pkToAddrStr(publicKey, ChainConfigOuterClass.AddrType.ETHEREUM, hashType);
    }

    public static String getEVMAddressFromPKHex(String pkHex, String hashType, String algo) {
        PublicKey publicKey = CryptoUtils.hexToPublicKey(pkHex, algo);
        return CryptoUtils.pkToAddrStr(publicKey, ChainConfigOuterClass.AddrType.ETHEREUM, hashType);
    }

    public static String getEVMAddressFromPKPEM(String pkPem, String hashType, String algo) {
        PublicKey publicKey = CryptoUtils.publicKeyFromPem(pkPem, algo);
        return CryptoUtils.pkToAddrStr(publicKey, ChainConfigOuterClass.AddrType.ETHEREUM, hashType);
    }

    public static String getZXAddressFromPKHex(String pkHex, String hashType, String algo) {
        PublicKey publicKey = CryptoUtils.hexToPublicKey(pkHex, algo);
        return ZX_ADDR_PREFIX + CryptoUtils.pkToAddrStr(publicKey, ChainConfigOuterClass.AddrType.ZXL, hashType);
    }

    public static String getZXAddressFromPKPEM(String pkPem, String hashType, String algo) {
        PublicKey publicKey = CryptoUtils.publicKeyFromPem(pkPem, algo);
        return ZX_ADDR_PREFIX + CryptoUtils.pkToAddrStr(publicKey, ChainConfigOuterClass.AddrType.ZXL, hashType);
    }

    public static String getZXAddressFromCertPEM(String certPem) {
        String addr;
        java.security.cert.Certificate certificate = CryptoUtils.parseCertificate(certPem.getBytes(StandardCharsets.UTF_8));
        try {
            addr = CryptoUtils.certToAddrStr(certificate, ChainConfigOuterClass.AddrType.ZXL);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        return ZX_ADDR_PREFIX + addr;
    }

    public static String getCMAddressFromPKHex(String pkHex, String hashType, String algo) {
        PublicKey publicKey = CryptoUtils.hexToPublicKey(pkHex, algo);
        return CryptoUtils.pkToAddrStr(publicKey, ChainConfigOuterClass.AddrType.CHAINMAKER, hashType);
    }

    public static String getCMAddressFromPKPEM(String pkPem, String hashType, String algo) {
        PublicKey publicKey = CryptoUtils.publicKeyFromPem(pkPem, algo);
        return CryptoUtils.pkToAddrStr(publicKey, ChainConfigOuterClass.AddrType.CHAINMAKER, hashType);
    }

    public static String getCMAddressFromCertPEM(String certPem) {
        java.security.cert.Certificate certificate = CryptoUtils.parseCertificate(certPem.getBytes());
        Object addr = null;
        try {
            return CryptoUtils.certToAddrStr(certificate, ChainConfigOuterClass.AddrType.CHAINMAKER);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    private static String generteAddrStr(byte[] data, ChainConfigOuterClass.AddrType addrType) {
        if (addrType == ChainConfigOuterClass.AddrType.ZXL) {
            String zxAddress = CryptoUtils.zxAddress(data);
            return zxAddress.substring(2);
        }
        byte[] bytesAddr = CryptoUtils.keccak256(data);
        return Hex.toHexString((byte[])bytesAddr).substring(24);
    }

    public static String nameToAddrStr(String data, ChainConfigOuterClass.AddrType addrType) {
        byte[] res = data.getBytes();
        if (addrType == ChainConfigOuterClass.AddrType.ZXL) {
            SM3Digest digest = new SM3Digest();
            byte[] dataBytes = data.getBytes();
            digest.update(dataBytes, 0, dataBytes.length);
            byte[] result = new byte[digest.getDigestSize()];
            digest.doFinal(result, 0);
            return CryptoUtils.generteAddrStr(result, addrType);
        }
        res = CryptoUtils.keccak256(res);
        return CryptoUtils.generteAddrStr(res, addrType);
    }

    public static String pkToAddrStr(PublicKey publicKey, ChainConfigOuterClass.AddrType addrType, String hashType) {
        if (addrType == ChainConfigOuterClass.AddrType.CHAINMAKER) {
            byte[] encoded = publicKey.getEncoded();
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)ASN1Sequence.getInstance((Object)encoded));
            byte[] subjectPublicKeyEncoded = subjectPublicKeyInfo.getPublicKeyData().getBytes();
            byte[] data = Hash.hash((byte[])subjectPublicKeyEncoded, (String)hashType);
            return CryptoUtils.generteAddrStr(data, addrType);
        }
        byte[] result = CryptoUtils.marshalPublicKey(publicKey);
        if (addrType == ChainConfigOuterClass.AddrType.ETHEREUM) {
            byte[] dest = new byte[result.length - 1];
            System.arraycopy(result, 1, dest, 0, result.length - 1);
            return CryptoUtils.generteAddrStr(dest, addrType);
        }
        return CryptoUtils.generteAddrStr(result, addrType);
    }

    public static String certToAddrStr(java.security.cert.Certificate certificate, ChainConfigOuterClass.AddrType addrType) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (addrType == ChainConfigOuterClass.AddrType.CHAINMAKER) {
            ByteArrayInputStream bIn = null;
            try {
                bIn = new ByteArrayInputStream(certificate.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
            ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
            ASN1Sequence seq = null;
            try {
                seq = (ASN1Sequence)aIn.readObject();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Certificate obj = Certificate.getInstance((Object)seq);
            TBSCertificate tbsCertificate = obj.getTBSCertificate();
            Extensions ext = tbsCertificate.getExtensions();
            SubjectKeyIdentifier si = SubjectKeyIdentifier.fromExtensions((Extensions)ext);
            return CryptoUtils.generteAddrStr(si.getKeyIdentifier(), addrType);
        }
        PublicKey publicKey = certificate.getPublicKey();
        byte[] result = CryptoUtils.marshalPublicKey(publicKey);
        if (addrType == ChainConfigOuterClass.AddrType.ETHEREUM) {
            byte[] dest = new byte[result.length - 1];
            System.arraycopy(result, 1, dest, 0, result.length - 1);
            return CryptoUtils.generteAddrStr(dest, addrType);
        }
        return CryptoUtils.generteAddrStr(result, addrType);
    }

    private static String zxAddress(byte[] data) {
        SM3Digest digest = new SM3Digest();
        digest.update(data, 0, data.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        if (result.length < 20) {
            return "";
        }
        byte[] dest = new byte[20];
        System.arraycopy(result, 0, dest, 0, 20);
        return ZX_ADDR_PREFIX + Hex.toHexString((byte[])dest);
    }

    private static byte[] keccak256(byte[] data) {
        Keccak.Digest256 keccakDigest = new Keccak.Digest256();
        return keccakDigest.digest(data);
    }

    public static PublicKey publicKeyFromPem(String pkPem, String algo) {
        KeyFactory factory = null;
        try {
            factory = KeyFactory.getInstance(algo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        PemReader pemReader = new PemReader((Reader)new StringReader(pkPem));
        PemObject pemObject = null;
        try {
            pemObject = pemReader.readPemObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] content = pemObject.getContent();
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(content);
        try {
            return factory.generatePublic(pubKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    private static PublicKey hexToPublicKey(String publicKeyHexStr, String algo) {
        KeyFactory keyFact = null;
        try {
            keyFact = KeyFactory.getInstance(algo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(new BigInteger(publicKeyHexStr, 16).toByteArray());
        try {
            return keyFact.generatePublic(x509KeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static java.security.cert.Certificate parseCertificate(byte[] cert) {
        X509Certificate ret = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream certInputStream = new ByteArrayInputStream(cert);
            ret = (X509Certificate)cf.generateCertificate(certInputStream);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    private static byte[] marshalPublicKey(PublicKey publicKey) {
        if (Objects.equals(publicKey.getAlgorithm(), "ECDSA") || Objects.equals(publicKey.getAlgorithm(), "EC")) {
            if (publicKey instanceof BCECPublicKey) {
                BCECPublicKey pubKey = (BCECPublicKey)publicKey;
                ECParameterSpec spec = pubKey.getParameters();
                return CryptoUtils.publicKeyToByte(pubKey, ((ECNamedCurveParameterSpec)spec).getName());
            }
            BCECPublicKey pubKey = new BCECPublicKey((ECPublicKey)publicKey, BouncyCastleProvider.CONFIGURATION);
            return CryptoUtils.publicKeyToByte(pubKey, pubKey.getParams().toString());
        }
        if (Objects.equals(publicKey.getAlgorithm(), "RSA")) {
            try {
                if (publicKey instanceof RSAPublicKey) {
                    return ((RSAPublicKey)publicKey).toASN1Primitive().getEncoded();
                }
                Class<?> clazz = publicKey.getClass();
                Method m1 = clazz.getMethod("getModulus", new Class[0]);
                Method m2 = clazz.getMethod("getPublicExponent", new Class[0]);
                BigInteger modulus = (BigInteger)m1.invoke((Object)publicKey, new Object[0]);
                BigInteger publicExponent = (BigInteger)m2.invoke((Object)publicKey, new Object[0]);
                RSAPublicKey rsaPublicKey = new RSAPublicKey(modulus, publicExponent);
                return rsaPublicKey.toASN1Primitive().getEncoded();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new byte[0];
    }

    private static byte[] publicKeyToByte(BCECPublicKey publicKey, String name) {
        if (name.contains(SECP)) {
            return CryptoUtils.ecPublickeyToByte(publicKey);
        }
        try {
            return CryptoUtils.ecPublickeyToByte(publicKey);
        }
        catch (Exception e) {
            return CryptoUtils.sm2PublickeyToByte(publicKey);
        }
    }

    private static byte[] sm2PublickeyToByte(BCECPublicKey publicKey) {
        int length = (publicKey.getParams().getCurve().getField().getFieldSize() + 7) / 8;
        BigInteger x = publicKey.getQ().getXCoord().toBigInteger();
        BigInteger y = publicKey.getQ().getYCoord().toBigInteger();
        byte[] a = x.abs().toByteArray();
        byte[] b = y.abs().toByteArray();
        byte[] result = new byte[1 + 2 * length];
        result[0] = 4;
        System.arraycopy(a, 0, result, 1, length);
        System.arraycopy(b, 0, result, length + 1, length);
        return result;
    }

    private static byte[] ecPublickeyToByte(BCECPublicKey publicKey) {
        int length = (publicKey.getParams().getCurve().getField().getFieldSize() + 7) / 8;
        byte[] x = publicKey.getQ().getXCoord().getEncoded();
        byte[] y = publicKey.getQ().getYCoord().getEncoded();
        byte[] result = new byte[1 + 2 * length];
        result[0] = 4;
        System.arraycopy(x, 0, result, 1, length);
        System.arraycopy(y, 0, result, length + 1, length);
        return result;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

