/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk.utils;

import com.google.common.io.Resources;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.chainmaker.sdk.utils.UtilsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static byte[] getResourceFileBytes(String resourcePath) throws UtilsException {
        byte[] fileBytes = null;
        String protocol = Objects.requireNonNull(FileUtils.class.getResource("")).getProtocol();
        if (Objects.equals(protocol, "jar")) {
            try {
                fileBytes = FileUtils.getFileBytes(resourcePath);
                return fileBytes;
            }
            catch (Exception e) {
                logger.warn("jar get file fail, msg :{}", (Object)e.getMessage());
                try {
                    fileBytes = IOUtils.toByteArray((InputStream)Objects.requireNonNull(FileUtils.class.getClassLoader().getResourceAsStream(resourcePath)));
                    return fileBytes;
                }
                catch (Exception e2) {
                    logger.warn("jar two get file fail, msg :{}", (Object)e2.getMessage());
                }
            }
        }
        try {
            fileBytes = IOUtils.toByteArray((InputStream)((BufferedInputStream)Resources.getResource((String)resourcePath).getContent()));
        }
        catch (IOException e) {
            throw new UtilsException("get file by path err : " + e.getMessage());
        }
        return fileBytes;
    }

    public static byte[] getFileOrResourceFileBytes(String path) throws UtilsException {
        try {
            return FileUtils.getFileBytes(path);
        }
        catch (UtilsException e) {
            logger.warn("get file fail, msg :{}", (Object)e.getMessage());
            return FileUtils.getResourceFileBytes(path);
        }
    }

    public static byte[] getFileBytes(String filePath) throws UtilsException {
        byte[] fileBytes = null;
        File f = null;
        try {
            f = new File(filePath);
            fileBytes = IOUtils.toByteArray((InputStream)new FileInputStream(f));
        }
        catch (IOException e) {
            if (f != null) {
                System.out.println(f.getAbsolutePath());
            }
            throw new UtilsException("get file by path err : " + e.getMessage());
        }
        return fileBytes;
    }

    public static List<String> getFilesByPath(String path) {
        ArrayList<String> files = new ArrayList<String>();
        File file = new File(path);
        File[] tempList = file.listFiles();
        if (tempList != null) {
            for (File value : tempList) {
                if (!value.isFile() || !value.getName().contains(".crt")) continue;
                files.add(value.toString());
            }
        }
        return files;
    }

    public static String getResourceFilePath(String resourcePath) {
        return System.getProperty("user.dir") + "/src/main/resources/" + resourcePath;
    }

    public static boolean isFileExist(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }
}

