/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk.utils;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static final String REQUEST_METHOD = "POST";
    private static final String REQUEST_CONTENT_TYPE = "Content-type";
    private static final String REQUEST_CONTENT_TYPE_BODY = "application/json";
    private static final String REQUEST_CONTENT_TYPE_VALUE = "text/plain";
    private static final String REQUEST_CHARSET = "Accept-Charset";
    private static final String REQUEST_CHARSET_VALUE = "UTF-8";
    private static final String REQUEST_CONTENT_LENGTH = "Content-Length";

    public static String get(String u, int readTimeOut, int connectTimeOut) throws IOException {
        String line;
        String result = "";
        BufferedReader in = null;
        URL realUrl = new URL(u);
        URLConnection connection = realUrl.openConnection();
        connection.setReadTimeout(readTimeOut);
        connection.setConnectTimeout(connectTimeOut);
        connection.connect();
        in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
        while ((line = in.readLine()) != null) {
            result = result + line;
        }
        if (in != null) {
            in.close();
        }
        return result;
    }

    public static String post(String u, String str, int readTimeOut, int connectTimeOut) throws IOException {
        URL url = new URL(u);
        DataOutputStream printout = null;
        HttpURLConnection huc = (HttpURLConnection)url.openConnection();
        huc.setRequestMethod(REQUEST_METHOD);
        huc.setRequestProperty(REQUEST_CONTENT_TYPE, REQUEST_CONTENT_TYPE_BODY);
        huc.setRequestProperty(REQUEST_CONTENT_LENGTH, String.valueOf(str.getBytes().length));
        huc.setDoOutput(true);
        huc.setReadTimeout(readTimeOut);
        huc.setConnectTimeout(connectTimeOut);
        printout = new DataOutputStream(huc.getOutputStream());
        printout.write(str.getBytes());
        printout.flush();
        if (printout != null) {
            try {
                printout.close();
            }
            catch (IOException e) {
                logger.error("http close printout error:", (Throwable)e);
            }
        }
        StringBuffer sb = new StringBuffer();
        InputStream is = null;
        BufferedReader br = null;
        try {
            String line;
            is = huc.getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (IOException e) {
            logger.error("http input stream error:", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    is.close();
                }
                if (huc != null) {
                    huc.disconnect();
                }
            }
            catch (IOException e) {
                logger.error("http close input stream error:", (Throwable)e);
                return null;
            }
        }
        return sb.toString();
    }
}

