/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.zayk.mmk.ECCSignature;
import com.zayk.mmk.ECCrefPublicKey;
import com.zayk.mmk.StructTransform;
import com.zayk.mmk.ZAYKSDFLibrary;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.chainmaker.pb.accesscontrol.MemberOuterClass;
import org.chainmaker.pb.common.ContractOuterClass;
import org.chainmaker.pb.common.Request;
import org.chainmaker.sdk.ChainClientException;
import org.chainmaker.sdk.User;
import org.chainmaker.sdk.config.AuthType;
import org.chainmaker.sdk.crypto.ChainMakerCryptoSuiteException;
import org.chainmaker.sdk.utils.CryptoUtils;
import org.chainmaker.sdk.utils.UtilsException;

public class SdkUtils {
    private static final int RS_LEN = 32;
    private static final int HSM_MAX_LEN = 8192;

    public static Request.EndorsementEntry[] getEndorsers(Request.Payload payload, User[] users) throws ChainMakerCryptoSuiteException, UtilsException {
        return SdkUtils.getEndorsers(payload, users, "");
    }

    public static Request.EndorsementEntry[] getEndorsers(Request.Payload payload, User[] users, String hash) throws ChainMakerCryptoSuiteException, UtilsException {
        Request.EndorsementEntry[] endorsementEntries = new Request.EndorsementEntry[users.length];
        for (int i = 0; i < users.length; ++i) {
            Request.EndorsementEntry entry;
            endorsementEntries[i] = entry = SdkUtils.signPayload(users[i], payload.toByteArray(), hash);
        }
        return endorsementEntries;
    }

    public static Request.EndorsementEntry signPayload(Request.Payload payload, User user) throws ChainMakerCryptoSuiteException, UtilsException {
        return SdkUtils.signPayload(user, payload.toByteArray(), "");
    }

    public static Request.EndorsementEntry signPayload(Request.Payload payload, User user, String hash) throws ChainMakerCryptoSuiteException, UtilsException {
        return SdkUtils.signPayload(user, payload.toByteArray(), hash);
    }

    private static Request.EndorsementEntry signPayload(User user, byte[] payload, String hash) throws ChainMakerCryptoSuiteException, UtilsException {
        if (user.getAuthType().equals(AuthType.PermissionedWithCert.getMsg())) {
            byte[] signature = null;
            signature = !user.isPkcs11Enable() ? user.getCryptoSuite().sign(user.getPrivateKey(), payload) : user.getCryptoSuite().signWithCustom(payload, user.getKeys());
            return Request.EndorsementEntry.newBuilder().setSignature(ByteString.copyFrom((byte[])signature)).setSigner(SdkUtils.getSerializedMember(user)).build();
        }
        return Request.EndorsementEntry.newBuilder().setSignature(ByteString.copyFrom((byte[])user.getCryptoSuite().rsaSign(CryptoUtils.getPrivateKeyFromBytes(user.getPriBytes()), payload, hash))).setSigner(SdkUtils.getSerializedMember(user.getOrgId(), user.getPriBytes())).build();
    }

    public static MemberOuterClass.Member getSerializedMember(User user) {
        return MemberOuterClass.Member.newBuilder().setOrgId(user.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])user.getCertBytes())).setMemberType(MemberOuterClass.MemberType.CERT).build();
    }

    public static MemberOuterClass.Member getSerializedMember(String orgId, byte[] pkBytes) throws UtilsException {
        return MemberOuterClass.Member.newBuilder().setOrgId(orgId).setMemberInfo(ByteString.copyFrom((byte[])SdkUtils.dealRsaPk(pkBytes))).setMemberType(MemberOuterClass.MemberType.PUBLIC_KEY).build();
    }

    public static byte[] dealRsaPk(byte[] pemKey) throws UtilsException {
        PublicKey publicKey;
        try {
            PrivateKey priv = CryptoUtils.getPrivateKeyFromBytes(pemKey);
            publicKey = CryptoUtils.getPublicKeyFromPrivateKey(priv);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException | ChainMakerCryptoSuiteException e) {
            throw new UtilsException("new RSAPublicKeySpec err: " + e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        StringWriter writer = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)writer);
        try {
            pemWriter.writeObject((PemObjectGenerator)new PemObject("PUBLIC KEY", publicKey.getEncoded()));
            pemWriter.flush();
            pemWriter.close();
        }
        catch (IOException e) {
            throw new UtilsException("publicKey parse to pem err :" + e.getMessage());
        }
        return writer.toString().getBytes();
    }

    public static byte[] signWithHSM(int keyId, byte[] plainText) throws ChainMakerCryptoSuiteException {
        int rv;
        ECCSignature pucSignature;
        Pointer pSessionHandle;
        Pointer pHandle;
        block17: {
            PointerByReference ppHandle = new PointerByReference(Pointer.NULL);
            PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
            pHandle = null;
            pSessionHandle = null;
            pucSignature = new ECCSignature();
            try {
                IntByReference outDataLength;
                byte[] outData;
                ECCrefPublicKey pucPublicKey;
                rv = ZAYKSDFLibrary.SDF_OpenDevice((PointerByReference)ppHandle);
                if (rv != 0) {
                    throw new ChainMakerCryptoSuiteException("SDF_OpenDevice failed :" + rv);
                }
                pHandle = ppHandle.getValue();
                rv = ZAYKSDFLibrary.SDF_OpenSession((Pointer)pHandle, (PointerByReference)ppSessionHandle);
                if (rv != 0) {
                    throw new ChainMakerCryptoSuiteException("SDF_OpenSession failed :" + rv);
                }
                pSessionHandle = ppSessionHandle.getValue();
                rv = ZAYKSDFLibrary.SDF_ExportSignPublicKey_ECC((Pointer)pSessionHandle, (int)keyId, (ECCrefPublicKey)(pucPublicKey = new ECCrefPublicKey()));
                if (rv != 0) {
                    throw new ChainMakerCryptoSuiteException("SDF_ExportSignPublicKey_ECC failed :" + rv);
                }
                rv = ZAYKSDFLibrary.SDF_HashInit((Pointer)pSessionHandle, (int)1, (ECCrefPublicKey)pucPublicKey, (byte[])"1234567812345678".getBytes(), (int)16);
                if (rv != 0) {
                    throw new ChainMakerCryptoSuiteException("SDF_HashInit failed :" + rv);
                }
                byte[] plainText8k = null;
                if (plainText.length <= 8192) {
                    rv = ZAYKSDFLibrary.SDF_HashUpdate((Pointer)pSessionHandle, (byte[])plainText, (int)plainText.length);
                    if (rv != 0) {
                        throw new ChainMakerCryptoSuiteException("SDF_HashUpdate failed :" + rv);
                    }
                } else {
                    for (int i = 0; i < plainText.length / 8192 + 1; ++i) {
                        if (!(i == plainText.length / 8192 ? (rv = ZAYKSDFLibrary.SDF_HashUpdate((Pointer)pSessionHandle, (byte[])(plainText8k = Arrays.copyOfRange((byte[])plainText, (int)(i * 8192), (int)plainText.length)), (int)plainText8k.length)) != 0 : (rv = ZAYKSDFLibrary.SDF_HashUpdate((Pointer)pSessionHandle, (byte[])(plainText8k = Arrays.copyOfRange((byte[])plainText, (int)(i * 8192), (int)((i + 1) * 8192))), (int)plainText8k.length)) != 0)) continue;
                        throw new ChainMakerCryptoSuiteException("SDF_HashUpdate failed :" + rv);
                    }
                }
                if ((rv = ZAYKSDFLibrary.SDF_HashFinal((Pointer)pSessionHandle, (byte[])(outData = new byte[32]), (IntByReference)(outDataLength = new IntByReference()))) != 0) {
                    throw new ChainMakerCryptoSuiteException("SDF_HashFinal failed :" + rv);
                }
                rv = ZAYKSDFLibrary.SDF_InternalSign_ECC((Pointer)pSessionHandle, (int)keyId, (byte[])outData, (int)outData.length, (ECCSignature)pucSignature);
                if (rv == 0) break block17;
                throw new ChainMakerCryptoSuiteException("SDF_InternalSign_ECC failed :" + rv);
            }
            catch (ChainMakerCryptoSuiteException e) {
                try {
                    throw new ChainMakerCryptoSuiteException("signWithHSM failed : " + e.getMessage());
                }
                catch (Throwable throwable) {
                    int rv2 = ZAYKSDFLibrary.SDF_CloseSession(pSessionHandle);
                    if (rv2 != 0) {
                        System.out.println("---------->SDF_CloseSession rv=" + rv2);
                    }
                    if ((rv2 = ZAYKSDFLibrary.SDF_CloseDevice((Pointer)pHandle)) != 0) {
                        System.out.println("---------->SDF_CloseDevice rv=" + rv2);
                    }
                    throw throwable;
                }
            }
        }
        rv = ZAYKSDFLibrary.SDF_CloseSession((Pointer)pSessionHandle);
        if (rv != 0) {
            System.out.println("---------->SDF_CloseSession rv=" + rv);
        }
        if ((rv = ZAYKSDFLibrary.SDF_CloseDevice((Pointer)pHandle)) != 0) {
            System.out.println("---------->SDF_CloseDevice rv=" + rv);
        }
        return SdkUtils.rsPlainByteArrayToAsn1(StructTransform.ZAYK_SignStructToByte((ECCSignature)pucSignature));
    }

    public static byte[] rsPlainByteArrayToAsn1(byte[] sign) {
        if (sign.length != 64) {
            throw new RuntimeException("err rs. ");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)0, (int)32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)32, (int)64));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        try {
            return new DERSequence(v).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ContractOuterClass.Contract parseContract(byte[] jsonContractData) throws ChainClientException {
        ContractOuterClass.Contract.Builder contractBuilder = ContractOuterClass.Contract.newBuilder();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(jsonContractData);
            new JsonFormat().merge((InputStream)is, (Message.Builder)contractBuilder);
        }
        catch (IOException e) {
            throw new ChainClientException("contract parseFrom result : " + e.getMessage());
        }
        return contractBuilder.build();
    }
}

