/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.Definition;
import org.eclipse.californium.elements.Definitions;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextUtil;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.rule.LoggingRule;
import org.eclipse.californium.elements.util.Bytes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class EndpointContextUtilTest {
    private static final InetSocketAddress ADDRESS = new InetSocketAddress(0);
    public static final Definition<String> ID = new Definition("ID", String.class, MapBasedEndpointContext.ATTRIBUTE_DEFINITIONS);
    public static final Definition<String> UNKNOWN = new Definition("UNKNOWN", String.class, MapBasedEndpointContext.ATTRIBUTE_DEFINITIONS);
    @Rule
    public LoggingRule logging = new LoggingRule();
    private EndpointContext connectorContext;
    private EndpointContext relaxedMessageContext;
    private EndpointContext strictMessageContext;
    private EndpointContext differentMessageContext;
    private EndpointContext unsecureMessageContext;
    private EndpointContext unsecureMessageContext2;

    @Before
    public void setup() {
        Bytes session = new Bytes("session".getBytes());
        Bytes newSession = new Bytes("new-session".getBytes());
        this.connectorContext = new DtlsEndpointContext(ADDRESS, null, null, session, 1, "CIPHER", 100L);
        this.relaxedMessageContext = new DtlsEndpointContext(ADDRESS, null, null, session, 2, "CIPHER", 200L);
        this.strictMessageContext = new DtlsEndpointContext(ADDRESS, null, null, session, 1, "CIPHER", 100L);
        this.differentMessageContext = new DtlsEndpointContext(ADDRESS, null, null, newSession, 1, "CIPHER", 100L);
        MapBasedEndpointContext mapBasedContext = new MapBasedEndpointContext(ADDRESS, null, new MapBasedEndpointContext.Attributes().add(ID, (Object)"session").add(UNKNOWN, (Object)"secret"));
        this.unsecureMessageContext = mapBasedContext;
        mapBasedContext = new MapBasedEndpointContext(ADDRESS, null, new MapBasedEndpointContext.Attributes().add(ID, (Object)"session").add(UNKNOWN, (Object)"topsecret"));
        this.unsecureMessageContext2 = mapBasedContext;
    }

    @Test
    public void testEndpointContextUtil() {
        this.logging.setLoggingLevel("ERROR", EndpointContextUtil.class);
        Definitions keys = new Definitions("test").add(DtlsEndpointContext.KEY_SESSION_ID).add(DtlsEndpointContext.KEY_CIPHER);
        MatcherAssert.assertThat((Object)EndpointContextUtil.match((String)"test-1", (Definitions)keys, (EndpointContext)this.strictMessageContext, (EndpointContext)this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)EndpointContextUtil.match((String)"test-2", (Definitions)keys, (EndpointContext)this.relaxedMessageContext, (EndpointContext)this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)EndpointContextUtil.match((String)"test-3", (Definitions)keys, (EndpointContext)this.differentMessageContext, (EndpointContext)this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)EndpointContextUtil.match((String)"test-4", (Definitions)keys, (EndpointContext)this.differentMessageContext, (EndpointContext)this.unsecureMessageContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)EndpointContextUtil.match((String)"test-5", (Definitions)keys, (EndpointContext)this.unsecureMessageContext, (EndpointContext)this.unsecureMessageContext2), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testEndpointContextUtilWithAdditionalKey() {
        this.logging.setLoggingLevel("ERROR", EndpointContextUtil.class);
        Definitions keys = new Definitions("test").add(DtlsEndpointContext.KEY_SESSION_ID).add(DtlsEndpointContext.KEY_CIPHER).add(UNKNOWN);
        MatcherAssert.assertThat((Object)EndpointContextUtil.match((String)"test-1", (Definitions)keys, (EndpointContext)this.strictMessageContext, (EndpointContext)this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)EndpointContextUtil.match((String)"test-2", (Definitions)keys, (EndpointContext)this.relaxedMessageContext, (EndpointContext)this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)EndpointContextUtil.match((String)"test-3", (Definitions)keys, (EndpointContext)this.differentMessageContext, (EndpointContext)this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)EndpointContextUtil.match((String)"test-4", (Definitions)keys, (EndpointContext)this.differentMessageContext, (EndpointContext)this.unsecureMessageContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)EndpointContextUtil.match((String)"test-5", (Definitions)keys, (EndpointContext)this.unsecureMessageContext, (EndpointContext)this.unsecureMessageContext2), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testFollowUpEndpointContextStartHandshake() {
        AddressEndpointContext messageContext = new AddressEndpointContext(ADDRESS);
        messageContext = MapBasedEndpointContext.addEntries((EndpointContext)messageContext, (MapBasedEndpointContext.Attributes)new MapBasedEndpointContext.Attributes().add(DtlsEndpointContext.KEY_HANDSHAKE_MODE, (Object)"force"));
        AddressEndpointContext connectionContext = new AddressEndpointContext(ADDRESS, "myserver", null);
        EndpointContext followUp = EndpointContextUtil.getFollowUpEndpointContext((EndpointContext)messageContext, (EndpointContext)connectionContext);
        MatcherAssert.assertThat((Object)followUp.get(DtlsEndpointContext.KEY_HANDSHAKE_MODE), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testFollowUpEndpointContextNoneHandshake() {
        AddressEndpointContext messageContext = new AddressEndpointContext(ADDRESS);
        messageContext = MapBasedEndpointContext.addEntries((EndpointContext)messageContext, (MapBasedEndpointContext.Attributes)DtlsEndpointContext.ATTRIBUTE_HANDSHAKE_MODE_NONE);
        AddressEndpointContext connectionContext = new AddressEndpointContext(ADDRESS, "myserver", null);
        EndpointContext followUp = EndpointContextUtil.getFollowUpEndpointContext((EndpointContext)messageContext, (EndpointContext)connectionContext);
        MatcherAssert.assertThat((Object)followUp.getString(DtlsEndpointContext.KEY_HANDSHAKE_MODE), (Matcher)CoreMatchers.is((Object)"none"));
    }
}

