/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.auth;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.JceProviderUtil;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.TestCertificatesTools;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class X509CertPathIdentityTest {
    public static final String ALIAS_CLIENT = "client";
    private static SslContextUtil.Credentials ecCredentials;
    private static SslContextUtil.Credentials ed25519Credentials;

    @BeforeClass
    public static void init() throws IOException {
        try {
            ecCredentials = SslContextUtil.loadCredentials((String)"classpath://certs/keyStore.jks", (String)ALIAS_CLIENT, (char[])TestCertificatesTools.KEY_STORE_PASSWORD, (char[])TestCertificatesTools.KEY_STORE_PASSWORD);
        }
        catch (GeneralSecurityException e) {
            Assume.assumeNoException((String)"vm's without EC are not usable for CoAP!", (Throwable)e);
        }
        if (JceProviderUtil.isSupported((String)"Ed25519") && SslContextUtil.isAvailableFromUri((String)"classpath://certs/eddsaKeyStore.jks")) {
            try {
                ed25519Credentials = SslContextUtil.loadCredentials((String)"classpath://certs/eddsaKeyStore.jks", (String)"clienteddsa", (char[])TestCertificatesTools.KEY_STORE_PASSWORD, (char[])TestCertificatesTools.KEY_STORE_PASSWORD);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGetNameReturnsNamedInterfaceUri() {
        X509CertPath id = X509CertPath.fromCertificatesChain((Certificate[])ecCredentials.getCertificateChain());
        MatcherAssert.assertThat((Object)id.getName(), (Matcher)CoreMatchers.is((Object)ecCredentials.getCertificateChain()[0].getSubjectX500Principal().getName()));
    }

    @Test
    public void testGetCNReturnsCN() {
        X509CertPath id = X509CertPath.fromCertificatesChain((Certificate[])ecCredentials.getCertificateChain());
        MatcherAssert.assertThat((Object)id.getCN(), (Matcher)CoreMatchers.is((Object)"cf-client"));
    }

    @Test
    public void testGetTargetReturnsFirstCertificate() {
        X509CertPath id = X509CertPath.fromCertificatesChain((Certificate[])ecCredentials.getCertificateChain());
        MatcherAssert.assertThat((Object)id.getTarget(), (Matcher)CoreMatchers.is((Object)ecCredentials.getCertificateChain()[0]));
    }

    @Test
    public void testConstructorCreatesEcChainFromBytes() throws GeneralSecurityException {
        X509CertPath id = X509CertPath.fromCertificatesChain((Certificate[])ecCredentials.getCertificateChain());
        byte[] chain = id.toByteArray();
        X509CertPath principal = X509CertPath.fromBytes((byte[])chain);
        MatcherAssert.assertThat((Object)id, (Matcher)CoreMatchers.is((Object)principal));
        MatcherAssert.assertThat((Object)id.getPath(), (Matcher)CoreMatchers.is((Object)principal.getPath()));
        TestCertificatesTools.assertSigning("X509", ecCredentials.getPrivateKey(), principal.getTarget().getPublicKey(), "SHA256withECDSA");
    }

    @Test
    public void testConstructorCreatesEd25519ChainFromBytes() throws GeneralSecurityException {
        Assume.assumeNotNull((Object[])new Object[]{"Ed25519 not supported by vm!", ed25519Credentials});
        X509CertPath id = X509CertPath.fromCertificatesChain((Certificate[])ed25519Credentials.getCertificateChain());
        byte[] chain = id.toByteArray();
        X509CertPath principal = X509CertPath.fromBytes((byte[])chain);
        MatcherAssert.assertThat((Object)id, (Matcher)CoreMatchers.is((Object)principal));
        MatcherAssert.assertThat((Object)id.getPath(), (Matcher)CoreMatchers.is((Object)principal.getPath()));
        TestCertificatesTools.assertSigning("X509", ed25519Credentials.getPrivateKey(), principal.getTarget().getPublicKey(), "ED25519");
    }
}

