/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.BasicListDefinition;
import org.eclipse.californium.elements.config.BooleanDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.DocumentedDefinition;
import org.eclipse.californium.elements.config.EnumDefinition;
import org.eclipse.californium.elements.config.EnumListDefinition;
import org.eclipse.californium.elements.config.IntegerDefinition;
import org.eclipse.californium.elements.config.StringDefinition;
import org.eclipse.californium.elements.config.StringSetDefinition;
import org.eclipse.californium.elements.config.TcpConfig;
import org.eclipse.californium.elements.config.TimeDefinition;
import org.eclipse.californium.elements.rule.LoggingRule;
import org.eclipse.californium.elements.rule.TestNameLoggerRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ConfigurationTest {
    private static final String MODULE = "TEST.";
    private static final IntegerDefinition INT = new IntegerDefinition("TEST.INT", "TEST");
    private static final IntegerDefinition INT0 = new IntegerDefinition("TEST.INT0", "TEST", Integer.valueOf(0));
    private static final BooleanDefinition BOOL = new BooleanDefinition("TEST.BOOL", "TEST");
    private static final BooleanDefinition BOOL0 = new BooleanDefinition("TEST.BOOL0", "TEST", Boolean.valueOf(false));
    private static final BooleanDefinition BOOL1 = new BooleanDefinition("TEST.BOOL1", "TEST", Boolean.valueOf(true));
    private static final Configuration.ModuleDefinitionsProvider DEFAULTS = new Configuration.ModuleDefinitionsProvider(){

        public String getModule() {
            return ConfigurationTest.MODULE;
        }

        public void applyDefinitions(Configuration config) {
            config.set((BasicDefinition)INT, (Object)10);
            config.set((BasicDefinition)INT0, null);
            config.set((BasicDefinition)BOOL, (Object)true);
            config.set((BasicDefinition)BOOL0, null);
            config.set((BasicDefinition)BOOL1, null);
        }
    };
    private static final String MODULE2 = "TEST2.";
    private static final IntegerDefinition INT2 = new IntegerDefinition("TEST2.INT2", "TEST", null, Integer.valueOf(1));
    private static final StringDefinition STRING = new StringDefinition("TEST2.STRING", "TEST");
    private static final Configuration.ModuleDefinitionsProvider DEFAULTS2 = new Configuration.ModuleDefinitionsProvider(){

        public String getModule() {
            return ConfigurationTest.MODULE2;
        }

        public void applyDefinitions(Configuration config) {
            TcpConfig.register();
            config.set((BasicDefinition)INT2, (Object)100);
            config.set((BasicDefinition)STRING, (Object)"Hallo");
        }
    };
    @Rule
    public TestNameLoggerRule name = new TestNameLoggerRule();
    @Rule
    public LoggingRule logging = new LoggingRule();

    @Test
    public void testConfigurationAddModule() {
        Configuration.addDefaultModule((Configuration.ModuleDefinitionsProvider)DEFAULTS);
        Configuration configuration = Configuration.createStandardWithoutFile();
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)INT), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)INT0), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)BOOL), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)BOOL0), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testConfigurationCustomModule() {
        this.logging.setLoggingLevel("ERROR", Configuration.class);
        Configuration.addDefaultModule((Configuration.ModuleDefinitionsProvider)DEFAULTS);
        Configuration configuration = Configuration.createStandardWithoutFile();
        configuration.set((BasicDefinition)STRING, (Object)"bye!");
        configuration = ConfigurationTest.reload(configuration, (Configuration.DefinitionsProvider)DEFAULTS2);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)INT2), (Matcher)CoreMatchers.is((Object)100));
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)STRING), (Matcher)CoreMatchers.is((Object)"bye!"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigurationAddModuleNull() {
        Configuration.addDefaultModule((Configuration.ModuleDefinitionsProvider)new Configuration.ModuleDefinitionsProvider(){

            public String getModule() {
                return null;
            }

            public void applyDefinitions(Configuration config) {
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigurationAddModuleEmpty() {
        Configuration.addDefaultModule((Configuration.ModuleDefinitionsProvider)new Configuration.ModuleDefinitionsProvider(){

            public String getModule() {
                return "";
            }

            public void applyDefinitions(Configuration config) {
            }
        });
    }

    @Test(expected=NullPointerException.class)
    public void testConfigurationAddModuleNull2() {
        Configuration.addDefaultModule(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigurationAddModuleTwice() {
        Configuration.addDefaultModule((Configuration.ModuleDefinitionsProvider)new Configuration.ModuleDefinitionsProvider(){

            public String getModule() {
                return "DOUBLE";
            }

            public void applyDefinitions(Configuration config) {
            }
        });
        Configuration.addDefaultModule((Configuration.ModuleDefinitionsProvider)new Configuration.ModuleDefinitionsProvider(){

            public String getModule() {
                return "DOUBLE";
            }

            public void applyDefinitions(Configuration config) {
            }
        });
    }

    @Test
    public void testConfigurationBoolean() {
        Configuration configuration = Configuration.createStandardWithoutFile();
        configuration.set((BasicDefinition)BOOL, (Object)true);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)BOOL), (Matcher)CoreMatchers.is((Object)true));
        configuration.set((BasicDefinition)BOOL, (Object)false);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)BOOL), (Matcher)CoreMatchers.is((Object)false));
        configuration.set((BasicDefinition)BOOL, null);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)BOOL), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        configuration.set((BasicDefinition)BOOL0, (Object)true);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)BOOL0), (Matcher)CoreMatchers.is((Object)true));
        configuration.set((BasicDefinition)BOOL0, (Object)false);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)BOOL0), (Matcher)CoreMatchers.is((Object)false));
        configuration.set((BasicDefinition)BOOL0, null);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)BOOL0), (Matcher)CoreMatchers.is((Object)false));
        configuration.set((BasicDefinition)BOOL1, (Object)true);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)BOOL1), (Matcher)CoreMatchers.is((Object)true));
        configuration.set((BasicDefinition)BOOL1, (Object)false);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)BOOL1), (Matcher)CoreMatchers.is((Object)false));
        configuration.set((BasicDefinition)BOOL1, null);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)BOOL1), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testConfigurationUnknownBoolean() {
        Configuration configuration = Configuration.createStandardWithoutFile();
        BooleanDefinition BOOL_DEF = new BooleanDefinition("TEST.BOOL_DEF", "TEST", Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)BOOL_DEF), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigurationInvalidInteger() {
        Configuration configuration = Configuration.createStandardWithoutFile();
        configuration.set((BasicDefinition)INT2, (Object)0);
    }

    @Test
    public void testConfigurationEnum() {
        EnumDefinition enumDefinition = new EnumDefinition("TEST2.ENUM", "Test Enum", (Enum[])TestValues.values());
        Configuration configuration = Configuration.createStandardWithoutFile();
        configuration.set((BasicDefinition)enumDefinition, (Object)TestValues.TEST2);
        configuration = ConfigurationTest.reload(configuration, null);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)enumDefinition), (Matcher)CoreMatchers.is((Object)((Object)TestValues.TEST2)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigurationEnumFailure() {
        EnumDefinition enumDefinition = new EnumDefinition("TEST2.ENUM2", "Test Enum", (Enum[])new TestValues[]{TestValues.TEST1, TestValues.TEST2});
        Configuration configuration = Configuration.createStandardWithoutFile();
        configuration.set((BasicDefinition)enumDefinition, (Object)TestValues.TEST3);
    }

    @Test
    public void testConfigurationEnumList() {
        EnumListDefinition enumDefinition = new EnumListDefinition("TEST2.ENUM3", "Test Enum List", (Enum[])TestValues.values());
        Configuration configuration = Configuration.createStandardWithoutFile();
        configuration.setAsList((BasicListDefinition)enumDefinition, (Object[])new TestValues[]{TestValues.TEST2, TestValues.TEST4});
        configuration = ConfigurationTest.reload(configuration, null);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)enumDefinition), (Matcher)CoreMatchers.hasItem((Object)((Object)TestValues.TEST2)));
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)enumDefinition), (Matcher)CoreMatchers.hasItem((Object)((Object)TestValues.TEST4)));
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)enumDefinition), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)((Object)TestValues.TEST3))));
        configuration.setAsList((BasicListDefinition)enumDefinition, (Object[])new TestValues[]{TestValues.TEST5});
        configuration = ConfigurationTest.reload(configuration, null);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)enumDefinition), (Matcher)CoreMatchers.hasItem((Object)((Object)TestValues.TEST5)));
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)enumDefinition), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)((Object)TestValues.TEST3))));
        List<TestValues> values = Arrays.asList(TestValues.TEST1, TestValues.TEST3, TestValues.TEST4);
        configuration.set((BasicDefinition)enumDefinition, values);
        List storedValues = (List)configuration.get((BasicDefinition)enumDefinition);
        try {
            storedValues.add(TestValues.TEST2);
            Assert.fail((String)"List is not unmodifiable!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        configuration = ConfigurationTest.reload(configuration, null);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)enumDefinition), (Matcher)CoreMatchers.hasItem((Object)((Object)TestValues.TEST1)));
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)enumDefinition), (Matcher)CoreMatchers.hasItem((Object)((Object)TestValues.TEST3)));
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)enumDefinition), (Matcher)CoreMatchers.hasItem((Object)((Object)TestValues.TEST4)));
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)enumDefinition), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)((Object)TestValues.TEST5))));
        configuration.set((BasicDefinition)enumDefinition, null);
        configuration = ConfigurationTest.reload(configuration, null);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)enumDefinition), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigurationEnumListWithEmptyListFailure() {
        EnumListDefinition enumDefinition = new EnumListDefinition("TEST2.ENUM4", "Test Enum List", null, 1, (Enum[])TestValues.values());
        Configuration configuration = Configuration.createStandardWithoutFile();
        configuration.setAsList((BasicListDefinition)enumDefinition, (Object[])new TestValues[0]);
    }

    @Test
    public void testConfigurationEnumListAsText() {
        EnumListDefinition enumDefinition = new EnumListDefinition("TEST2.ENUM5", "Test Enum List", null, 0, (Enum[])TestValues.values());
        Configuration configuration = Configuration.createStandardWithoutFile();
        configuration.setAsListFromText((BasicListDefinition)enumDefinition, new String[0]);
        List list = (List)configuration.get((BasicDefinition)enumDefinition);
        MatcherAssert.assertThat((Object)list.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        configuration.setAsListFromText((BasicListDefinition)enumDefinition, new String[]{"TEST1", "TEST4"});
        list = (List)configuration.get((BasicDefinition)enumDefinition);
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)enumDefinition), (Matcher)CoreMatchers.hasItem((Object)((Object)TestValues.TEST1)));
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)enumDefinition), (Matcher)CoreMatchers.hasItem((Object)((Object)TestValues.TEST4)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigurationEnumListAsTextWithFailure() {
        EnumListDefinition enumDefinition = new EnumListDefinition("TEST2.ENUM6", "Test Enum List", null, 0, (Enum[])TestValues.values());
        Configuration configuration = Configuration.createStandardWithoutFile();
        configuration.setAsListFromText((BasicListDefinition)enumDefinition, new String[]{"TEST1", "TESTx"});
    }

    @Test
    public void testConfigurationStringSet() {
        StringSetDefinition setDefinition = new StringSetDefinition("TEST2.STRING_SET", "Test String-Set", new String[]{"val1", "val2"});
        Configuration configuration = Configuration.createStandardWithoutFile();
        configuration.set((BasicDefinition)setDefinition, (Object)"val1");
        configuration = ConfigurationTest.reload(configuration, null);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)setDefinition), (Matcher)CoreMatchers.is((Object)"val1"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigurationStringSetFailure() {
        StringSetDefinition setDefinition = new StringSetDefinition("TEST2.STRING_SET2", "Test String-Set", new String[]{"val1", "val2"});
        Configuration configuration = Configuration.createStandardWithoutFile();
        configuration.set((BasicDefinition)setDefinition, (Object)"val3");
    }

    @Test
    public void testConfigurationStringSetDefault() {
        StringSetDefinition setDefinition = new StringSetDefinition("TEST2.STRING_SET3", "Test String-Set", new String[]{"val2", "val1", "val2"});
        Configuration configuration = Configuration.createStandardWithoutFile();
        configuration.set((BasicDefinition)setDefinition, null);
        configuration = ConfigurationTest.reload(configuration, null);
        MatcherAssert.assertThat((Object)configuration.get((BasicDefinition)setDefinition), (Matcher)CoreMatchers.is((Object)"val2"));
    }

    @Test
    public void testConfigurationTime() {
        TimeDefinition timeDefinition = new TimeDefinition("TEST2.TIME", "Test Time");
        Configuration configuration = Configuration.createStandardWithoutFile();
        configuration.set(timeDefinition, 10, TimeUnit.SECONDS);
        configuration = ConfigurationTest.reload(configuration, null);
        MatcherAssert.assertThat((Object)configuration.get(timeDefinition, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)10000L));
    }

    @Test
    public void testConfigurationTransientTime() {
        TimeDefinition timeDefinition = new TimeDefinition("TEST2.TIME_TRANSIENT", "Test Time");
        Configuration configuration = Configuration.createStandardWithoutFile();
        configuration.set(timeDefinition, 10, TimeUnit.SECONDS);
        configuration.setTransient((DocumentedDefinition)timeDefinition);
        configuration = ConfigurationTest.reload(configuration, null);
        MatcherAssert.assertThat((Object)configuration.get(timeDefinition, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private static Configuration reload(Configuration configuration, Configuration.DefinitionsProvider provider) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        configuration.store((OutputStream)out, "Test Values", "Test");
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        return Configuration.createFromStream((InputStream)in, (Configuration.DefinitionsProvider)provider);
    }

    private static enum TestValues {
        TEST1,
        TEST2,
        TEST3,
        TEST4,
        TEST5;

    }
}

