/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.rule;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingRule
implements TestRule {
    private static final Class<?> LOGGER_CLASS;
    private static final Method SET_LEVEL;
    private static final Method GET_LEVEL;
    private static final Method TO_LEVEL;
    private volatile Description description;
    private volatile Logger[] logbackLoggers;
    private volatile Object[] backupLevels;

    public String toString() {
        Description description = this.description;
        if (null == description) {
            return super.toString();
        }
        if (description.isTest()) {
            return description.getDisplayName() + " (@Rule)";
        }
        return description.getDisplayName() + " (@ClassRule)";
    }

    private void startRule(Description description) {
        this.description = description;
    }

    public LoggingRule setLoggingLevel(String levelname, String ... loggerNames) {
        if (LOGGER_CLASS == null) {
            return this;
        }
        if (this.logbackLoggers != null) {
            throw new IllegalStateException("Logging level already applied!");
        }
        Logger[] loggers = new Logger[loggerNames.length];
        for (int index = 0; index < loggerNames.length; ++index) {
            loggers[index] = LoggerFactory.getLogger((String)loggerNames[index]);
        }
        return this.setLoggingLevel(levelname, loggers);
    }

    public LoggingRule setLoggingLevel(String levelname, Class<?> ... loggerClasses) {
        if (LOGGER_CLASS == null) {
            return this;
        }
        if (this.logbackLoggers != null) {
            throw new IllegalStateException("Logging level already applied!");
        }
        Logger[] loggers = new Logger[loggerClasses.length];
        for (int index = 0; index < loggerClasses.length; ++index) {
            loggers[index] = LoggerFactory.getLogger(loggerClasses[index]);
        }
        return this.setLoggingLevel(levelname, loggers);
    }

    public LoggingRule setLoggingLevel(String levelname, Logger ... loggers) {
        if (LOGGER_CLASS == null) {
            return this;
        }
        if (this.logbackLoggers != null) {
            throw new IllegalStateException("Logging level already applied!");
        }
        try {
            Object level = TO_LEVEL.invoke(null, levelname);
            this.logbackLoggers = new Logger[loggers.length];
            this.backupLevels = new Object[loggers.length];
            for (int index = 0; index < loggers.length; ++index) {
                if (!LOGGER_CLASS.isInstance(loggers[index])) continue;
                this.logbackLoggers[index] = loggers[index];
                this.backupLevels[index] = GET_LEVEL.invoke((Object)loggers[index], new Object[0]);
                SET_LEVEL.invoke((Object)loggers[index], level);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return this;
    }

    private void closeRule() {
        if (this.logbackLoggers != null) {
            try {
                for (int index = 0; index < this.logbackLoggers.length; ++index) {
                    Object level = this.backupLevels[index];
                    SET_LEVEL.invoke((Object)this.logbackLoggers[index], level);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            this.logbackLoggers = null;
            this.backupLevels = null;
        }
        this.description = null;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LoggingRule.this.startRule(description);
                try {
                    base.evaluate();
                }
                finally {
                    LoggingRule.this.closeRule();
                }
            }
        };
    }

    static {
        Class<?> loggerClass = null;
        Method setLevel = null;
        Method getLevel = null;
        Class<?> levelClass = null;
        Method toLevel = null;
        try {
            loggerClass = Class.forName("ch.qos.logback.classic.Logger");
            levelClass = Class.forName("ch.qos.logback.classic.Level");
            setLevel = loggerClass.getMethod("setLevel", levelClass);
            getLevel = loggerClass.getMethod("getLevel", new Class[0]);
            toLevel = levelClass.getMethod("toLevel", String.class);
        }
        catch (Throwable t) {
            loggerClass = null;
            setLevel = null;
            getLevel = null;
            toLevel = null;
        }
        LOGGER_CLASS = loggerClass;
        SET_LEVEL = setLevel;
        GET_LEVEL = getLevel;
        TO_LEVEL = toLevel;
    }
}

