/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.rule;

import java.io.IOError;
import java.net.DatagramSocketImpl;
import java.net.SocketException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.UdpConfig;
import org.eclipse.californium.elements.util.DatagramFormatter;
import org.eclipse.californium.elements.util.DirectDatagramSocketImpl;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkRule
implements TestRule {
    public static final Logger LOGGER = LoggerFactory.getLogger(NetworkRule.class);
    public static final String PROPERTY_NAME = "org.eclipse.californium.junit.socketmode";
    private static final int DEFAULT_MESSAGE_THREADS = 1;
    private static final DatagramFormatter DEFAULT_FORMATTER = null;
    private static final int DEFAULT_DELAY_IN_MILLIS = 0;
    private static final Mode usedMode;
    private static final Deque<NetworkRule> RULES_STACK;
    private static final Statement SKIP;
    private final Mode[] supportedModes;
    private final DatagramFormatter formatter;
    protected final AtomicInteger messageThreads = new AtomicInteger(1);
    private int delayInMillis;
    private Description description;

    public NetworkRule(Mode ... modes) {
        this(DEFAULT_FORMATTER, modes);
    }

    protected NetworkRule(DatagramFormatter formatter, Mode ... modes) {
        this.supportedModes = modes;
        this.formatter = formatter;
        this.delayInMillis = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Description description;
        Deque<NetworkRule> deque = RULES_STACK;
        synchronized (deque) {
            description = this.description;
        }
        if (null == description) {
            return super.toString();
        }
        if (description.isTest()) {
            return description.getDisplayName() + " (@Rule)";
        }
        return description.getDisplayName() + " (@ClassRule)";
    }

    private boolean supports(Mode mode) {
        for (Mode supportedMode : this.supportedModes) {
            if (mode != supportedMode) continue;
            return true;
        }
        return false;
    }

    public NetworkRule setDelay(int delayInMillis) {
        if (0 > delayInMillis) {
            throw new IllegalArgumentException("delays must be at least 0, not " + delayInMillis + "!");
        }
        if (!this.supports(Mode.DIRECT)) {
            throw new IllegalArgumentException("delays could only be used for DIRECT DatagramSockets!");
        }
        this.delayInMillis = delayInMillis;
        return this;
    }

    public NetworkRule setMessageThreads(int threads) {
        if (1 > threads) {
            throw new IllegalArgumentException("number of message threads must be at least 1, not " + threads + "!");
        }
        this.messageThreads.set(threads);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applyConfig(Description description) {
        int size;
        boolean first;
        Deque<NetworkRule> deque = RULES_STACK;
        synchronized (deque) {
            this.description = description;
            first = RULES_STACK.isEmpty();
            RULES_STACK.push(this);
            size = RULES_STACK.size();
        }
        LOGGER.info("{} rules active.", (Object)size);
        this.initNetwork(first);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeConfig() {
        int size;
        NetworkRule activeRule;
        NetworkRule closedRule;
        Deque<NetworkRule> deque = RULES_STACK;
        synchronized (deque) {
            closedRule = RULES_STACK.pop();
            activeRule = RULES_STACK.peek();
            size = RULES_STACK.size();
        }
        LOGGER.info("{} rules active.", (Object)size);
        if (this != closedRule) {
            throw new IllegalStateException("closed rule differs!");
        }
        if (null == activeRule) {
            this.closeNetwork();
        } else {
            activeRule.initNetwork(false);
        }
    }

    public Statement apply(final Statement base, final Description description) {
        if (this.supports(usedMode)) {
            return new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    NetworkRule.this.applyConfig(description);
                    try {
                        base.evaluate();
                    }
                    finally {
                        NetworkRule.this.closeConfig();
                    }
                }
            };
        }
        LOGGER.warn("Skip {} not applicable with socket mode {}", (Object)description, (Object)usedMode);
        return SKIP;
    }

    protected void initNetwork(boolean outerScope) {
        this.createStandardTestConfig();
        if (Mode.DIRECT == usedMode) {
            if (outerScope && !DirectDatagramSocketImpl.isEmpty()) {
                LOGGER.info("Previous test didn't 'closeNetwork()'!");
                DirectDatagramSocketImpl.clearAll();
            }
            DirectDatagramSocketImpl.configure(this.formatter, this.delayInMillis);
        }
    }

    protected void closeNetwork() {
        this.messageThreads.set(1);
        Configuration.setStandard(null);
        if (Mode.DIRECT == usedMode) {
            if (!DirectDatagramSocketImpl.isEmpty()) {
                LOGGER.info("Test didn't close all DatagramSockets!");
                DirectDatagramSocketImpl.clearAll();
            }
            DirectDatagramSocketImpl.configure(DEFAULT_FORMATTER, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureThisRuleIsActive() throws IllegalStateException {
        NetworkRule activeRule;
        Deque<NetworkRule> deque = RULES_STACK;
        synchronized (deque) {
            activeRule = RULES_STACK.peek();
        }
        if (this != activeRule) {
            Description description;
            Deque<NetworkRule> deque2 = RULES_STACK;
            synchronized (deque2) {
                description = this.description;
            }
            StringBuilder messageBuilder = new StringBuilder(this.toString());
            if (null == description) {
                messageBuilder.append(" rule is not applied!");
            } else {
                messageBuilder.append(" rule is not active!");
            }
            if (null == activeRule) {
                messageBuilder.append(" No active rule!");
            } else {
                messageBuilder.append(" Instead ").append(activeRule).append(" is active!");
            }
            String message = messageBuilder.toString();
            LOGGER.error(message);
            throw new IllegalStateException(message);
        }
    }

    public Configuration createStandardTestConfig() {
        Configuration config = this.createTestConfig();
        Configuration.setStandard((Configuration)config);
        return config;
    }

    public Configuration getStandardTestConfig() {
        this.ensureThisRuleIsActive();
        return Configuration.getStandard();
    }

    public Configuration createTestConfig() {
        this.ensureThisRuleIsActive();
        SystemConfig.register();
        UdpConfig.register();
        int threads = this.messageThreads.get();
        Configuration config = new Configuration();
        config.set((BasicDefinition)UdpConfig.UDP_RECEIVER_THREAD_COUNT, (Object)threads);
        config.set((BasicDefinition)UdpConfig.UDP_SENDER_THREAD_COUNT, (Object)threads);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isActive() {
        boolean active;
        int size;
        Deque<NetworkRule> deque = RULES_STACK;
        synchronized (deque) {
            size = RULES_STACK.size();
            active = !RULES_STACK.isEmpty();
        }
        LOGGER.info("{} rules active.", (Object)size);
        return active;
    }

    static {
        RULES_STACK = new LinkedList<NetworkRule>();
        Mode mode = Mode.NATIVE;
        String envMode = System.getProperty(PROPERTY_NAME);
        if (null != envMode) {
            try {
                mode = Mode.valueOf(envMode);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Value {} for property {} not supported!", (Object)envMode, (Object)PROPERTY_NAME);
            }
        }
        if (Mode.DIRECT == (usedMode = mode)) {
            DirectDatagramSocketImpl.initialize(new DirectDatagramSocketImpl.DirectDatagramSocketImplFactory(){

                @Override
                public DatagramSocketImpl createDatagramSocketImpl() {
                    if (!NetworkRule.isActive()) {
                        String message = "Use " + NetworkRule.class.getName() + " to define DatagramSocket behaviour!";
                        LOGGER.error(message);
                        throw new IOError(new SocketException(message));
                    }
                    return super.createDatagramSocketImpl();
                }
            });
        }
        SKIP = new Statement(){

            public void evaluate() throws Throwable {
            }
        };
    }

    public static enum Mode {
        NATIVE,
        DIRECT;

    }
}

