/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.rule;

import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.util.ClockUtil;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTimeRule
extends TestWatcher {
    public static final Logger LOGGER = LoggerFactory.getLogger(TestTimeRule.class);
    private final ClockUtil.Realtime handler = new ClockUtil.Realtime(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long nanoRealtime() {
            Long fixed;
            long shift;
            TestTimeRule testTimeRule = TestTimeRule.this;
            synchronized (testTimeRule) {
                shift = TestTimeRule.this.timeShiftNanos;
                fixed = TestTimeRule.this.timeFixed;
            }
            if (fixed != null) {
                return fixed + shift;
            }
            return System.nanoTime() + shift;
        }
    };
    private long timeShiftNanos;
    private Long timeFixed;

    public final synchronized void setFixedTestTime(boolean enable) {
        LOGGER.debug("set fixed test time {}", (Object)enable);
        this.timeFixed = enable ? Long.valueOf(System.nanoTime()) : null;
    }

    public final synchronized void addTestTimeShift(long delta, TimeUnit unit) {
        LOGGER.debug("add {} {} to timeshift {} ns", new Object[]{delta, unit, this.timeShiftNanos});
        this.timeShiftNanos += unit.toNanos(delta);
    }

    public final synchronized void setTestTimeShift(long shift, TimeUnit unit) {
        LOGGER.debug("set {} {} as timeshift", (Object)shift, (Object)unit);
        this.timeShiftNanos = unit.toNanos(shift);
    }

    public final synchronized long getTestTimeShiftNanos() {
        return this.timeShiftNanos;
    }

    protected void starting(Description description) {
        ClockUtil.setRealtimeHandler((ClockUtil.Realtime)this.handler);
    }

    protected void finished(Description description) {
        if (this.getTestTimeShiftNanos() != 0L) {
            this.setTestTimeShift(0L, TimeUnit.NANOSECONDS);
        }
    }
}

