/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.elements.util.ExpectedExceptionWrapper;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.TestCertificatesTools;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CertPathUtilTest {
    private static final char[] KEY_STORE_PASSWORD = "endPass".toCharArray();
    private static final String KEY_STORE_LOCATION = "certs/keyStore.jks";
    private static final X509Certificate[] ALL = new X509Certificate[0];
    @Rule
    public ExpectedException exception = ExpectedExceptionWrapper.none();
    private X509Certificate[] clientChainExtUsage;
    private X509Certificate[] clientSelfsigned;
    private X509Certificate[] server;
    private X509Certificate[] serverLarge;
    private List<X509Certificate> clientChainExtUsageList;
    private List<X509Certificate> clientSelfsignedList;
    private List<X509Certificate> serverLargeList;

    private void expectTrustAnchorError() {
        this.exception.expectMessage((Matcher)CoreMatchers.anyOf((Matcher)StringContains.containsString((String)"Path does not chain with any of the trust anchors"), (Matcher)StringContains.containsString((String)"Trust anchor for certification path not found")));
    }

    @Before
    public void init() throws IOException, GeneralSecurityException {
        this.clientChainExtUsage = SslContextUtil.loadCredentials((String)"classpath://certs/keyStore.jks", (String)"clientext", (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD).getCertificateChain();
        Assume.assumeThat((Object)this.clientChainExtUsage.length, (Matcher)CoreMatchers.is((Object)3));
        this.clientSelfsigned = SslContextUtil.loadCredentials((String)"classpath://certs/keyStore.jks", (String)"self", (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD).getCertificateChain();
        Assume.assumeThat((Object)this.clientSelfsigned.length, (Matcher)CoreMatchers.is((Object)1));
        this.server = SslContextUtil.loadCredentials((String)"classpath://certs/keyStore.jks", (String)"server", (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD).getCertificateChain();
        Assume.assumeThat((Object)this.server.length, (Matcher)CoreMatchers.is((Object)2));
        this.serverLarge = SslContextUtil.loadCredentials((String)"classpath://certs/keyStore.jks", (String)"serverlarge", (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD).getCertificateChain();
        Assume.assumeThat((Object)this.serverLarge.length, (Matcher)CoreMatchers.is((Object)3));
        this.clientChainExtUsageList = Arrays.asList(this.clientChainExtUsage);
        this.clientSelfsignedList = Arrays.asList(this.clientSelfsigned);
        this.serverLargeList = Arrays.asList(this.serverLarge);
    }

    @Test
    public void testGenerateCertPath() throws Exception {
        CertPath generateCertPath = CertPathUtil.generateCertPath(this.clientChainExtUsageList);
        Assert.assertEquals(this.clientChainExtUsageList, generateCertPath.getCertificates());
    }

    @Test
    public void testGenerateTruncatedCertPath() throws Exception {
        ArrayList<X509Certificate> truncated = new ArrayList<X509Certificate>(this.clientChainExtUsageList);
        truncated.remove(truncated.size() - 1);
        truncated.remove(truncated.size() - 1);
        CertPath generateCertPath = CertPathUtil.generateCertPath(this.clientChainExtUsageList, (int)(this.clientChainExtUsageList.size() - 2));
        Assert.assertEquals((long)truncated.size(), (long)generateCertPath.getCertificates().size());
        Assert.assertEquals(truncated, generateCertPath.getCertificates());
    }

    @Test
    public void testToX509CertificatesList() throws Exception {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(this.clientChainExtUsageList);
        List x509List = CertPathUtil.toX509CertificatesList(list);
        Assert.assertEquals(list, (Object)x509List);
    }

    @Test
    public void testToX509CertificatesListUsingInvalidCertificate() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Given certificate is not X.509!");
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(this.clientChainExtUsageList);
        list.add((X509Certificate)new Certificate("Dummy"){

            @Override
            public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            }

            @Override
            public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            }

            @Override
            public String toString() {
                return "Dummy";
            }

            @Override
            public PublicKey getPublicKey() {
                return null;
            }

            @Override
            public byte[] getEncoded() throws CertificateEncodingException {
                return Bytes.EMPTY;
            }
        });
        CertPathUtil.toX509CertificatesList(list);
    }

    @Test
    public void testCanBeUsedToVerifySignature() throws Exception {
        X509Certificate[] certificates = TestCertificatesTools.getTrustedCertificates();
        X509Certificate[] clientCertificates = TestCertificatesTools.getClientCertificateChain();
        X509Certificate[] serverCertificates = TestCertificatesTools.getServerCertificateChain();
        Assert.assertTrue((boolean)CertPathUtil.canBeUsedToVerifySignature((X509Certificate)certificates[0]));
        Assert.assertTrue((boolean)CertPathUtil.canBeUsedToVerifySignature((X509Certificate)certificates[1]));
        Assert.assertFalse((boolean)CertPathUtil.canBeUsedToVerifySignature((X509Certificate)clientCertificates[0]));
        Assert.assertFalse((boolean)CertPathUtil.canBeUsedToVerifySignature((X509Certificate)serverCertificates[0]));
        Assert.assertFalse((boolean)CertPathUtil.canBeUsedToVerifySignature((X509Certificate)this.clientSelfsigned[0]));
    }

    @Test
    public void testCanBeUsedForClientAuthentication() throws Exception {
        X509Certificate caCertificate = TestCertificatesTools.getTrustedCA();
        X509Certificate[] clientCertificates = TestCertificatesTools.getClientCertificateChain();
        Assert.assertFalse((boolean)CertPathUtil.canBeUsedForAuthentication((X509Certificate)caCertificate, (boolean)true));
        Assert.assertTrue((boolean)CertPathUtil.canBeUsedForAuthentication((X509Certificate)clientCertificates[0], (boolean)true));
        Assert.assertTrue((boolean)CertPathUtil.canBeUsedForAuthentication((X509Certificate)this.clientChainExtUsage[0], (boolean)true));
        Assert.assertTrue((boolean)CertPathUtil.canBeUsedForAuthentication((X509Certificate)this.clientSelfsigned[0], (boolean)true));
    }

    @Test
    public void testCanBeUsedForServerAuthentication() throws Exception {
        X509Certificate caCertificate = TestCertificatesTools.getTrustedCA();
        X509Certificate[] serverCertificates = TestCertificatesTools.getServerCertificateChain();
        Assert.assertFalse((boolean)CertPathUtil.canBeUsedForAuthentication((X509Certificate)caCertificate, (boolean)false));
        Assert.assertTrue((boolean)CertPathUtil.canBeUsedForAuthentication((X509Certificate)serverCertificates[0], (boolean)false));
        Assert.assertFalse((boolean)CertPathUtil.canBeUsedForAuthentication((X509Certificate)this.clientChainExtUsage[0], (boolean)false));
        Assert.assertTrue((boolean)CertPathUtil.canBeUsedForAuthentication((X509Certificate)this.clientSelfsigned[0], (boolean)false));
    }

    @Test
    public void testServerCertificateValidationWithoutTrust() throws Exception {
        this.exception.expect(CertPathValidatorException.class);
        this.exception.expectMessage("certificates are not trusted!");
        List<X509Certificate> path = Arrays.asList(TestCertificatesTools.getServerCertificateChain());
        CertPath certPath = CertPathUtil.generateCertPath(path);
        CertPathUtil.validateCertificatePathWithIssuer((boolean)false, (CertPath)certPath, null);
    }

    @Test
    public void testServerCertificateValidation() throws Exception {
        List<X509Certificate> certificates = TestCertificatesTools.getServerCertificateChainAsList();
        CertPath certPath = CertPathUtil.generateCertPath(certificates);
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)false, (CertPath)certPath, (X509Certificate[])ALL);
        TestCertificatesTools.assertEquals(certificates, verifiedPath.getCertificates());
    }

    @Test
    public void testServerCertificateValidationUnknownTrust() throws Exception {
        this.exception.expect(CertPathValidatorException.class);
        this.expectTrustAnchorError();
        List<X509Certificate> serverCertificates = TestCertificatesTools.getServerCertificateChainAsList();
        CertPath certPath = CertPathUtil.generateCertPath(serverCertificates);
        CertPathUtil.validateCertificatePathWithIssuer((boolean)false, (CertPath)certPath, (X509Certificate[])this.clientSelfsigned);
    }

    @Test
    public void testServerCertificateValidationWithTrust() throws Exception {
        List<X509Certificate> certificates = TestCertificatesTools.getServerCertificateChainAsList();
        ArrayList<X509Certificate> verified = new ArrayList<X509Certificate>(certificates);
        verified.add(TestCertificatesTools.getTrustedRootCA());
        CertPath certPath = CertPathUtil.generateCertPath(certificates);
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)false, (CertPath)certPath, (X509Certificate[])TestCertificatesTools.getTrustedCertificates());
        TestCertificatesTools.assertEquals(verified, verifiedPath.getCertificates());
    }

    @Test
    public void testServerCertificateValidationTruncatedWithTrust() throws Exception {
        List<X509Certificate> certificates = TestCertificatesTools.getServerCertificateChainAsList();
        CertPath certPath = CertPathUtil.generateCertPath(certificates);
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)true, (CertPath)certPath, (X509Certificate[])TestCertificatesTools.getTrustedCertificates());
        TestCertificatesTools.assertEquals(certificates, verifiedPath.getCertificates());
    }

    @Test
    public void testServerLargeCertificateValidationWithTrust() throws Exception {
        ArrayList<X509Certificate> verified = new ArrayList<X509Certificate>(this.serverLargeList);
        verified.add(TestCertificatesTools.getTrustedRootCA());
        CertPath certPath = CertPathUtil.generateCertPath(this.serverLargeList);
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)false, (CertPath)certPath, (X509Certificate[])TestCertificatesTools.getTrustedCertificates());
        TestCertificatesTools.assertEquals(verified, verifiedPath.getCertificates());
    }

    @Test
    public void testServerLargeCertificateValidationTruncatedWithTrust() throws Exception {
        ArrayList<X509Certificate> verified = new ArrayList<X509Certificate>();
        verified.add(this.serverLarge[0]);
        verified.add(this.serverLarge[1]);
        CertPath certPath = CertPathUtil.generateCertPath(this.serverLargeList);
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)true, (CertPath)certPath, (X509Certificate[])TestCertificatesTools.getTrustedCertificates());
        TestCertificatesTools.assertEquals(verified, verifiedPath.getCertificates());
    }

    @Test
    public void testServerLargeCertificateValidationTruncatedWithAmbiguousTrust() throws Exception {
        X509Certificate ca = TestCertificatesTools.getTrustedCA();
        X509Certificate caalt = TestCertificatesTools.getAlternativeCA();
        ArrayList<X509Certificate> path = new ArrayList<X509Certificate>();
        path.add(this.serverLarge[0]);
        path.add(this.serverLarge[1]);
        ArrayList<X509Certificate> verified = new ArrayList<X509Certificate>();
        verified.add(this.serverLarge[0]);
        verified.add(this.serverLarge[1]);
        verified.add(ca);
        X509Certificate[] trusts = new X509Certificate[]{ca, caalt};
        CertPath certPath = CertPathUtil.generateCertPath(path);
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)true, (CertPath)certPath, (X509Certificate[])trusts);
        TestCertificatesTools.assertEquals(verified, verifiedPath.getCertificates());
        trusts = new X509Certificate[]{caalt, ca};
        verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)true, (CertPath)certPath, (X509Certificate[])trusts);
        TestCertificatesTools.assertEquals(verified, verifiedPath.getCertificates());
    }

    @Test
    public void testServerCertificateValidationWithRootTrust() throws Exception {
        X509Certificate root = TestCertificatesTools.getTrustedRootCA();
        List<X509Certificate> certificates = TestCertificatesTools.getServerCertificateChainAsList();
        X509Certificate[] trusts = new X509Certificate[]{root};
        ArrayList<X509Certificate> verified = new ArrayList<X509Certificate>(certificates);
        verified.add(root);
        CertPath certPath = CertPathUtil.generateCertPath(certificates);
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)true, (CertPath)certPath, (X509Certificate[])trusts);
        TestCertificatesTools.assertEquals(verified, verifiedPath.getCertificates());
    }

    @Test
    public void testServerCertificateValidationWithIntermediateTrustFails() throws Exception {
        this.exception.expect(CertPathValidatorException.class);
        this.expectTrustAnchorError();
        List<X509Certificate> certificates = TestCertificatesTools.getServerCertificateChainAsList();
        X509Certificate[] trusts = new X509Certificate[]{TestCertificatesTools.getTrustedCA()};
        CertPath certPath = CertPathUtil.generateCertPath(certificates);
        CertPathUtil.validateCertificatePathWithIssuer((boolean)false, (CertPath)certPath, (X509Certificate[])trusts);
    }

    @Test
    public void testServerCertificateTruncatingValidationWithIntermediateTrust() throws Exception {
        List<X509Certificate> certificates = TestCertificatesTools.getServerCertificateChainAsList();
        X509Certificate[] trusts = new X509Certificate[]{TestCertificatesTools.getTrustedCA()};
        CertPath certPath = CertPathUtil.generateCertPath(certificates);
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)true, (CertPath)certPath, (X509Certificate[])trusts);
        TestCertificatesTools.assertEquals(certificates, verifiedPath.getCertificates());
    }

    @Test
    public void testServerCertificateValidationWithAmbiguousTrust() throws Exception {
        X509Certificate server = TestCertificatesTools.getServerCertificateChain()[0];
        X509Certificate ca = TestCertificatesTools.getTrustedCA();
        X509Certificate caalt = TestCertificatesTools.getAlternativeCA();
        X509Certificate[] path = new X509Certificate[]{server};
        X509Certificate[] trusts = new X509Certificate[]{ca, caalt};
        X509Certificate[] verfied = new X509Certificate[]{server, ca};
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(path));
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)false, (CertPath)certPath, (X509Certificate[])trusts);
        TestCertificatesTools.assertEquals(verfied, verifiedPath.getCertificates());
        X509Certificate[] trusts2 = new X509Certificate[]{caalt, ca};
        verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)false, (CertPath)certPath, (X509Certificate[])trusts2);
        TestCertificatesTools.assertEquals(verfied, verifiedPath.getCertificates());
    }

    @Test
    public void testServerCertificateTruncatingValidationWithTruncatedAmbiguousTrust() throws Exception {
        X509Certificate server = TestCertificatesTools.getServerCertificateChain()[0];
        X509Certificate ca = TestCertificatesTools.getTrustedCA();
        X509Certificate caalt = TestCertificatesTools.getAlternativeCA();
        X509Certificate[] path = new X509Certificate[]{server};
        X509Certificate[] trusts = new X509Certificate[]{ca, caalt};
        X509Certificate[] verfied = new X509Certificate[]{server, ca};
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(path));
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)true, (CertPath)certPath, (X509Certificate[])trusts);
        TestCertificatesTools.assertEquals(verfied, verifiedPath.getCertificates());
        X509Certificate[] trusts2 = new X509Certificate[]{caalt, ca};
        verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)true, (CertPath)certPath, (X509Certificate[])trusts2);
        TestCertificatesTools.assertEquals(verfied, verifiedPath.getCertificates());
    }

    @Test
    public void testServerCertificateValidationWithSelfTrustFails() throws Exception {
        this.exception.expect(CertPathValidatorException.class);
        this.expectTrustAnchorError();
        X509Certificate[] certificates = TestCertificatesTools.getServerCertificateChain();
        X509Certificate[] trusts = new X509Certificate[]{certificates[0]};
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(certificates));
        CertPathUtil.validateCertificatePathWithIssuer((boolean)false, (CertPath)certPath, (X509Certificate[])trusts);
    }

    @Test
    public void testServerCertificateTruncatingValidationWithSelfTrust() throws Exception {
        X509Certificate[] certificates = TestCertificatesTools.getServerCertificateChain();
        X509Certificate[] trusts = new X509Certificate[]{certificates[0]};
        X509Certificate[] verfied = new X509Certificate[]{certificates[0]};
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(certificates));
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)true, (CertPath)certPath, (X509Certificate[])trusts);
        TestCertificatesTools.assertEquals(verfied, verifiedPath.getCertificates());
    }

    @Test
    public void testClientExtCertificateValidationWithTrust() throws Exception {
        CertPath certPath = CertPathUtil.generateCertPath(this.clientChainExtUsageList);
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)false, (CertPath)certPath, (X509Certificate[])TestCertificatesTools.getTrustedCertificates());
        TestCertificatesTools.assertEquals(this.clientChainExtUsageList, verifiedPath.getCertificates());
    }

    @Test
    public void testServerCertificateInvalidPath() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Given certificates do not form a chain");
        X509Certificate[] certificates = TestCertificatesTools.getServerCertificateChain();
        certificates[1] = this.clientChainExtUsage[0];
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(certificates));
        CertPathUtil.validateCertificatePathWithIssuer((boolean)false, (CertPath)certPath, (X509Certificate[])TestCertificatesTools.getTrustedCertificates());
    }

    @Test
    public void testServerCertificateInvalidPath2() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Given certificates do not form a chain, root is not the last!");
        X509Certificate[] certificates = TestCertificatesTools.getServerCertificateChain();
        certificates[0] = this.clientSelfsigned[0];
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(certificates));
        CertPathUtil.validateCertificatePathWithIssuer((boolean)false, (CertPath)certPath, (X509Certificate[])TestCertificatesTools.getTrustedCertificates());
    }

    @Test
    public void testSelfSignedValidation() throws Exception {
        CertPath certPath = CertPathUtil.generateCertPath(this.clientSelfsignedList);
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)false, (CertPath)certPath, (X509Certificate[])ALL);
        TestCertificatesTools.assertEquals(this.clientSelfsignedList, verifiedPath.getCertificates());
    }

    @Test
    public void testSelfSignedValidationTrust() throws Exception {
        CertPath certPath = CertPathUtil.generateCertPath(this.clientSelfsignedList);
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)false, (CertPath)certPath, (X509Certificate[])this.clientSelfsigned);
        TestCertificatesTools.assertEquals(this.clientSelfsignedList, verifiedPath.getCertificates());
    }

    @Test
    public void testSelfSignedValidationTruncatedTrust() throws Exception {
        CertPath certPath = CertPathUtil.generateCertPath(this.clientSelfsignedList);
        CertPath verifiedPath = CertPathUtil.validateCertificatePathWithIssuer((boolean)true, (CertPath)certPath, (X509Certificate[])this.clientSelfsigned);
        TestCertificatesTools.assertEquals(this.clientSelfsignedList, verifiedPath.getCertificates());
    }

    @Test
    public void testGenerateValidationCertPath() throws Exception {
        ArrayList<X509Certificate> truncated = new ArrayList<X509Certificate>(this.clientChainExtUsageList);
        truncated.remove(truncated.size() - 1);
        CertPath generateCertPath = CertPathUtil.generateValidatableCertPath(this.clientChainExtUsageList, null);
        TestCertificatesTools.assertEquals(truncated, generateCertPath.getCertificates());
    }

    @Test
    public void testGenerateValidationCertPathForIssuer() throws Exception {
        ArrayList<X500Principal> certificateAuthorities = new ArrayList<X500Principal>();
        certificateAuthorities.add(this.clientChainExtUsage[1].getSubjectX500Principal());
        ArrayList<X509Certificate> truncated = new ArrayList<X509Certificate>(this.clientChainExtUsageList);
        truncated.remove(truncated.size() - 1);
        truncated.remove(truncated.size() - 1);
        CertPath generateCertPath = CertPathUtil.generateValidatableCertPath(this.clientChainExtUsageList, certificateAuthorities);
        TestCertificatesTools.assertEquals(truncated, generateCertPath.getCertificates());
    }

    @Test
    public void testGenerateValidationCertPathForUnknownIssuer() throws Exception {
        ArrayList<X500Principal> certificateAuthorities = new ArrayList<X500Principal>();
        certificateAuthorities.add(this.clientSelfsigned[0].getSubjectX500Principal());
        CertPath generateCertPath = CertPathUtil.generateValidatableCertPath(this.clientChainExtUsageList, certificateAuthorities);
        Assert.assertEquals((long)0L, (long)generateCertPath.getCertificates().size());
    }

    @Test
    public void testGenerateValidationCertPathForSingleCertificateAndUnknownIssuer() throws Exception {
        ArrayList<X509Certificate> path = new ArrayList<X509Certificate>();
        path.add(this.clientChainExtUsage[0]);
        ArrayList<X500Principal> certificateAuthorities = new ArrayList<X500Principal>();
        certificateAuthorities.add(this.clientSelfsigned[0].getSubjectX500Principal());
        CertPath generateCertPath = CertPathUtil.generateValidatableCertPath(path, certificateAuthorities);
        Assert.assertEquals((long)0L, (long)generateCertPath.getCertificates().size());
    }

    @Test
    public void testGenerateValidationCertPathSelfSigned() throws Exception {
        CertPath generateCertPath = CertPathUtil.generateValidatableCertPath(this.clientSelfsignedList, null);
        Assert.assertEquals(this.clientSelfsignedList, generateCertPath.getCertificates());
    }

    @Test
    public void testMatchDestination() throws Exception {
        Assert.assertTrue((boolean)CertPathUtil.matchDestination((X509Certificate)this.serverLarge[0], (String)"cf-serverlarge"));
        Assert.assertFalse((boolean)CertPathUtil.matchDestination((X509Certificate)this.server[0], (String)"cf-server"));
        Assert.assertTrue((boolean)CertPathUtil.matchDestination((X509Certificate)this.server[0], (String)"californium.eclipseprojects.io"));
        Assert.assertFalse((boolean)CertPathUtil.matchDestination((X509Certificate)this.server[0], (String)"foreign.server"));
        Assert.assertFalse((boolean)CertPathUtil.matchDestination((X509Certificate)this.server[0], (String)"*.server"));
        Assert.assertTrue((boolean)CertPathUtil.matchLiteralIP((X509Certificate)this.server[0], (String)"127.0.0.1"));
        Assert.assertFalse((boolean)CertPathUtil.matchLiteralIP((X509Certificate)this.server[0], (String)"127.0.0.2"));
    }

    @Test
    public void testMatchLiteralIP() throws Exception {
        Assert.assertTrue((boolean)CertPathUtil.matchLiteralIP((String)"127.0.0.1", (String)"127.0.0.1"));
        Assert.assertTrue((boolean)CertPathUtil.matchLiteralIP((String)"2001::1", (String)"2001:0:0:0:0:0:0:1"));
        Assert.assertFalse((boolean)CertPathUtil.matchLiteralIP((String)"127.0.0.1", (String)"127.0.0.2"));
        Assert.assertFalse((boolean)CertPathUtil.matchLiteralIP((String)"2001::2", (String)"2001:0:0:0:0:0:0:1"));
    }
}

