/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.ExpectedExceptionWrapper;
import org.eclipse.californium.elements.util.StringUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DatagramWriterTest {
    @Rule
    public ExpectedException exception = ExpectedExceptionWrapper.none();
    DatagramWriter writer;

    @Before
    public void setUp() throws Exception {
        this.writer = new DatagramWriter(32);
    }

    @Test
    public void testWrite() {
        this.writer.write(1193046, 24);
        byte[] data = this.writer.toByteArray();
        Assert.assertEquals((Object)"123456", (Object)DatagramWriterTest.hex(data));
    }

    @Test
    public void testWriteOdd() {
        this.writer.write(8, 4);
        this.writer.write(1193046, 22);
        byte[] data = this.writer.toByteArray();
        Assert.assertEquals((Object)"848D1580", (Object)DatagramWriterTest.hex(data));
    }

    @Test
    public void testWriteTooLarge() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Truncating");
        this.writer.write(1193046, 16);
    }

    @Test
    public void testWriteTooLargeNegativeValue() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Truncating");
        this.writer.write(-1, 16);
    }

    @Test
    public void testWriteTooManyBits() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Number of bits ");
        this.writer.write(1, 33);
    }

    @Test
    public void testWriteFull() {
        this.writer.write(-1, 32);
        byte[] data = this.writer.toByteArray();
        Assert.assertEquals((Object)"FFFFFFFF", (Object)DatagramWriterTest.hex(data));
    }

    @Test
    public void testWriteLong() {
        this.writer.writeLong(78187506637L, 48);
        byte[] data = this.writer.toByteArray();
        Assert.assertEquals((Object)"00123456ABCD", (Object)DatagramWriterTest.hex(data));
    }

    @Test
    public void testWriteLongOdd() {
        this.writer.write(8, 4);
        this.writer.writeLong(78187506637L, 48);
        byte[] data = this.writer.toByteArray();
        Assert.assertEquals((Object)"800123456ABCD0", (Object)DatagramWriterTest.hex(data));
    }

    @Test
    public void testWriteLongTooLarge() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Truncating");
        this.writer.writeLong(78187506637L, 36);
    }

    @Test
    public void testWriteLongTooLargeNegativeValue() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Truncating");
        this.writer.writeLong(-1L, 36);
    }

    @Test
    public void testWriteLongTooManyBits() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Number of bits ");
        this.writer.writeLong(1L, 65);
    }

    @Test
    public void testWriteFullLong() {
        this.writer.writeLong(-1L, 64);
        byte[] data = this.writer.toByteArray();
        Assert.assertEquals((Object)"FFFFFFFFFFFFFFFF", (Object)DatagramWriterTest.hex(data));
    }

    @Test
    public void testWriteByte() {
        this.writer.writeByte((byte)122);
        byte[] data = this.writer.toByteArray();
        Assert.assertEquals((Object)"7A", (Object)DatagramWriterTest.hex(data));
    }

    @Test
    public void testWriteByteOdd() {
        this.writer.write(8, 6);
        this.writer.writeByte((byte)122);
        byte[] data = this.writer.toByteArray();
        Assert.assertEquals((Object)"21E8", (Object)DatagramWriterTest.hex(data));
    }

    @Test
    public void testWriteByteOddNegativeValue() {
        this.writer.write(8, 6);
        this.writer.writeByte((byte)-1);
        byte[] data = this.writer.toByteArray();
        Assert.assertEquals((Object)"23FC", (Object)DatagramWriterTest.hex(data));
    }

    @Test
    public void testWriteBytes() {
        byte[] data = DatagramWriterTest.bin("ab12def671223344556677890a");
        this.writer.writeBytes(data);
        byte[] wdata = this.writer.toByteArray();
        Assert.assertEquals((Object)DatagramWriterTest.hex(data), (Object)DatagramWriterTest.hex(wdata));
    }

    @Test
    public void testWriteBytesOdd() {
        this.writer.write(6, 4);
        byte[] data = DatagramWriterTest.bin("ab12def671223344556677890a");
        this.writer.writeBytes(data);
        byte[] wdata = this.writer.toByteArray();
        Assert.assertEquals((Object)("6" + DatagramWriterTest.hex(data) + "0"), (Object)DatagramWriterTest.hex(wdata));
    }

    @Test
    public void testWriteVarByteArray() {
        byte[] data = DatagramWriterTest.bin("ab12def671223344556677890a");
        this.writer.writeVarBytes(data, 8);
        byte[] wdata = this.writer.toByteArray();
        String expected = String.format("%02X%s", data.length, DatagramWriterTest.hex(data));
        Assert.assertEquals((Object)expected, (Object)DatagramWriterTest.hex(wdata));
    }

    @Test
    public void testWriteEmptyVarByteArray() {
        byte[] data = Bytes.EMPTY;
        this.writer.writeVarBytes(data, 8);
        byte[] wdata = this.writer.toByteArray();
        String expected = String.format("%02X%s", 0, DatagramWriterTest.hex(data));
        Assert.assertEquals((Object)expected, (Object)DatagramWriterTest.hex(wdata));
    }

    @Test
    public void testWriteNullVarByteArray() {
        byte[] data = null;
        this.writer.writeVarBytes(data, 8);
        byte[] wdata = this.writer.toByteArray();
        String expected = "FF";
        Assert.assertEquals((Object)expected, (Object)DatagramWriterTest.hex(wdata));
    }

    @Test
    public void testWriteVarBytes() {
        byte[] data = DatagramWriterTest.bin("ab12def671223344556677890a0011");
        this.writer.writeVarBytes(new Bytes(data), 16);
        byte[] wdata = this.writer.toByteArray();
        String expected = String.format("%04X%s", data.length, DatagramWriterTest.hex(data));
        Assert.assertEquals((Object)expected, (Object)DatagramWriterTest.hex(wdata));
    }

    @Test
    public void testWriteEmptyVarBytes() {
        byte[] data = Bytes.EMPTY;
        this.writer.writeVarBytes(new Bytes(data), 16);
        byte[] wdata = this.writer.toByteArray();
        String expected = String.format("%04X%s", 0, DatagramWriterTest.hex(data));
        Assert.assertEquals((Object)expected, (Object)DatagramWriterTest.hex(wdata));
    }

    @Test
    public void testWriteNullVarBytes() {
        this.writer.writeVarBytes((Bytes)null, 16);
        byte[] wdata = this.writer.toByteArray();
        String expected = "FFFF";
        Assert.assertEquals((Object)expected, (Object)DatagramWriterTest.hex(wdata));
    }

    @Test
    public void testWritePosition() {
        byte[] data = DatagramWriterTest.bin("ab12def671223344556677890a");
        this.writer.writeBytes(data);
        this.writer.writeAt(2, 1193046, 24);
        byte[] wdata = this.writer.toByteArray();
        Assert.assertEquals((Object)"AB12123456223344556677890A", (Object)DatagramWriterTest.hex(wdata));
    }

    @Test
    public void testWritePositionAppend() {
        byte[] data = DatagramWriterTest.bin("ab12def671223344556677890a");
        this.writer.writeBytes(data);
        this.writer.writeAt(11, 1193046, 24);
        byte[] wdata = this.writer.toByteArray();
        Assert.assertEquals((Object)"AB12DEF671223344556677123456", (Object)DatagramWriterTest.hex(wdata));
    }

    @Test
    public void testWriteLongPosition() {
        byte[] data = DatagramWriterTest.bin("ab12def671223344556677890a");
        this.writer.writeBytes(data);
        this.writer.writeLongAt(2, 78187493547L, 40);
        byte[] wdata = this.writer.toByteArray();
        Assert.assertEquals((Object)"AB1212345678AB44556677890A", (Object)DatagramWriterTest.hex(wdata));
    }

    @Test
    public void testWriteLongPositionAppend() {
        byte[] data = DatagramWriterTest.bin("ab12def671223344556677890a");
        this.writer.writeBytes(data);
        this.writer.writeLongAt(10, 78187493547L, 40);
        byte[] wdata = this.writer.toByteArray();
        Assert.assertEquals((Object)"AB12DEF671223344556612345678AB", (Object)DatagramWriterTest.hex(wdata));
    }

    @Test
    public void testWriteDatagramWriter() {
        this.writer.writeBytes(DatagramWriterTest.bin("1234"));
        DatagramWriter writer2 = new DatagramWriter(16);
        writer2.writeBytes(DatagramWriterTest.bin("5678"));
        this.writer.write(writer2);
        byte[] data = this.writer.toByteArray();
        Assert.assertEquals((Object)"12345678", (Object)DatagramWriterTest.hex(data));
    }

    private static byte[] bin(String hex) {
        return StringUtil.hex2ByteArray((String)hex);
    }

    private static String hex(byte[] data) {
        return StringUtil.byteArray2Hex((byte[])data);
    }
}

