/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class NamedThreadFactoryTest {
    @Test
    public void testDaemonThreadGroup() throws Exception {
        ThreadGroup group = new ThreadGroup("test-group");
        group.setDaemon(true);
        this.createAndStopThread(group);
        Assert.assertTrue((String)"group is not destroyed", (boolean)group.isDestroyed());
    }

    @Test
    public void testNoneDaemonThreadGroup() throws Exception {
        ThreadGroup group = new ThreadGroup("test-group");
        group.setDaemon(false);
        this.createAndStopThread(group);
        Assert.assertFalse((String)"group is destroyed", (boolean)group.isDestroyed());
    }

    @Test
    public void testLoadedScandiumThreadGroup() throws Exception {
        ThreadGroup parent = new ThreadGroup("parent");
        parent.setDaemon(true);
        ThreadGroup group = NamedThreadFactoryTest.loadInstance(parent, "SCANDIUM_THREAD_GROUP");
        Assert.assertFalse((String)"not fresh loaded", (group == NamedThreadFactory.SCANDIUM_THREAD_GROUP ? 1 : 0) != 0);
        Assert.assertFalse((String)"still daemon", (boolean)group.isDaemon());
        this.createAndStopThread(group);
        Assert.assertFalse((String)"group is destroyed", (boolean)group.isDestroyed());
    }

    private void createAndStopThread(ThreadGroup group) throws InterruptedException {
        MatcherAssert.assertThat((String)"group is not empty", (Object)group.activeCount(), (Matcher)CoreMatchers.is((Object)0));
        final CountDownLatch ready = new CountDownLatch(1);
        NamedThreadFactory daemons = new NamedThreadFactory("Test", group);
        Assert.assertFalse((String)"group is already destroyed 1", (boolean)group.isDestroyed());
        Thread thread = daemons.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ready.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        thread.start();
        Assert.assertTrue((String)"thread hasn't started", (boolean)thread.isAlive());
        MatcherAssert.assertThat((String)"group misses thread", (Object)group.activeCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertFalse((String)"group is already destroyed 2", (boolean)group.isDestroyed());
        ready.countDown();
        thread.join();
        Assert.assertFalse((String)"thread is still alive", (boolean)thread.isAlive());
        MatcherAssert.assertThat((String)"group is not empty again", (Object)group.activeCount(), (Matcher)CoreMatchers.is((Object)0));
    }

    private static ThreadGroup loadInstance(ThreadGroup parent, final String name) throws Exception {
        final AtomicReference exception = new AtomicReference();
        final AtomicReference group = new AtomicReference();
        Thread execute = new Thread(parent, new Runnable(){

            @Override
            public void run() {
                try {
                    ThreadGroup loadedGroup = NamedThreadFactoryTest.loadInstance(name);
                    group.set(loadedGroup);
                }
                catch (Exception ex) {
                    exception.set(ex);
                }
            }
        });
        execute.start();
        execute.join();
        Exception ex = (Exception)exception.get();
        if (ex != null) {
            throw ex;
        }
        return (ThreadGroup)group.get();
    }

    private static ThreadGroup loadInstance(String name) throws Exception {
        ClassLoader loader = new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (name.startsWith("org.eclipse.californium.")) {
                    InputStream input = this.getClass().getClassLoader().getResourceAsStream(name.replace(".", "/") + ".class");
                    if (input != null) {
                        try {
                            int readlength = 0;
                            byte[] buffer = new byte[1024];
                            ByteArrayOutputStream output = new ByteArrayOutputStream();
                            while ((readlength = input.read(buffer)) != -1) {
                                output.write(buffer, 0, readlength);
                            }
                            byte[] bt = output.toByteArray();
                            return this.defineClass(name, bt, 0, bt.length);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            throw new ClassNotFoundException(name + ": read error!");
                        }
                    }
                    throw new ClassNotFoundException(name);
                }
                return super.loadClass(name);
            }
        };
        Class<?> loadedClass = loader.loadClass(NamedThreadFactory.class.getName());
        Field field = loadedClass.getField(name);
        return (ThreadGroup)field.get(null);
    }
}

