/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TestScheduledExecutorService
implements ScheduledExecutorService {
    private final List<Runnable> jobs = new ArrayList<Runnable>();
    private volatile boolean shutdown;
    private volatile boolean terminated;

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown = true;
        List<Runnable> list = this.jobs;
        synchronized (list) {
            ArrayList<Runnable> jobs = new ArrayList<Runnable>(this.jobs);
            this.jobs.clear();
            this.terminated = true;
            this.jobs.notifyAll();
            return jobs;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        List<Runnable> list = this.jobs;
        synchronized (list) {
            if (!this.terminated) {
                this.jobs.wait(unit.toMillis(timeout));
            }
        }
        return this.terminated;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new RuntimeException("not supported!");
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new RuntimeException("not supported!");
    }

    @Override
    public Future<?> submit(Runnable task) {
        throw new RuntimeException("not supported!");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new RuntimeException("not supported!");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new RuntimeException("not supported!");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new RuntimeException("not supported!");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new RuntimeException("not supported!");
    }

    @Override
    public void execute(Runnable command) {
        if (this.shutdown) {
            throw new RejectedExecutionException("already shutdown!");
        }
        this.jobs.add(command);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (this.shutdown) {
            throw new RejectedExecutionException("already shutdown!");
        }
        ScheduledRunnable job = new ScheduledRunnable(command, delay, unit);
        this.jobs.add(job);
        return job;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        throw new RuntimeException("not supported!");
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        throw new RuntimeException("not supported!");
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        throw new RuntimeException("not supported!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        List<Runnable> list = this.jobs;
        synchronized (list) {
            this.jobs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeJobs() {
        ArrayList<Runnable> currentJobs;
        int count = 0;
        List<Runnable> list = this.jobs;
        synchronized (list) {
            currentJobs = new ArrayList<Runnable>(this.jobs);
        }
        for (Runnable run : currentJobs) {
            if (this.shutdown || !this.isPending(run)) continue;
            run.run();
            ++count;
        }
        list = this.jobs;
        synchronized (list) {
            if (this.shutdown && this.jobs.isEmpty()) {
                this.terminated = true;
                this.jobs.notify();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPending(Runnable run) {
        List<Runnable> list = this.jobs;
        synchronized (list) {
            if (this.jobs.remove(run) && run instanceof ScheduledFuture) {
                ScheduledFuture future = (ScheduledFuture)((Object)run);
                boolean bl = !future.isCancelled();
                return bl;
            }
            return false;
        }
    }

    private class ScheduledRunnable
    implements Runnable,
    ScheduledFuture<Void> {
        private final Runnable job;
        private final long delay;
        private final TimeUnit unit;
        private volatile boolean completed;
        private volatile boolean cancelled;

        private ScheduledRunnable(Runnable job, long delay, TimeUnit unit) {
            this.job = job;
            this.delay = delay;
            this.unit = unit;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.delay, this.unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.getDelay(TimeUnit.NANOSECONDS) - o.getDelay(TimeUnit.NANOSECONDS));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.completed && !this.cancelled) {
                this.cancelled = true;
                List list = TestScheduledExecutorService.this.jobs;
                synchronized (list) {
                    TestScheduledExecutorService.this.jobs.remove(this);
                }
                if (mayInterruptIfRunning) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.cancelled;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.completed;
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                this.job.run();
                if (!this.cancelled) {
                    this.completed = true;
                }
            }
        }
    }
}

