/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.configurator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeAliasRegistry;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.AbstractEngineConfiguration;
import org.flowable.engine.common.impl.AbstractEngineConfigurator;
import org.flowable.engine.common.impl.EngineDeployer;
import org.flowable.engine.common.impl.db.MybatisTypeAliasConfigurator;
import org.flowable.engine.common.impl.db.MybatisTypeHandlerConfigurator;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.deployer.FormDeployer;
import org.flowable.form.engine.impl.cfg.StandaloneFormEngineConfiguration;
import org.flowable.form.engine.impl.db.EntityDependencyOrder;
import org.flowable.form.engine.impl.persistence.ResourceRefTypeHandler;
import org.flowable.form.engine.impl.persistence.entity.ResourceRef;

public class FormEngineConfigurator
extends AbstractEngineConfigurator {
    protected FormEngineConfiguration formEngineConfiguration;

    public int getPriority() {
        return 300000;
    }

    protected List<EngineDeployer> getCustomDeployers() {
        ArrayList<EngineDeployer> deployers = new ArrayList<EngineDeployer>();
        deployers.add(new FormDeployer());
        return deployers;
    }

    protected String getMybatisCfgPath() {
        return "org/flowable/form/db/mapping/mappings.xml";
    }

    protected List<MybatisTypeAliasConfigurator> getMybatisTypeAliases() {
        return Collections.singletonList(new MybatisTypeAliasConfigurator(){

            public void configure(TypeAliasRegistry typeAliasRegistry) {
                typeAliasRegistry.registerAlias("ResourceRefTypeHandler", ResourceRefTypeHandler.class);
            }
        });
    }

    protected List<MybatisTypeHandlerConfigurator> getMybatisTypeHandlers() {
        return Collections.singletonList(new MybatisTypeHandlerConfigurator(){

            public void configure(TypeHandlerRegistry typeHandlerRegistry) {
                typeHandlerRegistry.register(ResourceRef.class, JdbcType.VARCHAR, ResourceRefTypeHandler.class);
            }
        });
    }

    public void configure(AbstractEngineConfiguration engineConfiguration) {
        if (this.formEngineConfiguration == null) {
            this.formEngineConfiguration = new StandaloneFormEngineConfiguration();
        }
        this.initialiseCommonProperties(engineConfiguration, (AbstractEngineConfiguration)this.formEngineConfiguration);
        this.initFormEngine();
        this.initServiceConfigurations(engineConfiguration, (AbstractEngineConfiguration)this.formEngineConfiguration);
    }

    protected List<Class<? extends Entity>> getEntityInsertionOrder() {
        return EntityDependencyOrder.INSERT_ORDER;
    }

    protected List<Class<? extends Entity>> getEntityDeletionOrder() {
        return EntityDependencyOrder.DELETE_ORDER;
    }

    protected synchronized FormEngine initFormEngine() {
        if (this.formEngineConfiguration == null) {
            throw new FlowableException("FormEngineConfiguration is required");
        }
        return this.formEngineConfiguration.buildFormEngine();
    }

    public FormEngineConfiguration getFormEngineConfiguration() {
        return this.formEngineConfiguration;
    }

    public FormEngineConfigurator setFormEngineConfiguration(FormEngineConfiguration formEngineConfiguration) {
        this.formEngineConfiguration = formEngineConfiguration;
        return this;
    }
}

