/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.content;

import org.flowable.content.api.ContentManagementService;
import org.flowable.content.api.ContentService;
import org.flowable.content.engine.ContentEngine;
import org.flowable.content.engine.ContentEngineConfiguration;
import org.flowable.content.engine.ContentEngines;
import org.flowable.content.spring.ContentEngineFactoryBean;
import org.flowable.engine.ProcessEngine;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnContentEngine;
import org.flowable.spring.boot.content.ContentEngineAutoConfiguration;
import org.flowable.spring.boot.content.FlowableContentProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnContentEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableContentProperties.class})
@AutoConfigureAfter(value={ContentEngineAutoConfiguration.class, ProcessEngineAutoConfiguration.class})
public class ContentEngineServicesAutoConfiguration {
    @Bean
    public ContentService contentService(ContentEngine contentEngine) {
        return contentEngine.getContentService();
    }

    @Bean
    public ContentManagementService contentManagementService(ContentEngine contentEngine) {
        return contentEngine.getContentManagementService();
    }

    @Configuration
    @ConditionalOnMissingBean(type={"org.flowable.content.engine.ContentEngine", "org.flowable.engine.ProcessEngine"})
    static class StandaloneConfiguration {
        StandaloneConfiguration() {
        }

        @Bean
        public ContentEngineFactoryBean contentEngine(ContentEngineConfiguration contentEngineConfiguration) {
            ContentEngineFactoryBean factory = new ContentEngineFactoryBean();
            factory.setContentEngineConfiguration(contentEngineConfiguration);
            return factory;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(type={"org.flowable.content.engine.ContentEngine"})
    @ConditionalOnBean(type={"org.flowable.engine.ProcessEngine"})
    static class AlreadyInitializedConfiguration {
        AlreadyInitializedConfiguration() {
        }

        @Bean
        public ContentEngine contentEngine(ProcessEngine processEngine) {
            if (!ContentEngines.isInitialized()) {
                throw new IllegalStateException("Content engine has not been initialized");
            }
            return ContentEngines.getDefaultContentEngine();
        }
    }
}

