/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import org.flowable.common.engine.api.identity.AuthenticationContext;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.idm.IdmEngineServicesAutoConfiguration;
import org.flowable.spring.security.FlowableAuthenticationProvider;
import org.flowable.spring.security.FlowableUserDetailsService;
import org.flowable.spring.security.SpringSecurityAuthenticationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.core.userdetails.UserDetailsService;

@Configuration
@ConditionalOnClass(value={AuthenticationManager.class, IdmIdentityService.class, FlowableAuthenticationProvider.class, GlobalAuthenticationConfigurerAdapter.class})
@ConditionalOnBean(value={IdmIdentityService.class})
@AutoConfigureBefore(value={SecurityAutoConfiguration.class})
@AutoConfigureAfter(value={IdmEngineServicesAutoConfiguration.class, ProcessEngineAutoConfiguration.class})
public class FlowableSecurityAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableSecurityAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={UserDetailsService.class})
    public FlowableUserDetailsService flowableUserDetailsService(IdmIdentityService identityService) {
        return new FlowableUserDetailsService(identityService);
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthenticationProvider.class})
    public FlowableAuthenticationProvider flowableAuthenticationProvider(IdmIdentityService idmIdentityService, UserDetailsService userDetailsService) {
        return new FlowableAuthenticationProvider(idmIdentityService, userDetailsService);
    }

    @Configuration
    @ConditionalOnClass(value={AuthenticationContext.class})
    public static class SpringSecurityAuthenticationContextConfiguration {
        public SpringSecurityAuthenticationContextConfiguration(ObjectProvider<AuthenticationContext> authenticationContext) {
            AuthenticationContext context = (AuthenticationContext)authenticationContext.getIfAvailable();
            if (context == null) {
                context = new SpringSecurityAuthenticationContext();
            }
            Authentication.setAuthenticationContext((AuthenticationContext)context);
        }
    }

    @Configuration
    public static class UserDetailsServiceConfiguration
    extends GlobalAuthenticationConfigurerAdapter {
        protected final ObjectProvider<AuthenticationProvider> authenticationProviderProvider;
        protected final ObjectProvider<UserDetailsService> userDetailsServiceProvider;

        public UserDetailsServiceConfiguration(ObjectProvider<AuthenticationProvider> authenticationProviderProvider, ObjectProvider<UserDetailsService> userDetailsServiceProvider) {
            this.authenticationProviderProvider = authenticationProviderProvider;
            this.userDetailsServiceProvider = userDetailsServiceProvider;
        }

        public void init(AuthenticationManagerBuilder auth) throws Exception {
            if (!auth.isConfigured()) {
                AuthenticationProvider authenticationProvider = (AuthenticationProvider)this.authenticationProviderProvider.getIfUnique();
                if (authenticationProvider != null) {
                    auth.authenticationProvider(authenticationProvider);
                } else {
                    LOGGER.warn("There is no authentication provider configured. However, there is no single one in the context. Please configure the global authentication provider by yourself.");
                }
            }
        }
    }
}

