/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.eventregistry;

import org.flowable.app.engine.AppEngine;
import org.flowable.engine.ProcessEngine;
import org.flowable.eventregistry.api.EventManagementService;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.EventRegistryEngines;
import org.flowable.eventregistry.spring.EventRegistryFactoryBean;
import org.flowable.eventregistry.spring.SpringEventRegistryEngineConfiguration;
import org.flowable.spring.boot.BaseEngineConfigurationWithConfigurers;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.ProcessEngineServicesAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineServicesAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnEventRegistry;
import org.flowable.spring.boot.eventregistry.EventRegistryAutoConfiguration;
import org.flowable.spring.boot.eventregistry.FlowableEventRegistryProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnEventRegistry
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableEventRegistryProperties.class})
@AutoConfiguration(after={EventRegistryAutoConfiguration.class, AppEngineServicesAutoConfiguration.class, ProcessEngineServicesAutoConfiguration.class})
public class EventRegistryServicesAutoConfiguration {
    @Bean
    public EventRepositoryService eventRepositoryService(EventRegistryEngine eventRegistryEngine) {
        return eventRegistryEngine.getEventRepositoryService();
    }

    @Bean
    public EventManagementService eventManagementService(EventRegistryEngine eventRegistryEngine) {
        return eventRegistryEngine.getEventManagementService();
    }

    @Bean
    public EventRegistry eventRegistry(EventRegistryEngine eventRegistryEngine) {
        return eventRegistryEngine.getEventRegistry();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(type={"org.flowable.eventregistry.impl.EventRegistryEngine", "org.flowable.engine.ProcessEngine", "org.flowable.app.engine.AppEngine"})
    static class StandaloneEventRegistryConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringEventRegistryEngineConfiguration> {
        StandaloneEventRegistryConfiguration() {
        }

        @Bean
        public EventRegistryFactoryBean formEngine(SpringEventRegistryEngineConfiguration eventEngineConfiguration) {
            EventRegistryFactoryBean factory = new EventRegistryFactoryBean();
            factory.setEventEngineConfiguration((EventRegistryEngineConfiguration)eventEngineConfiguration);
            this.invokeConfigurers(eventEngineConfiguration);
            return factory;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(type={"org.flowable.eventregistry.impl.EventRegistryEngine"})
    @ConditionalOnBean(type={"org.flowable.app.engine.AppEngine"})
    static class AlreadyInitializedAppEngineConfiguration {
        AlreadyInitializedAppEngineConfiguration() {
        }

        @Bean
        public EventRegistryEngine eventRegistryEngine(AppEngine appEngine) {
            if (!EventRegistryEngines.isInitialized()) {
                throw new IllegalStateException("Event registry has not been initialized");
            }
            return EventRegistryEngines.getDefaultEventRegistryEngine();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(type={"org.flowable.eventregistry.impl.EventRegistryEngine", "org.flowable.app.engine.AppEngine"})
    @ConditionalOnBean(type={"org.flowable.engine.ProcessEngine"})
    static class AlreadyInitializedEventRegistryConfiguration {
        AlreadyInitializedEventRegistryConfiguration() {
        }

        @Bean
        public EventRegistryEngine eventRegistryEngine(ProcessEngine processEngine) {
            if (!EventRegistryEngines.isInitialized()) {
                throw new IllegalStateException("Event registry has not been initialized");
            }
            return EventRegistryEngines.getDefaultEventRegistryEngine();
        }
    }
}

