/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.Privilege;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.ConflictingRequestException;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.idm.model.UserInformation;
import org.flowable.ui.idm.service.AbstractIdmService;
import org.flowable.ui.idm.service.UserService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserServiceImpl
extends AbstractIdmService
implements UserService {
    private static final int MAX_USER_SIZE = 100;

    @Override
    public List<User> getUsers(String filter, String sort, Integer start) {
        Integer startValue = start != null ? start : 0;
        Integer size = 100;
        return this.createUserQuery(filter, sort).listPage(startValue.intValue(), size != null && size > 0 ? size : 100);
    }

    @Override
    public long getUserCount(String filter, String sort, Integer start, String groupId) {
        return this.createUserQuery(filter, sort).count();
    }

    protected UserQuery createUserQuery(String filter, String sort) {
        UserQuery userQuery = this.identityService.createUserQuery();
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            userQuery.userFullNameLikeIgnoreCase("%" + filter + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)sort)) {
            if ("idDesc".equals(sort)) {
                ((UserQuery)userQuery.orderByUserId()).desc();
            } else if ("idAsc".equals(sort)) {
                ((UserQuery)userQuery.orderByUserId()).asc();
            } else if ("emailAsc".equals(sort)) {
                ((UserQuery)userQuery.orderByUserEmail()).asc();
            } else if ("emailDesc".equals(sort)) {
                ((UserQuery)userQuery.orderByUserEmail()).desc();
            }
        }
        return userQuery;
    }

    @Override
    public void updateUserDetails(String userId, String firstName, String lastName, String email) {
        User user = (User)((UserQuery)this.identityService.createUserQuery().userId(userId)).singleResult();
        if (user != null) {
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setEmail(email);
            this.identityService.saveUser(user);
        }
    }

    @Override
    public void bulkUpdatePassword(List<String> userIds, String newPassword) {
        for (String userId : userIds) {
            User user = (User)((UserQuery)this.identityService.createUserQuery().userId(userId)).singleResult();
            if (user == null) continue;
            user.setPassword(newPassword);
            this.identityService.updateUserPassword(user);
        }
    }

    @Override
    public void deleteUser(String userId) {
        List privileges = this.identityService.createPrivilegeQuery().userId(userId).list();
        for (Privilege privilege : privileges) {
            this.identityService.deleteUserPrivilegeMapping(privilege.getId(), userId);
        }
        List groups = this.identityService.createGroupQuery().groupMember(userId).list();
        if (groups != null && groups.size() > 0) {
            for (Group group : groups) {
                this.identityService.deleteMembership(userId, group.getId());
            }
        }
        this.identityService.deleteUser(userId);
    }

    @Override
    public User createNewUser(String id, String firstName, String lastName, String email, String password) {
        if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)password) || StringUtils.isBlank((CharSequence)firstName)) {
            throw new BadRequestException("Id, password and first name are required");
        }
        if (email != null && ((UserQuery)this.identityService.createUserQuery().userEmail(email)).count() > 0L) {
            throw new ConflictingRequestException("User already registered", "ACCOUNT.SIGNUP.ERROR.ALREADY-REGISTERED");
        }
        User user = this.identityService.newUser(id);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEmail(email);
        this.identityService.saveUser(user);
        User savedUser = (User)((UserQuery)this.identityService.createUserQuery().userEmail(email)).singleResult();
        savedUser.setPassword(password);
        this.identityService.updateUserPassword(savedUser);
        return user;
    }

    @Override
    public UserInformation getUserInformation(String userId) {
        User user = (User)((UserQuery)this.identityService.createUserQuery().userId(userId)).singleResult();
        if (user == null) {
            throw new NotFoundException();
        }
        List userPrivileges = this.identityService.createPrivilegeQuery().userId(userId).list();
        HashSet<String> privilegeNames = new HashSet<String>();
        for (Privilege userPrivilege : userPrivileges) {
            privilegeNames.add(userPrivilege.getName());
        }
        List groups = this.identityService.createGroupQuery().groupMember(userId).list();
        if (groups.size() > 0) {
            ArrayList<String> groupIds = new ArrayList<String>();
            for (Group group : groups) {
                groupIds.add(group.getId());
            }
            List groupPrivileges = this.identityService.createPrivilegeQuery().groupIds(groupIds).list();
            for (Privilege groupPrivilege : groupPrivileges) {
                privilegeNames.add(groupPrivilege.getName());
            }
        }
        return new UserInformation(user, groups, new ArrayList<String>(privilegeNames));
    }
}

