/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.numeric;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jaitools.CollectionFactory;
import org.jaitools.numeric.AbstractProcessor;
import org.jaitools.numeric.Statistic;

public class ApproxMedianProcessor
extends AbstractProcessor {
    private static final Set<Statistic> SUPPORTED = Collections.singleton(Statistic.APPROX_MEDIAN);
    private static final int BASE = 21;
    private static final int MEDIAN_POS = 10;
    private boolean needsCalculation = true;
    private double remedian;
    private List<Buffer> buffers = CollectionFactory.list();
    private Buffer buf0 = new Buffer();

    public ApproxMedianProcessor() {
        this.buffers.add(this.buf0);
    }

    @Override
    public Collection<Statistic> getSupported() {
        return SUPPORTED;
    }

    @Override
    protected boolean update(Double sample) {
        if (this.isAccepted(sample)) {
            if (this.buf0.isFull()) {
                this.cascade(0);
            }
            this.buf0.add(sample);
            this.needsCalculation = true;
            return true;
        }
        return false;
    }

    @Override
    public Double get(Statistic stat) {
        if (SUPPORTED.contains((Object)stat)) {
            if (this.getNumAccepted() == 0L) {
                return Double.NaN;
            }
            if (this.getNumAccepted() == 1L) {
                return this.buf0.data[0];
            }
            if (this.needsCalculation) {
                List samples = CollectionFactory.list();
                long weight = 1L;
                for (Buffer buf : this.buffers) {
                    for (int i = 0; i < buf.pos; ++i) {
                        WeightedSample datum = new WeightedSample();
                        datum.value = buf.data[i];
                        datum.weight = weight;
                        samples.add(datum);
                    }
                    weight *= 21L;
                }
                Collections.sort(samples);
                long nHalf = this.getNumAccepted() / 2L;
                Iterator iter = samples.iterator();
                WeightedSample datum = null;
                for (long n = 0L; n < nHalf; n += datum.weight) {
                    datum = (WeightedSample)iter.next();
                }
                this.remedian = datum.value;
                this.needsCalculation = false;
            }
            return this.remedian;
        }
        throw new IllegalArgumentException((Object)((Object)stat) + " not supported by " + this.getClass().getName());
    }

    private void cascade(int level) {
        Buffer nextBuf;
        Buffer buf = this.buffers.get(level);
        Arrays.sort(buf.data);
        double median = buf.data[10];
        if (level + 1 < this.buffers.size()) {
            nextBuf = this.buffers.get(level + 1);
        } else {
            nextBuf = new Buffer();
            this.buffers.add(nextBuf);
        }
        if (nextBuf.isFull()) {
            this.cascade(level + 1);
        }
        buf.pos = 0;
        nextBuf.add(median);
    }

    private static class WeightedSample
    implements Comparable<WeightedSample> {
        double value;
        long weight;

        private WeightedSample() {
        }

        @Override
        public int compareTo(WeightedSample other) {
            return Double.compare(this.value, other.value);
        }
    }

    private static class Buffer {
        double[] data = new double[21];
        int pos = 0;

        private Buffer() {
        }

        void add(double value) {
            this.data[this.pos++] = value;
        }

        boolean isFull() {
            return this.pos >= 21;
        }
    }
}

