/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.vectorize;

import java.awt.image.renderable.ParameterBlock;
import java.util.Collection;
import java.util.Collections;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ROI;

public class VectorizeDescriptor
extends OperationDescriptorImpl {
    public static final String VECTOR_PROPERTY_NAME = "vectors";
    public static final int FILTER_MERGE_LARGEST = 0;
    public static final int FILTER_MERGE_RANDOM = 1;
    public static final int FILTER_DELETE = 2;
    static final int ROI_ARG = 0;
    static final int BAND_ARG = 1;
    static final int OUTSIDE_VALUES_ARG = 2;
    static final int INSIDE_EDGES_ARG = 3;
    static final int REMOVE_COLLINEAR_ARG = 4;
    static final int FILTER_SMALL_POLYS_ARG = 5;
    static final int FILTER_METHOD_ARG = 6;
    private static final String[] paramNames = new String[]{"roi", "band", "outsideValues", "insideEdges", "removeCollinear", "filterThreshold", "filterMethod"};
    private static final Class[] paramClasses = new Class[]{ROI.class, Integer.class, Collection.class, Boolean.class, Boolean.class, Double.class, Integer.class};
    private static final Object[] paramDefaults = new Object[]{null, 0, Collections.EMPTY_LIST, Boolean.TRUE, Boolean.TRUE, 0.0, 0};

    public VectorizeDescriptor() {
        super((String[][])new String[][]{{"GlobalName", "Vectorize"}, {"LocalName", "Vectorize"}, {"Vendor", "org.jaitools.media.jai"}, {"Description", "Vecotirze boundaries of regions of uniform value"}, {"DocURL", "http://code.google.com/p/jaitools/"}, {"Version", "1.1.0"}, {"arg0Desc", paramNames[0] + " an optional ROI"}, {"arg1Desc", paramNames[1] + " (Integer, default=0) the source image band to process"}, {"arg2Desc", paramNames[2] + " (Collection, default=null) optional set of values to treat as outside"}, {"arg3Desc", paramNames[3] + " (Boolean, default=true) whether to vectorize boundaries between adjacentregions with non-outside values"}, {"arg4Desc", paramNames[4] + " (Boolean, default=false) whether to reduce collinear points in the resulting polygons"}, {"arg5Desc", paramNames[5] + " (Double, default=0) area (fractional pixels) below which polygons will be filtered"}, {"arg6Desc", paramNames[6] + " (Integer, default=FILTER_MERGE_LARGEST) filter method to use for polygons smaller than threshold area"}}, new String[]{"rendered"}, 1, paramNames, paramClasses, paramDefaults, null);
    }

    protected boolean validateParameters(String modeName, ParameterBlock pb, StringBuffer msg) {
        int filterMethod;
        boolean ok = super.validateParameters(modeName, pb, msg);
        if (ok && (filterMethod = pb.getIntParameter(6)) != 0 && filterMethod != 1 && filterMethod != 2) {
            ok = false;
            msg.append("Invalid filter method: ").append(filterMethod);
        }
        return ok;
    }
}

