/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jamon.api.Location;
import org.jamon.codegen.AbstractStatement;
import org.jamon.codegen.ArgNames;
import org.jamon.codegen.CallStatement;
import org.jamon.codegen.ClassNames;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.ParamValues;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.util.StringUtils;

public abstract class AbstractCallStatement
extends AbstractStatement
implements CallStatement {
    private final String path;
    private final ParamValues params;
    private final Map<String, FragmentUnit> fragParams = new HashMap<String, FragmentUnit>();
    private static final String FRAGMENT_IMPL_PREFIX = "__jamon__instanceOf__";
    private final Map<FragmentUnit, String> m_fragmentImplNames = new HashMap<FragmentUnit, String>();

    AbstractCallStatement(String path, ParamValues params, Location location, String templateIdentifier) {
        super(location, templateIdentifier);
        this.path = path;
        this.params = params;
    }

    @Override
    public void addFragmentImpl(FragmentUnit unit, ParserErrorsImpl errors) {
        this.fragParams.put(unit.getName(), unit);
    }

    protected abstract String getFragmentIntfName(FragmentUnit var1);

    private String getFragmentImplName(CodeWriter writer, FragmentUnit fragmentUnitIntf) {
        if (!this.m_fragmentImplNames.containsKey(fragmentUnitIntf)) {
            this.m_fragmentImplNames.put(fragmentUnitIntf, FRAGMENT_IMPL_PREFIX + writer.nextFragmentImplCounter() + "__" + fragmentUnitIntf.getFragmentInterfaceName(false));
        }
        return this.m_fragmentImplNames.get(fragmentUnitIntf);
    }

    private void makeFragmentImplClass(FragmentUnit fragmentUnitIntf, CodeWriter writer, TemplateDescriber describer) throws ParserErrorImpl {
        FragmentUnit fragmentUnitImpl = this.fragParams.remove(fragmentUnitIntf.getName());
        if (fragmentUnitImpl == null) {
            throw new ParserErrorImpl(this.getLocation(), "Call is missing fragment " + fragmentUnitIntf.getName());
        }
        writer.println("class " + this.getFragmentImplName(writer, fragmentUnitIntf));
        writer.println("  extends " + ClassNames.BASE_TEMPLATE);
        writer.println("  implements " + this.getFragmentIntfName(fragmentUnitIntf));
        writer.openBlock();
        writer.println("public " + this.getFragmentImplName(writer, fragmentUnitIntf) + "(" + ClassNames.TEMPLATE_MANAGER + " p_manager)");
        writer.openBlock();
        writer.println("super(p_manager);");
        writer.closeBlock();
        writer.print("@Override public " + ClassNames.RENDERER + " makeRenderer");
        writer.openList();
        fragmentUnitImpl.printRenderArgsDecl(writer);
        writer.closeList();
        writer.println();
        writer.openBlock();
        writer.print("return new " + ClassNames.ABSTRACT_RENDERER + "()");
        writer.openBlock();
        writer.println("@Override");
        writer.println("public void renderTo(" + ArgNames.WRITER_DECL + ")");
        fragmentUnitImpl.generateThrowsIOExceptionIfNecessary(writer);
        writer.openBlock();
        writer.print("renderNoFlush");
        writer.openList();
        writer.printListElement("jamonWriter");
        fragmentUnitImpl.printRenderArgs(writer);
        writer.closeList();
        writer.println(";");
        writer.closeBlock();
        writer.closeBlock(";");
        writer.closeBlock();
        writer.print("@Override public void renderNoFlush");
        writer.openList();
        writer.printListElement(ArgNames.WRITER_DECL);
        fragmentUnitImpl.printRenderArgsDecl(writer);
        writer.closeList();
        fragmentUnitImpl.generateThrowsIOExceptionIfNecessary(writer);
        fragmentUnitImpl.generateRenderBody(writer, describer);
        writer.closeBlock();
    }

    protected void makeFragmentImplClasses(List<FragmentArgument> fragmentInterfaces, CodeWriter writer, TemplateDescriber describer) throws ParserErrorImpl {
        if (this.fragParams.size() == 1 && this.fragParams.keySet().iterator().next() == null) {
            if (fragmentInterfaces.size() == 0) {
                throw new ParserErrorImpl(this.getLocation(), "Call provides a fragment, but none are expected");
            }
            if (fragmentInterfaces.size() > 1) {
                throw new ParserErrorImpl(this.getLocation(), "Call must provide multiple fragments");
            }
            this.fragParams.put(fragmentInterfaces.get(0).getName(), this.fragParams.remove(null));
        }
        for (FragmentArgument arg : fragmentInterfaces) {
            this.makeFragmentImplClass(arg.getFragmentUnit(), writer, describer);
        }
    }

    protected void generateFragmentParams(CodeWriter writer, List<FragmentArgument> fragmentInterfaces) {
        for (FragmentArgument fragmentArgument : fragmentInterfaces) {
            writer.printListElement("new " + this.getFragmentImplName(writer, fragmentArgument.getFragmentUnit()) + "(this.getTemplateManager())");
        }
    }

    protected void checkSuppliedParams() throws ParserErrorImpl {
        if (this.getParams().hasUnusedParams()) {
            throw this.constructExtraParamsException("arguments", this.getParams().getUnusedParams());
        }
        if (!this.fragParams.isEmpty()) {
            throw this.constructExtraParamsException("fragments", this.fragParams.keySet());
        }
    }

    ParserErrorImpl constructExtraParamsException(String paramType, Iterable<String> extraParams) {
        StringBuilder message = new StringBuilder("Call provides unused ");
        message.append(paramType);
        message.append(" ");
        StringUtils.commaJoin(message, extraParams);
        return new ParserErrorImpl(this.getLocation(), message.toString());
    }

    protected final String getPath() {
        return this.path;
    }

    protected final ParamValues getParams() {
        return this.params;
    }
}

