/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jamon.api.Location;
import org.jamon.codegen.AbstractArgument;
import org.jamon.codegen.AbstractStatementBlock;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.GenericParams;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.RequiredArgument;
import org.jamon.codegen.SequentialList;
import org.jamon.codegen.StatementBlock;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.codegen.Unit;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.ArgNode;
import org.jamon.node.FragmentArgsNode;
import org.jamon.node.OptionalArgNode;

public abstract class AbstractUnit
extends AbstractStatementBlock
implements Unit {
    private final String name;
    private final ParserErrorsImpl errors;
    private final Set<String> argNames = new HashSet<String>();

    public AbstractUnit(String name, StatementBlock parent, ParserErrorsImpl errors, Location location) {
        super(parent, location);
        this.name = name;
        this.errors = errors;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Unit getParentUnit() {
        return (Unit)this.getParent();
    }

    protected final ParserErrorsImpl getErrors() {
        return this.errors;
    }

    protected abstract void addFragmentArg(FragmentArgument var1);

    @Override
    public abstract List<FragmentArgument> getFragmentArgs();

    @Override
    public FragmentUnit getFragmentUnitIntf(String path) {
        for (FragmentArgument arg : this.getFragmentArgs()) {
            if (!path.equals(arg.getName())) continue;
            return arg.getFragmentUnit();
        }
        return null;
    }

    @Override
    public void generateRenderBody(CodeWriter writer, TemplateDescriber describer) throws ParserErrorImpl {
        writer.openBlock();
        this.printStatements(writer, describer);
        writer.closeBlock();
    }

    public abstract void addRequiredArg(RequiredArgument var1);

    public abstract void addOptionalArg(OptionalArgument var1);

    @Override
    public abstract List<RequiredArgument> getSignatureRequiredArgs();

    @Override
    public abstract Collection<OptionalArgument> getSignatureOptionalArgs();

    public abstract Collection<AbstractArgument> getVisibleArgs();

    @Override
    public FragmentUnit addFragment(FragmentArgsNode node, GenericParams genericParams) {
        this.checkArgName(node.getFragmentName(), node.getLocation());
        FragmentUnit frag = new FragmentUnit(node.getFragmentName(), this, genericParams, this.errors, node.getLocation());
        this.addFragmentArg(new FragmentArgument(frag, node.getLocation()));
        return frag;
    }

    @Override
    public void addRequiredArg(ArgNode node) {
        this.checkArgName(node.getName().getName(), node.getName().getLocation());
        this.addRequiredArg(new RequiredArgument(node));
    }

    @Override
    public void addOptionalArg(OptionalArgNode node) {
        this.checkArgName(node.getName().getName(), node.getName().getLocation());
        this.addOptionalArg(new OptionalArgument(node));
    }

    protected void addArgName(AbstractArgument arg) {
        this.argNames.add(arg.getName());
    }

    private void checkArgName(String name, Location location) {
        if (!this.argNames.add(name)) {
            this.getErrors().addError("multiple arguments named " + name, location);
        }
    }

    public List<AbstractArgument> getRenderArgs() {
        return new SequentialList<AbstractArgument>(this.getSignatureRequiredArgs(), this.getFragmentArgs());
    }

    @Override
    public void printRenderArgsDecl(CodeWriter writer) {
        AbstractUnit.printArgsDecl(writer, this.getRenderArgs());
    }

    public void printRenderArgs(CodeWriter writer) {
        AbstractUnit.printArgs(writer, this.getRenderArgs());
    }

    protected static void printArgsDecl(CodeWriter writer, Iterable<? extends AbstractArgument> i) {
        for (AbstractArgument abstractArgument : i) {
            writer.printListElement("final " + abstractArgument.getFullyQualifiedType() + " " + abstractArgument.getName());
        }
    }

    protected static void printArgs(CodeWriter writer, Iterable<? extends AbstractArgument> args) {
        for (AbstractArgument abstractArgument : args) {
            writer.printListElement(abstractArgument.getName());
        }
    }

    protected void generateInterfaceSummary(StringBuilder buf) {
        buf.append("Required\n");
        for (RequiredArgument arg : this.getSignatureRequiredArgs()) {
            buf.append(arg.getName());
            buf.append(":");
            buf.append(arg.getType());
            buf.append("\n");
        }
        buf.append("Optional\n");
        TreeMap<String, OptionalArgument> optArgs = new TreeMap<String, OptionalArgument>();
        for (OptionalArgument arg : this.getSignatureOptionalArgs()) {
            optArgs.put(arg.getName(), arg);
        }
        for (OptionalArgument arg : optArgs.values()) {
            buf.append(arg.getName());
            buf.append(":");
            buf.append(arg.getType());
            buf.append("\n");
        }
    }
}

