/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jamon.api.Location;
import org.jamon.codegen.AbstractArgument;
import org.jamon.codegen.CallStatement;
import org.jamon.codegen.ChildCallStatement;
import org.jamon.codegen.ComponentCallStatement;
import org.jamon.codegen.DefCallStatement;
import org.jamon.codegen.DefUnit;
import org.jamon.codegen.EscapingDirective;
import org.jamon.codegen.FargCallStatement;
import org.jamon.codegen.FlowControlBlock;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.InheritedUnit;
import org.jamon.codegen.LiteralStatement;
import org.jamon.codegen.MethodCallStatement;
import org.jamon.codegen.MethodUnit;
import org.jamon.codegen.NamedParamValues;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.ParamValues;
import org.jamon.codegen.PathAdapter;
import org.jamon.codegen.RawStatement;
import org.jamon.codegen.SequentialIterator;
import org.jamon.codegen.Statement;
import org.jamon.codegen.StatementBlock;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.codegen.TemplateDescription;
import org.jamon.codegen.TemplateUnit;
import org.jamon.codegen.UnnamedParamValues;
import org.jamon.codegen.WriteStatement;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.emit.EmitMode;
import org.jamon.node.AbsMethodNode;
import org.jamon.node.AbstractComponentCallNode;
import org.jamon.node.AbstractEscapeNode;
import org.jamon.node.AbstractNode;
import org.jamon.node.AbstractParamsNode;
import org.jamon.node.AbstractPathNode;
import org.jamon.node.AliasDefNode;
import org.jamon.node.AliasesNode;
import org.jamon.node.AnalysisAdapter;
import org.jamon.node.AnnotationNode;
import org.jamon.node.ArgNode;
import org.jamon.node.ChildCallNode;
import org.jamon.node.ClassNode;
import org.jamon.node.DefNode;
import org.jamon.node.DefaultEscapeNode;
import org.jamon.node.DepthFirstAnalysisAdapter;
import org.jamon.node.ElseIfNode;
import org.jamon.node.ElseNode;
import org.jamon.node.EmitNode;
import org.jamon.node.EscapeDirectiveNode;
import org.jamon.node.EscapeNode;
import org.jamon.node.ExtendsNode;
import org.jamon.node.ForNode;
import org.jamon.node.FragmentArgsNode;
import org.jamon.node.FragmentCallNode;
import org.jamon.node.GenericCallParam;
import org.jamon.node.GenericsParamNode;
import org.jamon.node.IfNode;
import org.jamon.node.ImplementNode;
import org.jamon.node.ImportNode;
import org.jamon.node.JavaNode;
import org.jamon.node.LiteralNode;
import org.jamon.node.MethodNode;
import org.jamon.node.MultiFragmentCallNode;
import org.jamon.node.NamedFragmentNode;
import org.jamon.node.NamedParamNode;
import org.jamon.node.NamedParamsNode;
import org.jamon.node.OptionalArgNode;
import org.jamon.node.OverrideNode;
import org.jamon.node.ParamValueNode;
import org.jamon.node.ParentArgNode;
import org.jamon.node.ParentArgWithDefaultNode;
import org.jamon.node.ParentArgsNode;
import org.jamon.node.ParentMarkerNode;
import org.jamon.node.ReplaceableNode;
import org.jamon.node.ReplacesNode;
import org.jamon.node.SimpleCallNode;
import org.jamon.node.StaticImportNode;
import org.jamon.node.TextNode;
import org.jamon.node.TopNode;
import org.jamon.node.UnnamedParamsNode;
import org.jamon.node.WhileNode;
import org.jamon.util.StringUtils;

public class Analyzer {
    static final String ABSTRACT_REPLACING_TEMPLATE_ERROR = "An abstract template cannot replace another template";
    static final String ABSTRACT_REPLACEABLE_TEMPLATE_ERROR = "Abstract templates are not replaceable";
    static final String REPLACING_NON_REPLACEABLE_TEMPLATE_ERROR = "Replaced template is not marked as <%replaceable>";
    static final String XARGS_DECLARED_WITHOUT_PARENT_ERROR = "xargs may not be declared without extending another template";
    private final TemplateUnit templateUnit;
    private StatementBlock currentStatementBlock;
    private final TemplateDescriber describer;
    private final Set<String> children;
    private final LinkedList<CallStatement> callStatements = new LinkedList();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final String templateDir;
    private final String templateIdentifier;
    private final EmitMode emitMode;
    private ParserErrorsImpl errors = new ParserErrorsImpl();
    private EscapingDirective defaultEscaping;

    public Analyzer(String templatePath, TemplateDescriber describer, Set<String> children) throws IOException {
        this.templateUnit = new TemplateUnit(templatePath, this.errors);
        this.templateDir = templatePath.substring(0, 1 + templatePath.lastIndexOf(47));
        this.currentStatementBlock = this.templateUnit;
        this.describer = describer;
        this.children = children;
        this.emitMode = describer.getEmitMode(templatePath);
        this.templateIdentifier = describer.getExternalIdentifier(templatePath);
        this.templateUnit.setJamonContextType(describer.getJamonContextType(templatePath));
        this.aliases.putAll(describer.getAliases(templatePath));
    }

    public Analyzer(String templatePath, TemplateDescriber describer) throws IOException {
        this(templatePath, describer, new HashSet<String>());
    }

    public TemplateUnit analyze() throws IOException {
        TopNode top = this.describer.parseTemplate(this.templateUnit.getName());
        this.templateUnit.setEncoding(top.getEncoding());
        this.preAnalyze(top);
        this.mainAnalyze(top);
        this.checkForConcreteness(top);
        this.checkTemplateReplacement(top);
        if (this.errors.hasErrors()) {
            throw this.errors;
        }
        return this.templateUnit;
    }

    private void addError(String message, Location location) {
        this.errors.addError(new ParserErrorImpl(location, message));
    }

    private void preAnalyze(TopNode top) throws IOException {
        this.topLevelAnalyze(top, new AliasAdapter());
        this.topLevelAnalyze(top, new PreliminaryAdapter());
        if (this.defaultEscaping == null) {
            this.defaultEscaping = this.describer.getEscaping(this.templateUnit.getName());
        }
        if (this.defaultEscaping == null) {
            this.defaultEscaping = EscapingDirective.get("h");
        }
    }

    private void topLevelAnalyze(TopNode top, AnalysisAdapter adapter) {
        for (AbstractNode node : top.getSubNodes()) {
            node.apply(adapter);
        }
    }

    private void mainAnalyze(TopNode top) {
        top.apply(new Adapter());
    }

    private void checkForConcreteness(TopNode top) {
        if (!this.getTemplateUnit().isParent() && !this.getTemplateUnit().getAbstractMethodNames().isEmpty()) {
            this.topLevelAnalyze(top, new AnalysisAdapter(){

                @Override
                public void caseExtendsNode(ExtendsNode extendsNode) {
                    StringBuilder message = new StringBuilder("The abstract method(s) ");
                    StringUtils.commaJoin(message, Analyzer.this.getTemplateUnit().getAbstractMethodNames());
                    message.append(" have no concrete implementation");
                    Analyzer.this.addError(message.toString(), extendsNode.getLocation());
                }
            });
        }
    }

    private void checkTemplateReplacement(TopNode top) {
        this.topLevelAnalyze(top, new AnalysisAdapter(){

            @Override
            public void caseReplaceableNode(ReplaceableNode replaceable) {
                if (Analyzer.this.getTemplateUnit().isParent()) {
                    Analyzer.this.addError(Analyzer.ABSTRACT_REPLACEABLE_TEMPLATE_ERROR, replaceable.getLocation());
                } else {
                    Analyzer.this.getTemplateUnit().setReplaceable(true);
                }
            }

            @Override
            public void caseReplacesNode(ReplacesNode replaces) {
                if (Analyzer.this.getTemplateUnit().isParent()) {
                    Analyzer.this.addError(Analyzer.ABSTRACT_REPLACING_TEMPLATE_ERROR, replaces.getLocation());
                } else {
                    String replacedTemplatePath = Analyzer.this.getAbsolutePath(Analyzer.this.computePath(replaces.getPath()));
                    TemplateDescription replacedTemplateDescription = Analyzer.this.getTemplateDescription(replacedTemplatePath, replaces.getLocation());
                    if (replacedTemplateDescription != null) {
                        if (!replacedTemplateDescription.isReplaceable()) {
                            Analyzer.this.addError(Analyzer.REPLACING_NON_REPLACEABLE_TEMPLATE_ERROR, replaces.getLocation());
                        }
                        Analyzer.this.getTemplateUnit().setReplacedTemplatePathAndDescription(replacedTemplatePath, replacedTemplateDescription);
                        Analyzer.this.verifyRequiredArgsComeFromReplacedTemplate(replaces.getLocation(), replacedTemplateDescription);
                        Analyzer.this.verifyFragmentArgsComeFromReplacedTemplate(replaces.getLocation(), replacedTemplateDescription);
                        Analyzer.this.verifyOptionalArgsComeFromReplacedTemplate(replaces.getLocation(), replacedTemplateDescription);
                    }
                }
            }
        });
    }

    private void verifyRequiredArgsComeFromReplacedTemplate(Location location, TemplateDescription replacedTemplateDescription) {
        this.verifyArgsComeFromReplacedTemplate(location, replacedTemplateDescription.getRequiredArgs().iterator(), this.getTemplateUnit().getSignatureRequiredArgs(), "required");
    }

    private void verifyFragmentArgsComeFromReplacedTemplate(Location location, TemplateDescription replacedTemplateDescription) {
        this.verifyArgsComeFromReplacedTemplate(location, replacedTemplateDescription.getFragmentInterfaces().iterator(), this.getTemplateUnit().getFragmentArgs(), "fragment");
    }

    private void verifyOptionalArgsComeFromReplacedTemplate(Location location, TemplateDescription replacedTemplateDescription) {
        this.verifyArgsComeFromReplacedTemplate(location, new SequentialIterator<OptionalArgument>(replacedTemplateDescription.getRequiredArgs().iterator(), replacedTemplateDescription.getOptionalArgs().iterator()), this.getTemplateUnit().getSignatureOptionalArgs(), "required or optional");
    }

    private <T extends AbstractArgument> void verifyArgsComeFromReplacedTemplate(Location location, Iterator<T> replacedTemplateArgs, Collection<? extends T> templateArgs, String argumentKind) {
        HashSet<String> replacedTemplateArgNames = new HashSet<String>();
        while (replacedTemplateArgs.hasNext()) {
            replacedTemplateArgNames.add(((AbstractArgument)replacedTemplateArgs.next()).getName());
        }
        for (AbstractArgument arg : templateArgs) {
            if (replacedTemplateArgNames.contains(arg.getName())) continue;
            this.addError("Replaced template contains no " + argumentKind + " argument named " + arg.getName(), location);
        }
    }

    private void pushDefUnit(String defName) {
        this.currentStatementBlock = this.getTemplateUnit().getDefUnit(defName);
    }

    private void pushMethodUnit(String methodName) {
        this.currentStatementBlock = this.getTemplateUnit().getMethodUnit(methodName);
    }

    private void pushOverriddenMethodUnit(OverrideNode node) {
        this.currentStatementBlock = this.getTemplateUnit().makeOverridenMethodUnit(node.getName(), node.getLocation());
    }

    private void pushFlowControlBlock(Location location, String header) {
        FlowControlBlock flowControlBlock = new FlowControlBlock(this.currentStatementBlock, header, location);
        this.addStatement(flowControlBlock);
        this.currentStatementBlock = flowControlBlock;
    }

    private FragmentUnit pushFragmentUnitImpl(String fragName, Location location) {
        this.currentStatementBlock = new FragmentUnit(fragName, this.getCurrentStatementBlock(), this.getTemplateUnit().getGenericParams(), this.errors, location);
        return (FragmentUnit)this.currentStatementBlock;
    }

    private void pushFragmentArg(FragmentUnit frag) {
        this.currentStatementBlock = frag;
    }

    private void popStatementBlock() {
        this.currentStatementBlock = this.currentStatementBlock.getParent();
    }

    private void pushCallStatement(CallStatement callStatement) {
        this.callStatements.add(callStatement);
    }

    private void popCallStatement() {
        this.callStatements.removeLast();
    }

    private CallStatement getCurrentCallStatement() {
        return this.callStatements.getLast();
    }

    private TemplateUnit getTemplateUnit() {
        return this.templateUnit;
    }

    private StatementBlock getCurrentStatementBlock() {
        return this.currentStatementBlock;
    }

    private String getAbsolutePath(String path) {
        return path.charAt(0) == '/' ? path : this.templateDir + path;
    }

    private String computePath(AbstractPathNode path) {
        PathAdapter adapter = new PathAdapter(this.templateDir, this.aliases, this.errors);
        path.apply(adapter);
        return adapter.getPath();
    }

    private EscapingDirective getDefaultEscaping() {
        return this.defaultEscaping;
    }

    private CallStatement makeCallStatement(AbstractComponentCallNode node) {
        String path = this.computePath(node.getCallPath());
        ParamValues paramValues = this.makeParamValues(node.getParams());
        FragmentUnit fragmentUnit = this.getCurrentStatementBlock().getFragmentUnitIntf(path);
        List<GenericCallParam> genericParams = node.getGenericParams();
        if (fragmentUnit != null) {
            if (!genericParams.isEmpty()) {
                this.addError("Fragment calls may not have generic params", node.getLocation());
            }
            return new FargCallStatement(path, paramValues, fragmentUnit, node.getLocation(), this.templateIdentifier);
        }
        DefUnit defUnit = this.getTemplateUnit().getDefUnit(path);
        if (defUnit != null) {
            if (!genericParams.isEmpty()) {
                this.addError("def " + defUnit.getName() + " is being called with generic parameters", node.getLocation());
            }
            return new DefCallStatement(path, paramValues, defUnit, node.getLocation(), this.templateIdentifier);
        }
        MethodUnit methodUnit = this.getTemplateUnit().getMethodUnit(path);
        if (methodUnit != null) {
            if (!genericParams.isEmpty()) {
                this.addError("method" + methodUnit.getName() + " is being called with generic parameters", node.getLocation());
            }
            return new MethodCallStatement(path, paramValues, methodUnit, node.getLocation(), this.templateIdentifier);
        }
        this.getTemplateUnit().addCallPath(this.getAbsolutePath(path));
        return new ComponentCallStatement(this.getAbsolutePath(path), paramValues, node.getLocation(), this.templateIdentifier, genericParams, this.getTemplateUnit().getJamonContextType());
    }

    private ParamValues makeParamValues(AbstractParamsNode params) {
        return new ParamsAdapter().getParamValues(params);
    }

    private void addStatement(Statement statement) {
        this.getCurrentStatementBlock().addStatement(statement);
    }

    private TemplateDescription getTemplateDescription(String path, Location location) {
        if (this.children.contains(path)) {
            this.addError("cyclic inheritance or replacement involving " + path, location);
            return null;
        }
        this.children.add(path);
        try {
            return this.describer.getTemplateDescription(path, location, this.children);
        }
        catch (ParserErrorImpl e) {
            this.errors.addError(e);
        }
        catch (ParserErrorsImpl e) {
            this.errors.addErrors(e);
        }
        catch (IOException e) {
            this.addError(e.getMessage(), location);
        }
        return null;
    }

    private static class ParamsAdapter
    extends DepthFirstAnalysisAdapter {
        private Map<String, String> paramsMap = null;
        private List<String> paramsList = null;

        private ParamsAdapter() {
        }

        public ParamValues getParamValues(AbstractParamsNode node) {
            node.apply(this);
            if (this.paramsList != null) {
                return new UnnamedParamValues(this.paramsList, node.getLocation());
            }
            return new NamedParamValues(this.paramsMap, node.getLocation());
        }

        @Override
        public void inNamedParamsNode(NamedParamsNode node) {
            this.paramsMap = new HashMap<String, String>();
        }

        @Override
        public void inUnnamedParamsNode(UnnamedParamsNode node) {
            this.paramsList = new LinkedList<String>();
        }

        @Override
        public void caseNamedParamNode(NamedParamNode node) {
            this.paramsMap.put(node.getName().getName(), node.getValue().getValue());
        }

        @Override
        public void caseParamValueNode(ParamValueNode node) {
            this.paramsList.add(node.getValue());
        }
    }

    private class Adapter
    extends DepthFirstAnalysisAdapter {
        private Adapter() {
        }

        @Override
        public void caseImportNode(ImportNode importNode) {
            Analyzer.this.getTemplateUnit().addImport(importNode);
        }

        @Override
        public void caseStaticImportNode(StaticImportNode staticImportNode) {
            Analyzer.this.getTemplateUnit().addStaticImport(staticImportNode);
        }

        @Override
        public void caseImplementNode(ImplementNode node) {
            Analyzer.this.getTemplateUnit().addInterface(node.getName());
        }

        @Override
        public void caseParentArgsNode(ParentArgsNode node) {
            if (Analyzer.this.getCurrentStatementBlock() instanceof TemplateUnit && !((TemplateUnit)Analyzer.this.getCurrentStatementBlock()).hasParentPath()) {
                Analyzer.this.addError(Analyzer.XARGS_DECLARED_WITHOUT_PARENT_ERROR, node.getLocation());
            } else {
                super.caseParentArgsNode(node);
            }
        }

        @Override
        public void caseParentArgNode(ParentArgNode node) {
            ((InheritedUnit)((Object)Analyzer.this.getCurrentStatementBlock())).addParentArg(node);
        }

        @Override
        public void caseParentArgWithDefaultNode(ParentArgWithDefaultNode node) {
            ((InheritedUnit)((Object)Analyzer.this.getCurrentStatementBlock())).addParentArg(node);
        }

        @Override
        public void inFragmentArgsNode(FragmentArgsNode node) {
            Analyzer.this.pushFragmentArg(Analyzer.this.getCurrentStatementBlock().addFragment(node, Analyzer.this.getTemplateUnit().getGenericParams()));
        }

        @Override
        public void outFragmentArgsNode(FragmentArgsNode node) {
            Analyzer.this.popStatementBlock();
        }

        @Override
        public void caseArgNode(ArgNode node) {
            Analyzer.this.getCurrentStatementBlock().addRequiredArg(node);
        }

        @Override
        public void caseOptionalArgNode(OptionalArgNode node) {
            Analyzer.this.getCurrentStatementBlock().addOptionalArg(node);
        }

        @Override
        public void inDefNode(DefNode node) {
            Analyzer.this.pushDefUnit(node.getName());
        }

        @Override
        public void outDefNode(DefNode def) {
            Analyzer.this.popStatementBlock();
        }

        @Override
        public void inMethodNode(MethodNode node) {
            Analyzer.this.pushMethodUnit(node.getName());
        }

        @Override
        public void outMethodNode(MethodNode node) {
            Analyzer.this.popStatementBlock();
        }

        @Override
        public void inAbsMethodNode(AbsMethodNode node) {
            if (!Analyzer.this.getTemplateUnit().isParent()) {
                Analyzer.this.addError("Non-abstract templates cannot have abstract methods", node.getLocation());
            }
            Analyzer.this.pushMethodUnit(node.getName());
        }

        @Override
        public void outAbsMethodNode(AbsMethodNode node) {
            Analyzer.this.popStatementBlock();
        }

        @Override
        public void inOverrideNode(OverrideNode node) {
            Analyzer.this.pushOverriddenMethodUnit(node);
        }

        @Override
        public void outOverrideNode(OverrideNode node) {
            Analyzer.this.popStatementBlock();
        }

        @Override
        public void caseGenericsParamNode(GenericsParamNode node) {
            if (Analyzer.this.templateUnit.isParent()) {
                Analyzer.this.addError("<%generics> tag not allowed in abstract templates", node.getLocation());
            }
            Analyzer.this.templateUnit.addGenericsParamNode(node);
        }

        @Override
        public void caseSimpleCallNode(SimpleCallNode node) {
            Analyzer.this.addStatement(Analyzer.this.makeCallStatement(node));
        }

        @Override
        public void caseChildCallNode(ChildCallNode node) {
            TemplateUnit unit = Analyzer.this.getTemplateUnit();
            if (!unit.isParent()) {
                Analyzer.this.addError("<& *CHILD &> cannot be called from a template without an <%abstract> tag", node.getLocation());
            }
            Analyzer.this.addStatement(new ChildCallStatement(unit.getInheritanceDepth() + 1));
        }

        @Override
        public void caseClassNode(ClassNode node) {
            Analyzer.this.getTemplateUnit().addClassContent(node);
        }

        @Override
        public void caseTextNode(TextNode node) {
            Analyzer.this.addStatement(new LiteralStatement(node.getText(), node.getLocation(), Analyzer.this.templateIdentifier));
        }

        @Override
        public void caseLiteralNode(LiteralNode node) {
            Analyzer.this.addStatement(new LiteralStatement(node.getText(), node.getLocation(), Analyzer.this.templateIdentifier));
        }

        @Override
        public void inMultiFragmentCallNode(MultiFragmentCallNode node) {
            CallStatement s = Analyzer.this.makeCallStatement(node);
            Analyzer.this.addStatement(s);
            Analyzer.this.pushCallStatement(s);
        }

        @Override
        public void outMultiFragmentCallNode(MultiFragmentCallNode call) {
            Analyzer.this.popCallStatement();
        }

        @Override
        public void inNamedFragmentNode(NamedFragmentNode node) {
            Analyzer.this.getCurrentCallStatement().addFragmentImpl(Analyzer.this.pushFragmentUnitImpl(node.getName(), node.getLocation()), Analyzer.this.errors);
        }

        @Override
        public void outNamedFragmentNode(NamedFragmentNode node) {
            Analyzer.this.popStatementBlock();
        }

        @Override
        public void inFragmentCallNode(FragmentCallNode node) {
            CallStatement s = Analyzer.this.makeCallStatement(node);
            Analyzer.this.addStatement(s);
            s.addFragmentImpl(Analyzer.this.pushFragmentUnitImpl(null, node.getLocation()), Analyzer.this.errors);
        }

        @Override
        public void outFragmentCallNode(FragmentCallNode node) {
            Analyzer.this.popStatementBlock();
        }

        @Override
        public void inWhileNode(WhileNode node) {
            Analyzer.this.pushFlowControlBlock(node.getLocation(), "while (" + node.getCondition() + ")");
        }

        @Override
        public void outWhileNode(WhileNode node) {
            Analyzer.this.popStatementBlock();
        }

        @Override
        public void inForNode(ForNode node) {
            Analyzer.this.pushFlowControlBlock(node.getLocation(), "for (" + node.getLoopSpecifier() + ")");
        }

        @Override
        public void outForNode(ForNode node) {
            Analyzer.this.popStatementBlock();
        }

        @Override
        public void inIfNode(IfNode node) {
            Analyzer.this.pushFlowControlBlock(node.getLocation(), "if (" + node.getCondition() + ")");
        }

        @Override
        public void outIfNode(IfNode node) {
            Analyzer.this.popStatementBlock();
        }

        @Override
        public void inElseIfNode(ElseIfNode node) {
            Analyzer.this.pushFlowControlBlock(node.getLocation(), "else if (" + node.getCondition() + ")");
        }

        @Override
        public void outElseIfNode(ElseIfNode node) {
            Analyzer.this.popStatementBlock();
        }

        @Override
        public void inElseNode(ElseNode node) {
            Analyzer.this.pushFlowControlBlock(node.getLocation(), "else");
        }

        @Override
        public void outElseNode(ElseNode node) {
            Analyzer.this.popStatementBlock();
        }

        @Override
        public void outTopNode(TopNode node) {
        }

        @Override
        public void caseJavaNode(JavaNode node) {
            Analyzer.this.addStatement(new RawStatement(node.getJava(), node.getLocation(), Analyzer.this.templateIdentifier));
        }

        @Override
        public void caseEmitNode(EmitNode node) {
            Analyzer.this.addStatement(new WriteStatement(node.getEmitExpression(), new EmitAdapter().getEscape(node.getEscaping()), node.getLocation(), Analyzer.this.templateIdentifier, Analyzer.this.emitMode));
        }

        private class EmitAdapter
        extends AnalysisAdapter {
            EscapingDirective escapeCode = null;

            private EmitAdapter() {
            }

            @Override
            public void caseEscapeNode(EscapeNode node) {
                this.escapeCode = EscapingDirective.get(node.getEscapeCode());
                if (this.escapeCode == null) {
                    Analyzer.this.addError("Unknown escaping directive '" + node.getEscapeCode() + "'", node.getLocation());
                }
            }

            @Override
            public void caseDefaultEscapeNode(DefaultEscapeNode node) {
                this.escapeCode = Analyzer.this.getDefaultEscaping();
            }

            public EscapingDirective getEscape(AbstractEscapeNode node) {
                node.apply(this);
                return this.escapeCode;
            }
        }
    }

    private class PreliminaryAdapter
    extends AnalysisAdapter {
        private PreliminaryAdapter() {
        }

        @Override
        public void caseEscapeDirectiveNode(EscapeDirectiveNode escape) {
            if (Analyzer.this.defaultEscaping != null) {
                Analyzer.this.addError("a template cannot specify multiple default escapings", escape.getLocation());
            }
            Analyzer.this.defaultEscaping = EscapingDirective.get(escape.getEscapeCode());
            if (Analyzer.this.defaultEscaping == null) {
                Analyzer.this.addError("Unknown escaping directive '" + escape.getEscapeCode() + "'", escape.getLocation());
            }
        }

        @Override
        public void caseExtendsNode(ExtendsNode extendsNode) {
            String parentPath;
            TemplateDescription parentDescription;
            if (Analyzer.this.getTemplateUnit().hasParentPath()) {
                Analyzer.this.addError("a template cannot extend multiple templates", extendsNode.getLocation());
            }
            if ((parentDescription = Analyzer.this.getTemplateDescription(parentPath = Analyzer.this.getAbsolutePath(Analyzer.this.computePath(extendsNode.getPath())), extendsNode.getLocation())) != null) {
                Analyzer.this.getTemplateUnit().setParentPath(parentPath);
                Analyzer.this.getTemplateUnit().setParentDescription(parentDescription);
            }
        }

        @Override
        public void caseAnnotationNode(AnnotationNode node) {
            Analyzer.this.templateUnit.addAnnotationNode(node);
        }

        @Override
        public void caseParentMarkerNode(ParentMarkerNode node) {
            Analyzer.this.getTemplateUnit().setIsParent();
        }

        @Override
        public void caseDefNode(DefNode node) {
            Analyzer.this.getTemplateUnit().makeDefUnit(node.getName(), node.getLocation());
        }

        @Override
        public void caseMethodNode(MethodNode node) {
            Analyzer.this.getTemplateUnit().makeMethodUnit(node.getName(), node.getLocation(), false);
        }

        @Override
        public void caseAbsMethodNode(AbsMethodNode node) {
            Analyzer.this.getTemplateUnit().makeMethodUnit(node.getName(), node.getLocation(), true);
        }
    }

    private class AliasAdapter
    extends AnalysisAdapter {
        private AliasAdapter() {
        }

        @Override
        public void caseAliasesNode(AliasesNode node) {
            for (AliasDefNode defNode : node.getAliass()) {
                this.handleAlias(defNode);
            }
        }

        private void handleAlias(AliasDefNode node) {
            if (Analyzer.this.aliases.containsKey(node.getName())) {
                Analyzer.this.addError("Duplicate alias for " + node.getName(), node.getLocation());
            } else {
                Analyzer.this.aliases.put(node.getName(), Analyzer.this.computePath(node.getPath()));
            }
        }
    }
}

