/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import org.jamon.api.Location;

public class CodeWriter {
    private final PrintWriter writer;
    private int indentation = 0;
    private LinkedList<Boolean> argAlreadyPrintedStack = new LinkedList();
    private LinkedList<Boolean> itemPerLineStack = new LinkedList();
    private int nextFragmentImplCounter = 0;
    private boolean beginingOfLine = true;
    private static final int BASIC_OFFSET = 2;
    private static final String SPACES = "                                        ";

    public CodeWriter(OutputStream stream, String encoding) {
        try {
            this.writer = new PrintWriter(new OutputStreamWriter(stream, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int nextFragmentImplCounter() {
        return this.nextFragmentImplCounter++;
    }

    public void printLocation(Location location) {
        if (location != null) {
            this.println("// " + location.getLine() + ", " + location.getColumn());
        }
    }

    public void println() {
        this.println("");
    }

    public void println(Object obj) {
        this.maybeIndent();
        this.writer.println(obj);
        this.beginingOfLine = true;
    }

    public void print(Object obj) {
        this.maybeIndent();
        this.writer.print(obj);
        this.beginingOfLine = false;
    }

    public void openBlock() {
        this.println("{");
        this.indent();
    }

    public void closeBlock(String extra) {
        this.outdent();
        this.println("}" + extra);
    }

    public void closeBlock() {
        this.closeBlock("");
    }

    public void indent() {
        this.indentation += 2;
    }

    public void outdent() {
        this.indentation -= 2;
        if (this.indentation < 0) {
            throw new IllegalStateException("Attempting to outdent past 0");
        }
    }

    public void openList() {
        this.openList("(", false);
    }

    public void openList(String openToken, boolean itemPerLine) {
        this.argAlreadyPrintedStack.addLast(Boolean.FALSE);
        this.itemPerLineStack.addLast(itemPerLine);
        this.print(openToken);
        if (itemPerLine) {
            this.indent();
        }
    }

    public void closeList() {
        this.closeList(")");
    }

    public void closeList(String closeToken) {
        if (this.argAlreadyPrintedStack.isEmpty()) {
            throw new IllegalStateException("Attempt to close unopened list");
        }
        this.argAlreadyPrintedStack.removeLast();
        if (this.itemPerLineStack.removeLast().booleanValue()) {
            this.outdent();
        }
        this.print(closeToken);
    }

    public void printListElement(String listElement) {
        if (this.argAlreadyPrintedStack.isEmpty()) {
            throw new IllegalStateException("Attempt to print arg outside of list");
        }
        if (this.argAlreadyPrintedStack.getLast().booleanValue()) {
            if (this.itemPerLineStack.getLast().booleanValue()) {
                this.println(",");
            } else {
                this.print(", ");
            }
        } else {
            this.argAlreadyPrintedStack.removeLast();
            this.argAlreadyPrintedStack.addLast(Boolean.TRUE);
            if (this.itemPerLineStack.getLast().booleanValue()) {
                this.println();
            }
        }
        this.print(listElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        if (this.indentation != 0) {
            throw new IllegalStateException("indentation is " + this.indentation + " at end of file");
        }
        if (!this.argAlreadyPrintedStack.isEmpty()) {
            throw new IllegalStateException("in a list at end of file");
        }
        try {
            if (this.writer.checkError()) {
                throw new IOException("Exception writing to stream");
            }
        }
        finally {
            this.writer.close();
        }
    }

    private void maybeIndent() {
        if (this.beginingOfLine) {
            this.writer.print(SPACES.substring(0, Math.min(this.indentation, SPACES.length())));
        }
    }
}

